/*
 * Decompiled with CFR 0.152.
 */
package me.dags.http.json;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import me.dags.http.json.JsonParser;
import me.dags.http.json.JsonWriter;

public class JsonNode {
    public static JsonNode NULL = new JsonNode(null);
    private final Object value;

    public JsonNode(Object value) {
        this.value = value;
    }

    public boolean isPresent() {
        return this != NULL;
    }

    public boolean isArray() {
        return this.value != null && List.class.isInstance(this.value);
    }

    public boolean isObject() {
        return this.value != null && Map.class.isInstance(this.value);
    }

    public boolean isString() {
        return String.class.isInstance(this.value);
    }

    public Number number() {
        return JsonNode.cast(this.value, Number.class, Double.NaN);
    }

    public String string() {
        return this.value == null ? "null" : this.value.toString();
    }

    public boolean bool() {
        return JsonNode.cast(this.value, Boolean.class, false);
    }

    public List<JsonNode> list() {
        return JsonNode.cast(this.value, List.class, Collections.emptyList());
    }

    public Map<String, JsonNode> map() {
        return JsonNode.cast(this.value, Map.class, Collections.emptyMap());
    }

    public JsonNode get(String key) {
        return this.map().getOrDefault(key, NULL);
    }

    public String toJson() {
        StringBuilder sb = new StringBuilder();
        JsonWriter writer = new JsonWriter(sb);
        try {
            writer.write(this);
        }
        catch (IOException e) {
            e.printStackTrace();
            return "{}";
        }
        return sb.toString();
    }

    public String toString() {
        return this.value.toString();
    }

    private static <T> T cast(Object o, Class<?> type, T def) {
        if (o != null && type.isInstance(o)) {
            return (T)o;
        }
        return def;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JsonNode parse(Path path) {
        try (BufferedReader reader = Files.newBufferedReader(path);){
            JsonNode jsonNode = JsonNode.parse(reader);
            return jsonNode;
        }
        catch (IOException e) {
            e.printStackTrace();
            return NULL;
        }
    }

    public static JsonNode parse(Reader reader) {
        return new JsonParser(reader).parse();
    }
}

