/*
 * Decompiled with CFR 0.152.
 */
package me.dags.http.json;

import java.io.IOException;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import me.dags.http.json.JsonNode;

public class JsonParser {
    private final Reader reader;
    private char current = (char)65535;
    private int line = 1;
    private int character = 0;

    public JsonParser(Reader reader) {
        this.reader = reader;
    }

    private void next() throws IOException {
        this.current = (char)this.reader.read();
        if (this.current == '\n') {
            ++this.line;
            this.character = 0;
        } else {
            ++this.character;
        }
    }

    public JsonNode parse() {
        try {
            this.next();
            return this.nextElement();
        }
        catch (Exception e) {
            System.out.printf("Line: %s, Char: %s\n", this.line, this.character);
            e.printStackTrace();
            return JsonNode.NULL;
        }
    }

    private JsonNode nextElement() throws IOException {
        while (Character.isWhitespace(this.current)) {
            this.next();
        }
        switch (this.current) {
            case '{': {
                return this.nextObject();
            }
            case '[': {
                return this.nextArray();
            }
            case '\"': {
                return new JsonNode(this.nextString());
            }
            case 't': {
                this.reader.skip(4L);
                return new JsonNode(true);
            }
            case 'f': {
                this.reader.skip(5L);
                return new JsonNode(false);
            }
            case 'n': {
                this.reader.skip(3L);
                return JsonNode.NULL;
            }
        }
        return new JsonNode(this.nextNumber(this.current));
    }

    private JsonNode nextObject() throws IOException {
        LinkedHashMap<String, JsonNode> map = new LinkedHashMap<String, JsonNode>();
        while (true) {
            this.next();
            if (this.current == ',' || Character.isWhitespace(this.current)) continue;
            if (this.current == '\"') {
                String key = this.nextString();
                this.readUntil(':');
                this.next();
                map.put(key, this.nextElement());
            }
            if (this.current == '}') break;
        }
        this.next();
        return new JsonNode(map);
    }

    private JsonNode nextArray() throws IOException {
        LinkedList<JsonNode> list = new LinkedList<JsonNode>();
        while (true) {
            this.next();
            if (this.current == ',' || Character.isWhitespace(this.current)) continue;
            if (this.current != ']') {
                list.add(this.nextElement());
            }
            if (this.current == ']') break;
        }
        this.next();
        return new JsonNode(list);
    }

    private String nextString() throws IOException {
        StringBuilder sb = new StringBuilder();
        boolean escaped = false;
        while (true) {
            this.next();
            if (!escaped && this.current == '\"') break;
            escaped = this.current == '\\';
            if (escaped) continue;
            sb.append(this.current);
        }
        return sb.toString();
    }

    private Number nextNumber(char start) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(start);
        boolean decimal = false;
        while (true) {
            this.next();
            if (!this.isDigit(this.current)) break;
            if (this.current == '.') {
                decimal = true;
            }
            sb.append(this.current);
        }
        if (decimal) {
            return Double.parseDouble(sb.toString());
        }
        return Long.parseLong(sb.toString());
    }

    private void readUntil(char end) throws IOException {
        do {
            this.next();
        } while (this.current != end);
    }

    private boolean isDigit(char c) {
        return Character.isDigit(c) || c == '.' || c == '-' || c == '+' || c == 'e' || c == 'E';
    }
}

