/*
 * Decompiled with CFR 0.152.
 */
package me.dags.http.json;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import me.dags.http.json.JsonNode;

public class JsonWriter {
    private final Appendable appendable;
    private final int spaces = 2;
    private int indent = 0;

    public JsonWriter(Appendable appendable) {
        this.appendable = appendable;
    }

    public void write(JsonNode node) throws IOException {
        if (node.isObject()) {
            this.writeObject(node);
            return;
        }
        if (node.isArray()) {
            this.writeArray(node);
            return;
        }
        if (node.isString()) {
            this.writeString(node.string());
            return;
        }
        this.appendable.append(node.string());
    }

    private void writeObject(JsonNode node) throws IOException {
        Iterator<Map.Entry<String, JsonNode>> iterator = node.map().entrySet().iterator();
        this.appendable.append('{');
        this.incIndent();
        if (iterator.hasNext()) {
            while (iterator.hasNext()) {
                Map.Entry<String, JsonNode> next = iterator.next();
                this.newLine();
                this.indent();
                this.writeString(next.getKey());
                this.appendable.append(':').append(' ');
                this.write(next.getValue());
                if (!iterator.hasNext()) continue;
                this.appendable.append(',');
            }
            this.newLine();
            this.decIndent();
            this.indent();
        } else {
            this.decIndent();
        }
        this.appendable.append('}');
    }

    private void writeArray(JsonNode node) throws IOException {
        Iterator<JsonNode> iterator = node.list().iterator();
        this.appendable.append('[');
        this.incIndent();
        if (iterator.hasNext()) {
            while (iterator.hasNext()) {
                this.newLine();
                this.indent();
                this.write(iterator.next());
                if (!iterator.hasNext()) continue;
                this.appendable.append(',');
            }
            this.newLine();
            this.decIndent();
            this.indent();
        } else {
            this.decIndent();
        }
        this.appendable.append(']');
    }

    private void writeString(String in) throws IOException {
        this.appendable.append('\"').append(in).append('\"');
    }

    private void incIndent() {
        ++this.indent;
    }

    private void decIndent() {
        --this.indent;
    }

    private void indent() throws IOException {
        for (int i = this.indent * 2; i > 0; --i) {
            this.appendable.append(' ');
        }
    }

    private void newLine() throws IOException {
        this.appendable.append('\n');
    }
}

