/*
 * Decompiled with CFR 0.152.
 */
package me.dags.http.server;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import me.dags.http.server.NanoHTTPD;

public class Context
implements NanoHTTPD.IHTTPSession {
    private final Map<String, String> routeParams;
    private final NanoHTTPD.IHTTPSession session;

    Context(NanoHTTPD.IHTTPSession session, Map<String, String> routeParams) {
        this.routeParams = routeParams;
        this.session = session;
    }

    public String getRouteParam(String name) {
        return this.routeParams.get(name);
    }

    public String getRouteParam(String name, String defaultVal) {
        String value = this.getRouteParam(name);
        return value == null ? defaultVal : value;
    }

    public String getQueryParam(String name) {
        List values = this.session.getParameters().getOrDefault(name, Collections.emptyList());
        if (values.size() > 0) {
            return (String)values.get(0);
        }
        return null;
    }

    public String getQueryParam(String name, String defaultVal) {
        String value = this.getQueryParam(name);
        return value == null ? defaultVal : value;
    }

    @Override
    public void execute() throws IOException {
        this.session.execute();
    }

    @Override
    public NanoHTTPD.CookieHandler getCookies() {
        return this.session.getCookies();
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.session.getHeaders();
    }

    @Override
    public InputStream getInputStream() {
        return this.session.getInputStream();
    }

    @Override
    public NanoHTTPD.Method getMethod() {
        return this.session.getMethod();
    }

    @Override
    @Deprecated
    public Map<String, String> getParms() {
        return this.session.getParms();
    }

    @Override
    public Map<String, List<String>> getParameters() {
        return this.session.getParameters();
    }

    @Override
    public String getQueryParameterString() {
        return this.session.getQueryParameterString();
    }

    @Override
    public String getUri() {
        return this.session.getUri();
    }

    @Override
    public void parseBody(Map<String, String> files) throws IOException, NanoHTTPD.ResponseException {
        this.session.parseBody(files);
    }

    @Override
    public String getRemoteIpAddress() {
        return this.session.getRemoteIpAddress();
    }

    @Override
    public String getRemoteHostName() {
        return this.session.getRemoteHostName();
    }
}

