/*
 * Decompiled with CFR 0.152.
 */
package me.dags.http.server;

import java.io.IOException;
import java.io.InputStream;
import me.dags.http.server.NanoHTTPD;
import me.dags.http.server.Server;

public class ResponseWriter {
    private static final NanoHTTPD.Response.IStatus OK = NanoHTTPD.Response.Status.OK;
    private static final NanoHTTPD.Response.IStatus DENY = NanoHTTPD.Response.Status.FORBIDDEN;
    private static final NanoHTTPD.Response.IStatus REDIRECT = NanoHTTPD.Response.Status.REDIRECT;
    private final Server server;
    private final NanoHTTPD.Response response;

    public ResponseWriter(Server server, NanoHTTPD.Response response) {
        this.server = server;
        this.response = response;
    }

    NanoHTTPD.Response getResponse() {
        return this.response;
    }

    public ResponseWriter close() throws IOException {
        this.response.close();
        return this;
    }

    public ResponseWriter addHeader(String name, String value) {
        this.response.addHeader(name, value);
        return this;
    }

    public ResponseWriter closeConnection(boolean close) {
        this.response.closeConnection(close);
        return this;
    }

    public ResponseWriter setGzipEncoding(boolean encodeAsGzip) {
        this.response.setGzipEncoding(encodeAsGzip);
        return this;
    }

    public ResponseWriter setKeepAlive(boolean useKeepAlive) {
        this.response.setKeepAlive(useKeepAlive);
        return this;
    }

    public ResponseWriter setChunkedTransfer(boolean chunkedTransfer) {
        this.response.setChunkedTransfer(chunkedTransfer);
        return this;
    }

    public ResponseWriter setBody(String body) {
        this.server.setBody(this.response, body);
        return this;
    }

    public ResponseWriter setBody(InputStream data) {
        this.response.setData(data);
        return this;
    }

    public ResponseWriter accept() {
        this.response.setStatus(OK);
        return this;
    }

    public ResponseWriter deny() {
        this.response.setStatus(DENY);
        this.clear();
        return this;
    }

    public ResponseWriter redirect() {
        this.response.setStatus(REDIRECT);
        return this;
    }

    public ResponseWriter clear() {
        this.setBody((InputStream)null);
        return this;
    }

    public ResponseWriter html() {
        this.response.setMimeType("text/html");
        return this;
    }

    public ResponseWriter text() {
        this.response.setMimeType("text/plain");
        return this;
    }

    public ResponseWriter html(String html) {
        return this.accept().html().setBody(html);
    }

    public ResponseWriter text(String text) {
        return this.accept().text().setBody(text);
    }

    public ResponseWriter redirect(String url) {
        return this.redirect().text().clear().addHeader("Location", url);
    }
}

