/*
 * Decompiled with CFR 0.152.
 */
package me.dags.http.server;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Route {
    private final Pattern pattern;
    private final String[] names;

    private Route(Pattern pattern, String[] names) {
        this.pattern = pattern;
        this.names = names;
    }

    public Map<String, String> parse(String uri) {
        int count;
        Matcher matcher = this.pattern.matcher(uri);
        if (matcher.find() && (count = matcher.groupCount()) == this.names.length) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (int i = 0; i < count; ++i) {
                String group = matcher.group(i + 1);
                map.put(this.names[i], group);
            }
            return map;
        }
        return null;
    }

    public static Route parseRoute(String in) {
        LinkedList<String> keys = new LinkedList<String>();
        StringBuilder patternBuilder = new StringBuilder("^");
        int last = 0;
        for (int i = 0; i < in.length(); ++i) {
            int end;
            if (in.charAt(i) != '{') continue;
            patternBuilder.append(in.substring(last, i));
            int start = i + 1;
            for (end = start + 1; end < in.length() && in.charAt(end) != '}'; ++end) {
            }
            keys.add(in.substring(start, end).toLowerCase());
            patternBuilder.append("(.+)");
            last = i = end + 1;
        }
        if (last < in.length()) {
            patternBuilder.append(in.substring(last, in.length()));
        }
        patternBuilder.append("$");
        Pattern pattern = Pattern.compile(patternBuilder.toString(), 2);
        String[] names = keys.toArray(new String[keys.size()]);
        return new Route(pattern, names);
    }
}

