/*
 * Decompiled with CFR 0.152.
 */
package me.dags.http.server;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import me.dags.http.server.Context;
import me.dags.http.server.Handler;
import me.dags.http.server.NanoHTTPD;
import me.dags.http.server.ResponseWriter;
import me.dags.http.server.Route;

public class Server
extends NanoHTTPD {
    private static final NanoHTTPD.Response BAD = Server.newFixedLengthResponse(NanoHTTPD.Response.Status.BAD_REQUEST, "text/plain", null);
    private final Map<Route, Handler> handlers;

    private Server(Builder builder) {
        super(builder.address, builder.port);
        this.handlers = Collections.unmodifiableMap(new HashMap(builder.handlers));
    }

    @Override
    public NanoHTTPD.Response serve(NanoHTTPD.IHTTPSession session) {
        for (Map.Entry<Route, Handler> entry : this.handlers.entrySet()) {
            Route route = entry.getKey();
            Map<String, String> routeParams = route.parse(session.getUri());
            if (routeParams == null) continue;
            try {
                ResponseWriter writer = new ResponseWriter(this, Server.newFixedLengthResponse(null));
                Context request = new Context(session, routeParams);
                entry.getValue().handle(writer, request);
                return writer.getResponse();
            }
            catch (Throwable t) {
                t.printStackTrace();
                return Server.newFixedLengthResponse(t.getMessage());
            }
        }
        return BAD;
    }

    void setBody(NanoHTTPD.Response response, String content) {
        byte[] data;
        if (content == null) {
            data = new byte[]{};
        } else {
            try {
                NanoHTTPD.ContentType contentType = new NanoHTTPD.ContentType(response.getMimeType());
                CharsetEncoder newEncoder = Charset.forName(contentType.getEncoding()).newEncoder();
                if (!newEncoder.canEncode(content)) {
                    contentType = contentType.tryUTF8();
                }
                byte[] data2 = content.getBytes(contentType.getEncoding());
                response.setData(new ByteArrayInputStream(data2));
                return;
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                data = new byte[]{};
            }
        }
        response.setData(new ByteArrayInputStream(data));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int port = 8080;
        private String address = "127.0.0.1";
        private Map<Route, Handler> handlers = new HashMap<Route, Handler>();

        public Builder address(String address) {
            this.address = address;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder route(String route, Handler httpHandler) {
            Route r = Route.parseRoute(route);
            this.handlers.put(r, httpHandler);
            return this;
        }

        public Server build() {
            return new Server(this);
        }
    }
}

