/*
 * Decompiled with CFR 0.152.
 */
package net.dodogang.crumbs.block;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Random;
import java.util.Set;
import net.dodogang.crumbs.mixin.PointOfInterestTypeAccessor;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BarrelBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.tileentity.BarrelTileEntity;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class CrumbsBarrelBlock
extends BarrelBlock {
    public static final ArrayList<BlockState> modBarrels = new ArrayList();

    public CrumbsBarrelBlock(AbstractBlock.Properties properties) {
        super(properties);
        modBarrels.addAll(PointOfInterestType.func_221042_a((Block)this));
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te == null || te.func_145831_w() == null) {
            return;
        }
        if (te instanceof BarrelTileEntity) {
            int i = te.func_174877_v().func_177958_n();
            int j = te.func_174877_v().func_177956_o();
            int k = te.func_174877_v().func_177952_p();
            int numPlayersUsing = ChestTileEntity.func_213976_a((World)te.func_145831_w(), (LockableTileEntity)((BarrelTileEntity)te), (int)i, (int)j, (int)k);
            if (numPlayersUsing > 0) {
                te.func_145831_w().func_205220_G_().func_205360_a(te.func_174877_v(), (Object)te.func_195044_w().func_177230_c(), 5);
            } else if (((Boolean)state.func_177229_b((Property)BarrelBlock.field_220093_b)).booleanValue()) {
                this.playSound((BarrelTileEntity)te, state);
                te.func_145831_w().func_180501_a(te.func_174877_v(), (BlockState)state.func_206870_a((Property)BarrelBlock.field_220093_b, (Comparable)Boolean.valueOf(false)), 3);
            }
        }
    }

    private void playSound(BarrelTileEntity te, BlockState state) {
        World world = te.func_145831_w();
        if (world == null) {
            return;
        }
        Vector3i vec3i = ((Direction)state.func_177229_b((Property)BarrelBlock.field_220092_a)).func_176730_m();
        double d0 = (double)te.func_174877_v().func_177958_n() + 0.5 + (double)vec3i.func_177958_n() / 2.0;
        double d1 = (double)te.func_174877_v().func_177956_o() + 0.5 + (double)vec3i.func_177956_o() / 2.0;
        double d2 = (double)te.func_174877_v().func_177952_p() + 0.5 + (double)vec3i.func_177952_p() / 2.0;
        world.func_184148_a(null, d0, d1, d2, SoundEvents.field_219601_N, SoundCategory.BLOCKS, 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
    }

    public static void registerPointsOfInterest() {
        modBarrels.forEach(modBarrel -> {
            PointOfInterestType pointOfInterestType = PointOfInterestTypeAccessor.getBlockStateToPointOfInterest().put((BlockState)modBarrel, PointOfInterestType.field_221060_h);
            if (pointOfInterestType != null) {
                throw (IllegalStateException)Util.func_229757_c_((Throwable)new IllegalStateException(String.format("%s is defined in too many tags", modBarrel)));
            }
        });
        PointOfInterestTypeAccessor fishermanAccessor = (PointOfInterestTypeAccessor)PointOfInterestType.field_221060_h;
        ArrayList<BlockState> blockStates = new ArrayList<BlockState>(fishermanAccessor.getBlockStates());
        blockStates.addAll(modBarrels);
        fishermanAccessor.setBlockStates((Set<BlockState>)ImmutableSet.copyOf(blockStates));
    }
}

