/*
 * Decompiled with CFR 0.152.
 */
package net.dodogang.crumbs.init;

import com.google.common.collect.ImmutableMap;
import net.dodogang.crumbs.Crumbs;
import net.dodogang.crumbs.block.CrumbsBarrelBlock;
import net.dodogang.crumbs.block.CrumbsBlock;
import net.dodogang.crumbs.block.CrumbsCraftingTableBlock;
import net.dodogang.crumbs.block.WoodLanternBlock;
import net.dodogang.crumbs.block.vanilla.PublicStairsBlock;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.AxeItem;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class CrumbsBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"crumbs");
    public static final DeferredRegister<Item> BLOCK_ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"crumbs");
    public static final Block OAK_BUNDLED_LOG = CrumbsBlocks.registerPillarBlock("oak_bundled_log", Blocks.field_196617_K);
    public static final Block BIRCH_BUNDLED_LOG = CrumbsBlocks.registerPillarBlock("birch_bundled_log", Blocks.field_196619_M);
    public static final Block SPRUCE_BUNDLED_LOG = CrumbsBlocks.registerPillarBlock("spruce_bundled_log", Blocks.field_196618_L);
    public static final Block JUNGLE_BUNDLED_LOG = CrumbsBlocks.registerPillarBlock("jungle_bundled_log", Blocks.field_196620_N);
    public static final Block ACACIA_BUNDLED_LOG = CrumbsBlocks.registerPillarBlock("acacia_bundled_log", Blocks.field_196621_O);
    public static final Block DARK_OAK_BUNDLED_LOG = CrumbsBlocks.registerPillarBlock("dark_oak_bundled_log", Blocks.field_196623_P);
    public static final Block CRIMSON_BUNDLED_STEM = CrumbsBlocks.registerPillarBlock("crimson_bundled_stem", Blocks.field_235377_mq_);
    public static final Block WARPED_BUNDLED_STEM = CrumbsBlocks.registerPillarBlock("warped_bundled_stem", Blocks.field_235368_mh_);
    public static final Block STRIPPED_OAK_BUNDLED_LOG = CrumbsBlocks.registerPillarBlock("stripped_oak_bundled_log", Blocks.field_203204_R);
    public static final Block STRIPPED_BIRCH_BUNDLED_LOG = CrumbsBlocks.registerPillarBlock("stripped_birch_bundled_log", Blocks.field_203206_T);
    public static final Block STRIPPED_SPRUCE_BUNDLED_LOG = CrumbsBlocks.registerPillarBlock("stripped_spruce_bundled_log", Blocks.field_203205_S);
    public static final Block STRIPPED_JUNGLE_BUNDLED_LOG = CrumbsBlocks.registerPillarBlock("stripped_jungle_bundled_log", Blocks.field_203207_U);
    public static final Block STRIPPED_ACACIA_BUNDLED_LOG = CrumbsBlocks.registerPillarBlock("stripped_acacia_bundled_log", Blocks.field_203208_V);
    public static final Block STRIPPED_DARK_OAK_BUNDLED_LOG = CrumbsBlocks.registerPillarBlock("stripped_dark_oak_bundled_log", Blocks.field_203209_W);
    public static final Block STRIPPED_CRIMSON_BUNDLED_STEM = CrumbsBlocks.registerPillarBlock("stripped_crimson_bundled_stem", Blocks.field_235378_mr_);
    public static final Block STRIPPED_WARPED_BUNDLED_STEM = CrumbsBlocks.registerPillarBlock("stripped_warped_bundled_stem", Blocks.field_235369_mi_);
    public static final Block OAK_TILE = CrumbsBlocks.registerCopy("oak_tile", Blocks.field_196662_n);
    public static final Block SPRUCE_TILE = CrumbsBlocks.registerCopy("spruce_tile", Blocks.field_196664_o);
    public static final Block BIRCH_TILE = CrumbsBlocks.registerCopy("birch_tile", Blocks.field_196666_p);
    public static final Block JUNGLE_TILE = CrumbsBlocks.registerCopy("jungle_tile", Blocks.field_196668_q);
    public static final Block ACACIA_TILE = CrumbsBlocks.registerCopy("acacia_tile", Blocks.field_196670_r);
    public static final Block DARK_OAK_TILE = CrumbsBlocks.registerCopy("dark_oak_tile", Blocks.field_196672_s);
    public static final Block CRIMSON_TILE = CrumbsBlocks.registerCopy("crimson_tile", Blocks.field_235344_mC_);
    public static final Block WARPED_TILE = CrumbsBlocks.registerCopy("warped_tile", Blocks.field_235345_mD_);
    public static final Block OAK_TILE_SLAB = CrumbsBlocks.registerSlab("oak_tile", Blocks.field_196662_n);
    public static final Block SPRUCE_TILE_SLAB = CrumbsBlocks.registerSlab("spruce_tile", Blocks.field_196664_o);
    public static final Block BIRCH_TILE_SLAB = CrumbsBlocks.registerSlab("birch_tile", Blocks.field_196666_p);
    public static final Block JUNGLE_TILE_SLAB = CrumbsBlocks.registerSlab("jungle_tile", Blocks.field_196668_q);
    public static final Block ACACIA_TILE_SLAB = CrumbsBlocks.registerSlab("acacia_tile", Blocks.field_196670_r);
    public static final Block DARK_OAK_TILE_SLAB = CrumbsBlocks.registerSlab("dark_oak_tile", Blocks.field_196672_s);
    public static final Block CRIMSON_TILE_SLAB = CrumbsBlocks.registerSlab("crimson_tile", Blocks.field_235344_mC_);
    public static final Block WARPED_TILE_SLAB = CrumbsBlocks.registerSlab("warped_tile", Blocks.field_235345_mD_);
    public static final Block REINFORCED_OAK_PLANKS = CrumbsBlocks.registerPillarBlock("reinforced_oak_planks", Blocks.field_196662_n);
    public static final Block REINFORCED_SPRUCE_PLANKS = CrumbsBlocks.registerPillarBlock("reinforced_spruce_planks", Blocks.field_196664_o);
    public static final Block REINFORCED_BIRCH_PLANKS = CrumbsBlocks.registerPillarBlock("reinforced_birch_planks", Blocks.field_196666_p);
    public static final Block REINFORCED_JUNGLE_PLANKS = CrumbsBlocks.registerPillarBlock("reinforced_jungle_planks", Blocks.field_196668_q);
    public static final Block REINFORCED_ACACIA_PLANKS = CrumbsBlocks.registerPillarBlock("reinforced_acacia_planks", Blocks.field_196670_r);
    public static final Block REINFORCED_DARK_OAK_PLANKS = CrumbsBlocks.registerPillarBlock("reinforced_dark_oak_planks", Blocks.field_196672_s);
    public static final Block REINFORCED_CRIMSON_PLANKS = CrumbsBlocks.registerPillarBlock("reinforced_crimson_planks", Blocks.field_235344_mC_);
    public static final Block REINFORCED_WARPED_PLANKS = CrumbsBlocks.registerPillarBlock("reinforced_warped_planks", Blocks.field_235345_mD_);
    public static final Block SPRUCE_CRAFTING_TABLE = CrumbsBlocks.registerCraftingTable("spruce", Blocks.field_196664_o);
    public static final Block BIRCH_CRAFTING_TABLE = CrumbsBlocks.registerCraftingTable("birch", Blocks.field_196666_p);
    public static final Block JUNGLE_CRAFTING_TABLE = CrumbsBlocks.registerCraftingTable("jungle", Blocks.field_196668_q);
    public static final Block ACACIA_CRAFTING_TABLE = CrumbsBlocks.registerCraftingTable("acacia", Blocks.field_196670_r);
    public static final Block DARK_OAK_CRAFTING_TABLE = CrumbsBlocks.registerCraftingTable("dark_oak", Blocks.field_196672_s);
    public static final Block CRIMSON_CRAFTING_TABLE = CrumbsBlocks.registerCraftingTable("crimson", Blocks.field_235344_mC_);
    public static final Block WARPED_CRAFTING_TABLE = CrumbsBlocks.registerCraftingTable("warped", Blocks.field_235345_mD_);
    public static final Block OAK_BARREL = CrumbsBlocks.registerBarrel("oak", Blocks.field_196662_n);
    public static final Block BIRCH_BARREL = CrumbsBlocks.registerBarrel("birch", Blocks.field_196666_p);
    public static final Block JUNGLE_BARREL = CrumbsBlocks.registerBarrel("jungle", Blocks.field_196668_q);
    public static final Block ACACIA_BARREL = CrumbsBlocks.registerBarrel("acacia", Blocks.field_196670_r);
    public static final Block DARK_OAK_BARREL = CrumbsBlocks.registerBarrel("dark_oak", Blocks.field_196672_s);
    public static final Block CRIMSON_BARREL = CrumbsBlocks.registerBarrel("crimson", Blocks.field_235344_mC_);
    public static final Block WARPED_BARREL = CrumbsBlocks.registerBarrel("warped", Blocks.field_235345_mD_);
    public static final Block OAK_LANTERN = CrumbsBlocks.registerWoodLantern("oak", Blocks.field_196662_n);
    public static final Block SPRUCE_LANTERN = CrumbsBlocks.registerWoodLantern("spruce", Blocks.field_196664_o);
    public static final Block BIRCH_LANTERN = CrumbsBlocks.registerWoodLantern("birch", Blocks.field_196666_p);
    public static final Block JUNGLE_LANTERN = CrumbsBlocks.registerWoodLantern("jungle", Blocks.field_196668_q);
    public static final Block ACACIA_LANTERN = CrumbsBlocks.registerWoodLantern("acacia", Blocks.field_196670_r);
    public static final Block DARK_OAK_LANTERN = CrumbsBlocks.registerWoodLantern("dark_oak", Blocks.field_196672_s);
    public static final Block CRIMSON_LANTERN = CrumbsBlocks.registerWoodLantern("crimson", Blocks.field_235344_mC_);
    public static final Block WARPED_LANTERN = CrumbsBlocks.registerWoodLantern("warped", Blocks.field_235345_mD_);
    public static final Block COBBLED_GRANITE = CrumbsBlocks.registerCopy("cobbled_granite", Blocks.field_196650_c);
    public static final Block CHISELED_POLISHED_GRANITE = CrumbsBlocks.registerCopy("chiseled_polished_granite", Blocks.field_196650_c);
    public static final Block BEVELED_POLISHED_GRANITE = CrumbsBlocks.registerCopy("beveled_polished_granite", Blocks.field_196650_c);
    public static final Block CRACKED_POLISHED_GRANITE = CrumbsBlocks.registerCopy("cracked_polished_granite", Blocks.field_196650_c);
    public static final Block COBBLED_DIORITE = CrumbsBlocks.registerCopy("cobbled_diorite", Blocks.field_196654_e);
    public static final Block CHISELED_POLISHED_DIORITE = CrumbsBlocks.registerCopy("chiseled_polished_diorite", Blocks.field_196654_e);
    public static final Block BEVELED_POLISHED_DIORITE = CrumbsBlocks.registerCopy("beveled_polished_diorite", Blocks.field_196654_e);
    public static final Block CRACKED_POLISHED_DIORITE = CrumbsBlocks.registerCopy("cracked_polished_diorite", Blocks.field_196654_e);
    public static final Block COBBLED_ANDESITE = CrumbsBlocks.registerCopy("cobbled_andesite", Blocks.field_196656_g);
    public static final Block CHISELED_POLISHED_ANDESITE = CrumbsBlocks.registerCopy("chiseled_polished_andesite", Blocks.field_196656_g);
    public static final Block BEVELED_POLISHED_ANDESITE = CrumbsBlocks.registerCopy("beveled_polished_andesite", Blocks.field_196656_g);
    public static final Block CRACKED_POLISHED_ANDESITE = CrumbsBlocks.registerCopy("cracked_polished_andesite", Blocks.field_196656_g);
    public static final Block BEVELED_POLISHED_BLACKSTONE = CrumbsBlocks.registerCopy("beveled_polished_blackstone", Blocks.field_235406_np_);
    public static final Block CRACKED_POLISHED_BLACKSTONE = CrumbsBlocks.registerCopy("cracked_polished_blackstone", Blocks.field_235406_np_);
    public static final Block COBBLED_GRANITE_WALL = CrumbsBlocks.registerWall("cobbled_granite", COBBLED_GRANITE);
    public static final Block COBBLED_DIORITE_WALL = CrumbsBlocks.registerWall("cobbled_diorite", COBBLED_DIORITE);
    public static final Block COBBLED_ANDESITE_WALL = CrumbsBlocks.registerWall("cobbled_andesite", COBBLED_ANDESITE);
    public static final Block COBBLED_GRANITE_SLAB = CrumbsBlocks.registerSlab("cobbled_granite", COBBLED_GRANITE);
    public static final Block COBBLED_DIORITE_SLAB = CrumbsBlocks.registerSlab("cobbled_diorite", COBBLED_DIORITE);
    public static final Block COBBLED_ANDESITE_SLAB = CrumbsBlocks.registerSlab("cobbled_andesite", COBBLED_ANDESITE);
    public static final Block COBBLED_GRANITE_STAIRS = CrumbsBlocks.registerStairs("cobbled_granite", COBBLED_GRANITE);
    public static final Block COBBLED_DIORITE_STAIRS = CrumbsBlocks.registerStairs("cobbled_diorite", COBBLED_DIORITE);
    public static final Block COBBLED_ANDESITE_STAIRS = CrumbsBlocks.registerStairs("cobbled_andesite", COBBLED_ANDESITE);
    public static final Block SANDSTONE_TILE = CrumbsBlocks.registerCopy("sandstone_tile", Blocks.field_150322_A);
    public static final Block LARGE_SANDSTONE_TILE = CrumbsBlocks.registerCopy("large_sandstone_tile", Blocks.field_150322_A);
    public static final Block RED_SANDSTONE_TILE = CrumbsBlocks.registerCopy("red_sandstone_tile", Blocks.field_180395_cM);
    public static final Block LARGE_RED_SANDSTONE_TILE = CrumbsBlocks.registerCopy("large_red_sandstone_tile", Blocks.field_180395_cM);
    public static final Block SANDSTONE_TILE_WALL = CrumbsBlocks.registerWall("sandstone_tile", Blocks.field_150322_A);
    public static final Block RED_SANDSTONE_TILE_WALL = CrumbsBlocks.registerWall("red_sandstone_tile", Blocks.field_180395_cM);
    public static final Block SANDSTONE_TILE_SLAB = CrumbsBlocks.registerSlab("sandstone_tile", Blocks.field_150322_A);
    public static final Block RED_SANDSTONE_TILE_SLAB = CrumbsBlocks.registerSlab("red_sandstone_tile", Blocks.field_180395_cM);
    public static final Block SANDSTONE_TILE_STAIRS = CrumbsBlocks.registerStairs("sandstone_tile", Blocks.field_150322_A);
    public static final Block RED_SANDSTONE_TILE_STAIRS = CrumbsBlocks.registerStairs("red_sandstone_tile", Blocks.field_180395_cM);
    public static final Block CHISELED_RED_NETHER_BRICKS = CrumbsBlocks.registerCopy("chiseled_red_nether_bricks", Blocks.field_196653_dH);
    public static final Block CRACKED_RED_NETHER_BRICKS = CrumbsBlocks.registerCopy("cracked_red_nether_bricks", Blocks.field_196653_dH);
    public static final Block BLUE_NETHER_BRICKS = CrumbsBlocks.registerCopy("blue_nether_bricks", Blocks.field_196653_dH);
    public static final Block CHISELED_BLUE_NETHER_BRICKS = CrumbsBlocks.registerCopy("chiseled_blue_nether_bricks", Blocks.field_196653_dH);
    public static final Block CRACKED_BLUE_NETHER_BRICKS = CrumbsBlocks.registerCopy("cracked_blue_nether_bricks", Blocks.field_196653_dH);
    public static final Block BLUE_NETHER_BRICK_WALL = CrumbsBlocks.registerWall("blue_nether_brick", BLUE_NETHER_BRICKS);
    public static final Block BLUE_NETHER_BRICK_STAIRS = CrumbsBlocks.registerStairs("blue_nether_brick", BLUE_NETHER_BRICKS);
    public static final Block BLUE_NETHER_BRICK_SLAB = CrumbsBlocks.registerSlab("blue_nether_brick", BLUE_NETHER_BRICKS);

    public static void registerBlocks(RegistryEvent.Register<Block> registry) {
        for (CrumbsBlock crumbsBlock : CrumbsBlock.getAll()) {
            registry.getRegistry().register(crumbsBlock.getBlock().setRegistryName(new ResourceLocation("crumbs", crumbsBlock.getId())));
        }
    }

    public static void registerBlockItems(RegistryEvent.Register<Item> registry) {
        for (CrumbsBlock crumbsBlock : CrumbsBlock.getAll()) {
            Block block = crumbsBlock.getBlock();
            registry.getRegistry().register(new BlockItem(block, new Item.Properties().func_200916_a(Crumbs.ITEM_GROUP)).setRegistryName(block.getRegistryName()));
        }
    }

    public static void addStrippingFunctionality(PlayerInteractEvent.RightClickBlock event) {
        if (!(event.getItemStack().func_77973_b() instanceof AxeItem)) {
            return;
        }
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        BlockState blockState = world.func_180495_p(pos);
        new ImmutableMap.Builder().put((Object)OAK_BUNDLED_LOG, (Object)STRIPPED_OAK_BUNDLED_LOG).put((Object)DARK_OAK_BUNDLED_LOG, (Object)STRIPPED_DARK_OAK_BUNDLED_LOG).put((Object)ACACIA_BUNDLED_LOG, (Object)STRIPPED_ACACIA_BUNDLED_LOG).put((Object)BIRCH_BUNDLED_LOG, (Object)STRIPPED_BIRCH_BUNDLED_LOG).put((Object)JUNGLE_BUNDLED_LOG, (Object)STRIPPED_JUNGLE_BUNDLED_LOG).put((Object)SPRUCE_BUNDLED_LOG, (Object)STRIPPED_SPRUCE_BUNDLED_LOG).put((Object)WARPED_BUNDLED_STEM, (Object)STRIPPED_WARPED_BUNDLED_STEM).put((Object)CRIMSON_BUNDLED_STEM, (Object)STRIPPED_CRIMSON_BUNDLED_STEM).build().forEach((base, result) -> {
            if (blockState.func_177230_c() == base) {
                PlayerEntity player = event.getPlayer();
                world.func_184133_a(player, pos, SoundEvents.field_203255_y, SoundCategory.BLOCKS, 1.0f, 1.0f);
                player.func_184609_a(event.getHand());
                if (!world.field_72995_K) {
                    world.func_180501_a(pos, (BlockState)result.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, blockState.func_177229_b((Property)RotatedPillarBlock.field_176298_M)), 11);
                    event.getItemStack().func_222118_a(1, (LivingEntity)player, playerEntity -> playerEntity.func_213334_d(event.getHand()));
                }
            }
        });
        event.setCancellationResult(ActionResultType.CONSUME);
    }

    private static Block registerCopy(String id, Block base) {
        return CrumbsBlocks.register(id, new Block(AbstractBlock.Properties.func_200950_a((AbstractBlock)base)));
    }

    private static Block registerCraftingTable(String id, Block base) {
        return CrumbsBlocks.register(id + "_crafting_table", (Block)new CrumbsCraftingTableBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)base)));
    }

    private static Block registerWoodLantern(String id, Block base) {
        return CrumbsBlocks.register(id + "_lantern", new WoodLanternBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)base)));
    }

    private static Block registerSlab(String id, Block base) {
        return CrumbsBlocks.register(id + "_slab", (Block)new SlabBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)base)));
    }

    private static Block registerStairs(String id, Block base) {
        return CrumbsBlocks.register(id + "_stairs", (Block)new PublicStairsBlock(() -> ((Block)base).func_176223_P(), AbstractBlock.Properties.func_200950_a((AbstractBlock)base)));
    }

    private static Block registerWall(String id, Block base) {
        return CrumbsBlocks.register(id + "_wall", (Block)new WallBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)base)));
    }

    private static Block registerBarrel(String id, Block base) {
        return CrumbsBlocks.register(id + "_barrel", (Block)new CrumbsBarrelBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)base)));
    }

    private static Block registerPillarBlock(String id, Block base) {
        return CrumbsBlocks.register(id, (Block)new RotatedPillarBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)base)));
    }

    public static Block register(String id, Block block, boolean registerItem) {
        CrumbsBlock crumbsBlock = new CrumbsBlock(id, block);
        return crumbsBlock.getBlock();
    }

    public static Block register(String id, Block block) {
        return CrumbsBlocks.register(id, block, true);
    }
}

