/*
 * Decompiled with CFR 0.152.
 */
package com.lilypuree.decorative_blocks.datagen.types;

import com.lilypuree.decorative_blocks.datagen.types.IWoodType;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;

public enum VanillaWoodTypes implements IWoodType
{
    OAK("oak"),
    BIRCH("birch"){

        @Override
        public MaterialColor getMaterialColor() {
            return MaterialColor.field_151658_d;
        }
    }
    ,
    SPRUCE("spruce"){

        @Override
        public MaterialColor getMaterialColor() {
            return MaterialColor.field_151654_J;
        }
    }
    ,
    ACACIA("acacia"){

        @Override
        public MaterialColor getMaterialColor() {
            return MaterialColor.field_151676_q;
        }
    }
    ,
    JUNGLE("jungle"){

        @Override
        public MaterialColor getMaterialColor() {
            return MaterialColor.field_151664_l;
        }
    }
    ,
    DARK_OAK("dark_oak"){

        @Override
        public MaterialColor getMaterialColor() {
            return MaterialColor.field_151650_B;
        }
    }
    ,
    CRIMSON("crimson"){

        @Override
        public boolean isFlammable() {
            return false;
        }

        @Override
        public Material getMaterial() {
            return Material.field_237214_y_;
        }

        @Override
        public MaterialColor getMaterialColor() {
            return MaterialColor.field_151655_K;
        }
    }
    ,
    WARPED("warped"){

        @Override
        public boolean isFlammable() {
            return false;
        }

        @Override
        public Material getMaterial() {
            return Material.field_237214_y_;
        }

        @Override
        public MaterialColor getMaterialColor() {
            return MaterialColor.field_151679_y;
        }
    };

    private final String name;

    private VanillaWoodTypes(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public static VanillaWoodTypes withName(String name) {
        if (name.equalsIgnoreCase("oak")) {
            return OAK;
        }
        if (name.equalsIgnoreCase("birch")) {
            return BIRCH;
        }
        if (name.equalsIgnoreCase("spruce")) {
            return SPRUCE;
        }
        if (name.equalsIgnoreCase("acacia")) {
            return ACACIA;
        }
        if (name.equalsIgnoreCase("jungle")) {
            return JUNGLE;
        }
        if (name.equalsIgnoreCase("dark")) {
            return DARK_OAK;
        }
        if (name.equalsIgnoreCase("crimson")) {
            return CRIMSON;
        }
        if (name.equalsIgnoreCase("warped")) {
            return WARPED;
        }
        return OAK;
    }

    public static VanillaWoodTypes fromPath(String path) {
        String[] paths = path.split("_");
        return VanillaWoodTypes.withName(paths[0]);
    }

    @Override
    public Block getLog() {
        switch (this) {
            case OAK: {
                return Blocks.field_196617_K;
            }
            case SPRUCE: {
                return Blocks.field_196618_L;
            }
            case BIRCH: {
                return Blocks.field_196619_M;
            }
            case JUNGLE: {
                return Blocks.field_196620_N;
            }
            case DARK_OAK: {
                return Blocks.field_196623_P;
            }
            case ACACIA: {
                return Blocks.field_196621_O;
            }
            case CRIMSON: {
                return Blocks.field_235377_mq_;
            }
            case WARPED: {
                return Blocks.field_235368_mh_;
            }
        }
        return Blocks.field_196617_K;
    }

    @Override
    public Block getStrippedLog() {
        switch (this) {
            case OAK: {
                return Blocks.field_203204_R;
            }
            case SPRUCE: {
                return Blocks.field_203205_S;
            }
            case BIRCH: {
                return Blocks.field_203206_T;
            }
            case JUNGLE: {
                return Blocks.field_203207_U;
            }
            case DARK_OAK: {
                return Blocks.field_203209_W;
            }
            case ACACIA: {
                return Blocks.field_203208_V;
            }
            case CRIMSON: {
                return Blocks.field_235378_mr_;
            }
            case WARPED: {
                return Blocks.field_235369_mi_;
            }
        }
        return Blocks.field_203204_R;
    }

    @Override
    public Block getSlab() {
        switch (this) {
            case OAK: {
                return Blocks.field_196622_bq;
            }
            case SPRUCE: {
                return Blocks.field_196624_br;
            }
            case BIRCH: {
                return Blocks.field_196627_bs;
            }
            case JUNGLE: {
                return Blocks.field_196630_bt;
            }
            case DARK_OAK: {
                return Blocks.field_196635_bv;
            }
            case ACACIA: {
                return Blocks.field_196632_bu;
            }
            case CRIMSON: {
                return Blocks.field_235346_mE_;
            }
            case WARPED: {
                return Blocks.field_235347_mF_;
            }
        }
        return Blocks.field_196622_bq;
    }

    @Override
    public Block getFence() {
        switch (this) {
            case OAK: {
                return Blocks.field_180407_aO;
            }
            case SPRUCE: {
                return Blocks.field_180408_aP;
            }
            case BIRCH: {
                return Blocks.field_180404_aQ;
            }
            case JUNGLE: {
                return Blocks.field_180403_aR;
            }
            case DARK_OAK: {
                return Blocks.field_180406_aS;
            }
            case ACACIA: {
                return Blocks.field_180405_aT;
            }
            case CRIMSON: {
                return Blocks.field_235350_mI_;
            }
            case WARPED: {
                return Blocks.field_235351_mJ_;
            }
        }
        return Blocks.field_180407_aO;
    }

    @Override
    public Block getPlanks() {
        switch (this) {
            case OAK: {
                return Blocks.field_196662_n;
            }
            case SPRUCE: {
                return Blocks.field_196664_o;
            }
            case BIRCH: {
                return Blocks.field_196666_p;
            }
            case JUNGLE: {
                return Blocks.field_196668_q;
            }
            case DARK_OAK: {
                return Blocks.field_196672_s;
            }
            case ACACIA: {
                return Blocks.field_196670_r;
            }
            case CRIMSON: {
                return Blocks.field_235344_mC_;
            }
            case WARPED: {
                return Blocks.field_235345_mD_;
            }
        }
        return Blocks.field_196662_n;
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public boolean isFlammable() {
        return true;
    }
}

