/*
 * Decompiled with CFR 0.152.
 */
package raltsmc.desolation.world.gen.trunk;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1945;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2465;
import net.minecraft.class_2680;
import net.minecraft.class_2715;
import net.minecraft.class_2769;
import net.minecraft.class_2944;
import net.minecraft.class_3341;
import net.minecraft.class_3746;
import net.minecraft.class_3747;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_5140;
import net.minecraft.class_5142;
import raltsmc.desolation.registry.DesolationBlocks;
import raltsmc.desolation.registry.DesolationTrunkPlacerTypes;

public class BasedTrunkPlacer
extends class_5140 {
    public static final Codec<BasedTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> BasedTrunkPlacer.method_28904((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, BasedTrunkPlacer::new));

    public BasedTrunkPlacer(int baseHeight, int firstRandomHeight, int secondRandomHeight) {
        super(baseHeight, firstRandomHeight, secondRandomHeight);
    }

    protected class_5142<?> method_28903() {
        return DesolationTrunkPlacerTypes.BASED;
    }

    public List<class_4647.class_5208> method_26991(class_3747 world, Random random, int trunkHeight, class_2338 pos, Set<class_2338> set, class_3341 blockBox, class_4643 treeFeatureConfig) {
        class_2350 placementDirection = class_2350.field_11036;
        class_2338.class_2339 currentPos = pos.method_25503();
        int maxBaseHeight = 2;
        for (int i = 0; i < trunkHeight; ++i) {
            BasedTrunkPlacer.placeAt(world, random, (class_2338)currentPos, placementDirection, set, blockBox, treeFeatureConfig);
            if (i == 0) {
                BasedTrunkPlacer.generateBase(world, random, (class_2338)currentPos, placementDirection, set, blockBox, treeFeatureConfig, maxBaseHeight);
            }
            currentPos.method_10098(class_2350.field_11036);
        }
        return ImmutableList.of((Object)new class_4647.class_5208((class_2338)currentPos, 0, false));
    }

    protected static void generateBase(class_3747 world, Random random, class_2338 pos, class_2350 direction, Set<class_2338> set, class_3341 blockBox, class_4643 treeFeatureConfig, int maxBaseHeight) {
        List<class_2350> dirs = Arrays.asList(class_2350.values());
        Collections.shuffle(dirs);
        for (class_2350 dir : dirs) {
            class_2338.class_2339 startPos;
            int height = random.nextInt(maxBaseHeight + 1);
            if (height <= 0 || dir == class_2350.field_11036 || dir == class_2350.field_11033 || random.nextInt(3) <= 0 || BasedTrunkPlacer.canReplace(world, (startPos = pos.method_10093(dir).method_25503()).method_10074())) continue;
            for (int j = 0; j < height; ++j) {
                BasedTrunkPlacer.placeAt(world, random, startPos.method_10086(j), direction, set, blockBox, treeFeatureConfig);
            }
            if (!random.nextBoolean()) continue;
            --maxBaseHeight;
        }
    }

    protected static void placeAt(class_3747 world, Random random, class_2338 pos, class_2350 direction, Set<class_2338> set, class_3341 blockBox, class_4643 treeFeatureConfig) {
        BasedTrunkPlacer.method_27404((class_1945)world, (class_2338)pos, (class_2680)((class_2680)treeFeatureConfig.field_21288.method_23455(random, pos).method_11657((class_2769)class_2465.field_11459, (Comparable)direction.method_10166())), (class_3341)blockBox);
        set.add(pos.method_10062());
    }

    protected static boolean canReplace(class_3747 world, class_2338 pos) {
        Predicate REPLACEABLE_PREDICATE = class_2715.method_11758((class_2248)DesolationBlocks.ASH_BLOCK).or((Predicate)class_2715.method_11758((class_2248)DesolationBlocks.ASH_LAYER_BLOCK)).or(class_2715.method_11758((class_2248)DesolationBlocks.EMBER_BLOCK));
        return class_2944.method_27371((class_3746)world, (class_2338)pos) || world.method_16358(pos, REPLACEABLE_PREDICATE);
    }
}

