/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.despawningeggshatch.config;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="despeggshatch")
@Config.LangKey(value="Despawning Eggs Hatch Config")
public class ModConfig {
    @Config.Comment(value={"The chance an egg will hatch just before despawning if the entity limiter is not active."})
    @Config.RangeDouble(min=0.0, max=1.0)
    public static double eggWillHatchChance = 1.0;
    @Config.Comment(value={"Prevents too many entities from hatching. A despawning egg will only hatch if there are less chickens than defined here in a radius of 32 blocks around."})
    @Config.RangeInt(min=0, max=1000)
    public static int onlyHatchIfLessChickensAroundThan = 50;
    @Config.Comment(value={"If enabled, the newly hatched chicken is a small chick."})
    public static boolean newHatchlingIsBaby = true;

    @Mod.EventBusSubscriber(modid="despeggshatch")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("despeggshatch")) {
                ConfigManager.sync((String)"despeggshatch", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }
}

