/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.client;

import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;

public class TextureUtils {
    public static int compose(int r, int g, int b, int a) {
        int rgb = a;
        rgb = (rgb << 8) + r;
        rgb = (rgb << 8) + g;
        rgb = (rgb << 8) + b;
        return rgb;
    }

    public static int compose(int[] c) {
        return c.length >= 4 ? TextureUtils.compose(c[0], c[1], c[2], c[3]) : 0;
    }

    public static int[] decompose(int c) {
        return new int[]{TextureUtils.red(c), TextureUtils.green(c), TextureUtils.blue(c), TextureUtils.alpha(c)};
    }

    public static int alpha(int c) {
        return c >> 24 & 0xFF;
    }

    public static int red(int c) {
        return c >> 16 & 0xFF;
    }

    public static int green(int c) {
        return c >> 8 & 0xFF;
    }

    public static int blue(int c) {
        return c & 0xFF;
    }

    public static int avgColors(int[] pixels) {
        long rAccum = 0L;
        long gAccum = 0L;
        long bAccum = 0L;
        int count = 0;
        for (int i = 0; i < pixels.length; ++i) {
            int alpha = TextureUtils.alpha(pixels[i]);
            if (alpha < 128) continue;
            rAccum += (long)TextureUtils.red(pixels[i]);
            gAccum += (long)TextureUtils.green(pixels[i]);
            bAccum += (long)TextureUtils.blue(pixels[i]);
            ++count;
        }
        count = Math.max(1, count);
        int r = (int)(rAccum / (long)count);
        int g = (int)(gAccum / (long)count);
        int b = (int)(bAccum / (long)count);
        return TextureUtils.compose(r, g, b, 255);
    }

    public static class PixelBuffer {
        public final int[] pixels;
        public final int w;
        public final int h;

        public PixelBuffer(int w, int h) {
            this.w = w;
            this.h = h;
            this.pixels = new int[w * h];
        }

        public PixelBuffer(TextureAtlasSprite sprite) {
            this.w = sprite.func_94211_a();
            this.h = sprite.func_94216_b();
            int[][] data = sprite.func_147965_a(0);
            this.pixels = data[0];
        }

        public PixelBuffer(TextureAtlasSprite sprite, boolean copy) {
            this.w = sprite.func_94211_a();
            this.h = sprite.func_94216_b();
            int[][] original = sprite.func_147965_a(0);
            this.pixels = Arrays.copyOf(original[0], original[0].length);
        }

        public PixelBuffer(PixelBuffer other) {
            this.w = other.w;
            this.h = other.h;
            this.pixels = Arrays.copyOf(other.pixels, other.pixels.length);
        }

        public void apply(TextureAtlasSprite sprite) {
            if (this.w == sprite.func_94211_a() && this.h == sprite.func_94216_b()) {
                int[][] original = sprite.func_147965_a(0);
                int[][] data = new int[original.length][];
                data[0] = this.pixels;
                ArrayList<int[][]> ftd = new ArrayList<int[][]>();
                ftd.add(data);
                sprite.func_110968_a(ftd);
            }
        }

        public int calcPos(int offX, int offY) {
            return offY * this.w + offX;
        }

        public int getPixel(int offX, int offY) {
            if (offX >= 0 && offX < this.w && offY >= 0 && offY < this.h) {
                return this.pixels[this.calcPos(offX, offY)];
            }
            return 0;
        }

        public void setPixel(int offX, int offY, int pixel) {
            if (offX >= 0 && offX < this.w && offY >= 0 && offY < this.h) {
                this.pixels[this.calcPos((int)offX, (int)offY)] = pixel;
            }
        }

        public void blit(PixelBuffer dst, int offX, int offY) {
            this.blit(dst, offX, offY, 0);
        }

        public void blit(PixelBuffer dst, int offX, int offY, int rotCW90) {
            switch (rotCW90 & 3) {
                case 0: {
                    for (int y = 0; y < this.h; ++y) {
                        for (int x = 0; x < this.w; ++x) {
                            dst.setPixel(x + offX, y + offY, this.getPixel(x, y));
                        }
                    }
                    return;
                }
                case 1: {
                    for (int y = 0; y < this.h; ++y) {
                        for (int x = 0; x < this.w; ++x) {
                            int destX = this.h - y - 1;
                            int destY = x;
                            dst.setPixel(destX + offX, destY + offY, this.getPixel(x, y));
                        }
                    }
                    return;
                }
                case 2: {
                    for (int y = 0; y < this.h; ++y) {
                        for (int x = 0; x < this.w; ++x) {
                            int destX = this.w - x - 1;
                            int destY = this.h - y - 1;
                            dst.setPixel(destX + offX, destY + offY, this.getPixel(x, y));
                        }
                    }
                    return;
                }
                case 3: {
                    for (int y = 0; y < this.h; ++y) {
                        for (int x = 0; x < this.w; ++x) {
                            int destX = y;
                            int destY = this.w - x - 1;
                            dst.setPixel(destX + offX, destY + offY, this.getPixel(x, y));
                        }
                    }
                    return;
                }
            }
        }

        public int averageColor() {
            return TextureUtils.avgColors(this.pixels);
        }

        public void grayScale() {
            for (int i = 0; i < this.pixels.length; ++i) {
                int a = TextureUtils.alpha(this.pixels[i]);
                int r = TextureUtils.red(this.pixels[i]);
                int g = TextureUtils.green(this.pixels[i]);
                int b = TextureUtils.blue(this.pixels[i]);
                int gray = (r * 30 + g * 59 + b * 11) / 100;
                this.pixels[i] = TextureUtils.compose(gray, gray, gray, a);
            }
        }

        public void fill(int color) {
            for (int i = 0; i < this.pixels.length; ++i) {
                this.pixels[i] = color;
            }
        }
    }
}

