/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.command;

import com.ferreusveritas.dynamictrees.ModItems;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.command.SubCommand;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.worldgen.JoCode;
import java.awt.Color;
import java.util.Collection;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scala.actors.threadpool.Arrays;

public class CommandCreateStaff
extends SubCommand {
    public static final String CREATESTAFF = "createstaff";
    public static final String DEFAULTJOCODE = "JP";

    @Override
    public String getName() {
        return CREATESTAFF;
    }

    public List<String> getJoCode(World world, BlockPos targetPos) {
        return Arrays.asList((Object[])new String[]{TreeHelper.getJoCode(world, targetPos).map(JoCode::toString).orElse(DEFAULTJOCODE)});
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        switch (args.length) {
            case 2: 
            case 3: 
            case 4: {
                return CommandBase.func_175771_a((String[])args, (int)1, (BlockPos)targetPos);
            }
            case 5: {
                return CommandBase.func_175762_a((String[])args, (Collection)Species.REGISTRY.getKeys());
            }
            case 6: {
                return this.getJoCode(sender.func_130014_f_(), targetPos);
            }
            case 7: {
                return Arrays.asList((Object[])new Object[]{"#00FFFF"});
            }
            case 8: {
                return CommandBase.func_71530_a((String[])args, (String[])new String[]{"true", "false"});
            }
            case 9: {
                return Arrays.asList((Object[])new String[]{"64"});
            }
        }
        return super.getTabCompletions(server, sender, args, targetPos);
    }

    @Override
    public void execute(World world, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 4) {
            throw new WrongUsageException("commands.dynamictrees.createstaff.usage", new Object[0]);
        }
        BlockPos pos = CommandBase.func_175757_a((ICommandSender)sender, (String[])args, (int)1, (boolean)false);
        ItemStack stack = new ItemStack((Item)ModItems.treeStaff, 1, 0);
        ModItems.treeStaff.setSpecies(stack, TreeRegistry.findSpeciesSloppy("oak"));
        block11: for (int arg = 0; arg < args.length; ++arg) {
            switch (arg) {
                case 4: {
                    Species species = TreeRegistry.findSpeciesSloppy(args[4]);
                    if (species == Species.NULLSPECIES) {
                        throw new CommandException("commands.dynamictrees.createstaff.specieserror", new Object[]{args[4]});
                    }
                    ModItems.treeStaff.setSpecies(stack, species);
                    continue block11;
                }
                case 5: {
                    ModItems.treeStaff.setCode(stack, args[5]);
                    continue block11;
                }
                case 6: {
                    try {
                        Color.decode(args[6]).getRGB();
                        ModItems.treeStaff.setColor(stack, args[6]);
                        continue block11;
                    }
                    catch (NumberFormatException e) {
                        throw new CommandException("commands.dynamictrees.createstaff.colorerror", new Object[]{args[6]});
                    }
                }
                case 7: {
                    if ("true".equals(args[7]) || "false".equals(args[7])) {
                        boolean readonly = "true".equals(args[7]);
                        ModItems.treeStaff.setReadOnly(stack, readonly);
                        continue block11;
                    }
                    throw new CommandException("commands.dynamictrees.createstaff.readonlyerror", new Object[]{args[7]});
                }
                case 8: {
                    try {
                        int maxUses = Integer.decode(args[8]);
                        if (maxUses <= 0) {
                            throw new CommandException("commands.dynamictrees.createstaff.maxuseserror", new Object[]{args[8]});
                        }
                        ModItems.treeStaff.setMaxUses(stack, maxUses);
                        ModItems.treeStaff.setUses(stack, maxUses);
                        continue block11;
                    }
                    catch (NumberFormatException e) {
                        throw new CommandException("commands.dynamictrees.createstaff.maxuseserror", new Object[]{args[8]});
                    }
                }
            }
        }
        while (!world.func_175623_d(pos)) {
            pos = pos.func_177984_a();
        }
        EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack);
        entityItem.field_70159_w = 0.0;
        entityItem.field_70181_x = 0.0;
        entityItem.field_70179_y = 0.0;
        world.func_72838_d((Entity)entityItem);
    }
}

