/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.trees;

import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.ModConfigs;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.blocks.BlockSurfaceRoot;
import com.ferreusveritas.dynamictrees.systems.dropcreators.DropCreatorApple;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenClearVolume;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenFlareBottom;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenHugeMushrooms;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenMound;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenPredicate;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenRoots;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import com.ferreusveritas.dynamictrees.trees.TreeFamilyVanilla;
import java.util.List;
import java.util.Random;
import java.util.function.BiFunction;
import net.minecraft.block.Block;
import net.minecraft.block.BlockNewLeaf;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Biomes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class TreeDarkOak
extends TreeFamilyVanilla {
    BlockSurfaceRoot surfaceRootBlock;

    public TreeDarkOak() {
        super(BlockPlanks.EnumType.DARK_OAK);
        this.hasConiferVariants = true;
        this.surfaceRootBlock = new BlockSurfaceRoot(Material.field_151575_d, this.getName() + "root");
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() instanceof BlockNewLeaf && state.func_177229_b((IProperty)BlockNewLeaf.field_176240_P) == BlockPlanks.EnumType.DARK_OAK);
    }

    @Override
    public void createSpecies() {
        this.setCommonSpecies(new SpeciesDarkOak((TreeFamily)this));
    }

    @Override
    public boolean isThick() {
        return true;
    }

    @Override
    public List<Block> getRegisterableBlocks(List<Block> blockList) {
        blockList = super.getRegisterableBlocks(blockList);
        blockList.add(this.surfaceRootBlock);
        return blockList;
    }

    @Override
    public BlockSurfaceRoot getSurfaceRoots() {
        return this.surfaceRootBlock;
    }

    public class SpeciesDarkOak
    extends Species {
        protected FeatureGenHugeMushrooms underGen;
        protected FeatureGenFlareBottom flareBottomGen;
        protected FeatureGenRoots rootGen;
        protected FeatureGenMound moundGen;

        SpeciesDarkOak(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily);
            this.setBasicGrowingParameters(0.3f, 18.0f, 4, 6, 0.8f);
            this.setGrowthLogicKit(TreeRegistry.findGrowthLogicKit("darkoak"));
            this.setSoilLongevity(14);
            this.envFactor(BiomeDictionary.Type.COLD, 0.75f);
            this.envFactor(BiomeDictionary.Type.HOT, 0.5f);
            this.envFactor(BiomeDictionary.Type.DRY, 0.25f);
            this.envFactor(BiomeDictionary.Type.MUSHROOM, 1.25f);
            if (ModConfigs.worldGen && !ModConfigs.enableAppleTrees) {
                this.addDropCreator(new DropCreatorApple());
            }
            this.setupStandardSeedDropping();
            this.addGenFeature(new FeatureGenClearVolume(6));
            this.addGenFeature(new FeatureGenFlareBottom());
            this.addGenFeature(new FeatureGenMound(5));
            if (ModConfigs.roofedForestMushroomGen) {
                this.addGenFeature(new FeatureGenPredicate(new FeatureGenHugeMushrooms().setMaxShrooms(1).setMaxAttempts(3)).setBiomePredicate(biome -> biome == Biomes.field_150585_R));
            }
            this.addGenFeature(new FeatureGenRoots(13).setScaler(this.getRootScaler()));
        }

        protected BiFunction<Integer, Integer, Integer> getRootScaler() {
            return (inRadius, trunkRadius) -> {
                float scale = MathHelper.func_76131_a((float)(trunkRadius >= 13 ? (float)trunkRadius.intValue() / 24.0f : 0.0f), (float)0.0f, (float)1.0f);
                return (int)((float)inRadius.intValue() * scale);
            };
        }

        @Override
        public boolean isBiomePerfect(Biome biome) {
            return SpeciesDarkOak.isOneOfBiomes(biome, Biomes.field_150585_R);
        }

        @Override
        public int getLowestBranchHeight(World world, BlockPos pos) {
            return (int)((float)super.getLowestBranchHeight(world, pos) * this.biomeSuitability(world, pos));
        }

        @Override
        public float getEnergy(World world, BlockPos pos) {
            return super.getEnergy(world, pos) * this.biomeSuitability(world, pos);
        }

        @Override
        public float getGrowthRate(World world, BlockPos pos) {
            return super.getGrowthRate(world, pos) * this.biomeSuitability(world, pos);
        }

        @Override
        public boolean rot(World world, BlockPos pos, int neighborCount, int radius, Random random, boolean rapid) {
            if (super.rot(world, pos, neighborCount, radius, random, rapid)) {
                if (radius > 2 && TreeHelper.isRooty(world.func_180495_p(pos.func_177977_b())) && world.func_175642_b(EnumSkyBlock.SKY, pos) < 6) {
                    world.func_175656_a(pos, ModBlocks.blockStates.redMushroom);
                    world.func_175656_a(pos.func_177977_b(), ModBlocks.blockStates.podzol);
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean isThick() {
            return true;
        }
    }
}

