/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.trees;

import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.growthlogic.ConiferLogic;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenClearVolume;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenConiferTopper;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenMound;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenPodzol;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import com.ferreusveritas.dynamictrees.trees.TreeFamilyVanilla;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Biomes;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class TreeSpruce
extends TreeFamilyVanilla {
    Species megaSpecies;

    protected boolean isLocationForMega(World world, BlockPos trunkPos) {
        return Species.isOneOfBiomes(world.func_180494_b(trunkPos), Biomes.field_150578_U, Biomes.field_150581_V);
    }

    public TreeSpruce() {
        super(BlockPlanks.EnumType.SPRUCE);
        this.hasConiferVariants = true;
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() instanceof BlockOldLeaf && state.func_177229_b((IProperty)BlockOldLeaf.field_176239_P) == BlockPlanks.EnumType.SPRUCE);
        this.addSpeciesLocationOverride((world, trunkPos) -> this.isLocationForMega(world, trunkPos) ? this.megaSpecies : Species.NULLSPECIES);
    }

    @Override
    public void createSpecies() {
        this.megaSpecies = new SpeciesMegaSpruce((TreeFamily)this);
        this.setCommonSpecies(new SpeciesSpruce((TreeFamily)this));
    }

    @Override
    public void registerSpecies(IForgeRegistry<Species> speciesRegistry) {
        super.registerSpecies(speciesRegistry);
        speciesRegistry.register((IForgeRegistryEntry)this.megaSpecies);
    }

    @Override
    public boolean isThick() {
        return true;
    }

    public class SpeciesMegaSpruce
    extends SpeciesBaseSpruce {
        private static final String speciesName = "megaspruce";

        SpeciesMegaSpruce(TreeFamily treeFamily) {
            super(new ResourceLocation(treeFamily.getName().func_110624_b(), speciesName), treeFamily);
            this.setBasicGrowingParameters(0.25f, 24.0f, 7, 5, 0.9f);
            this.setGrowthLogicKit(new ConiferLogic(5.0f));
            this.setSoilLongevity(16);
            this.addGenFeature(new FeatureGenClearVolume(8));
            this.addGenFeature(new FeatureGenMound(999));
        }

        @Override
        public ItemStack getSeedStack(int qty) {
            return TreeSpruce.this.getCommonSpecies().getSeedStack(qty);
        }

        @Override
        public Seed getSeed() {
            return TreeSpruce.this.getCommonSpecies().getSeed();
        }

        @Override
        public int maxBranchRadius() {
            return 24;
        }

        @Override
        public boolean isThick() {
            return true;
        }

        @Override
        public boolean isMega() {
            return true;
        }

        @Override
        public boolean getRequiresTileEntity(World world, BlockPos pos) {
            return !TreeSpruce.this.isLocationForMega(world, pos);
        }
    }

    public class SpeciesSpruce
    extends SpeciesBaseSpruce {
        SpeciesSpruce(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily);
        }

        @Override
        public Species getMegaSpecies() {
            return TreeSpruce.this.megaSpecies;
        }
    }

    public class SpeciesBaseSpruce
    extends Species {
        SpeciesBaseSpruce(ResourceLocation name, TreeFamily treeFamily) {
            super(name, treeFamily);
            this.setBasicGrowingParameters(0.25f, 16.0f, 3, 3, 0.9f);
            this.setGrowthLogicKit(TreeRegistry.findGrowthLogicKit("conifer"));
            this.envFactor(BiomeDictionary.Type.HOT, 0.5f);
            this.envFactor(BiomeDictionary.Type.DRY, 0.25f);
            this.envFactor(BiomeDictionary.Type.WET, 0.75f);
            this.setupStandardSeedDropping();
            this.addGenFeature(new FeatureGenConiferTopper(this.getLeavesProperties()));
            this.addGenFeature(new FeatureGenPodzol());
        }

        @Override
        public boolean isBiomePerfect(Biome biome) {
            return BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.CONIFEROUS);
        }
    }
}

