/*
 * Decompiled with CFR 0.152.
 */
package slexom.earthtojava.mobs.init;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import me.sargunvohra.mcmods.autoconfig1u.AutoConfig;
import net.fabricmc.fabric.api.event.registry.RegistryEntryAddedCallback;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2893;
import net.minecraft.class_2975;
import net.minecraft.class_5458;
import slexom.earthtojava.mobs.config.ModConfig;
import slexom.earthtojava.mobs.init.FeatureInit;
import slexom.earthtojava.mobs.mixins.GenerationSettingsAccessor;

public class BiomeInit {
    private static final ModConfig config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();

    public static void init() {
        class_5458.field_25933.forEach(BiomeInit::handleBiome);
        RegistryEntryAddedCallback.event((class_2378)class_5458.field_25933).register((i, identifier, biome) -> BiomeInit.handleBiome(biome));
    }

    private static void handleBiome(class_1959 biome) {
        BiomeInit.addOres(biome);
        BiomeInit.addMudLake(biome);
        BiomeInit.addButtercup(biome);
    }

    private static void addOres(class_1959 biome) {
        BiomeInit.addRubyOre(biome);
    }

    private static boolean isInOverworld(class_1959 biome) {
        return biome.method_8688() != class_1959.class_1961.field_9366 && biome.method_8688() != class_1959.class_1961.field_9360;
    }

    private static boolean isMushroom(class_1959 biome) {
        return biome.method_8688() == class_1959.class_1961.field_9365;
    }

    private static void addRubyOre(class_1959 biome) {
        if (BiomeInit.config.rubyOre.canGenerate && BiomeInit.isInOverworld(biome)) {
            BiomeInit.addFeature(biome, class_2893.class_2895.field_13177, FeatureInit.ORE_RUBY_CONFIGURED_FEATURE);
        }
    }

    private static void addMudLake(class_1959 biome) {
        if (BiomeInit.isInOverworld(biome) && !BiomeInit.isMushroom(biome)) {
            BiomeInit.addFeature(biome, class_2893.class_2895.field_25186, FeatureInit.MUD_LAKE_CONFIGURED_FEATURE);
        }
    }

    private static void addButtercup(class_1959 biome) {
        if (BiomeInit.isInOverworld(biome) && biome.method_8688() == class_1959.class_1961.field_9355) {
            BiomeInit.addFeature(biome, class_2893.class_2895.field_13178, FeatureInit.FLOWER_BUTTERCUP_CONFIGURED_FEATURE);
        }
    }

    public static void addFeature(class_1959 biome, class_2893.class_2895 step, class_2975<?, ?> feature) {
        GenerationSettingsAccessor generationSettingsAccessor = (GenerationSettingsAccessor)biome.method_30970();
        int stepIndex = step.ordinal();
        ArrayList featuresByStep = new ArrayList(generationSettingsAccessor.getFeatures());
        while (featuresByStep.size() <= stepIndex) {
            featuresByStep.add(Lists.newArrayList());
        }
        ArrayList<Supplier<class_2975>> features = new ArrayList<Supplier<class_2975>>((Collection)featuresByStep.get(stepIndex));
        features.add(() -> feature);
        featuresByStep.set(stepIndex, features);
        generationSettingsAccessor.setFeatures(featuresByStep);
    }
}

