/*
 * Decompiled with CFR 0.152.
 */
package slexom.earthtojava.mobs.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.event.registry.RegistryEntryAddedCallback;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1311;
import net.minecraft.class_1429;
import net.minecraft.class_1480;
import net.minecraft.class_1588;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_5458;
import net.minecraft.class_5483;
import slexom.earthtojava.mobs.world.biome.ExtendedSpawnSettings;

public final class BiomeSpawnHelper {
    public static final String[] MOOBLOOM_SPAWN_BIOMES = BiomeSpawnHelper.getBiomesListFromBiomes(new String[][]{{"minecraft:flower_forest"}});
    public static final String[] PINK_FOOTED_PIG_SPAWN_BIOMES = BiomeSpawnHelper.getBiomesListFromBiomeCategories(class_1959.class_1961.field_9355);
    private static final String[] GRAVELLY_MOUNTAINS = new String[]{"minecraft:gravelly_mountains", "minecraft:modified_gravelly_mountains"};
    private static final String[] BADLANDS = new String[]{"minecraft:badlands", "minecraft:badlands_plateau", "minecraft:modified_badlands_plateau", "minecraft:wooded_badlands_plateau", "minecraft:modified_wooded_badlands_plateau", "minecraft:eroded_badlands"};
    public static final String[] BONE_SPIDER_SPAWN_BIOMES = BiomeSpawnHelper.getBiomesListFromBiomes(new String[][]{BADLANDS});
    private static final String[] BAMBOO_JUNGLE = new String[]{"minecraft:bamboo_jungle", "minecraft:bamboo_jungle_hills"};
    private static final String[] BEACH = new String[]{"minecraft:beach"};
    public static final String[] TROPICAL_SLIME_SPAWN_BIOMES = BiomeSpawnHelper.getBiomesListFromBiomes(new String[][]{BEACH});
    private static final String[] BIRCH_FOREST = new String[]{"minecraft:birch_forest", "minecraft:birch_forest_hills", "minecraft:tall_birch_forest", "minecraft:tall_birch_hills"};
    private static final String[] DARK_FOREST = new String[]{"minecraft:dark_forest", "minecraft:dark_forest_hills"};
    private static final String[] DESERT = new String[]{"minecraft:desert", "minecraft:desert_hills", "minecraft:desert_lakes"};
    public static final String[] FURNACE_GOLEM_SPAWN_BIOMES = BiomeSpawnHelper.getBiomesListFromBiomes(new String[][]{DESERT});
    private static final String[] FOREST = new String[]{"minecraft:forest", "minecraft:wooded_hills", "minecraft:flower_forest"};
    private static final String[] FROZEN_RIVER = new String[]{"minecraft:frozen_river"};
    private static final String[] GIANT_TAIGA = new String[]{"minecraft:giant_tree_taiga", "minecraft:giant_tree_taiga_hills", "minecraft:giant_spruce_taiga", "minecraft:giant_spruce_taiga_hills"};
    private static final String[] ICE_SPIKE = new String[]{"minecraft:ice_spikes"};
    private static final String[] JUNGLE = new String[]{"minecraft:jungle", "minecraft:jungle_hills", "minecraft:modified_jungle", "minecraft:jungle_edge", "minecraft:modified_jungle_edge"};
    public static final String[] MIDNIGHT_CHICKEN_SPAWN_BIOMES = BiomeSpawnHelper.getBiomesListFromBiomes(FOREST, DARK_FOREST, JUNGLE, BIRCH_FOREST);
    private static final String[] MOUNTAINS = new String[]{"minecraft:mountains", "minecraft:wooded_mountains", "minecraft:mountain_edge"};
    public static final String[] ASHEN_COW_SPAWN_BIOMES = BiomeSpawnHelper.getBiomesListFromBiomes(MOUNTAINS, GRAVELLY_MOUNTAINS);
    private static final String[] MUSHROOM_FIELDS = new String[]{"minecraft:mushroom_fields", "minecraft:mushroom_fields"};
    public static final String[] CLUCKSHROOM_SPAWN_BIOMES = BiomeSpawnHelper.getBiomesListFromBiomes(new String[][]{MUSHROOM_FIELDS});
    private static final String[] OCEAN = new String[]{"minecraft:ocean", "minecraft:deep_ocean", "minecraft:frozen_ocean", "minecraft:deep_frozen_ocean", "minecraft:cold_ocean", "minecraft:deep_cold_ocean", "minecraft:lukewarm_ocean", "minecraft:deep_lukewarm_ocean", "minecraft:warm_ocean", "minecraft:deep_warm_ocean"};
    private static final String[] PLAINS = new String[]{"minecraft:plains", "minecraft:sunflower_plains"};
    public static final String[] BRONZED_CHICKEN_SPAWN_BIOMES = BiomeSpawnHelper.getBiomesListFromBiomes(new String[][]{PLAINS});
    public static final String[] ALBINO_COW_SPAWN_BIOMES = BiomeSpawnHelper.getBiomesListFromBiomes(PLAINS, MOUNTAINS, GRAVELLY_MOUNTAINS);
    public static final String[] MUDDY_FOOT_RABBIT_SPAWN_BIOMES = BiomeSpawnHelper.getBiomesListFromBiomes(new String[][]{PLAINS});
    public static final String[] HARELEQUIN_RABBIT_SPAWN_BIOMES = BiomeSpawnHelper.getBiomesListFromBiomes(new String[][]{PLAINS});
    public static final String[] JUMBO_RABBIT_SPAWN_BIOMES = BiomeSpawnHelper.getBiomesListFromBiomes(new String[][]{PLAINS});
    public static final String[] INKY_SHEEP_SPAWN_BIOMES = BiomeSpawnHelper.getBiomesListFromBiomes(PLAINS, MOUNTAINS, GRAVELLY_MOUNTAINS);
    public static final String[] HORNED_SHEEP_SPAWN_BIOMES = BiomeSpawnHelper.getBiomesListFromBiomes(PLAINS, MOUNTAINS, GRAVELLY_MOUNTAINS);
    public static final String[] RAINBOW_SHEEP_SPAWN_BIOMES = BiomeSpawnHelper.getBiomesListFromBiomes(PLAINS, FOREST);
    public static final String[] ROCKY_SHEEP_SPAWN_BIOMES = BiomeSpawnHelper.getBiomesListFromBiomes(PLAINS, MOUNTAINS, GRAVELLY_MOUNTAINS);
    public static final String[] VESTED_RABBIT_SPAWN_BIOMES = BiomeSpawnHelper.getBiomesListFromBiomes(new String[][]{PLAINS});
    private static final String[] RIVER = new String[]{"minecraft:river"};
    public static final String[] MUDDY_PIG_SPAWN_BIOMES = BiomeSpawnHelper.getBiomesListFromBiomes(PLAINS, MOUNTAINS, RIVER);
    private static final String[] SAVANNA = new String[]{"minecraft:savanna", "minecraft:savanna_plateau", "minecraft:shattered_savanna", "minecraft:shattered_savanna_plateau"};
    public static final String[] AMBER_CHICKEN_SPAWN_BIOMES = BiomeSpawnHelper.getBiomesListFromBiomes(DESERT, SAVANNA);
    public static final String[] SUNSET_COW_SPAWN_BIOMES = BiomeSpawnHelper.getBiomesListFromBiomes(new String[][]{SAVANNA});
    private static final String[] SNOWY_BEACH = new String[]{"minecraft:snowy_beach"};
    private static final String[] SNOWY_TAIGA = new String[]{"minecraft:snowy_taiga", "minecraft:snowy_taiga_hills", "minecraft:snowy_taiga_mountains"};
    private static final String[] SNOWY_TUNDRA = new String[]{"minecraft:snowy_tundra", "minecraft:snowy_mountains"};
    public static final String[] PALE_PIG_SPAWN_BIOMES = BiomeSpawnHelper.getBiomesListFromBiomes(SNOWY_TUNDRA, SNOWY_TAIGA);
    public static final String[] MELON_GOLEM_SPAWN_BIOMES = BiomeSpawnHelper.getBiomesListFromBiomes(SNOWY_TAIGA, SNOWY_TUNDRA, SNOWY_BEACH, ICE_SPIKE);
    public static final String[] JOLLY_LLAMA_SPAWN_BIOMES = BiomeSpawnHelper.getBiomesListFromBiomes(SNOWY_TUNDRA, ICE_SPIKE, SNOWY_TAIGA, FROZEN_RIVER, SNOWY_BEACH);
    private static final String[] SWAMP = new String[]{"minecraft:swamp", "minecraft:swamp_hills"};
    public static final String[] SPOTTED_PIG_SPAWN_BIOMES = BiomeSpawnHelper.getBiomesListFromBiomes(new String[][]{SWAMP});
    public static final String[] GLOW_SQUID_SPAWN_BIOMES = BiomeSpawnHelper.getBiomesListFromBiomes(OCEAN, RIVER, SWAMP);
    private static final String[] TAIGA = new String[]{"minecraft:taiga", "minecraft:taiga_hills", "minecraft:taiga_mountains"};
    public static final String[] STORMY_CHICKEN_SPAWN_BIOMES = BiomeSpawnHelper.getBiomesListFromBiomes(PLAINS, MOUNTAINS, GRAVELLY_MOUNTAINS, TAIGA);
    public static final String[] FLECKED_SHEEP_SPAWN_BIOMES = BiomeSpawnHelper.getBiomesListFromBiomes(PLAINS, MOUNTAINS, TAIGA, GRAVELLY_MOUNTAINS, FOREST);
    public static final String[] PIEBALD_PIG_SPAWN_BIOMES = BiomeSpawnHelper.getBiomesListFromBiomes(FOREST, BIRCH_FOREST, PLAINS, MOUNTAINS, TAIGA, SAVANNA);
    public static final String[] SKELETON_WOLF_SPAWN_BIOMES = BiomeSpawnHelper.getBiomesListFromBiomes(FOREST, TAIGA, SNOWY_TAIGA, GIANT_TAIGA, BADLANDS);
    public static final String[] WOOLY_COW_SPAWN_BIOMES = BiomeSpawnHelper.getBiomesListFromBiomes(TAIGA, SNOWY_TAIGA, GIANT_TAIGA);

    private BiomeSpawnHelper() {
    }

    public static String[] getBiomesListFromBiomes(String[] ... biomes) {
        return (String[])Stream.of(biomes).flatMap(Stream::of).toArray(String[]::new);
    }

    public static String[] getBiomesListFromBiomeCategories(class_1959.class_1961 ... types) {
        return (String[])Stream.of(types).flatMap(Stream::of).map(class_1959.class_1961::method_8749).toArray(String[]::new);
    }

    private static void setSpawnBiomes(class_1299<?> entity, String[] spawnBiomes, int weight, int minGroupSize, int maxGroupSize, class_1311 classification) {
        List blackList = Arrays.stream(spawnBiomes).filter(id -> id.contains("!")).collect(Collectors.toList());
        List<String> spawnList = BiomeSpawnHelper.expandSpawnList(Arrays.stream(spawnBiomes).filter(id -> !id.contains("!")).collect(Collectors.toList()));
        blackList.replaceAll(s -> s.replace("!", ""));
        spawnList.removeAll(blackList);
        BiomeSpawnHelper.addEntityToBiomes(entity, spawnList, minGroupSize, maxGroupSize, classification, weight);
    }

    private static List<String> expandSpawnList(List<String> spawnList) {
        ArrayList biomes = new ArrayList(Collections.emptyList());
        ArrayList biomeCategories = new ArrayList(Collections.emptyList());
        ArrayList biomesFromCategories = new ArrayList(Collections.emptyList());
        spawnList.forEach(identifier -> {
            if (BiomeSpawnHelper.isBiomeCategory(identifier)) {
                biomeCategories.add(identifier);
            } else {
                biomes.add(identifier);
            }
        });
        for (String biomeCategory : biomeCategories) {
            class_5458.field_25933.forEach(biome -> {
                if (biome.method_8688().toString().toUpperCase().equals(biomeCategory.toUpperCase())) {
                    biomesFromCategories.add(class_5458.field_25933.method_10221(biome).toString());
                }
            });
        }
        return Stream.concat(biomes.stream(), biomesFromCategories.stream()).collect(Collectors.toList());
    }

    private static boolean isBiomeCategory(String identifier) {
        return identifier.split(":").length == 1;
    }

    private static void addEntityToBiomes(class_1299<?> entity, List<String> spawnList, int minGroupSize, int maxGroupSize, class_1311 classification, int weight) {
        for (String identifier : spawnList) {
            String[] splitted = identifier.split(":");
            if (splitted.length == 2) {
                class_5458.field_25933.forEach(biome -> {
                    if (class_5458.field_25933.method_10221(biome).toString().equals(identifier)) {
                        BiomeSpawnHelper.addToBiome(biome, entity, weight, minGroupSize, maxGroupSize, classification);
                    }
                });
                RegistryEntryAddedCallback.event((class_2378)class_5458.field_25933).register((i, registryName, biome) -> {
                    if (registryName.toString().equals(identifier)) {
                        BiomeSpawnHelper.addToBiome(biome, entity, weight, minGroupSize, maxGroupSize, classification);
                    }
                });
            }
            if (splitted.length != 1) continue;
            class_5458.field_25933.forEach(biome -> BiomeSpawnHelper.addToBiomeCategory(biome, identifier, entity, weight, minGroupSize, maxGroupSize, classification));
            RegistryEntryAddedCallback.event((class_2378)class_5458.field_25933).register((i, registryName, biome) -> BiomeSpawnHelper.addToBiomeCategory(biome, identifier, entity, weight, minGroupSize, maxGroupSize, classification));
        }
    }

    private static void addToBiomeCategory(class_1959 biome, String identifier, class_1299<?> entity, int weight, int minGroupSize, int maxGroupSize, class_1311 classification) {
        if (biome.method_8688().toString().toUpperCase().equals(identifier.toUpperCase())) {
            BiomeSpawnHelper.addToBiome(biome, entity, weight, minGroupSize, maxGroupSize, classification);
        }
    }

    private static void addToBiome(class_1959 biome, class_1299<?> entity, int weight, int minGroupSize, int maxGroupSize, class_1311 spawnGroup) {
        class_5483 spawnSettings = biome.method_30966();
        ((ExtendedSpawnSettings)spawnSettings).e2jAddToSpawner(spawnGroup, new class_5483.class_1964(entity, weight, minGroupSize, maxGroupSize));
    }

    public static <T extends class_1429> void setCreatureSpawnBiomes(class_1299<T> entity, String[] spawnBiomes, int weight, int minGroupCountIn, int maxGroupCountIn) {
        BiomeSpawnHelper.setSpawnBiomes(entity, spawnBiomes, weight, minGroupCountIn, maxGroupCountIn, class_1311.field_6294);
    }

    public static <T extends class_1480> void setWaterCreatureSpawnBiomes(class_1299<T> entity, String[] spawnBiomes, int weight, int minGroupCountIn, int maxGroupCountIn) {
        BiomeSpawnHelper.setSpawnBiomes(entity, spawnBiomes, weight, minGroupCountIn, maxGroupCountIn, class_1311.field_6300);
    }

    public static <T extends class_1588> void setMonsterSpawnBiomes(class_1299<T> entity, String[] spawnBiomes, int weight, int minGroupCountIn, int maxGroupCountIn) {
        BiomeSpawnHelper.setSpawnBiomes(entity, spawnBiomes, weight, minGroupCountIn, maxGroupCountIn, class_1311.field_6302);
    }

    public static <T extends class_1308> void setMobSpawnBiomes(class_1299<T> entity, String[] spawnBiomes, int weight, int minGroupCountIn, int maxGroupCountIn) {
        BiomeSpawnHelper.setSpawnBiomes(entity, spawnBiomes, weight, minGroupCountIn, maxGroupCountIn, class_1311.field_17715);
    }

    public static List<String> convertForConfig(String[] ary) {
        return Arrays.stream(ary).collect(Collectors.toList());
    }
}

