/*
 * Decompiled with CFR 0.152.
 */
package slexom.earthtojava.mobs;

import java.util.Random;
import net.minecraft.block.ComposterBlock;
import net.minecraft.block.FlowerBlock;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.BlockStateFeatureConfig;
import net.minecraft.world.gen.feature.DefaultFlowersFeature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.LakesFeature;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import slexom.earthtojava.mobs.config.ConfigHolder;
import slexom.earthtojava.mobs.config.E2JModConfig;
import slexom.earthtojava.mobs.entity.passive.GlowSquidEntity;
import slexom.earthtojava.mobs.init.BlockInit;
import slexom.earthtojava.mobs.init.EntityTypesInit;
import slexom.earthtojava.mobs.init.FluidInit;
import slexom.earthtojava.mobs.init.ItemInit;
import slexom.earthtojava.mobs.init.RecipesInit;
import slexom.earthtojava.mobs.init.TileEntityTypeInit;
import slexom.earthtojava.mobs.utils.BiomeSpawnHelper;
import slexom.earthtojava.mobs.world.spawner.E2JWanderingTraderSpawner;

@Mod(value="earthtojavamobs")
public class EarthToJavaMobsMod {
    public static final String MOD_ID = "earthtojavamobs";

    public EarthToJavaMobsMod() {
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        FluidInit.FLUIDS.register(modEventBus);
        BlockInit.BLOCKS.register(modEventBus);
        TileEntityTypeInit.TILE_ENTITY_TYPES.register(modEventBus);
        EntityTypesInit.ENTITY_TYPES.register(modEventBus);
        ItemInit.ITEMS.register(modEventBus);
        RecipesInit.RECIPES.register(modEventBus);
        modEventBus.register((Object)this);
        modEventBus.addListener(this::setup);
        MinecraftForge.EVENT_BUS.register((Object)new E2JWanderingTraderSpawner());
        modLoadingContext.registerConfig(ModConfig.Type.CLIENT, ConfigHolder.CLIENT_SPEC);
        modLoadingContext.registerConfig(ModConfig.Type.SERVER, ConfigHolder.SERVER_SPEC);
        modLoadingContext.registerConfig(ModConfig.Type.COMMON, ConfigHolder.COMMON_SPEC);
    }

    private static void setMudLakeSpawn() {
        DeferredWorkQueue.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
                    biome.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, new LakesFeature(BlockStateFeatureConfig::func_227271_a_){

                        public boolean func_212245_a(IWorld world, ChunkGenerator generator, Random rand, BlockPos pos, BlockStateFeatureConfig config) {
                            DimensionType dimensionType = world.func_201675_m().func_186058_p();
                            boolean dimensionCriteria = false;
                            if (dimensionType == DimensionType.field_223227_a_) {
                                dimensionCriteria = true;
                            }
                            if (!dimensionCriteria) {
                                return false;
                            }
                            return super.func_212245_a(world, generator, rand, pos, config);
                        }
                    }.func_225566_b_((IFeatureConfig)new BlockStateFeatureConfig(((FlowingFluidBlock)BlockInit.MUD_BLOCK.get()).func_176223_P())).func_227228_a_(Placement.field_215006_E.func_227446_a_((IPlacementConfig)new ChanceConfig(E2JModConfig.mudLakeFrequency))));
                }
            }
        });
    }

    private static void registerEntitiesSpawn() {
        EarthToJavaMobsMod.registerAnimalEntitySpawn((EntityType)EntityTypesInit.AMBER_CHICKEN_REGISTRY_OBJECT.get(), E2JModConfig.amberChickenSpawnBiomes.toArray(new String[0]), E2JModConfig.amberChickenWeight, E2JModConfig.amberChickenGroupMin, E2JModConfig.amberChickenGroupMax);
        EarthToJavaMobsMod.registerAnimalEntitySpawn((EntityType)EntityTypesInit.ASHEN_COW_REGISTRY_OBJECT.get(), E2JModConfig.ashenCowSpawnBiomes.toArray(new String[0]), E2JModConfig.ashenCowWeight, E2JModConfig.ashenCowGroupMin, E2JModConfig.ashenCowGroupMax);
        EarthToJavaMobsMod.registerAnimalEntitySpawn((EntityType)EntityTypesInit.BRONZED_CHICKEN_REGISTRY_OBJECT.get(), E2JModConfig.bronzedChickenSpawnBiomes.toArray(new String[0]), E2JModConfig.bronzedChickenWeight, E2JModConfig.bronzedChickenGroupMin, E2JModConfig.bronzedChickenGroupMax);
        EarthToJavaMobsMod.registerAnimalEntitySpawn((EntityType)EntityTypesInit.CLUCKSHROOM_REGISTRY_OBJECT.get(), E2JModConfig.cluckshroomSpawnBiomes.toArray(new String[0]), E2JModConfig.cluckshroomWeight, E2JModConfig.cluckshroomGroupMin, E2JModConfig.cluckshroomGroupMax);
        EarthToJavaMobsMod.registerAnimalEntitySpawn((EntityType)EntityTypesInit.FLECKED_SHEEP_REGISTRY_OBJECT.get(), E2JModConfig.fleckedSheepSpawnBiomes.toArray(new String[0]), E2JModConfig.fleckedSheepWeight, E2JModConfig.fleckedSheepGroupMin, E2JModConfig.fleckedSheepGroupMax);
        EarthToJavaMobsMod.registerGlowingSquidSpawn();
        EarthToJavaMobsMod.registerAnimalEntitySpawn((EntityType)EntityTypesInit.HARELEQUIN_RABBIT_REGISTRY_OBJECT.get(), E2JModConfig.harelequinRabbitSpawnBiomes.toArray(new String[0]), E2JModConfig.harelequinRabbitWeight, E2JModConfig.harelequinRabbitGroupMin, E2JModConfig.harelequinRabbitGroupMax);
        EarthToJavaMobsMod.registerAnimalEntitySpawn((EntityType)EntityTypesInit.HORNED_SHEEP_REGISTRY_OBJECT.get(), E2JModConfig.hornedSheepSpawnBiomes.toArray(new String[0]), E2JModConfig.hornedSheepWeight, E2JModConfig.hornedSheepGroupMin, E2JModConfig.hornedSheepGroupMax);
        EarthToJavaMobsMod.registerAnimalEntitySpawn((EntityType)EntityTypesInit.INKY_SHEEP_REGISTRY_OBJECT.get(), E2JModConfig.inkySheepSpawnBiomes.toArray(new String[0]), E2JModConfig.inkySheepWeight, E2JModConfig.inkySheepGroupMin, E2JModConfig.inkySheepGroupMax);
        EarthToJavaMobsMod.registerAnimalEntitySpawn((EntityType)EntityTypesInit.MIDNIGHT_CHICKEN_REGISTRY_OBJECT.get(), E2JModConfig.midnightChickenSpawnBiomes.toArray(new String[0]), E2JModConfig.midnightChickenWeight, E2JModConfig.midnightChickenGroupMin, E2JModConfig.midnightChickenGroupMax);
        EarthToJavaMobsMod.registerAnimalEntitySpawn((EntityType)EntityTypesInit.MOOBLOOM_REGISTRY_OBJECT.get(), E2JModConfig.moobloomSpawnBiomes.toArray(new String[0]), E2JModConfig.moobloomWeight, E2JModConfig.moobloomGroupMin, E2JModConfig.moobloomGroupMax);
        EarthToJavaMobsMod.registerAnimalEntitySpawn((EntityType)EntityTypesInit.MUDDY_FOOT_RABBIT_REGISTRY_OBJECT.get(), E2JModConfig.muddyFootRabbitSpawnBiomes.toArray(new String[0]), E2JModConfig.muddyFootRabbitWeight, E2JModConfig.muddyFootRabbitGroupMin, E2JModConfig.muddyFootRabbitGroupMax);
        EarthToJavaMobsMod.registerAnimalEntitySpawn((EntityType)EntityTypesInit.MUDDY_PIG_REGISTRY_OBJECT.get(), E2JModConfig.muddyPigSpawnBiomes.toArray(new String[0]), E2JModConfig.muddyPigWeight, E2JModConfig.muddyPigGroupMin, E2JModConfig.muddyPigGroupMax);
        EarthToJavaMobsMod.registerAnimalEntitySpawn((EntityType)EntityTypesInit.PALE_PIG_REGISTRY_OBJECT.get(), E2JModConfig.palePigSpawnBiomes.toArray(new String[0]), E2JModConfig.palePigWeight, E2JModConfig.palePigGroupMin, E2JModConfig.palePigGroupMax);
        EarthToJavaMobsMod.registerAnimalEntitySpawn((EntityType)EntityTypesInit.PIEBALD_PIG_REGISTRY_OBJECT.get(), E2JModConfig.piebaldPigSpawnBiomes.toArray(new String[0]), E2JModConfig.piebaldPigWeight, E2JModConfig.piebaldPigGroupMin, E2JModConfig.piebaldPigGroupMax);
        EarthToJavaMobsMod.registerAnimalEntitySpawn((EntityType)EntityTypesInit.PINK_FOOTED_PIG_REGISTRY_OBJECT.get(), E2JModConfig.pinkFootedPigSpawnBiomes.toArray(new String[0]), E2JModConfig.pinkFootedPigWeight, E2JModConfig.pinkFootedPigGroupMin, E2JModConfig.pinkFootedPigGroupMax);
        EarthToJavaMobsMod.registerAnimalEntitySpawn((EntityType)EntityTypesInit.ROCKY_SHEEP_REGISTRY_OBJECT.get(), E2JModConfig.rockySheepSpawnBiomes.toArray(new String[0]), E2JModConfig.rockySheepWeight, E2JModConfig.rockySheepGroupMin, E2JModConfig.rockySheepGroupMax);
        EarthToJavaMobsMod.registerMonsterEntitySpawn((EntityType)EntityTypesInit.SKELETON_WOLF_REGISTRY_OBJECT.get(), E2JModConfig.skeletonWolfSpawnBiomes.toArray(new String[0]), E2JModConfig.skeletonWolfWeight, E2JModConfig.skeletonWolfGroupMin, E2JModConfig.skeletonWolfGroupMax);
        EarthToJavaMobsMod.registerAnimalEntitySpawn((EntityType)EntityTypesInit.SPOTTED_PIG_REGISTRY_OBJECT.get(), E2JModConfig.spottedPigSpawnBiomes.toArray(new String[0]), E2JModConfig.spottedPigWeight, E2JModConfig.spottedPigGroupMin, E2JModConfig.spottedPigGroupMax);
        EarthToJavaMobsMod.registerAnimalEntitySpawn((EntityType)EntityTypesInit.STORMY_CHICKEN_REGISTRY_OBJECT.get(), E2JModConfig.stormyChickenSpawnBiomes.toArray(new String[0]), E2JModConfig.stormyChickenWeight, E2JModConfig.stormyChickenGroupMin, E2JModConfig.stormyChickenGroupMax);
        EarthToJavaMobsMod.registerAnimalEntitySpawn((EntityType)EntityTypesInit.SUNSET_COW_REGISTRY_OBJECT.get(), E2JModConfig.sunsetCowSpawnBiomes.toArray(new String[0]), E2JModConfig.sunsetCowWeight, E2JModConfig.sunsetCowGroupMin, E2JModConfig.sunsetCowGroupMax);
        EarthToJavaMobsMod.registerMonsterEntitySpawn((EntityType)EntityTypesInit.TROPICAL_SLIME_REGISTRY_OBJECT.get(), E2JModConfig.tropicalSlimeSpawnBiomes.toArray(new String[0]), E2JModConfig.tropicalSlimeWeight, E2JModConfig.tropicalSlimeGroupMin, E2JModConfig.tropicalSlimeGroupMax);
        EarthToJavaMobsMod.registerAnimalEntitySpawn((EntityType)EntityTypesInit.VESTED_RABBIT_REGISTRY_OBJECT.get(), E2JModConfig.vestedRabbitSpawnBiomes.toArray(new String[0]), E2JModConfig.vestedRabbitWeight, E2JModConfig.vestedRabbitGroupMin, E2JModConfig.vestedRabbitGroupMax);
        EarthToJavaMobsMod.registerAnimalEntitySpawn((EntityType)EntityTypesInit.WOOLY_COW_REGISTRY_OBJECT.get(), E2JModConfig.woolyCowSpawnBiomes.toArray(new String[0]), E2JModConfig.woolyCowWeight, E2JModConfig.woolyCowGroupMin, E2JModConfig.woolyCowGroupMax);
        EarthToJavaMobsMod.registerMobEntitySpawn((EntityType)EntityTypesInit.FURNACE_GOLEM_REGISTRY_OBJECT.get(), E2JModConfig.furnaceGolemSpawnBiomes.toArray(new String[0]), E2JModConfig.furnaceGolemWeight, E2JModConfig.furnaceGolemGroupMin, E2JModConfig.furnaceGolemGroupMax);
        EarthToJavaMobsMod.registerMobEntitySpawn((EntityType)EntityTypesInit.MELON_GOLEM_REGISTRY_OBJECT.get(), E2JModConfig.melonGolemSpawnBiomes.toArray(new String[0]), E2JModConfig.melonGolemWeight, E2JModConfig.melonGolemGroupMin, E2JModConfig.melonGolemGroupMax);
        EarthToJavaMobsMod.registerAnimalEntitySpawn((EntityType)EntityTypesInit.ALBINO_COW_REGISTRY_OBJECT.get(), E2JModConfig.albinoCowSpawnBiomes.toArray(new String[0]), E2JModConfig.albinoCowWeight, E2JModConfig.albinoCowGroupMin, E2JModConfig.albinoCowGroupMax);
        EarthToJavaMobsMod.registerMonsterEntitySpawn((EntityType)EntityTypesInit.BONE_SPIDER_REGISTRY_OBJECT.get(), E2JModConfig.boneSpiderSpawnBiomes.toArray(new String[0]), E2JModConfig.boneSpiderWeight, E2JModConfig.boneSpiderGroupMin, E2JModConfig.boneSpiderGroupMax);
        EarthToJavaMobsMod.registerAnimalEntitySpawn((EntityType)EntityTypesInit.JUMBO_RABBIT_REGISTRY_OBJECT.get(), E2JModConfig.jumboRabbitSpawnBiomes.toArray(new String[0]), E2JModConfig.jumboRabbitWeight, E2JModConfig.jumboRabbitGroupMin, E2JModConfig.jumboRabbitGroupMax);
        EarthToJavaMobsMod.registerAnimalEntitySpawn((EntityType)EntityTypesInit.JOLLY_LLAMA_REGISTRY_OBJECT.get(), E2JModConfig.jollyLlamaSpawnBiomes.toArray(new String[0]), E2JModConfig.jollyLlamaWeight, E2JModConfig.jollyLlamaGroupMin, E2JModConfig.jollyLlamaGroupMax);
        EarthToJavaMobsMod.registerAnimalEntitySpawn((EntityType)EntityTypesInit.RAINBOW_SHEEP_REGISTRY_OBJECT.get(), E2JModConfig.rainbowSheepSpawnBiomes.toArray(new String[0]), E2JModConfig.rainbowSheepWeight, E2JModConfig.rainbowSheepGroupMin, E2JModConfig.rainbowSheepGroupMax);
    }

    private static void registerAnimalEntitySpawn(EntityType entity, String[] spawnBiomes, int weight, int minGroupCountIn, int maxGroupCountIn) {
        DeferredWorkQueue.runLater(() -> {
            BiomeSpawnHelper.setCreatureSpawnBiomes(entity, spawnBiomes, weight, minGroupCountIn, maxGroupCountIn);
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)entity, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AnimalEntity::func_223316_b);
        });
    }

    private static void registerMonsterEntitySpawn(EntityType entity, String[] spawnBiomes, int weight, int minGroupCountIn, int maxGroupCountIn) {
        DeferredWorkQueue.runLater(() -> {
            BiomeSpawnHelper.setMonsterSpawnBiomes(entity, spawnBiomes, weight, minGroupCountIn, maxGroupCountIn);
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)entity, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223324_d);
        });
    }

    private static void registerMobEntitySpawn(EntityType entity, String[] spawnBiomes, int weight, int minGroupCountIn, int maxGroupCountIn) {
        DeferredWorkQueue.runLater(() -> {
            BiomeSpawnHelper.setMonsterSpawnBiomes(entity, spawnBiomes, weight, minGroupCountIn, maxGroupCountIn);
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)entity, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MobEntity::func_223315_a);
        });
    }

    private static void registerGlowingSquidSpawn() {
        DeferredWorkQueue.runLater(() -> {
            BiomeSpawnHelper.setWaterCreatureSpawnBiomes((EntityType)EntityTypesInit.GLOW_SQUID_REGISTRY_OBJECT.get(), E2JModConfig.glowSquidSpawnBiomes.toArray(new String[0]), E2JModConfig.glowSquidWeight, E2JModConfig.glowSquidGroupMin, E2JModConfig.glowSquidGroupMax);
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityTypesInit.GLOW_SQUID_REGISTRY_OBJECT.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, GlowSquidEntity::canGlowingSquidSpawn);
        });
    }

    private static void setButtercupSpawn() {
        DeferredWorkQueue.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
                    biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, new DefaultFlowersFeature(BlockClusterFeatureConfig::func_227300_a_){

                        public boolean place(IWorld world, ChunkGenerator generator, Random random, BlockPos pos, BlockClusterFeatureConfig config) {
                            DimensionType dimensionType = world.func_201675_m().func_186058_p();
                            boolean dimensionCriteria = false;
                            if (dimensionType == DimensionType.field_223227_a_) {
                                dimensionCriteria = true;
                            }
                            if (!dimensionCriteria) {
                                return false;
                            }
                            return super.func_212245_a(world, generator, random, pos, (IFeatureConfig)config);
                        }
                    }.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((FlowerBlock)BlockInit.BUTTERCUP.get()).func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227322_d_()).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(5))));
                }
            }
        });
    }

    private static void registerToComposter() {
        DeferredWorkQueue.runLater(() -> ComposterBlock.func_220290_a((float)0.65f, (IItemProvider)((IItemProvider)BlockInit.BUTTERCUP.get())));
    }

    private void setup(FMLCommonSetupEvent event) {
        EarthToJavaMobsMod.registerToComposter();
        EarthToJavaMobsMod.setMudLakeSpawn();
        EarthToJavaMobsMod.setButtercupSpawn();
        EarthToJavaMobsMod.registerEntitiesSpawn();
    }

    public static class E2JItemGroup
    extends ItemGroup {
        public static final E2JItemGroup instance = new E2JItemGroup(ItemGroup.field_78032_a.length, "earthtojavamobs");

        private E2JItemGroup(int index, String label) {
            super(index, label);
        }

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)ItemInit.HORN.get());
        }
    }
}

