/*
 * Decompiled with CFR 0.152.
 */
package slexom.earthtojava.mobs;

import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CarvedPumpkinBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.pattern.BlockMaterialMatcher;
import net.minecraft.block.pattern.BlockPattern;
import net.minecraft.block.pattern.BlockPatternBuilder;
import net.minecraft.block.pattern.BlockStateMatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.EggEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.IProperty;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slexom.earthtojava.mobs.entity.passive.FurnaceGolemEntity;
import slexom.earthtojava.mobs.init.BlockInit;
import slexom.earthtojava.mobs.init.EntityTypesInit;

@Mod.EventBusSubscriber(modid="earthtojavamobs", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class ForgeEventSubscriber {
    private static final Logger LOGGER = LogManager.getLogger((String)"earthtojavamobs Mod Event Subscriber");
    private static final Predicate<BlockState> IS_PUMPKIN = blockState -> blockState != null && (blockState.func_177230_c() == Blocks.field_196625_cS || blockState.func_177230_c() == Blocks.field_196628_cT);

    @SubscribeEvent
    public static void onEggThrown(ProjectileImpactEvent.Throwable event) {
        ThrowableEntity throwable = event.getThrowable();
        World world = throwable.field_70170_p;
        if (throwable instanceof EggEntity && !world.field_72995_K) {
            if (new Random().nextInt(8) == 0) {
                int i = 1;
                if (new Random().nextInt(32) == 0) {
                    i = 4;
                }
                for (int j = 0; j < i; ++j) {
                    ChickenEntity chickenentity = ForgeEventSubscriber.getChickenEntity(world);
                    chickenentity.func_70873_a(-24000);
                    chickenentity.func_70012_b(throwable.func_226277_ct_(), throwable.func_226278_cu_(), throwable.func_226281_cx_(), throwable.field_70177_z, 0.0f);
                    world.func_217376_c((Entity)chickenentity);
                }
            }
            world.func_72960_a((Entity)throwable, (byte)3);
            throwable.func_70106_y();
        }
    }

    private static ChickenEntity getChickenEntity(World world) {
        ChickenEntity chickenentity;
        int chickenType = new Random().nextInt(8);
        switch (chickenType) {
            case 0: {
                chickenentity = (ChickenEntity)((EntityType)EntityTypesInit.AMBER_CHICKEN_REGISTRY_OBJECT.get()).func_200721_a(world);
                break;
            }
            case 2: {
                chickenentity = (ChickenEntity)((EntityType)EntityTypesInit.MIDNIGHT_CHICKEN_REGISTRY_OBJECT.get()).func_200721_a(world);
                break;
            }
            case 4: {
                chickenentity = (ChickenEntity)((EntityType)EntityTypesInit.STORMY_CHICKEN_REGISTRY_OBJECT.get()).func_200721_a(world);
                break;
            }
            case 6: {
                chickenentity = (ChickenEntity)((EntityType)EntityTypesInit.BRONZED_CHICKEN_REGISTRY_OBJECT.get()).func_200721_a(world);
                break;
            }
            default: {
                chickenentity = (ChickenEntity)EntityType.field_200795_i.func_200721_a(world);
            }
        }
        return chickenentity;
    }

    @SubscribeEvent
    public static void onCarvingMelon(PlayerInteractEvent.RightClickBlock event) {
        PlayerEntity player = event.getPlayer();
        BlockPos pos = event.getPos();
        Hand hand = event.getHand();
        ItemStack itemstack = player.func_184586_b(hand);
        World worldIn = player.field_70170_p;
        BlockState blockState = worldIn.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (itemstack.func_77973_b() == Items.field_151097_aZ && block == Blocks.field_150440_ba && !worldIn.field_72995_K) {
            Direction direction = event.getFace();
            Direction direction1 = direction.func_176740_k() == Direction.Axis.Y ? player.func_174811_aO().func_176734_d() : direction;
            worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_199059_fV, SoundCategory.BLOCKS, 1.0f, 1.0f);
            worldIn.func_180501_a(pos, (BlockState)((Block)BlockInit.CARVED_MELON.get()).func_176223_P().func_206870_a((IProperty)CarvedPumpkinBlock.field_196359_a, (Comparable)direction1), 11);
            ItemEntity itementity = new ItemEntity(worldIn, (double)pos.func_177958_n() + 0.5 + (double)direction1.func_82601_c() * 0.65, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5 + (double)direction1.func_82599_e() * 0.65, new ItemStack((IItemProvider)Items.field_151081_bc, 4));
            itementity.func_213293_j(0.05 * (double)direction1.func_82601_c() + worldIn.field_73012_v.nextDouble() * 0.02, 0.05, 0.05 * (double)direction1.func_82599_e() + worldIn.field_73012_v.nextDouble() * 0.02);
            worldIn.func_217376_c((Entity)itementity);
            itemstack.func_222118_a(1, (LivingEntity)player, entity -> entity.func_213334_d(hand));
        }
    }

    @SubscribeEvent
    public static void onFurnaceGolemCreation(BlockEvent.EntityPlaceEvent event) {
        BlockState blockState = event.getPlacedBlock();
        Block block = blockState.func_177230_c();
        if (block == Blocks.field_150339_S || block == Blocks.field_222424_lM || block == Blocks.field_196628_cT || block == Blocks.field_196625_cS) {
            World world = event.getWorld().func_201672_e();
            BlockPos pos = event.getPos();
            BlockPattern golemPattern = BlockPatternBuilder.func_177660_a().func_177659_a(new String[]{"~^~", "#@#", "~#~"}).func_177662_a('^', CachedBlockInfo.func_177510_a(IS_PUMPKIN)).func_177662_a('#', CachedBlockInfo.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)Blocks.field_150339_S))).func_177662_a('@', CachedBlockInfo.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)Blocks.field_222424_lM))).func_177662_a('~', CachedBlockInfo.func_177510_a((Predicate)BlockMaterialMatcher.func_189886_a((Material)Material.field_151579_a))).func_177661_b();
            BlockPattern.PatternHelper patternHelper = golemPattern.func_177681_a((IWorldReader)world, pos);
            if (patternHelper != null) {
                for (int j = 0; j < golemPattern.func_177684_c(); ++j) {
                    for (int k = 0; k < golemPattern.func_177685_b(); ++k) {
                        CachedBlockInfo cachedBlockInfo = patternHelper.func_177670_a(j, k, 0);
                        world.func_180501_a(cachedBlockInfo.func_177508_d(), Blocks.field_150350_a.func_176223_P(), 2);
                        world.func_217379_c(2001, cachedBlockInfo.func_177508_d(), Block.func_196246_j((BlockState)cachedBlockInfo.func_177509_a()));
                    }
                }
                BlockPos blockpos = patternHelper.func_177670_a(1, 2, 0).func_177508_d();
                FurnaceGolemEntity furnaceGolemEntity = (FurnaceGolemEntity)((EntityType)EntityTypesInit.FURNACE_GOLEM_REGISTRY_OBJECT.get()).func_200721_a(world);
                furnaceGolemEntity.func_70849_f(true);
                furnaceGolemEntity.func_70012_b((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.05, (double)blockpos.func_177952_p() + 0.5, 0.0f, 0.0f);
                world.func_217376_c((Entity)furnaceGolemEntity);
                for (ServerPlayerEntity serverplayerentity1 : world.func_217357_a(ServerPlayerEntity.class, furnaceGolemEntity.func_174813_aQ().func_186662_g(5.0))) {
                    CriteriaTriggers.field_192133_m.func_192229_a(serverplayerentity1, (Entity)furnaceGolemEntity);
                }
                for (int i1 = 0; i1 < golemPattern.func_177684_c(); ++i1) {
                    for (int j1 = 0; j1 < golemPattern.func_177685_b(); ++j1) {
                        CachedBlockInfo cachedblockinfo1 = patternHelper.func_177670_a(i1, j1, 0);
                        world.func_195592_c(cachedblockinfo1.func_177508_d(), Blocks.field_150350_a);
                    }
                }
            }
        }
    }
}

