/*
 * Decompiled with CFR 0.152.
 */
package slexom.earthtojava.mobs;

import net.minecraft.block.Block;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slexom.earthtojava.mobs.EarthToJavaMobsMod;
import slexom.earthtojava.mobs.client.renderer.tileentity.RainbowBedItemStackTileEntityRenderer;
import slexom.earthtojava.mobs.config.ConfigHelper;
import slexom.earthtojava.mobs.config.ConfigHolder;
import slexom.earthtojava.mobs.init.BlockInit;
import slexom.earthtojava.mobs.item.E2JBlockItem;
import slexom.earthtojava.mobs.item.ModdedSpawnEggItem;
import slexom.earthtojava.mobs.world.gen.E2JOreGen;

@Mod.EventBusSubscriber(modid="earthtojavamobs", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ModEventSubscriber {
    private static final Logger LOGGER = LogManager.getLogger((String)"earthtojavamobs Mod Event Subscriber");

    @SubscribeEvent
    public static void onRegisterItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        EarthToJavaMobsMod.E2JItemGroup ITEM_GROUP = EarthToJavaMobsMod.E2JItemGroup.instance;
        BlockInit.BLOCKS.getEntries().stream().filter(block -> !(block.get() instanceof FlowingFluidBlock)).filter(block -> block.get() != BlockInit.POTTED_BUTTERCUP.get()).map(RegistryObject::get).forEach(block -> {
            Item.Properties properties = new Item.Properties().func_200916_a(ITEM_GROUP);
            Item.Properties hiddenBlockProperties = new Item.Properties().func_200916_a(null);
            if (block == BlockInit.MELON_GOLEM_HEAD_BLINK.get() || block == BlockInit.MELON_GOLEM_HEAD_SHOOT.get()) {
                E2JBlockItem blockItem = new E2JBlockItem((Block)block, hiddenBlockProperties);
                blockItem.setRegistryName(block.getRegistryName());
                registry.register((IForgeRegistryEntry)blockItem);
            } else if (block == BlockInit.RAINBOW_BED.get()) {
                Item.Properties bedProperties = new Item.Properties().setISTER(() -> RainbowBedItemStackTileEntityRenderer::new).func_200916_a(ITEM_GROUP);
                E2JBlockItem blockItem = new E2JBlockItem((Block)block, bedProperties);
                blockItem.setRegistryName(block.getRegistryName());
                registry.register((IForgeRegistryEntry)blockItem);
            } else {
                E2JBlockItem blockItem = new E2JBlockItem((Block)block, properties);
                blockItem.setRegistryName(block.getRegistryName());
                registry.register((IForgeRegistryEntry)blockItem);
            }
        });
    }

    @SubscribeEvent
    public static void onModConfigEvent(ModConfig.ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == ConfigHolder.CLIENT_SPEC) {
            ConfigHelper.bakeClient(config);
            LOGGER.debug("Baked client config");
        } else if (config.getSpec() == ConfigHolder.COMMON_SPEC) {
            ConfigHelper.bakeCommon(config);
            LOGGER.debug("Baked common config");
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPostRegisterEntities(RegistryEvent.Register<EntityType<?>> event) {
        ModdedSpawnEggItem.initUnaddedEggs();
    }

    @SubscribeEvent
    public static void registerOres(FMLLoadCompleteEvent event) {
        E2JOreGen.generateOre();
    }
}

