/*
 * Decompiled with CFR 0.152.
 */
package slexom.earthtojava.mobs.block;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.pattern.BlockPattern;
import net.minecraft.block.pattern.BlockPatternBuilder;
import net.minecraft.block.pattern.BlockStateMatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import slexom.earthtojava.mobs.entity.passive.MelonGolemEntity;
import slexom.earthtojava.mobs.init.BlockInit;
import slexom.earthtojava.mobs.init.EntityTypesInit;

public class CarvedMelonBlock
extends HorizontalBlock {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    @Nullable
    private BlockPattern snowmanBasePattern;
    @Nullable
    private BlockPattern snowmanPattern;
    private static final Predicate<BlockState> IS_MELON = p_210301_0_ -> p_210301_0_ != null && (p_210301_0_.func_177230_c() == BlockInit.CARVED_MELON.get() || p_210301_0_.func_177230_c() == BlockInit.MELON_LANTERN.get());

    public CarvedMelonBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH));
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (oldState.func_177230_c() != state.func_177230_c()) {
            this.trySpawnGolem(worldIn, pos);
        }
    }

    public boolean canDispenserPlace(IWorldReader p_196354_1_, BlockPos p_196354_2_) {
        return this.getSnowmanBasePattern().func_177681_a(p_196354_1_, p_196354_2_) != null;
    }

    private void trySpawnGolem(World p_196358_1_, BlockPos p_196358_2_) {
        BlockPattern.PatternHelper blockpattern$patternhelper = this.getSnowmanPattern().func_177681_a((IWorldReader)p_196358_1_, p_196358_2_);
        if (blockpattern$patternhelper != null) {
            for (int i = 0; i < this.getSnowmanPattern().func_177685_b(); ++i) {
                CachedBlockInfo cachedBlockInfo = blockpattern$patternhelper.func_177670_a(0, i, 0);
                p_196358_1_.func_180501_a(cachedBlockInfo.func_177508_d(), Blocks.field_150350_a.func_176223_P(), 2);
                p_196358_1_.func_217379_c(2001, cachedBlockInfo.func_177508_d(), Block.func_196246_j((BlockState)cachedBlockInfo.func_177509_a()));
            }
            MelonGolemEntity melonGolemEntity = (MelonGolemEntity)((EntityType)EntityTypesInit.MELON_GOLEM_REGISTRY_OBJECT.get()).func_200721_a(p_196358_1_);
            BlockPos blockPos = blockpattern$patternhelper.func_177670_a(0, 2, 0).func_177508_d();
            melonGolemEntity.func_70012_b((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.05, (double)blockPos.func_177952_p() + 0.5, 0.0f, 0.0f);
            p_196358_1_.func_217376_c((Entity)melonGolemEntity);
            for (ServerPlayerEntity serverplayerentity : p_196358_1_.func_217357_a(ServerPlayerEntity.class, melonGolemEntity.func_174813_aQ().func_186662_g(5.0))) {
                CriteriaTriggers.field_192133_m.func_192229_a(serverplayerentity, (Entity)melonGolemEntity);
            }
            for (int l = 0; l < this.getSnowmanPattern().func_177685_b(); ++l) {
                CachedBlockInfo cachedBlockInfo3 = blockpattern$patternhelper.func_177670_a(0, l, 0);
                p_196358_1_.func_195592_c(cachedBlockInfo3.func_177508_d(), Blocks.field_150350_a);
            }
        }
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING});
    }

    private BlockPattern getSnowmanBasePattern() {
        if (this.snowmanBasePattern == null) {
            this.snowmanBasePattern = BlockPatternBuilder.func_177660_a().func_177659_a(new String[]{" ", "#", "#"}).func_177662_a('#', CachedBlockInfo.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)Blocks.field_196604_cC))).func_177661_b();
        }
        return this.snowmanBasePattern;
    }

    private BlockPattern getSnowmanPattern() {
        if (this.snowmanPattern == null) {
            this.snowmanPattern = BlockPatternBuilder.func_177660_a().func_177659_a(new String[]{"^", "#", "#"}).func_177662_a('^', CachedBlockInfo.func_177510_a(IS_MELON)).func_177662_a('#', CachedBlockInfo.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)Blocks.field_196604_cC))).func_177661_b();
        }
        return this.snowmanPattern;
    }

    public boolean func_220067_a(BlockState state, IBlockReader worldIn, BlockPos pos, EntityType<?> type) {
        return true;
    }
}

