/*
 * Decompiled with CFR 0.152.
 */
package slexom.earthtojava.mobs.client.renderer.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.text.MessageFormat;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.layers.SlimeGelLayer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.SlimeModel;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import slexom.earthtojava.mobs.entity.passive.TropicalSlimeEntity;

@OnlyIn(value=Dist.CLIENT)
public class TropicalSlimeRenderer
extends MobRenderer<TropicalSlimeEntity, SlimeModel<TropicalSlimeEntity>> {
    private static final int ANIMATION_FRAMES = 48;
    private static final float ANIMATION_TIME = 12.0f;
    private int currentFrame = 0;

    public TropicalSlimeRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, (EntityModel)new SlimeModel(16), 0.25f);
        this.func_177094_a((LayerRenderer)new SlimeGelLayer((IEntityRenderer)this));
    }

    public void render(TropicalSlimeEntity entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        this.field_76989_e = 1.0f;
        this.currentFrame = (int)(Math.floor((float)entityIn.field_70173_aa / 12.0f) % 48.0);
        super.func_225623_a_((MobEntity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    protected void preRenderCallback(TropicalSlimeEntity entitylivingbaseIn, MatrixStack matrixStackIn, float partialTickTime) {
        float f = 0.999f;
        matrixStackIn.func_227862_a_(0.999f, 0.999f, 0.999f);
        matrixStackIn.func_227861_a_(0.0, (double)0.001f, 0.0);
        float f1 = 4.0f;
        float f2 = MathHelper.func_219799_g((float)partialTickTime, (float)entitylivingbaseIn.prevSquishFactor, (float)entitylivingbaseIn.squishFactor) / (f1 * 0.5f + 1.0f);
        float f3 = 1.0f / (f2 + 1.0f);
        matrixStackIn.func_227862_a_(f3 * f1, 1.0f / f3 * f1, f3 * f1);
    }

    public ResourceLocation getEntityTexture(TropicalSlimeEntity entity) {
        String frameLocation = MessageFormat.format("earthtojavamobs:textures/mobs/slime/tropical_slime/tropical_slime_anim_{0}.png", this.currentFrame + 1);
        return new ResourceLocation(frameLocation);
    }
}

