/*
 * Decompiled with CFR 0.152.
 */
package slexom.earthtojava.mobs.client.renderer.entity.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.renderer.entity.model.AgeableModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CluckshroomModel<T extends Entity>
extends AgeableModel<T> {
    private final ModelRenderer head;
    private final ModelRenderer body;
    private final ModelRenderer rightLeg;
    private final ModelRenderer leftLeg;
    private final ModelRenderer rightWing;
    private final ModelRenderer leftWing;
    private final ModelRenderer bill;
    private final ModelRenderer chin;

    public CluckshroomModel() {
        int i = 16;
        this.head = new ModelRenderer((Model)this, 0, 0);
        this.head.func_228301_a_(-2.0f, -6.0f, -2.0f, 4.0f, 6.0f, 3.0f, 0.0f);
        this.head.func_78793_a(0.0f, 15.0f, -4.0f);
        this.bill = new ModelRenderer((Model)this, 14, 0);
        this.bill.func_228301_a_(-2.0f, -4.0f, -4.0f, 4.0f, 2.0f, 2.0f, 0.0f);
        this.bill.func_78793_a(0.0f, 15.0f, -4.0f);
        this.chin = new ModelRenderer((Model)this, 14, 4);
        this.chin.func_228301_a_(-1.0f, -2.0f, -3.0f, 2.0f, 2.0f, 2.0f, 0.0f);
        this.chin.func_78793_a(0.0f, 15.0f, -4.0f);
        this.body = new ModelRenderer((Model)this, 0, 9);
        this.body.func_228301_a_(-3.0f, -4.0f, -3.0f, 6.0f, 8.0f, 6.0f, 0.0f);
        this.body.func_78793_a(0.0f, 16.0f, 0.0f);
        this.rightLeg = new ModelRenderer((Model)this, 26, 0);
        this.rightLeg.func_228300_a_(-1.0f, 0.0f, -3.0f, 3.0f, 5.0f, 3.0f);
        this.rightLeg.func_78793_a(-2.0f, 19.0f, 1.0f);
        this.leftLeg = new ModelRenderer((Model)this, 26, 0);
        this.leftLeg.func_228300_a_(-1.0f, 0.0f, -3.0f, 3.0f, 5.0f, 3.0f);
        this.leftLeg.func_78793_a(1.0f, 19.0f, 1.0f);
        this.rightWing = new ModelRenderer((Model)this, 24, 13);
        this.rightWing.func_228300_a_(0.0f, 0.0f, -3.0f, 1.0f, 4.0f, 6.0f);
        this.rightWing.func_78793_a(-4.0f, 13.0f, 0.0f);
        this.leftWing = new ModelRenderer((Model)this, 24, 13);
        this.leftWing.func_228300_a_(-1.0f, 0.0f, -3.0f, 1.0f, 4.0f, 6.0f);
        this.leftWing.func_78793_a(4.0f, 13.0f, 0.0f);
    }

    protected Iterable<ModelRenderer> func_225602_a_() {
        return ImmutableList.of((Object)this.head, (Object)this.bill, (Object)this.chin);
    }

    protected Iterable<ModelRenderer> func_225600_b_() {
        return ImmutableList.of((Object)this.body, (Object)this.rightLeg, (Object)this.leftLeg, (Object)this.rightWing, (Object)this.leftWing);
    }

    public void func_225597_a_(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.field_78795_f = headPitch * ((float)Math.PI / 180);
        this.head.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
        this.bill.field_78795_f = this.head.field_78795_f;
        this.bill.field_78796_g = this.head.field_78796_g;
        this.chin.field_78795_f = this.head.field_78795_f;
        this.chin.field_78796_g = this.head.field_78796_g;
        this.body.field_78795_f = 1.5707964f;
        this.rightLeg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftLeg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.rightWing.field_78808_h = ageInTicks;
        this.leftWing.field_78808_h = -ageInTicks;
    }

    public ModelRenderer getHead() {
        return this.head;
    }
}

