/*
 * Decompiled with CFR 0.152.
 */
package slexom.earthtojava.mobs.client.renderer.entity.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import slexom.earthtojava.mobs.entity.passive.JumboRabbitEntity;

@OnlyIn(value=Dist.CLIENT)
public class JumboRabbitModel<T extends JumboRabbitEntity>
extends EntityModel<T> {
    private final ModelRenderer rabbitLeftFoot;
    private final ModelRenderer rabbitRightFoot;
    private final ModelRenderer rabbitLeftThigh;
    private final ModelRenderer rabbitRightThigh;
    private final ModelRenderer rabbitBody;
    private final ModelRenderer rabbitLeftArm;
    private final ModelRenderer rabbitRightArm;
    private final ModelRenderer rabbitHead;
    private final ModelRenderer rabbitRightEar;
    private final ModelRenderer rabbitLeftEar;
    private final ModelRenderer rabbitTail;
    private final ModelRenderer rabbitNose;
    private float jumpRotation;

    public JumboRabbitModel() {
        float bodyX = -3.5f;
        float bodyY = -6.0f;
        float bodyZ = -11.5f;
        float headX = bodyX + 1.5f;
        float headY = -8.0f;
        float headZ = -5.0f;
        this.rabbitLeftFoot = new ModelRenderer((Model)this, 24, 47).func_78787_b(64, 64);
        this.rabbitLeftFoot.func_228300_a_(-0.0f, 5.5f, -2.7f, 3.0f, 2.0f, 9.0f);
        this.rabbitLeftFoot.func_78793_a(3.0f, 17.5f, 3.7f);
        this.rabbitLeftFoot.field_78809_i = true;
        this.setRotationOffset(this.rabbitLeftFoot, 0.0f, 0.0f, 0.0f);
        this.rabbitRightFoot = new ModelRenderer((Model)this, 0, 47).func_78787_b(64, 64);
        this.rabbitRightFoot.func_228300_a_(-2.0f, 5.5f, -2.7f, 3.0f, 2.0f, 9.0f);
        this.rabbitRightFoot.func_78793_a(-3.0f, 17.5f, 3.7f);
        this.rabbitRightFoot.field_78809_i = true;
        this.setRotationOffset(this.rabbitRightFoot, 0.0f, 0.0f, 0.0f);
        this.rabbitLeftThigh = new ModelRenderer((Model)this, 42, 14).func_78787_b(64, 64);
        this.rabbitLeftThigh.func_228300_a_(-0.0f, -4.0f, 0.0f, 3.0f, 7.0f, 8.0f);
        this.rabbitLeftThigh.func_78793_a(3.0f, 17.5f, 3.7f);
        this.rabbitLeftThigh.field_78809_i = true;
        this.setRotationOffset(this.rabbitLeftThigh, -0.34906584f, 0.0f, 0.0f);
        this.rabbitRightThigh = new ModelRenderer((Model)this, 42, 29).func_78787_b(64, 64);
        this.rabbitRightThigh.func_228300_a_(-2.0f, -4.0f, 0.0f, 3.0f, 7.0f, 8.0f);
        this.rabbitRightThigh.func_78793_a(-3.0f, 17.5f, 3.7f);
        this.rabbitRightThigh.field_78809_i = true;
        this.setRotationOffset(this.rabbitRightThigh, -0.34906584f, 0.0f, 0.0f);
        this.rabbitBody = new ModelRenderer((Model)this, 0, 0).func_78787_b(64, 64);
        this.rabbitBody.func_228300_a_(bodyX, bodyY, bodyZ, 8.0f, 8.0f, 14.0f);
        this.rabbitBody.func_78793_a(0.0f, 19.0f, 8.0f);
        this.rabbitBody.field_78809_i = true;
        this.setRotationOffset(this.rabbitBody, -0.34906584f, 0.0f, 0.0f);
        this.rabbitLeftArm = new ModelRenderer((Model)this, 8, 33).func_78787_b(64, 64);
        this.rabbitLeftArm.func_228300_a_(0.0f, -3.0f, -2.7f, 2.0f, 11.0f, 3.0f);
        this.rabbitLeftArm.func_78793_a(3.0f, 17.0f, -1.0f);
        this.rabbitLeftArm.field_78809_i = true;
        this.setRotationOffset(this.rabbitLeftArm, -0.17453292f, 0.0f, 0.0f);
        this.rabbitRightArm = new ModelRenderer((Model)this, 0, 33).func_78787_b(64, 64);
        this.rabbitRightArm.func_228300_a_(-1.0f, -3.0f, -2.7f, 2.0f, 11.0f, 3.0f);
        this.rabbitRightArm.func_78793_a(-3.0f, 17.0f, -1.0f);
        this.rabbitRightArm.field_78809_i = true;
        this.setRotationOffset(this.rabbitRightArm, -0.17453292f, 0.0f, 0.0f);
        this.rabbitHead = new ModelRenderer((Model)this, 0, 22).func_78787_b(64, 64);
        this.rabbitHead.func_228300_a_(headX, headY, headZ, 5.0f, 5.0f, 6.0f);
        this.rabbitHead.func_78793_a(0.0f, 16.0f, -1.0f);
        this.rabbitHead.field_78809_i = true;
        this.setRotationOffset(this.rabbitHead, 0.0f, 0.0f, 0.0f);
        this.rabbitRightEar = new ModelRenderer((Model)this, 48, 0).func_78787_b(64, 64);
        this.rabbitRightEar.func_228300_a_(headX - 1.0f, headY - 12.0f, headZ + 4.0f, 3.0f, 10.0f, 1.0f).func_78784_a(48, 11).func_228300_a_(headX, headY - 2.0f, headZ + 4.0f, 2.0f, 2.0f, 1.0f);
        this.rabbitRightEar.func_78793_a(0.0f, 16.0f, -1.0f);
        this.rabbitRightEar.field_78809_i = true;
        this.setRotationOffset(this.rabbitRightEar, 0.0f, -0.2617994f, 0.0f);
        this.rabbitLeftEar = new ModelRenderer((Model)this, 56, 0).func_78787_b(64, 64);
        this.rabbitLeftEar.func_228300_a_(headX + 3.0f, headY - 12.0f, headZ + 4.0f, 3.0f, 10.0f, 1.0f).func_78784_a(54, 11).func_228300_a_(headX + 3.0f, headY - 2.0f, headZ + 4.0f, 2.0f, 2.0f, 1.0f);
        this.rabbitLeftEar.func_78793_a(0.0f, 16.0f, -1.0f);
        this.rabbitLeftEar.field_78809_i = true;
        this.setRotationOffset(this.rabbitLeftEar, 0.0f, 0.2617994f, 0.0f);
        this.rabbitTail = new ModelRenderer((Model)this, 22, 22).func_78787_b(64, 64);
        this.rabbitTail.func_228300_a_(bodyX + 2.5f, bodyY + 1.0f, bodyZ + 14.0f, 3.0f, 3.0f, 2.0f);
        this.rabbitTail.func_78793_a(0.0f, 20.0f, 7.0f);
        this.rabbitTail.field_78809_i = true;
        this.setRotationOffset(this.rabbitTail, -0.3490659f, 0.0f, 0.0f);
        this.rabbitNose = new ModelRenderer((Model)this, 22, 27).func_78787_b(64, 64);
        this.rabbitNose.func_228300_a_(headX + 2.0f, headY + 2.0f, headZ - 1.0f, 1.0f, 1.0f, 1.0f);
        this.rabbitNose.func_78793_a(0.0f, 16.0f, -1.0f);
        this.rabbitNose.field_78809_i = true;
        this.setRotationOffset(this.rabbitNose, 0.0f, 0.0f, 0.0f);
    }

    private void setRotationOffset(ModelRenderer renderer, float x, float y, float z) {
        renderer.field_78795_f = x;
        renderer.field_78796_g = y;
        renderer.field_78808_h = z;
    }

    public void func_225598_a_(MatrixStack matrixStackIn, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (this.field_217114_e) {
            float f = 1.5f;
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227862_a_(0.56666666f, 0.56666666f, 0.56666666f);
            matrixStackIn.func_227861_a_(0.0, 1.375, 0.125);
            ImmutableList.of((Object)this.rabbitHead, (Object)this.rabbitLeftEar, (Object)this.rabbitRightEar, (Object)this.rabbitNose).forEach(p_228292_8_ -> p_228292_8_.func_228309_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha));
            matrixStackIn.func_227865_b_();
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227862_a_(0.4f, 0.4f, 0.4f);
            matrixStackIn.func_227861_a_(0.0, 2.25, 0.0);
            ImmutableList.of((Object)this.rabbitLeftFoot, (Object)this.rabbitRightFoot, (Object)this.rabbitLeftThigh, (Object)this.rabbitRightThigh, (Object)this.rabbitBody, (Object)this.rabbitLeftArm, (Object)this.rabbitRightArm, (Object)this.rabbitTail).forEach(p_228291_8_ -> p_228291_8_.func_228309_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha));
            matrixStackIn.func_227865_b_();
        } else {
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227862_a_(0.6f, 0.6f, 0.6f);
            matrixStackIn.func_227861_a_(0.0, 1.0, 0.0);
            ImmutableList.of((Object)this.rabbitLeftFoot, (Object)this.rabbitRightFoot, (Object)this.rabbitLeftThigh, (Object)this.rabbitRightThigh, (Object)this.rabbitBody, (Object)this.rabbitLeftArm, (Object)this.rabbitRightArm, (Object)this.rabbitHead, (Object)this.rabbitRightEar, (Object)this.rabbitLeftEar, (Object)this.rabbitTail, (Object)this.rabbitNose, (Object[])new ModelRenderer[0]).forEach(p_228290_8_ -> p_228290_8_.func_228309_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha));
            matrixStackIn.func_227865_b_();
        }
    }

    public void setRotationAngles(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float f = ageInTicks - (float)((JumboRabbitEntity)((Object)entityIn)).field_70173_aa;
        this.rabbitNose.field_78795_f = headPitch * ((float)Math.PI / 180);
        this.rabbitHead.field_78795_f = headPitch * ((float)Math.PI / 180);
        this.rabbitRightEar.field_78795_f = headPitch * ((float)Math.PI / 180);
        this.rabbitLeftEar.field_78795_f = headPitch * ((float)Math.PI / 180);
        this.rabbitNose.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
        this.rabbitHead.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
        this.rabbitRightEar.field_78796_g = this.rabbitNose.field_78796_g - 0.2617994f;
        this.rabbitLeftEar.field_78796_g = this.rabbitNose.field_78796_g + 0.2617994f;
        this.jumpRotation = MathHelper.func_76126_a((float)(entityIn.func_175521_o(f) * (float)Math.PI));
        this.rabbitLeftThigh.field_78795_f = (this.jumpRotation * 50.0f - 21.0f) * ((float)Math.PI / 180);
        this.rabbitRightThigh.field_78795_f = (this.jumpRotation * 50.0f - 21.0f) * ((float)Math.PI / 180);
        this.rabbitLeftFoot.field_78795_f = this.jumpRotation * 50.0f * ((float)Math.PI / 180);
        this.rabbitRightFoot.field_78795_f = this.jumpRotation * 50.0f * ((float)Math.PI / 180);
        this.rabbitLeftArm.field_78795_f = (this.jumpRotation * -40.0f - 11.0f) * ((float)Math.PI / 180);
        this.rabbitRightArm.field_78795_f = (this.jumpRotation * -40.0f - 11.0f) * ((float)Math.PI / 180);
    }

    public void setLivingAnimations(T entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        super.func_212843_a_(entityIn, limbSwing, limbSwingAmount, partialTick);
        this.jumpRotation = MathHelper.func_76126_a((float)(entityIn.func_175521_o(partialTick) * (float)Math.PI));
    }
}

