/*
 * Decompiled with CFR 0.152.
 */
package slexom.earthtojava.mobs.entity.monster;

import java.util.EnumSet;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import slexom.earthtojava.mobs.entity.base.E2JBaseSpiderEntity;
import slexom.earthtojava.mobs.entity.projectile.BoneShardEntity;

public class BoneSpiderEntity
extends E2JBaseSpiderEntity<BoneSpiderEntity>
implements IRangedAttackMob {
    public BoneSpiderEntity(EntityType<BoneSpiderEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new StationaryRangedAttackGoal(this, 20, 40, 12.0f));
        this.field_70714_bg.func_75776_a(4, (Goal)new LeapAtTargetGoal((MobEntity)this, 0.4f));
        this.field_70714_bg.func_75776_a(4, (Goal)new AttackGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(32.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        BoneShardEntity boneShard = new BoneShardEntity(this.field_70170_p, (LivingEntity)this);
        double d0 = target.func_226280_cw_() - (double)1.1f;
        double d1 = target.func_226277_ct_() - this.func_226277_ct_();
        double d2 = d0 - boneShard.func_226278_cu_();
        double d3 = target.func_226281_cx_() - this.func_226281_cx_();
        float f = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3)) * 0.2f;
        boneShard.func_70186_c(d1, d2 + (double)f, d3, 1.6f, 8.0f);
        this.func_184185_a(SoundEvents.field_219616_bH, 1.0f, 1.2f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_217376_c((Entity)boneShard);
    }

    static class StationaryRangedAttackGoal
    extends Goal {
        private final MobEntity entityHost;
        private final IRangedAttackMob rangedAttackEntityHost;
        private final int attackIntervalMin;
        private final int maxRangedAttackTime;
        private final float attackRadius;
        private final float maxAttackDistance;
        private LivingEntity attackTarget;
        private int rangedAttackTime = -1;
        private int seeTime;

        public StationaryRangedAttackGoal(IRangedAttackMob attacker, int maxAttackTime, float maxAttackDistanceIn) {
            this(attacker, maxAttackTime, maxAttackTime, maxAttackDistanceIn);
        }

        public StationaryRangedAttackGoal(IRangedAttackMob attacker, int p_i1650_4_, int maxAttackTime, float maxAttackDistanceIn) {
            if (!(attacker instanceof LivingEntity)) {
                throw new IllegalArgumentException("ArrowAttackGoal requires Mob implements RangedAttackMob");
            }
            this.rangedAttackEntityHost = attacker;
            this.entityHost = (MobEntity)attacker;
            this.attackIntervalMin = p_i1650_4_;
            this.maxRangedAttackTime = maxAttackTime;
            this.attackRadius = maxAttackDistanceIn;
            this.maxAttackDistance = maxAttackDistanceIn * maxAttackDistanceIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            LivingEntity livingentity = this.entityHost.func_70638_az();
            if (livingentity != null && livingentity.func_70089_S()) {
                double distance = this.entityHost.func_70092_e(livingentity.func_226277_ct_(), livingentity.func_226278_cu_(), livingentity.func_226281_cx_());
                boolean flag = distance > 3.0;
                this.attackTarget = livingentity;
                return flag;
            }
            return false;
        }

        public boolean func_75253_b() {
            return this.func_75250_a() || !this.entityHost.func_70661_as().func_75500_f();
        }

        public void func_75251_c() {
            this.attackTarget = null;
            this.seeTime = 0;
            this.rangedAttackTime = -1;
        }

        public void func_75246_d() {
            double d0 = this.entityHost.func_70092_e(this.attackTarget.func_226277_ct_(), this.attackTarget.func_226278_cu_(), this.attackTarget.func_226281_cx_());
            boolean flag = this.entityHost.func_70635_at().func_75522_a((Entity)this.attackTarget);
            this.seeTime = flag ? ++this.seeTime : 0;
            if (!(d0 > (double)this.maxAttackDistance) && this.seeTime >= 5) {
                this.entityHost.func_70661_as().func_75499_g();
            }
            this.entityHost.func_70671_ap().func_75651_a((Entity)this.attackTarget, 30.0f, 30.0f);
            if (--this.rangedAttackTime == 0) {
                if (!flag) {
                    return;
                }
                float f = MathHelper.func_76133_a((double)d0) / this.attackRadius;
                float lvt_5_1_ = MathHelper.func_76131_a((float)f, (float)0.1f, (float)1.0f);
                this.rangedAttackEntityHost.func_82196_d(this.attackTarget, lvt_5_1_);
                this.rangedAttackTime = MathHelper.func_76141_d((float)(f * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
            } else if (this.rangedAttackTime < 0) {
                float f2 = MathHelper.func_76133_a((double)d0) / this.attackRadius;
                this.rangedAttackTime = MathHelper.func_76141_d((float)(f2 * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
            }
        }
    }

    static class AttackGoal
    extends MeleeAttackGoal {
        public AttackGoal(BoneSpiderEntity spider) {
            super((CreatureEntity)spider, 1.0, false);
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !this.field_75441_b.func_184207_aI();
        }

        public boolean func_75253_b() {
            LivingEntity livingentity = this.field_75441_b.func_70638_az();
            if (livingentity == null) {
                this.field_75441_b.func_70661_as().func_75499_g();
                return false;
            }
            return super.func_75253_b();
        }

        protected double func_179512_a(LivingEntity attackTarget) {
            return 3.0f + attackTarget.func_213311_cf();
        }
    }
}

