/*
 * Decompiled with CFR 0.152.
 */
package slexom.earthtojava.mobs.entity.passive;

import java.util.EnumSet;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.entity.ai.goal.MoveTowardsVillageGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import slexom.earthtojava.mobs.entity.passive.TropicalSlimeEntity;

public class FurnaceGolemEntity
extends IronGolemEntity {
    public static final DataParameter<Boolean> IS_ANGRY = EntityDataManager.func_187226_a(FurnaceGolemEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private int attackTimer;
    private int lastBlink = 0;
    private int nextBlinkInterval = new Random().nextInt(760) + 60;
    private int remainingTick = 0;
    private int internalBlinkTick = 0;

    public FurnaceGolemEntity(EntityType<? extends IronGolemEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70728_aV = 5;
        this.func_94061_f(false);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(2, (Goal)new MoveTowardsTargetGoal((CreatureEntity)this, 0.9, 32.0f));
        this.field_70714_bg.func_75776_a(2, (Goal)new MoveTowardsVillageGoal((CreatureEntity)this, 0.6));
        this.field_70714_bg.func_75776_a(3, (Goal)new MoveThroughVillageGoal((CreatureEntity)this, 0.6, false, 4, () -> false));
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.6));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new DefendVillageTargetGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal(this, MobEntity.class, 5, false, false, p_213619_0_ -> p_213619_0_ instanceof IMob && !(p_213619_0_ instanceof CreeperEntity) && !(p_213619_0_ instanceof TropicalSlimeEntity)));
    }

    public boolean func_70652_k(Entity entityIn) {
        this.attackTimer = 10;
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        float f1 = f > 0.0f ? f / 2.0f + (float)this.field_70146_Z.nextInt((int)f) : 0.0f;
        boolean flag = entityIn.func_70097_a(DamageSource.field_76370_b, f1);
        if (flag) {
            entityIn.func_213317_d(entityIn.func_213322_ci().func_72441_c(0.0, 0.4, 0.0));
            this.func_174815_a((LivingEntity)this, entityIn);
        }
        this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
        return flag;
    }

    public void func_70636_d() {
        int z;
        int y;
        int x;
        BlockPos pos;
        BlockPos posRandom;
        float rand;
        super.func_70636_d();
        if (this.isAngry() && (rand = new Random().nextFloat()) > 0.8f && rand <= 0.83f && !this.field_70170_p.func_175623_d(posRandom = (pos = new BlockPos((double)(x = MathHelper.func_76128_c((double)this.func_226277_ct_())), (double)(y = MathHelper.func_76128_c((double)this.func_226278_cu_())) - 0.2, (double)(z = MathHelper.func_76128_c((double)this.func_226281_cx_())))).func_177982_a(new Random().nextInt(3) - 1, 0, new Random().nextInt(3) - 1)) && this.field_70170_p.func_175623_d(posRandom.func_177984_a())) {
            this.field_70170_p.func_180501_a(posRandom.func_177984_a(), Blocks.field_150480_ab.func_176223_P(), 3);
        }
        if (this.func_70090_H()) {
            this.func_70097_a(DamageSource.field_76369_e, 5.0f);
        }
        if (this.remainingTick > 0) {
            --this.remainingTick;
        }
        if (this.internalBlinkTick == this.lastBlink + this.nextBlinkInterval) {
            this.lastBlink = this.internalBlinkTick;
            this.nextBlinkInterval = new Random().nextInt(740) + 60;
            this.remainingTick = 4;
        }
        ++this.internalBlinkTick;
    }

    public int getBlinkRemainingTicks() {
        return this.remainingTick;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_ANGRY, (Object)false);
    }

    public boolean isAngry() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_ANGRY);
    }

    public void setAngry(boolean angry) {
        this.field_70180_af.func_187227_b(IS_ANGRY, (Object)angry);
    }

    public class DefendVillageTargetGoal
    extends net.minecraft.entity.ai.goal.DefendVillageTargetGoal {
        private final FurnaceGolemEntity golem;
        private LivingEntity villageAgressorTarget;

        public DefendVillageTargetGoal(FurnaceGolemEntity ironGolemIn) {
            super((IronGolemEntity)ironGolemIn);
            this.golem = ironGolemIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.TARGET));
        }

        public void func_75249_e() {
            this.golem.setAngry(true);
            this.golem.func_70624_b(this.villageAgressorTarget);
            super.func_75249_e();
        }

        public void func_75251_c() {
            this.golem.setAngry(false);
            super.func_75251_c();
        }
    }

    private static final class NearestAttackableTargetGoal
    extends net.minecraft.entity.ai.goal.NearestAttackableTargetGoal<LivingEntity> {
        FurnaceGolemEntity golem;

        public NearestAttackableTargetGoal(FurnaceGolemEntity entity, Class targetClassIn, int targetChanceIn, boolean checkSight, boolean nearbyOnlyIn, @Nullable Predicate targetPredicate) {
            super((MobEntity)entity, targetClassIn, targetChanceIn, checkSight, nearbyOnlyIn, targetPredicate);
            this.golem = entity;
        }

        public void func_75249_e() {
            this.golem.setAngry(true);
            super.func_75249_e();
        }

        public void func_75251_c() {
            this.golem.setAngry(false);
            super.func_75251_c();
        }
    }
}

