/*
 * Decompiled with CFR 0.152.
 */
package slexom.earthtojava.mobs.entity.passive;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.EatGrassGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import slexom.earthtojava.mobs.entity.base.E2JBaseSheepEntity;

public class HornedSheepEntity
extends E2JBaseSheepEntity<HornedSheepEntity> {
    private EatGrassGoal eatGrassGoal;
    private static final DataParameter<Byte> DATA_FLAGS_ID = EntityDataManager.func_187226_a(HornedSheepEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Integer> ANGER_TIME = EntityDataManager.func_187226_a(HornedSheepEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private UUID lastHurtBy;

    public HornedSheepEntity(EntityType<? extends HornedSheepEntity> type, World world) {
        super(type, world);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_FLAGS_ID, (Object)0);
        this.field_70180_af.func_187214_a(ANGER_TIME, (Object)0);
    }

    protected void func_184651_r() {
        this.eatGrassGoal = new EatGrassGoal((MobEntity)this);
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)this, 1.1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151015_O}), false));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal((AnimalEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(4, (Goal)this.eatGrassGoal);
        this.field_70714_bg.func_75776_a(5, (Goal)new ChargeGoal(this, 1.4, true));
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new AngerGoal(this).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new AttackPlayerGoal(this));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Anger", this.getAnger());
        if (this.lastHurtBy != null) {
            compound.func_74778_a("HurtBy", this.lastHurtBy.toString());
        } else {
            compound.func_74778_a("HurtBy", "");
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        String s = compound.func_74779_i("HurtBy");
        if (!s.isEmpty()) {
            this.lastHurtBy = UUID.fromString(s);
            PlayerEntity playerentity = this.field_70170_p.func_217371_b(this.lastHurtBy);
            this.func_70604_c((LivingEntity)playerentity);
            if (playerentity != null) {
                this.field_70717_bb = playerentity;
                this.field_70718_bc = this.func_142015_aE();
            }
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        if (flag) {
            this.func_174815_a((LivingEntity)this, entityIn);
        }
        return flag;
    }

    public void func_70604_c(@Nullable LivingEntity livingBase) {
        super.func_70604_c(livingBase);
        if (livingBase != null) {
            this.lastHurtBy = livingBase.func_110124_au();
        }
    }

    protected void func_70619_bc() {
        if (this.isAngry()) {
            int i = this.getAnger();
            this.setAnger(i - 1);
            LivingEntity livingentity = this.func_70638_az();
            if (i == 0 && livingentity != null) {
                this.setSheepAttacker((Entity)livingentity);
            }
        }
    }

    public boolean isAngry() {
        return this.getAnger() > 0;
    }

    private int getAnger() {
        return (Integer)this.field_70180_af.func_187225_a(ANGER_TIME);
    }

    private void setAnger(int angerTime) {
        this.field_70180_af.func_187227_b(ANGER_TIME, (Object)angerTime);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            boolean flag = this.isAngry() && this.func_70638_az() != null && this.func_70638_az().func_70068_e((Entity)this) < 4.0;
            this.setNearTarget(flag);
        }
    }

    private boolean isNearTarget() {
        return this.getSheepFlag();
    }

    private void setNearTarget(boolean p_226452_1_) {
        this.setSheepFlag(p_226452_1_);
    }

    private boolean isTooFar(BlockPos pos) {
        return !this.isWithinDistance(pos);
    }

    private void setSheepFlag(boolean p_226404_2_) {
        if (p_226404_2_) {
            this.field_70180_af.func_187227_b(DATA_FLAGS_ID, (Object)((byte)((Byte)this.field_70180_af.func_187225_a(DATA_FLAGS_ID) | 2)));
        } else {
            this.field_70180_af.func_187227_b(DATA_FLAGS_ID, (Object)((byte)((Byte)this.field_70180_af.func_187225_a(DATA_FLAGS_ID) & 0xFFFFFFFD)));
        }
    }

    private boolean getSheepFlag() {
        return ((Byte)this.field_70180_af.func_187225_a(DATA_FLAGS_ID) & 2) != 0;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(48.0);
    }

    public ResourceLocation func_184647_J() {
        if (this.func_70892_o()) {
            return this.func_200600_R().func_220348_g();
        }
        switch (this.func_175509_cj()) {
            default: {
                return new ResourceLocation("earthtojavamobs", "entities/horned_sheep/white");
            }
            case ORANGE: {
                return new ResourceLocation("earthtojavamobs", "entities/horned_sheep/orange");
            }
            case MAGENTA: {
                return new ResourceLocation("earthtojavamobs", "entities/horned_sheep/magenta");
            }
            case LIGHT_BLUE: {
                return new ResourceLocation("earthtojavamobs", "entities/horned_sheep/light_blue");
            }
            case YELLOW: {
                return new ResourceLocation("earthtojavamobs", "entities/horned_sheep/yellow");
            }
            case LIME: {
                return new ResourceLocation("earthtojavamobs", "entities/horned_sheep/lime");
            }
            case PINK: {
                return new ResourceLocation("earthtojavamobs", "entities/horned_sheep/pink");
            }
            case GRAY: {
                return new ResourceLocation("earthtojavamobs", "entities/horned_sheep/gray");
            }
            case LIGHT_GRAY: {
                return new ResourceLocation("earthtojavamobs", "entities/horned_sheep/light_gray");
            }
            case CYAN: {
                return new ResourceLocation("earthtojavamobs", "entities/horned_sheep/cyan");
            }
            case PURPLE: {
                return new ResourceLocation("earthtojavamobs", "entities/horned_sheep/purple");
            }
            case BLUE: {
                return new ResourceLocation("earthtojavamobs", "entities/horned_sheep/blue");
            }
            case BROWN: {
                return new ResourceLocation("earthtojavamobs", "entities/horned_sheep/brown");
            }
            case GREEN: {
                return new ResourceLocation("earthtojavamobs", "entities/horned_sheep/green");
            }
            case RED: {
                return new ResourceLocation("earthtojavamobs", "entities/horned_sheep/red");
            }
            case BLACK: 
        }
        return new ResourceLocation("earthtojavamobs", "entities/horned_sheep/black");
    }

    public boolean setSheepAttacker(Entity attacker) {
        this.setAnger(400 + this.field_70146_Z.nextInt(400));
        if (attacker instanceof LivingEntity) {
            this.func_70604_c((LivingEntity)attacker);
        }
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (!this.field_70170_p.field_72995_K && entity instanceof PlayerEntity && !((PlayerEntity)entity).func_184812_l_() && this.func_70685_l(entity) && !this.func_175446_cd()) {
            this.setSheepAttacker(entity);
        }
        return super.func_70097_a(source, amount);
    }

    private boolean isWithinDistance(BlockPos pos) {
        return pos.func_218141_a((Vec3i)new BlockPos((Entity)this), 48.0);
    }

    @Override
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    class ChargeGoal
    extends MeleeAttackGoal {
        final HornedSheepEntity field_75441_b;

        ChargeGoal(HornedSheepEntity creatureIn, double speedIn, boolean useLongMemory) {
            super((CreatureEntity)creatureIn, speedIn, useLongMemory);
            this.field_75441_b = creatureIn;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && this.field_75441_b.isAngry();
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && this.field_75441_b.isAngry();
        }
    }

    static class AttackPlayerGoal
    extends NearestAttackableTargetGoal<PlayerEntity> {
        AttackPlayerGoal(HornedSheepEntity sheepEntity) {
            super((MobEntity)sheepEntity, PlayerEntity.class, true);
        }

        public boolean func_75250_a() {
            return this.canCharge() && super.func_75250_a();
        }

        public boolean func_75253_b() {
            boolean flag = this.canCharge();
            if (flag && this.field_75299_d.func_70638_az() != null) {
                return super.func_75253_b();
            }
            this.field_188509_g = null;
            return false;
        }

        private boolean canCharge() {
            HornedSheepEntity sheepEntity = (HornedSheepEntity)this.field_75299_d;
            return sheepEntity.isAngry();
        }
    }

    static class AngerGoal
    extends HurtByTargetGoal {
        AngerGoal(HornedSheepEntity sheepIn) {
            super((CreatureEntity)sheepIn, new Class[0]);
        }

        protected void func_220793_a(MobEntity mobIn, LivingEntity targetIn) {
            if (mobIn instanceof HornedSheepEntity && this.field_75299_d.func_70685_l((Entity)targetIn) && ((HornedSheepEntity)mobIn).setSheepAttacker((Entity)targetIn)) {
                mobIn.func_70624_b(targetIn);
            }
        }
    }
}

