/*
 * Decompiled with CFR 0.152.
 */
package slexom.earthtojava.mobs.entity.passive;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.event.ForgeEventFactory;
import slexom.earthtojava.mobs.entity.passive.TropicalSlimeEntity;
import slexom.earthtojava.mobs.entity.projectile.MelonSeedProjectileEntity;

public class MelonGolemEntity
extends GolemEntity
implements IRangedAttackMob,
IShearable {
    private static final DataParameter<Byte> MELON_EQUIPPED = EntityDataManager.func_187226_a(MelonGolemEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Integer> SHOOTING_TICKS = EntityDataManager.func_187226_a(MelonGolemEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private int lastBlink = 0;
    private int nextBlinkInterval = new Random().nextInt(740) + 60;
    private int remainingTick = 0;
    private int internalBlinkTick = 0;

    public MelonGolemEntity(EntityType<? extends MelonGolemEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new MoveHelperController(this);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new RangedAttack(this, 1.25, 20, 10.0f));
        this.field_70714_bg.func_75776_a(2, (Goal)new FaceRandomGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(5, (Goal)new HopGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MobEntity.class, 10, true, false, entity -> entity instanceof IMob && !(entity instanceof TropicalSlimeEntity)));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.2f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MELON_EQUIPPED, (Object)16);
        this.field_70180_af.func_187214_a(SHOOTING_TICKS, (Object)0);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Pumpkin", this.isMelonEquipped());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("Pumpkin")) {
            this.setMelonEquipped(compound.func_74767_n("Pumpkin"));
        }
    }

    public void func_70636_d() {
        int currentShootingTicks;
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            int i = MathHelper.func_76128_c((double)this.func_226277_ct_());
            int j = MathHelper.func_76128_c((double)this.func_226278_cu_());
            int k = MathHelper.func_76128_c((double)this.func_226281_cx_());
            if (this.func_203008_ap()) {
                this.func_70097_a(DamageSource.field_76369_e, 1.0f);
            }
            BlockPos blockPos = new BlockPos(i, 0, k);
            BlockPos blockPos2 = new BlockPos(i, j, k);
            if (this.field_70170_p.func_226691_t_(blockPos).func_225486_c(blockPos2) > 1.0f) {
                this.func_70097_a(DamageSource.field_76370_b, 1.0f);
            }
            if (!ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
                return;
            }
            BlockState blockstate = Blocks.field_150433_aE.func_176223_P();
            for (int l = 0; l < 4; ++l) {
                i = MathHelper.func_76128_c((double)(this.func_226277_ct_() + (double)((float)(l % 2 * 2 - 1) * 0.25f)));
                BlockPos blockpos = new BlockPos(i, j = MathHelper.func_76128_c((double)this.func_226278_cu_()), k = MathHelper.func_76128_c((double)(this.func_226281_cx_() + (double)((float)(l / 2 % 2 * 2 - 1) * 0.25f))));
                if (!this.field_70170_p.func_175623_d(blockpos) || !(this.field_70170_p.func_226691_t_(blockpos).func_225486_c(blockpos) < 0.8f) || !blockstate.func_196955_c((IWorldReader)this.field_70170_p, blockpos)) continue;
                this.field_70170_p.func_175656_a(blockpos, blockstate);
            }
        }
        if ((currentShootingTicks = ((Integer)this.field_70180_af.func_187225_a(SHOOTING_TICKS)).intValue()) > 0) {
            this.field_70180_af.func_187227_b(SHOOTING_TICKS, (Object)(--currentShootingTicks));
        }
        if (this.remainingTick > 0) {
            --this.remainingTick;
        }
        if (this.internalBlinkTick == this.lastBlink + this.nextBlinkInterval) {
            this.lastBlink = this.internalBlinkTick;
            this.nextBlinkInterval = new Random().nextInt(740) + 60;
            this.remainingTick = 4;
        }
        ++this.internalBlinkTick;
    }

    public int getBlinkRemainingTicks() {
        return this.remainingTick;
    }

    public boolean isShooting() {
        return (Integer)this.field_70180_af.func_187225_a(SHOOTING_TICKS) > 0;
    }

    public void setShootingTicks() {
        this.field_70180_af.func_187227_b(SHOOTING_TICKS, (Object)8);
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        this.setShootingTicks();
        MelonSeedProjectileEntity melonSeedEntity = new MelonSeedProjectileEntity(this.field_70170_p, (LivingEntity)this);
        double d0 = target.func_226280_cw_() - (double)1.1f;
        double d1 = target.func_226277_ct_() - this.func_226277_ct_();
        double d2 = d0 - melonSeedEntity.func_226278_cu_();
        double d3 = target.func_226281_cx_() - this.func_226281_cx_();
        float f = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3)) * 0.2f;
        melonSeedEntity.func_70186_c(d1, d2 + (double)f, d3, 1.6f, 12.0f);
        this.func_184185_a(SoundEvents.field_187805_fE, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_217376_c((Entity)melonSeedEntity);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 1.7f;
    }

    public boolean isMelonEquipped() {
        return ((Byte)this.field_70180_af.func_187225_a(MELON_EQUIPPED) & 0x10) != 0;
    }

    public void setMelonEquipped(boolean melonEquipped) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(MELON_EQUIPPED);
        if (melonEquipped) {
            this.field_70180_af.func_187227_b(MELON_EQUIPPED, (Object)((byte)(b0 | 0x10)));
        } else {
            this.field_70180_af.func_187227_b(MELON_EQUIPPED, (Object)((byte)(b0 & 0xFFFFFFEF)));
        }
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187799_fB;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187803_fD;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187801_fC;
    }

    protected int getJumpDelay() {
        return this.field_70146_Z.nextInt(20) + 10;
    }

    public boolean isShearable(ItemStack item, IWorldReader world, BlockPos pos) {
        return this.isMelonEquipped();
    }

    public List<ItemStack> onSheared(ItemStack item, IWorld world, BlockPos pos, int fortune) {
        this.setMelonEquipped(false);
        return new ArrayList<ItemStack>();
    }

    static class FaceRandomGoal
    extends Goal {
        private final MelonGolemEntity melonGolem;
        private float chosenDegrees;
        private int nextRandomizeTime;

        public FaceRandomGoal(MelonGolemEntity melonGolem) {
            this.melonGolem = melonGolem;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return this.melonGolem.func_70638_az() == null && (this.melonGolem.field_70122_E || this.melonGolem.func_70090_H() || this.melonGolem.func_180799_ab() || this.melonGolem.func_70644_a(Effects.field_188424_y)) && this.melonGolem.func_70605_aq() instanceof MoveHelperController;
        }

        public void func_75246_d() {
            if (--this.nextRandomizeTime <= 0) {
                this.nextRandomizeTime = 40 + this.melonGolem.func_70681_au().nextInt(60);
                this.chosenDegrees = this.melonGolem.func_70681_au().nextInt(360);
            }
            ((MoveHelperController)this.melonGolem.func_70605_aq()).setDirection(this.chosenDegrees, false);
        }
    }

    static class MoveHelperController
    extends MovementController {
        private float yRot;
        private int jumpDelay;
        private final MelonGolemEntity melonGolem;
        private boolean isAggressive;

        public MoveHelperController(MelonGolemEntity entity) {
            super((MobEntity)entity);
            this.melonGolem = entity;
            this.yRot = 180.0f * entity.field_70177_z / (float)Math.PI;
        }

        public void setDirection(float yRotIn, boolean aggressive) {
            this.yRot = yRotIn;
            this.isAggressive = aggressive;
        }

        public void setSpeed(double speedIn) {
            this.field_75645_e = speedIn;
            this.field_188491_h = MovementController.Action.MOVE_TO;
        }

        public void func_75641_c() {
            this.field_75648_a.field_70759_as = this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, this.yRot, 90.0f);
            this.field_75648_a.field_70761_aq = this.field_75648_a.field_70177_z;
            if (this.field_188491_h != MovementController.Action.MOVE_TO) {
                this.field_75648_a.func_191989_p(0.0f);
            } else {
                this.field_188491_h = MovementController.Action.WAIT;
                if (this.field_75648_a.field_70122_E) {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                    if (this.jumpDelay-- <= 0) {
                        this.jumpDelay = this.melonGolem.getJumpDelay();
                        if (this.isAggressive) {
                            this.jumpDelay /= 3;
                        }
                        this.melonGolem.func_70683_ar().func_75660_a();
                    } else {
                        this.melonGolem.field_70702_br = 0.0f;
                        this.melonGolem.field_191988_bg = 0.0f;
                        this.field_75648_a.func_70659_e(0.0f);
                    }
                } else {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                }
            }
        }
    }

    static class HopGoal
    extends Goal {
        private final MelonGolemEntity melonGolem;

        public HopGoal(MelonGolemEntity entity) {
            this.melonGolem = entity;
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return !this.melonGolem.func_184218_aH();
        }

        public void func_75246_d() {
            ((MoveHelperController)this.melonGolem.func_70605_aq()).setSpeed(1.0);
        }
    }

    static class RangedAttack
    extends RangedAttackGoal {
        private final MelonGolemEntity rangedAttackEntityHost;

        public RangedAttack(MelonGolemEntity attacker, double movespeed, int maxAttackTime, float maxAttackDistanceIn) {
            super((IRangedAttackMob)attacker, movespeed, maxAttackTime, maxAttackDistanceIn);
            this.rangedAttackEntityHost = attacker;
        }

        public RangedAttack(MelonGolemEntity attacker, double movespeed, int p_i1650_4_, int maxAttackTime, float maxAttackDistanceIn) {
            super((IRangedAttackMob)attacker, movespeed, p_i1650_4_, maxAttackTime, maxAttackDistanceIn);
            this.rangedAttackEntityHost = attacker;
        }

        public void func_75246_d() {
            super.func_75246_d();
            ((MoveHelperController)this.rangedAttackEntityHost.func_70605_aq()).setDirection(this.rangedAttackEntityHost.field_70177_z, true);
        }
    }
}

