/*
 * Decompiled with CFR 0.152.
 */
package slexom.earthtojava.mobs.entity.passive;

import net.minecraft.block.Block;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import slexom.earthtojava.mobs.entity.base.E2JBasePigEntity;
import slexom.earthtojava.mobs.init.BlockInit;

public class MuddyPigEntity
extends E2JBasePigEntity<MuddyPigEntity> {
    private static final DataParameter<Boolean> MUDDY_STATE = EntityDataManager.func_187226_a(MuddyPigEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final Ingredient TEMPTATION_ITEMS = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151172_bF, Items.field_151174_bG, Items.field_185164_cV});
    private int outOfMud = 0;
    private int finallyInMud = 0;
    private boolean isShaking;
    private float timeWolfIsShaking;
    private float prevTimeWolfIsShaking;

    public MuddyPigEntity(EntityType<MuddyPigEntity> type, World world) {
        super(type, world);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)this, 1.2, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151146_bM}), false));
        this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)this, 1.2, TEMPTATION_ITEMS, false));
        this.field_70714_bg.func_75776_a(4, (Goal)new GoToMudGoal(this, 1.2));
        this.field_70714_bg.func_75776_a(5, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(8, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0, 100));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        int i = MathHelper.func_76128_c((double)this.func_226277_ct_());
        int j = MathHelper.func_76128_c((double)this.func_226278_cu_());
        int k = MathHelper.func_76128_c((double)this.func_226281_cx_());
        BlockPos blockPos = new BlockPos(i, j, k);
        boolean condition = this.field_70170_p.func_204610_c(blockPos).func_206883_i().func_177230_c().equals(BlockInit.MUD_BLOCK.get());
        if (condition) {
            if (!this.isInMuddyState()) {
                if (!this.isShaking) {
                    this.isShaking = true;
                    this.timeWolfIsShaking = 0.0f;
                    this.prevTimeWolfIsShaking = 0.0f;
                    this.field_70170_p.func_72960_a((Entity)this, (byte)8);
                }
                if (++this.finallyInMud > 60) {
                    this.setMuddyState(true);
                    this.finallyInMud = 0;
                    this.resetShake();
                }
            }
        } else if (this.isInMuddyState()) {
            ++this.outOfMud;
            if (this.outOfMud > 60) {
                this.setMuddyState(false);
                this.outOfMud = 0;
            }
        }
    }

    private void resetShake() {
        this.isShaking = false;
        this.prevTimeWolfIsShaking = 0.0f;
        this.timeWolfIsShaking = 0.0f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_70089_S() && this.isShaking) {
            this.prevTimeWolfIsShaking = this.timeWolfIsShaking;
            this.timeWolfIsShaking += 0.033f;
            if (this.prevTimeWolfIsShaking >= 2.0f) {
                this.resetShake();
            }
        }
    }

    public void func_70645_a(DamageSource cause) {
        this.resetShake();
        super.func_70645_a(cause);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MUDDY_STATE, (Object)false);
    }

    public boolean isInMuddyState() {
        return (Boolean)this.field_70180_af.func_187225_a(MUDDY_STATE);
    }

    public void setMuddyState(boolean inMud) {
        this.field_70180_af.func_187227_b(MUDDY_STATE, (Object)inMud);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("IsInMud", this.isInMuddyState());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setMuddyState(compound.func_74767_n("IsInMud"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 8) {
            this.isShaking = true;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
        } else {
            super.func_70103_a(id);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShakeAngle(float p_70923_1_, float p_70923_2_) {
        float f = (MathHelper.func_219799_g((float)p_70923_1_, (float)this.prevTimeWolfIsShaking, (float)this.timeWolfIsShaking) + p_70923_2_) / 1.8f;
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        return MathHelper.func_76126_a((float)(f * (float)Math.PI)) * MathHelper.func_76126_a((float)(f * (float)Math.PI * 11.0f)) * 0.15f * (float)Math.PI;
    }

    @Override
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static class GoToMudGoal
    extends MoveToBlockGoal {
        private final MuddyPigEntity muddyPig;

        public GoToMudGoal(MuddyPigEntity entity, double speedIn) {
            super((CreatureEntity)entity, speedIn, 16, 3);
            this.muddyPig = entity;
            this.field_203112_e = -1;
        }

        public boolean func_75250_a() {
            return !this.muddyPig.isInMuddyState() && super.func_75250_a();
        }

        public boolean func_75253_b() {
            return !this.muddyPig.isInMuddyState() && this.field_179493_e <= 600 && this.func_179488_a((IWorldReader)this.muddyPig.field_70170_p, this.field_179494_b);
        }

        public boolean func_203108_i() {
            return this.field_179493_e % 100 == 0;
        }

        protected boolean func_179488_a(IWorldReader worldIn, BlockPos pos) {
            Block block = worldIn.func_180495_p(pos).func_177230_c();
            return block == BlockInit.MUD_BLOCK.get();
        }
    }
}

