/*
 * Decompiled with CFR 0.152.
 */
package slexom.earthtojava.mobs.entity.passive;

import java.util.EnumSet;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class TropicalSlimeEntity
extends CreatureEntity {
    public float squishAmount;
    public float squishFactor;
    public float prevSquishFactor;
    private boolean wasOnGround;
    private final int size;

    public TropicalSlimeEntity(EntityType<TropicalSlimeEntity> type, World world) {
        super(type, world);
        this.field_70728_aV = this.size = 4;
        this.func_94061_f(false);
        this.field_70765_h = new MoveHelperController(this);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new FloatGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new AttackGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new FaceRandomGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new HopGoal(this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.6);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_77973_b() == Items.field_151133_ar && !player.field_71075_bZ.field_75098_d && !this.func_70631_g_()) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_70106_y();
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.func_226277_ct_(), this.func_226283_e_(0.5), this.func_226281_cx_(), 0.0, 0.0, 0.0);
                player.func_184185_a(SoundEvents.field_187886_fs, 1.0f, 1.0f);
                this.spawnWater();
                this.giveTropicalFishBucket(player, hand, itemstack);
                return true;
            }
            return super.func_184645_a(player, hand);
        }
        return super.func_184645_a(player, hand);
    }

    private void giveTropicalFishBucket(PlayerEntity player, Hand hand, ItemStack itemstack) {
        itemstack.func_190918_g(1);
        if (!player.field_71071_by.func_70441_a(new ItemStack((IItemProvider)Items.field_204272_aO))) {
            player.func_71019_a(new ItemStack((IItemProvider)Items.field_204272_aO), false);
        }
    }

    private void spawnWater() {
        int x = MathHelper.func_76128_c((double)this.func_226277_ct_());
        int y = MathHelper.func_76128_c((double)this.func_226278_cu_());
        int z = MathHelper.func_76128_c((double)this.func_226281_cx_());
        BlockPos blockPos = new BlockPos(x, y, z);
        BlockState waterState = Blocks.field_150355_j.func_176223_P();
        this.field_70170_p.func_175655_b(blockPos, false);
        this.field_70170_p.func_180501_a(blockPos, waterState, 3);
    }

    protected IParticleData getSquishParticle() {
        return ParticleTypes.field_197618_k;
    }

    public void func_70071_h_() {
        this.squishFactor += (this.squishAmount - this.squishFactor) * 0.5f;
        this.prevSquishFactor = this.squishFactor;
        super.func_70071_h_();
        if (this.field_70122_E && !this.wasOnGround) {
            int i = this.size;
            if (this.spawnCustomParticles()) {
                i = 0;
            }
            for (int j = 0; j < i * 8; ++j) {
                float f = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
                float f1 = this.field_70146_Z.nextFloat() * 0.5f + 0.5f;
                float f2 = MathHelper.func_76126_a((float)f) * (float)i * 0.5f * f1;
                float f3 = MathHelper.func_76134_b((float)f) * (float)i * 0.5f * f1;
                this.field_70170_p.func_195594_a(this.getSquishParticle(), this.func_226277_ct_() + (double)f2, this.func_226278_cu_(), this.func_226281_cx_() + (double)f3, 0.0, 0.0, 0.0);
            }
            this.func_184185_a(this.getSquishSound(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) / 0.8f);
            this.squishAmount = -0.5f;
        } else if (!this.field_70122_E && this.wasOnGround) {
            this.squishAmount = 1.0f;
        }
        this.wasOnGround = this.field_70122_E;
        this.alterSquishAmount();
    }

    protected void alterSquishAmount() {
        this.squishAmount *= 0.6f;
    }

    protected int getJumpDelay() {
        return this.field_70146_Z.nextInt(20) + 10;
    }

    public EntityType<? extends TropicalSlimeEntity> func_200600_R() {
        return super.func_200600_R();
    }

    public void func_70108_f(Entity entityIn) {
        super.func_70108_f(entityIn);
        if (entityIn instanceof IronGolemEntity && this.canDamagePlayer()) {
            this.dealDamage((LivingEntity)entityIn);
        }
    }

    public void func_70100_b_(PlayerEntity entityIn) {
        if (this.canDamagePlayer()) {
            this.dealDamage((LivingEntity)entityIn);
        }
    }

    protected void dealDamage(LivingEntity entityIn) {
        if (this.func_70089_S()) {
            int i = this.size;
            if (this.func_70068_e((Entity)entityIn) < 0.6 * (double)i * 0.6 * (double)i && this.func_70685_l((Entity)entityIn) && entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), this.func_225512_er_())) {
                this.func_184185_a(SoundEvents.field_187870_fk, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                this.func_174815_a((LivingEntity)this, (Entity)entityIn);
            }
        }
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 0.625f * sizeIn.field_220316_b;
    }

    protected boolean canDamagePlayer() {
        return this.func_70613_aW();
    }

    protected float func_225512_er_() {
        return (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187880_fp;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187874_fm;
    }

    protected SoundEvent getSquishSound() {
        return SoundEvents.field_187886_fs;
    }

    protected ResourceLocation func_184647_J() {
        return this.func_200600_R().func_220348_g();
    }

    public int func_70646_bf() {
        return 0;
    }

    protected boolean makesSoundOnJump() {
        return true;
    }

    protected void func_70664_aZ() {
        Vec3d vec3d = this.func_213322_ci();
        this.func_213293_j(vec3d.field_72450_a, this.func_175134_bD(), vec3d.field_72449_c);
        this.field_70160_al = true;
    }

    protected SoundEvent getJumpSound() {
        return SoundEvents.field_187882_fq;
    }

    protected boolean spawnCustomParticles() {
        return false;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    static class MoveHelperController
    extends MovementController {
        private float yRot;
        private int jumpDelay;
        private final TropicalSlimeEntity slime;
        private boolean isAggressive;

        public MoveHelperController(TropicalSlimeEntity slimeIn) {
            super((MobEntity)slimeIn);
            this.slime = slimeIn;
            this.yRot = 180.0f * slimeIn.field_70177_z / (float)Math.PI;
        }

        public void setDirection(float yRotIn, boolean aggressive) {
            this.yRot = yRotIn;
            this.isAggressive = aggressive;
        }

        public void setSpeed(double speedIn) {
            this.field_75645_e = speedIn;
            this.field_188491_h = MovementController.Action.MOVE_TO;
        }

        public void func_75641_c() {
            this.field_75648_a.field_70759_as = this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, this.yRot, 90.0f);
            this.field_75648_a.field_70761_aq = this.field_75648_a.field_70177_z;
            if (this.field_188491_h != MovementController.Action.MOVE_TO) {
                this.field_75648_a.func_191989_p(0.0f);
            } else {
                this.field_188491_h = MovementController.Action.WAIT;
                if (this.field_75648_a.field_70122_E) {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                    if (this.jumpDelay-- <= 0) {
                        this.jumpDelay = this.slime.getJumpDelay();
                        if (this.isAggressive) {
                            this.jumpDelay /= 3;
                        }
                        this.slime.func_70683_ar().func_75660_a();
                        if (this.slime.makesSoundOnJump()) {
                            this.slime.func_184185_a(this.slime.getJumpSound(), this.slime.func_70599_aP(), ((this.slime.func_70681_au().nextFloat() - this.slime.func_70681_au().nextFloat()) * 0.2f + 1.0f) * 0.8f);
                        }
                    } else {
                        this.slime.field_70702_br = 0.0f;
                        this.slime.field_191988_bg = 0.0f;
                        this.field_75648_a.func_70659_e(0.0f);
                    }
                } else {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                }
            }
        }
    }

    static class HopGoal
    extends Goal {
        private final TropicalSlimeEntity slime;

        public HopGoal(TropicalSlimeEntity slimeIn) {
            this.slime = slimeIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return !this.slime.func_184218_aH();
        }

        public void func_75246_d() {
            ((MoveHelperController)this.slime.func_70605_aq()).setSpeed(1.0);
        }
    }

    static class FloatGoal
    extends Goal {
        private final TropicalSlimeEntity slime;

        public FloatGoal(TropicalSlimeEntity slimeIn) {
            this.slime = slimeIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
            slimeIn.func_70661_as().func_212239_d(true);
        }

        public boolean func_75250_a() {
            return (this.slime.func_70090_H() || this.slime.func_180799_ab()) && this.slime.func_70605_aq() instanceof MoveHelperController;
        }

        public void func_75246_d() {
            if (this.slime.func_70681_au().nextFloat() < 0.8f) {
                this.slime.func_70683_ar().func_75660_a();
            }
            ((MoveHelperController)this.slime.func_70605_aq()).setSpeed(1.2);
        }
    }

    static class FaceRandomGoal
    extends Goal {
        private final TropicalSlimeEntity slime;
        private float chosenDegrees;
        private int nextRandomizeTime;

        public FaceRandomGoal(TropicalSlimeEntity slimeIn) {
            this.slime = slimeIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return this.slime.func_70638_az() == null && (this.slime.field_70122_E || this.slime.func_70090_H() || this.slime.func_180799_ab() || this.slime.func_70644_a(Effects.field_188424_y)) && this.slime.func_70605_aq() instanceof MoveHelperController;
        }

        public void func_75246_d() {
            if (--this.nextRandomizeTime <= 0) {
                this.nextRandomizeTime = 40 + this.slime.func_70681_au().nextInt(60);
                this.chosenDegrees = this.slime.func_70681_au().nextInt(360);
            }
            ((MoveHelperController)this.slime.func_70605_aq()).setDirection(this.chosenDegrees, false);
        }
    }

    static class AttackGoal
    extends Goal {
        private final TropicalSlimeEntity slime;
        private int growTieredTimer;

        public AttackGoal(TropicalSlimeEntity slimeIn) {
            this.slime = slimeIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            LivingEntity livingentity = this.slime.func_70638_az();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.func_70089_S()) {
                return false;
            }
            return livingentity instanceof PlayerEntity && ((PlayerEntity)livingentity).field_71075_bZ.field_75102_a ? false : this.slime.func_70605_aq() instanceof MoveHelperController;
        }

        public void func_75249_e() {
            this.growTieredTimer = 300;
            super.func_75249_e();
        }

        public boolean func_75253_b() {
            LivingEntity livingentity = this.slime.func_70638_az();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.func_70089_S()) {
                return false;
            }
            if (livingentity instanceof PlayerEntity && ((PlayerEntity)livingentity).field_71075_bZ.field_75102_a) {
                return false;
            }
            return --this.growTieredTimer > 0;
        }

        public void func_75246_d() {
            this.slime.func_70625_a((Entity)this.slime.func_70638_az(), 10.0f, 10.0f);
            ((MoveHelperController)this.slime.func_70605_aq()).setDirection(this.slime.field_70177_z, this.slime.canDamagePlayer());
        }
    }
}

