/*
 * Decompiled with CFR 0.152.
 */
package slexom.earthtojava.mobs.fluid;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.Item;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidAttributes;
import slexom.earthtojava.mobs.init.BlockInit;
import slexom.earthtojava.mobs.init.FluidInit;
import slexom.earthtojava.mobs.init.ItemInit;

public class MudFluid
extends FlowingFluid {
    public Fluid func_210197_e() {
        return (Fluid)FluidInit.MUD_FLUID_FLOWING.get();
    }

    public Fluid func_210198_f() {
        return (Fluid)FluidInit.MUD_FLUID_STILL.get();
    }

    protected boolean func_205579_d() {
        return false;
    }

    public boolean func_207187_a(Fluid fluidIn) {
        ResourceLocation mudTag = new ResourceLocation("earthtojavamobs", "mud");
        return fluidIn.func_207185_a(FluidTags.func_226157_a_().func_199915_b(mudTag));
    }

    public boolean isEntityInside(IFluidState state, IWorldReader world, BlockPos pos, Entity entity, double yToTest, Tag<Fluid> tag, boolean testingHead) {
        if (testingHead && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.func_70050_g(this.decreaseAir(livingEntity.func_70086_ai(), livingEntity));
            if (livingEntity.func_70086_ai() == -20) {
                livingEntity.func_70050_g(0);
                Vec3d vec3d = livingEntity.func_213322_ci();
                for (int i = 0; i < 8; ++i) {
                    float f = livingEntity.field_70170_p.field_73012_v.nextFloat() - livingEntity.field_70170_p.field_73012_v.nextFloat();
                    float f1 = livingEntity.field_70170_p.field_73012_v.nextFloat() - livingEntity.field_70170_p.field_73012_v.nextFloat();
                    float f2 = livingEntity.field_70170_p.field_73012_v.nextFloat() - livingEntity.field_70170_p.field_73012_v.nextFloat();
                    livingEntity.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, livingEntity.func_226277_ct_() + (double)f, livingEntity.func_226278_cu_() + (double)f1, livingEntity.func_226281_cx_() + (double)f2, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
                }
                livingEntity.func_70097_a(DamageSource.field_76369_e, 2.0f);
            }
        }
        return super.isEntityInside(state, world, pos, entity, yToTest, tag, testingHead);
    }

    protected int decreaseAir(int air, LivingEntity livingEntity) {
        int i = EnchantmentHelper.func_185292_c((LivingEntity)livingEntity);
        return i > 0 && livingEntity.field_70170_p.field_73012_v.nextInt(i + 1) > 0 ? air : air - 1;
    }

    protected void func_205580_a(IWorld worldIn, BlockPos pos, BlockState state) {
        TileEntity tileentity = state.func_177230_c().func_149716_u() ? worldIn.func_175625_s(pos) : null;
        Block.func_220059_a((BlockState)state, (World)worldIn.func_201672_e(), (BlockPos)pos, (TileEntity)tileentity);
    }

    protected int func_185698_b(IWorldReader worldIn) {
        return 4;
    }

    protected int func_204528_b(IWorldReader worldIn) {
        return 1;
    }

    public Item func_204524_b() {
        return (Item)ItemInit.MUD_BUCKET.get();
    }

    protected boolean func_215665_a(IFluidState fluidStateIn, IBlockReader blockReader, BlockPos pos, Fluid fluidIn, Direction directionIn) {
        ResourceLocation mudTag = new ResourceLocation("earthtojavamobs", "mud");
        return directionIn == Direction.DOWN && !fluidIn.func_207185_a(FluidTags.func_226157_a_().func_199915_b(mudTag));
    }

    public int func_205569_a(IWorldReader p_205569_1_) {
        return 20;
    }

    protected float func_210195_d() {
        return 100.0f;
    }

    protected BlockState func_204527_a(IFluidState state) {
        return (BlockState)((FlowingFluidBlock)BlockInit.MUD_BLOCK.get()).func_176223_P().func_206870_a((IProperty)FlowingFluidBlock.field_176367_b, (Comparable)Integer.valueOf(MudFluid.func_207205_e((IFluidState)state)));
    }

    public boolean func_207193_c(IFluidState state) {
        return false;
    }

    public int func_207192_d(IFluidState p_207192_1_) {
        return (Integer)p_207192_1_.func_177229_b((IProperty)field_207210_b);
    }

    private void triggerMixEffects(IWorld worldIn, BlockPos pos) {
        worldIn.func_217379_c(1501, pos, 0);
    }

    protected void func_205574_a(IWorld worldIn, BlockPos pos, BlockState blockStateIn, Direction direction, IFluidState fluidStateIn) {
        ResourceLocation mudTag = new ResourceLocation("earthtojavamobs", "mud");
        if (this.getFluid().func_207185_a(FluidTags.func_226157_a_().func_199915_b(mudTag))) {
            boolean flag = false;
            for (Direction dir : Direction.values()) {
                if (!worldIn.func_204610_c(pos.func_177972_a(dir)).func_206884_a(FluidTags.field_206960_b)) continue;
                flag = true;
                break;
            }
            if (flag) {
                worldIn.func_180501_a(pos, Blocks.field_150346_d.func_176223_P(), 3);
                this.triggerMixEffects(worldIn, pos);
                return;
            }
        }
        super.func_205574_a(worldIn, pos, blockStateIn, direction, fluidStateIn);
    }

    protected FluidAttributes createAttributes() {
        return FluidAttributes.builder((ResourceLocation)new ResourceLocation("earthtojavamobs", "/fluids/mud_still"), (ResourceLocation)new ResourceLocation("earthtojavamobs", "/fluids/mud_flow")).density(1600).viscosity(3400).build((Fluid)this);
    }

    public static class Source
    extends MudFluid {
        @Override
        public int func_207192_d(IFluidState p_207192_1_) {
            return 8;
        }

        @Override
        public boolean func_207193_c(IFluidState state) {
            return true;
        }
    }

    public static class Flowing
    extends MudFluid {
        protected void func_207184_a(StateContainer.Builder<Fluid, IFluidState> builder) {
            super.func_207184_a(builder);
            builder.func_206894_a(new IProperty[]{field_207210_b});
        }

        @Override
        public int func_207192_d(IFluidState p_207192_1_) {
            return (Integer)p_207192_1_.func_177229_b((IProperty)field_207210_b);
        }

        @Override
        public boolean func_207193_c(IFluidState state) {
            return false;
        }
    }
}

