/*
 * Decompiled with CFR 0.152.
 */
package slexom.earthtojava.mobs.item.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.BucketItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;
import slexom.earthtojava.mobs.init.RecipesInit;

public class MudBucketRecipe
extends ShapelessRecipe {
    public MudBucketRecipe(ResourceLocation idIn, String groupIn, ItemStack recipeOutputIn, NonNullList<Ingredient> recipeItemsIn) {
        super(idIn, groupIn, recipeOutputIn, recipeItemsIn);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        System.out.println("HERE");
        NonNullList remainingItems = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < remainingItems.size(); ++i) {
            ItemStack itemstack = inv.func_70301_a(i);
            if (!itemstack.hasContainerItem() || itemstack.func_77973_b() instanceof BucketItem) continue;
            remainingItems.set(i, (Object)itemstack.getContainerItem());
        }
        return remainingItems;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)RecipesInit.MUD_BUCKET_RECIPE.get();
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<MudBucketRecipe> {
        public MudBucketRecipe read(ResourceLocation recipeID, JsonObject json) {
            String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            NonNullList ingredients = NonNullList.func_191196_a();
            for (JsonElement element : JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients")) {
                ingredients.add((Object)CraftingHelper.getIngredient((JsonElement)element));
            }
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            ItemStack result = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"), (boolean)true);
            return new MudBucketRecipe(recipeID, group, result, (NonNullList<Ingredient>)ingredients);
        }

        public MudBucketRecipe read(ResourceLocation recipeID, PacketBuffer buffer) {
            String group = buffer.func_150789_c(Short.MAX_VALUE);
            int numIngredients = buffer.func_150792_a();
            NonNullList ingredients = NonNullList.func_191197_a((int)numIngredients, (Object)Ingredient.field_193370_a);
            for (int j = 0; j < ingredients.size(); ++j) {
                ingredients.set(j, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            ItemStack result = buffer.func_150791_c();
            return new MudBucketRecipe(recipeID, group, result, (NonNullList<Ingredient>)ingredients);
        }

        public void write(PacketBuffer buffer, MudBucketRecipe recipe) {
            buffer.func_180714_a(recipe.func_193358_e());
            buffer.func_150787_b(recipe.func_192400_c().size());
            for (Ingredient ingredient : recipe.func_192400_c()) {
                ingredient.func_199564_a(buffer);
            }
            buffer.func_150788_a(recipe.func_77571_b());
        }
    }
}

