/*
 * Decompiled with CFR 0.152.
 */
package slexom.earthtojava.mobs.world.spawner;

import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.merchant.villager.WanderingTraderEntity;
import net.minecraft.entity.passive.horse.TraderLlamaEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.WorldEntitySpawner;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import slexom.earthtojava.mobs.config.E2JModConfig;
import slexom.earthtojava.mobs.entity.merchant.villager.E2JWanderingTraderEntity;
import slexom.earthtojava.mobs.init.EntityTypesInit;

public class E2JWanderingTraderSpawner {
    private final int DAY = 24000;
    private Random random;
    private ServerWorld world;

    @SubscribeEvent
    public void tick(TickEvent.WorldTickEvent event) {
        if (E2JModConfig.canWanderingTraderSpawn && event.phase == TickEvent.Phase.END && event.side == LogicalSide.SERVER) {
            this.world = (ServerWorld)event.world;
            int CHANCE = E2JModConfig.wanderingTraderChance;
            int DELAY = E2JModConfig.wanderingTraderDelay;
            this.random = this.world.func_201674_k();
            long dayTime = this.world.func_72820_D();
            if (dayTime % (long)(24000 * DELAY) == 1500L && this.random.nextInt(100) < CHANCE) {
                this.spawnTrader();
            }
        }
    }

    private void spawnTrader() {
        ServerPlayerEntity playerentity = this.world.func_217472_l_();
        if (playerentity != null) {
            BlockPos blockpos = playerentity.func_180425_c();
            PointOfInterestManager pointofinterestmanager = this.world.func_217443_B();
            Optional optional = pointofinterestmanager.func_219127_a(PointOfInterestType.field_221070_r.func_221045_c(), p_221241_0_ -> true, blockpos, 48, PointOfInterestManager.Status.ANY);
            BlockPos blockpos1 = optional.orElse(blockpos);
            BlockPos blockpos2 = this.getLlamaSpawnPosition(blockpos1, 48);
            if (blockpos2 != null && this.isValid(blockpos2)) {
                if (this.world.func_226691_t_(blockpos2) == Biomes.field_185440_P) {
                    return;
                }
                E2JWanderingTraderEntity traderEntity = (E2JWanderingTraderEntity)((EntityType)EntityTypesInit.WANDERING_TRADER_REGISTRY_OBJECT.get()).func_220342_a((World)this.world, (CompoundNBT)null, (ITextComponent)null, (PlayerEntity)null, blockpos2, SpawnReason.EVENT, false, false);
                if (traderEntity != null) {
                    for (int j = 0; j < 2; ++j) {
                        this.spawnTraderLlama(traderEntity);
                    }
                    this.world.func_72912_H().func_215761_a(traderEntity.func_110124_au());
                    traderEntity.func_213728_s(32000);
                    traderEntity.func_213726_g(blockpos1);
                    traderEntity.func_213390_a(blockpos1, 16);
                }
            }
        }
    }

    private void spawnTraderLlama(WanderingTraderEntity traderEntity) {
        TraderLlamaEntity traderLlamaEntity;
        BlockPos blockpos = this.getLlamaSpawnPosition(new BlockPos((Entity)traderEntity), 4);
        if (blockpos != null && (traderLlamaEntity = (TraderLlamaEntity)EntityType.field_220354_ax.func_220342_a((World)this.world, (CompoundNBT)null, (ITextComponent)null, (PlayerEntity)null, blockpos, SpawnReason.EVENT, false, false)) != null) {
            traderLlamaEntity.func_110162_b((Entity)traderEntity, true);
        }
    }

    @Nullable
    private BlockPos getLlamaSpawnPosition(BlockPos pos, int radius) {
        BlockPos blockPos = null;
        for (int i = 0; i < 10; ++i) {
            int z;
            int y;
            int x = pos.func_177958_n() + this.random.nextInt(radius * 2) - radius;
            BlockPos blockPos1 = new BlockPos(x, y = this.world.func_201676_a(Heightmap.Type.WORLD_SURFACE, x, z = pos.func_177952_p() + this.random.nextInt(radius * 2) - radius), z);
            if (!WorldEntitySpawner.func_209382_a((EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (IWorldReader)this.world, (BlockPos)blockPos1, (EntityType)EntityType.field_220351_aK)) continue;
            blockPos = blockPos1;
            break;
        }
        return blockPos;
    }

    private boolean isValid(BlockPos pos) {
        for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)pos, (BlockPos)pos.func_177982_a(1, 2, 1))) {
            if (this.world.func_180495_p(blockpos).func_196952_d((IBlockReader)this.world, blockpos).func_197766_b()) continue;
            return false;
        }
        return true;
    }
}

