/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.client.model;

import baguchan.earthmobsmod.entity.MuddyPigEntity;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.RendererModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class ModelMuddyPig<T extends MuddyPigEntity>
extends EntityModel<T> {
    public RendererModel RightFrontLeg;
    public RendererModel LeftFrontLeg;
    public RendererModel RightBackLeg;
    public RendererModel LeftBackLeg;
    public RendererModel Body;
    public RendererModel Head;
    public RendererModel Snout;
    public RendererModel Dirt;
    public RendererModel Flower;
    protected float childYOffset = 6.0f;
    protected float childZOffset = 4.0f;

    public ModelMuddyPig() {
        this.field_78090_t = 64;
        this.field_78089_u = 32;
        this.LeftFrontLeg = new RendererModel((Model)this, 0, 16);
        this.LeftFrontLeg.func_78793_a(3.0f, 18.0f, -7.0f);
        this.LeftFrontLeg.func_78790_a(-2.0f, 0.0f, -2.0f, 4, 6, 4, 0.0f);
        this.RightFrontLeg = new RendererModel((Model)this, 0, 16);
        this.RightFrontLeg.func_78793_a(-3.0f, 18.0f, -7.0f);
        this.RightFrontLeg.func_78790_a(-2.0f, 0.0f, -2.0f, 4, 6, 4, 0.0f);
        this.Flower = new RendererModel((Model)this, 24, 0);
        this.Flower.func_78793_a(0.0f, 0.0f, 0.0f);
        this.Flower.func_78790_a(-2.0f, -11.0f, -5.0f, 6, 6, 0, 0.0f);
        this.Body = new RendererModel((Model)this, 28, 8);
        this.Body.func_78793_a(0.0f, 11.0f, 0.0f);
        this.Body.func_78790_a(-5.0f, -10.0f, -7.0f, 10, 16, 8, 0.0f);
        this.setRotateAngle(this.Body, 1.5707964f, 0.0f, 0.0f);
        this.Snout = new RendererModel((Model)this, 16, 16);
        this.Snout.func_78793_a(0.0f, 0.0f, 0.0f);
        this.Snout.func_78790_a(-2.0f, 0.0f, -9.0f, 4, 3, 1, 0.0f);
        this.Head = new RendererModel((Model)this, 0, 0);
        this.Head.func_78793_a(0.0f, 12.0f, -8.0f);
        this.Head.func_78790_a(-4.0f, -4.0f, -8.0f, 8, 8, 8, 0.0f);
        this.LeftBackLeg = new RendererModel((Model)this, 0, 16);
        this.LeftBackLeg.func_78793_a(3.0f, 18.0f, 5.0f);
        this.LeftBackLeg.func_78790_a(-2.0f, 0.0f, -2.0f, 4, 6, 4, 0.0f);
        this.RightBackLeg = new RendererModel((Model)this, 0, 16);
        this.RightBackLeg.func_78793_a(-3.0f, 18.0f, 5.0f);
        this.RightBackLeg.func_78790_a(-2.0f, 0.0f, -2.0f, 4, 6, 4, 0.0f);
        this.Dirt = new RendererModel((Model)this, 48, 0);
        this.Dirt.func_78793_a(0.0f, 0.0f, 0.0f);
        this.Dirt.func_78790_a(-1.0f, -5.0f, -7.0f, 4, 1, 4, 0.0f);
        this.Head.func_78792_a(this.Flower);
        this.Head.func_78792_a(this.Snout);
        this.Head.func_78792_a(this.Dirt);
    }

    public void render(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        this.setRotationAngles(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        if (this.field_217114_e) {
            float f = 2.0f;
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)0.0f, (float)(this.childYOffset * scale), (float)(this.childZOffset * scale));
            this.Head.func_78785_a(scale);
            GlStateManager.popMatrix();
            GlStateManager.pushMatrix();
            GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
            GlStateManager.translatef((float)0.0f, (float)(24.0f * scale), (float)0.0f);
            this.LeftFrontLeg.func_78785_a(scale);
            this.RightFrontLeg.func_78785_a(scale);
            this.Body.func_78785_a(scale);
            this.LeftBackLeg.func_78785_a(scale);
            this.RightBackLeg.func_78785_a(scale);
            GlStateManager.popMatrix();
        } else {
            this.LeftFrontLeg.func_78785_a(scale);
            this.RightFrontLeg.func_78785_a(scale);
            this.Body.func_78785_a(scale);
            this.Head.func_78785_a(scale);
            this.LeftBackLeg.func_78785_a(scale);
            this.RightBackLeg.func_78785_a(scale);
        }
    }

    public void setRotationAngles(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor) {
        this.Head.field_78795_f = headPitch * ((float)Math.PI / 180);
        this.Head.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
        this.RightFrontLeg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.LeftFrontLeg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.RightBackLeg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.LeftBackLeg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        if (((MuddyPigEntity)((Object)entityIn)).isRunning() && Entity.func_213296_b((Vec3d)entityIn.func_213322_ci()) > 1.0E-7) {
            this.RightFrontLeg.field_78795_f = MathHelper.func_76134_b((float)(ageInTicks * 0.32f)) * 1.2f;
            this.LeftFrontLeg.field_78795_f = -MathHelper.func_76134_b((float)(ageInTicks * 0.32f)) * 1.2f;
            this.RightBackLeg.field_78795_f = -MathHelper.func_76134_b((float)(ageInTicks * 0.32f)) * 1.2f;
            this.LeftBackLeg.field_78795_f = MathHelper.func_76134_b((float)(ageInTicks * 0.32f)) * 1.2f;
        }
        this.Flower.field_78806_j = ((MuddyPigEntity)((Object)entityIn)).getHasFlower();
    }

    public void setLivingAnimations(T entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        this.Head.field_78808_h = ((MuddyPigEntity)((Object)entityIn)).getShakeAngle(partialTick, 0.0f);
        this.Body.field_78808_h = ((MuddyPigEntity)((Object)entityIn)).getShakeAngle(partialTick, -0.16f);
    }

    public void setRotateAngle(RendererModel modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }
}

