/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.entity;

import baguchan.earthmobsmod.entity.ai.MoveToMushroom;
import baguchan.earthmobsmod.handler.EarthEntitys;
import baguchan.earthmobsmod.handler.EarthItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.FleeSunGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;

public class CluckShroomEntity
extends ChickenEntity
implements IShearable {
    private static final DataParameter<String> CLUCKSHROOM_TYPE = EntityDataManager.func_187226_a(CluckShroomEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private UUID lightningUUID;

    public CluckShroomEntity(EntityType<? extends CluckShroomEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new FleeSunGoal((CreatureEntity)this, 1.45));
        this.field_70714_bg.func_75776_a(2, (Goal)new PanicGoal((CreatureEntity)this, 1.45){

            public boolean func_75250_a() {
                if (CluckShroomEntity.this.field_70170_p.func_217337_f(new BlockPos(this.field_75267_a.field_70165_t, this.field_75267_a.func_174813_aQ().field_72338_b, this.field_75267_a.field_70161_v)) && CluckShroomEntity.this.field_70170_p.func_72935_r()) {
                    return this.func_190863_f();
                }
                return super.func_75250_a();
            }
        });
        this.field_70714_bg.func_75776_a(3, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(4, (Goal)new MoveToMushroom(this, 1.1));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CLUCKSHROOM_TYPE, (Object)Type.RED.name);
    }

    @Nullable
    public ItemEntity func_199703_a(IItemProvider itemProvider) {
        if (itemProvider == Items.field_151110_aK) {
            itemProvider = EarthItems.SMELLY_EGG;
        }
        return this.func_199702_a(itemProvider, 0);
    }

    public boolean isShearable(ItemStack item, IWorldReader world, BlockPos pos) {
        return true;
    }

    public List<ItemStack> onSheared(ItemStack item, IWorld world, BlockPos pos, int fortune) {
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.field_70165_t, this.field_70163_u + (double)(this.func_213302_cg() / 2.0f), this.field_70161_v, 0.0, 0.0, 0.0);
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (!this.field_70170_p.field_72995_K) {
            ret.add(new ItemStack((IItemProvider)Item.func_150898_a((Block)this.getCluckShroomType().getState().func_177230_c()), 2));
            ChickenEntity cluckShroomEntity = (ChickenEntity)EntityType.field_200795_i.func_200721_a(this.field_70170_p);
            cluckShroomEntity.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            cluckShroomEntity.func_94061_f(this.func_175446_cd());
            if (this.func_145818_k_()) {
                cluckShroomEntity.func_200203_b(this.func_200201_e());
                cluckShroomEntity.func_174805_g(this.func_174833_aM());
            }
            if (this.func_70631_g_()) {
                cluckShroomEntity.func_70873_a(this.func_70874_b());
            }
            this.field_70170_p.func_217376_c((Entity)cluckShroomEntity);
            this.func_70106_y();
        }
        this.func_184185_a(SoundEvents.field_187763_eJ, 1.0f, 1.0f);
        return ret;
    }

    public boolean func_204701_dC() {
        return false;
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.field_70170_p.field_73012_v.nextInt(300) == 0 && this.field_70170_p.func_201669_a(this.func_180425_c(), 0) < 12 && !this.func_70631_g_()) {
            BlockPos blockPos = this.func_180425_c();
            for (int i = 0; i < 2 + this.field_70146_Z.nextInt(6); ++i) {
                BlockPos pos = new BlockPos(blockPos.func_177958_n() + this.field_70146_Z.nextInt(12) - 6, blockPos.func_177956_o() + this.field_70146_Z.nextInt(4) - 2, blockPos.func_177952_p() + this.field_70146_Z.nextInt(12) - 6);
                BlockState blockstate = this.field_70170_p.func_180495_p(pos);
                if (blockstate.func_177230_c() != Blocks.field_150337_Q && blockstate.func_177230_c() != Blocks.field_150338_P || this.field_70170_p.field_72995_K) continue;
                this.field_70170_p.func_217379_c(2005, pos, 0);
                CluckShroomEntity cluckShroomEntity = (CluckShroomEntity)EarthEntitys.CLUCKSHROOM.func_200721_a(this.field_70170_p);
                cluckShroomEntity.func_70012_b((float)pos.func_177958_n() + 0.5f, pos.func_177956_o(), (float)pos.func_177952_p() + 0.5f, 0.0f, 0.0f);
                cluckShroomEntity.func_94061_f(this.func_175446_cd());
                cluckShroomEntity.func_70873_a(-24000);
                this.field_70170_p.func_217376_c((Entity)cluckShroomEntity);
                this.field_70170_p.func_175655_b(pos, false);
            }
        }
    }

    private void setCluckShroomType(Type typeIn) {
        this.field_70180_af.func_187227_b(CLUCKSHROOM_TYPE, (Object)typeIn.name);
    }

    public Type getCluckShroomType() {
        return Type.getTypeByName((String)this.field_70180_af.func_187225_a(CluckShroomEntity.CLUCKSHROOM_TYPE));
    }

    public CluckShroomEntity createChild(AgeableEntity ageable) {
        CluckShroomEntity cluckshroomentity = (CluckShroomEntity)EarthEntitys.CLUCKSHROOM.func_200721_a(this.field_70170_p);
        cluckshroomentity.setCluckShroomType(this.func_213445_a((CluckShroomEntity)ageable));
        return cluckshroomentity;
    }

    private Type func_213445_a(CluckShroomEntity p_213445_1_) {
        Type cluckshroomentity$type1;
        Type cluckshroomentity$type = this.getCluckShroomType();
        Type cluckshroomentity$type2 = cluckshroomentity$type == (cluckshroomentity$type1 = p_213445_1_.getCluckShroomType()) && this.field_70146_Z.nextInt(1024) == 0 ? (cluckshroomentity$type == Type.BROWN ? Type.RED : Type.BROWN) : (this.field_70146_Z.nextBoolean() ? cluckshroomentity$type : cluckshroomentity$type1);
        return cluckshroomentity$type2;
    }

    protected ResourceLocation func_184647_J() {
        return EntityType.field_200795_i.func_220348_g();
    }

    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        return 1.0f - worldIn.func_205052_D(pos);
    }

    public static boolean spawnHandler(EntityType<? extends CluckShroomEntity> entity, IWorld world, SpawnReason p_223325_2_, BlockPos p_223325_3_, Random p_223325_4_) {
        return world.func_180495_p(p_223325_3_.func_177977_b()).func_177230_c() == Blocks.field_150391_bh && CluckShroomEntity.lightCheck(world, p_223325_3_, p_223325_4_);
    }

    public static boolean lightCheck(IWorld world, BlockPos pos, Random rand) {
        if (world.func_175710_j(pos) && !world.func_201672_e().func_72935_r()) {
            return true;
        }
        return !world.func_201672_e().func_72935_r() && world.func_175642_b(LightType.SKY, pos) < rand.nextInt(20);
    }

    public void func_70077_a(LightningBoltEntity lightningBolt) {
        UUID uuid = lightningBolt.func_110124_au();
        if (!uuid.equals(this.lightningUUID)) {
            this.setCluckShroomType(this.getCluckShroomType() == Type.RED ? Type.BROWN : Type.RED);
            this.lightningUUID = uuid;
            this.func_184185_a(SoundEvents.field_219658_gv, 2.0f, 1.0f);
        }
    }

    public static enum Type {
        RED("red", Blocks.field_150337_Q.func_176223_P()),
        BROWN("brown", Blocks.field_150338_P.func_176223_P());

        private final String name;
        private final BlockState renderState;

        private Type(String nameIn, BlockState renderStateIn) {
            this.name = nameIn;
            this.renderState = renderStateIn;
        }

        public BlockState getState() {
            return this.renderState;
        }

        private static Type getTypeByName(String nameIn) {
            for (Type cluckshroomentity$type : Type.values()) {
                if (!cluckshroomentity$type.name.equals(nameIn)) continue;
                return cluckshroomentity$type;
            }
            return RED;
        }
    }
}

