/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.entity;

import baguchan.earthmobsmod.entity.ai.EatGrassOrBloomGoal;
import baguchan.earthmobsmod.handler.EarthBlocks;
import baguchan.earthmobsmod.handler.EarthEntitys;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowerBlock;
import net.minecraft.block.GrassBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.dispenser.IPosition;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IShearable;

public class MooBloomEntity
extends CowEntity
implements IShearable {
    private static final Ingredient BREEDING_ITEMS = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151153_ao});
    private static final DataParameter<Boolean> SLEEP = EntityDataManager.func_187226_a(MooBloomEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private boolean didAttack;
    private int grassEatTimer;
    private int eatDelayTimer;
    private EatGrassOrBloomGoal eatGrassGoal;
    @Nullable
    private BlockPos flowerHomeTarget;

    public MooBloomEntity(EntityType<? extends MooBloomEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_184651_r() {
        this.eatGrassGoal = new EatGrassOrBloomGoal(this);
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new DoNothingGoal());
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.45, false));
        this.field_70714_bg.func_75776_a(3, (Goal)new PanicGoal((CreatureEntity)this, 2.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new TemptGoal((CreatureEntity)this, 1.25, BREEDING_ITEMS, false));
        this.field_70714_bg.func_75776_a(6, (Goal)this.eatGrassGoal);
        this.field_70714_bg.func_75776_a(7, (Goal)new MoveToGoal(this, 3.0, 1.25));
        this.field_70714_bg.func_75776_a(8, (Goal)new FollowParentGoal((AnimalEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(9, (Goal)new MoveToBloom(this, 1.4));
        this.field_70714_bg.func_75776_a(10, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0){

            public boolean func_75250_a() {
                return super.func_75250_a() && (MooBloomEntity.this.getFlowerHome() == null || MooBloomEntity.this.func_70092_e(MooBloomEntity.this.getFlowerHome().func_177958_n(), MooBloomEntity.this.getFlowerHome().func_177956_o(), MooBloomEntity.this.getFlowerHome().func_177952_p()) < 11.0);
            }
        });
        this.field_70714_bg.func_75776_a(11, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true){

            public boolean func_75250_a() {
                return MooBloomEntity.this.getFlowerHome() != null && !MooBloomEntity.this.isSleep() && super.func_75250_a() && this.field_75309_a.func_70092_e((double)MooBloomEntity.this.getFlowerHome().func_177958_n(), (double)MooBloomEntity.this.getFlowerHome().func_177956_o(), (double)MooBloomEntity.this.getFlowerHome().func_177952_p()) < 11.0;
            }

            public boolean func_75253_b() {
                return super.func_75253_b() && this.field_75309_a.func_70092_e((double)MooBloomEntity.this.getFlowerHome().func_177958_n(), (double)MooBloomEntity.this.getFlowerHome().func_177956_o(), (double)MooBloomEntity.this.getFlowerHome().func_177952_p()) < 11.0;
            }
        });
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.2f);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
        this.func_110148_a(SharedMonsterAttributes.field_221120_g).func_111128_a(1.35);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SLEEP, (Object)false);
    }

    protected void func_70619_bc() {
        this.grassEatTimer = this.eatGrassGoal.getEatingGrassTimer();
        super.func_70619_bc();
        if (this.field_70122_E && this.field_70173_aa % 140 == 0 && this.field_70170_p.field_73012_v.nextInt(1) == 0 && !this.isSleep() && (this.field_70702_br > 0.0f || this.field_70701_bs > 0.0f || this.field_191988_bg > 0.0f)) {
            FlowerBlock flowerBlock = EarthBlocks.BUTTERCUP;
            BlockPos blockpos = this.func_180425_c().func_177977_b();
            this.setEatDelayTimer(120);
            if (flowerBlock.func_196260_a(flowerBlock.func_176223_P(), (IWorldReader)this.field_70170_p, blockpos) && this.field_70170_p.func_175623_d(this.func_180425_c())) {
                this.field_70170_p.func_175656_a(this.func_180425_c(), flowerBlock.func_176223_P());
            }
        }
        if (this.eatDelayTimer > 0) {
            --this.eatDelayTimer;
        }
        if (this.field_70122_E && this.field_70170_p.field_73012_v.nextInt(160) == 0 && this.isSleep()) {
            BlockPos blockPos = this.func_180425_c();
            for (int i = 0; i < 2 + this.field_70146_Z.nextInt(6); ++i) {
                BlockPos pos = new BlockPos(blockPos.func_177958_n() + this.field_70146_Z.nextInt(12) - 6, blockPos.func_177956_o() + this.field_70146_Z.nextInt(6) - 3, blockPos.func_177952_p() + this.field_70146_Z.nextInt(12) - 6);
                BlockState blockstate = this.field_70170_p.func_180495_p(pos);
                if (!(blockstate.func_177230_c() instanceof IGrowable) || blockstate.func_177230_c() instanceof GrassBlock) continue;
                IGrowable igrowable = (IGrowable)blockstate.func_177230_c();
                if (this.field_70170_p.field_72995_K) continue;
                this.field_70170_p.func_217379_c(2005, pos, 0);
                if (!igrowable.func_180670_a(this.field_70170_p, this.field_70170_p.field_73012_v, pos, blockstate)) continue;
                igrowable.func_176474_b(this.field_70170_p, this.field_70170_p.field_73012_v, pos, blockstate);
            }
        }
        if (this.isSleep() && this.field_70170_p.func_72935_r() || this.isSleep() && this.func_70638_az() != null) {
            this.setSleep(false);
        }
        if (!this.isSleep() && !this.field_70170_p.func_72935_r() && this.func_70638_az() == null && this.field_70146_Z.nextInt(240) == 0) {
            this.setSleep(true);
        }
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            this.grassEatTimer = Math.max(0, this.grassEatTimer - 1);
        }
        this.func_82168_bl();
        super.func_70636_d();
    }

    public int getEatDelayTimer() {
        return this.eatDelayTimer;
    }

    public void setEatDelayTimer(int eatDelayTimer) {
        this.eatDelayTimer = eatDelayTimer;
    }

    protected SoundEvent func_184639_G() {
        if (!this.isSleep()) {
            return SoundEvents.field_187558_ak;
        }
        return null;
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        if (item == Items.field_151054_z) {
            return false;
        }
        return super.func_184645_a(player, hand);
    }

    public boolean isShearable(ItemStack item, IWorldReader world, BlockPos pos) {
        return true;
    }

    public List<ItemStack> onSheared(ItemStack item, IWorld world, BlockPos pos, int fortune) {
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.field_70165_t, this.field_70163_u + (double)(this.func_213302_cg() / 2.0f), this.field_70161_v, 0.0, 0.0, 0.0);
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (!this.field_70170_p.field_72995_K) {
            ret.add(new ItemStack((IItemProvider)Item.func_150898_a((Block)EarthBlocks.BUTTERCUP), 3));
            CowEntity cowEntity = (CowEntity)EntityType.field_200796_j.func_200721_a(this.field_70170_p);
            cowEntity.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            cowEntity.func_94061_f(this.func_175446_cd());
            if (this.func_145818_k_()) {
                cowEntity.func_200203_b(this.func_200201_e());
                cowEntity.func_174805_g(this.func_174833_aM());
            }
            if (this.func_70631_g_()) {
                cowEntity.func_70873_a(this.func_70874_b());
            }
            this.field_70170_p.func_217376_c((Entity)cowEntity);
            this.func_70106_y();
        }
        this.func_184185_a(SoundEvents.field_187763_eJ, 1.0f, 1.0f);
        return ret;
    }

    public boolean isSleep() {
        return (Boolean)this.field_70180_af.func_187225_a(SLEEP);
    }

    public void setSleep(boolean sleep) {
        this.field_70180_af.func_187227_b(SLEEP, (Object)sleep);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Sleep", this.isSleep());
        compound.func_74768_a("EatDelay", this.getEatDelayTimer());
        if (this.flowerHomeTarget != null) {
            compound.func_218657_a("HomeTarget", (INBT)NBTUtil.func_186859_a((BlockPos)this.flowerHomeTarget));
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setSleep(compound.func_74767_n("Sleep"));
        this.setEatDelayTimer(compound.func_74762_e("EatDelay"));
        if (compound.func_74764_b("HomeTarget")) {
            this.flowerHomeTarget = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("HomeTarget"));
        }
        this.func_70873_a(Math.max(0, this.func_70874_b()));
    }

    public void setFlowerHome(@Nullable BlockPos p_213726_1_) {
        this.flowerHomeTarget = p_213726_1_;
    }

    @Nullable
    public BlockPos getFlowerHome() {
        return this.flowerHomeTarget;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.grassEatTimer = 40;
        } else {
            super.func_70103_a(id);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getHeadRotationPointY(float p_70894_1_) {
        if (this.grassEatTimer <= 0) {
            return 0.0f;
        }
        if (this.grassEatTimer >= 4 && this.grassEatTimer <= 36) {
            return 1.0f;
        }
        return this.grassEatTimer < 4 ? ((float)this.grassEatTimer - p_70894_1_) / 4.0f : -((float)(this.grassEatTimer - 40) - p_70894_1_) / 4.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getHeadRotationAngleX(float p_70890_1_) {
        if (this.grassEatTimer > 4 && this.grassEatTimer <= 36) {
            float f = ((float)(this.grassEatTimer - 4) - p_70890_1_) / 32.0f;
            return 0.62831855f + 0.21991149f * MathHelper.func_76126_a((float)(f * 28.7f));
        }
        return this.grassEatTimer > 0 ? 0.62831855f : this.field_70125_A * ((float)Math.PI / 180);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        float f1 = (float)this.func_110148_a(SharedMonsterAttributes.field_221120_g).func_111126_e();
        if (flag) {
            this.func_174815_a((LivingEntity)this, entityIn);
            f1 += (float)EnchantmentHelper.func_77501_a((LivingEntity)this);
            this.didAttack = true;
        }
        if (f1 > 0.0f && entityIn instanceof LivingEntity) {
            ((LivingEntity)entityIn).func_70653_a((Entity)this, f1 * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
            this.func_213317_d(this.func_213322_ci().func_216372_d(0.6, 1.0, 0.6));
        }
        return flag;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        this.setSleep(false);
        return super.func_70097_a(source, amount);
    }

    private void setDidAttack(boolean didSpitIn) {
        this.didAttack = didSpitIn;
    }

    public boolean func_70877_b(ItemStack stack) {
        return BREEDING_ITEMS.test(stack);
    }

    protected ResourceLocation func_184647_J() {
        return EntityType.field_200796_j.func_220348_g();
    }

    public MooBloomEntity createChild(AgeableEntity ageable) {
        return (MooBloomEntity)EarthEntitys.MOOBLOOM.func_200721_a(this.field_70170_p);
    }

    class DoNothingGoal
    extends Goal {
        public DoNothingGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public boolean func_75253_b() {
            return MooBloomEntity.this.isSleep();
        }

        public boolean func_75250_a() {
            return MooBloomEntity.this.isSleep();
        }

        public void func_75249_e() {
            MooBloomEntity.this.func_70637_d(false);
            MooBloomEntity.this.setSleep(true);
            MooBloomEntity.this.func_70605_aq().func_75642_a(MooBloomEntity.this.field_70165_t, MooBloomEntity.this.field_70163_u, MooBloomEntity.this.field_70161_v, 0.0);
        }

        public void func_75246_d() {
            super.func_75246_d();
            MooBloomEntity.this.func_70661_as().func_75499_g();
        }
    }

    static class HurtByTargetGoal
    extends net.minecraft.entity.ai.goal.HurtByTargetGoal {
        public HurtByTargetGoal(MooBloomEntity moobloom) {
            super((CreatureEntity)moobloom, new Class[0]);
        }

        public boolean func_75253_b() {
            MooBloomEntity moobloom;
            if (this.field_75299_d instanceof MooBloomEntity && (moobloom = (MooBloomEntity)this.field_75299_d).didAttack) {
                moobloom.setDidAttack(false);
                return false;
            }
            return super.func_75253_b();
        }
    }

    class MoveToGoal
    extends Goal {
        final MooBloomEntity moobloom;
        final double distance;
        final double speed;

        MoveToGoal(MooBloomEntity mooBloomEntity, double distance, double speed) {
            this.moobloom = mooBloomEntity;
            this.distance = distance;
            this.speed = speed;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public void func_75251_c() {
            MooBloomEntity.this.field_70699_by.func_75499_g();
        }

        public boolean func_75250_a() {
            BlockPos blockpos = this.moobloom.getFlowerHome();
            return blockpos != null && this.func_220846_a(blockpos, this.distance);
        }

        public void func_75246_d() {
            BlockPos blockpos = this.moobloom.getFlowerHome();
            if (blockpos != null && MooBloomEntity.this.field_70699_by.func_75500_f()) {
                if (this.func_220846_a(blockpos, 6.0)) {
                    Vec3d vec3d = new Vec3d((double)blockpos.func_177958_n() - this.moobloom.field_70165_t, (double)blockpos.func_177956_o() - this.moobloom.field_70163_u, (double)blockpos.func_177952_p() - this.moobloom.field_70161_v).func_72432_b();
                    Vec3d vec3d1 = vec3d.func_186678_a(10.0).func_72441_c(this.moobloom.field_70165_t, this.moobloom.field_70163_u, this.moobloom.field_70161_v);
                    MooBloomEntity.this.field_70699_by.func_75492_a(vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c, this.speed);
                } else {
                    MooBloomEntity.this.field_70699_by.func_75492_a((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), this.speed);
                }
            }
        }

        private boolean func_220846_a(BlockPos p_220846_1_, double p_220846_2_) {
            return !p_220846_1_.func_218137_a((IPosition)this.moobloom.func_213303_ch(), p_220846_2_);
        }
    }

    class MoveToBloom
    extends MoveToBlockGoal {
        private final MooBloomEntity cow;
        private final int searchLength;
        private final int field_203113_j;
        protected int field_203112_e;

        public MoveToBloom(MooBloomEntity p_i48911_1_, double speed) {
            super((CreatureEntity)p_i48911_1_, speed, 6, 1);
            this.cow = p_i48911_1_;
            this.searchLength = 6;
            this.field_203112_e = 0;
            this.field_203113_j = 1;
        }

        public boolean func_75250_a() {
            return super.func_75250_a();
        }

        public boolean func_75253_b() {
            return super.func_75253_b();
        }

        protected boolean func_179488_a(IWorldReader worldIn, BlockPos pos) {
            return worldIn.func_180495_p(pos) == EarthBlocks.BUTTERCUP.func_176223_P() && worldIn.func_175623_d(pos.func_177984_a());
        }

        protected boolean func_179489_g() {
            int i = this.searchLength;
            int j = this.field_203113_j;
            BlockPos blockpos = new BlockPos((Entity)this.field_179495_c);
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            int k = this.field_203112_e;
            while (k <= j) {
                for (int l = 0; l < i; ++l) {
                    int i1 = 0;
                    while (i1 <= l) {
                        int j1;
                        int n = j1 = i1 < l && i1 > -l ? l : 0;
                        while (j1 <= l) {
                            blockpos$mutableblockpos.func_189533_g((Vec3i)blockpos).func_196234_d(i1, k - 1, j1);
                            if (this.field_179495_c.func_213389_a((BlockPos)blockpos$mutableblockpos) && this.func_179488_a((IWorldReader)this.field_179495_c.field_70170_p, (BlockPos)blockpos$mutableblockpos) && (this.cow.getFlowerHome() == null || blockpos$mutableblockpos.func_218141_a((Vec3i)this.cow.getFlowerHome(), 2.25))) {
                                this.field_179494_b = blockpos$mutableblockpos;
                                return true;
                            }
                            j1 = j1 > 0 ? -j1 : 1 - j1;
                        }
                        i1 = i1 > 0 ? -i1 : 1 - i1;
                    }
                }
                k = k > 0 ? -k : 1 - k;
            }
            return false;
        }

        public void func_75249_e() {
            super.func_75249_e();
        }

        public void func_75251_c() {
            super.func_75251_c();
        }
    }
}

