/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.entity;

import baguchan.earthmobsmod.entity.ai.GoToMudGoal;
import baguchan.earthmobsmod.handler.EarthBlocks;
import baguchan.earthmobsmod.handler.EarthEntitys;
import baguchan.earthmobsmod.handler.EarthFluids;
import baguchan.earthmobsmod.handler.EarthTags;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.pathfinding.PathType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IShearable;

public class MuddyPigEntity
extends PigEntity
implements IShearable {
    private static final Ingredient TEMPTATION_ITEMS = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151172_bF, Items.field_151174_bG, Items.field_185164_cV});
    private static final DataParameter<Integer> FLOWER_COLOR = EntityDataManager.func_187226_a(MuddyPigEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> HAS_FLOWER = EntityDataManager.func_187226_a(MuddyPigEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> DRY = EntityDataManager.func_187226_a(MuddyPigEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> RUNNING = EntityDataManager.func_187226_a(MuddyPigEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final Map<DyeColor, IItemProvider> DYE_BY_COLOR = (Map)Util.func_200696_a((Object)Maps.newEnumMap(DyeColor.class), p_203402_0_ -> {
        p_203402_0_.put(DyeColor.WHITE, Items.field_222069_lA);
        p_203402_0_.put(DyeColor.ORANGE, Items.field_196108_bd);
        p_203402_0_.put(DyeColor.MAGENTA, Items.field_196110_be);
        p_203402_0_.put(DyeColor.LIGHT_BLUE, Items.field_196112_bf);
        p_203402_0_.put(DyeColor.YELLOW, Items.field_222081_ls);
        p_203402_0_.put(DyeColor.LIME, Items.field_196116_bh);
        p_203402_0_.put(DyeColor.PINK, Items.field_196118_bi);
        p_203402_0_.put(DyeColor.GRAY, Items.field_196120_bj);
        p_203402_0_.put(DyeColor.LIGHT_GRAY, Items.field_196122_bk);
        p_203402_0_.put(DyeColor.CYAN, Items.field_196124_bl);
        p_203402_0_.put(DyeColor.PURPLE, Items.field_196126_bm);
        p_203402_0_.put(DyeColor.BLUE, Items.field_222083_lx);
        p_203402_0_.put(DyeColor.BROWN, Items.field_222085_ly);
        p_203402_0_.put(DyeColor.GREEN, Items.field_222079_lj);
        p_203402_0_.put(DyeColor.RED, Items.field_222078_li);
        p_203402_0_.put(DyeColor.BLACK, Items.field_222086_lz);
    });
    private boolean isWet;
    private boolean isShaking;
    protected boolean inMud;
    private float timeIsShaking;
    private float prevTimeIsShaking;
    private int dryTime;

    public MuddyPigEntity(EntityType<MuddyPigEntity> type, World p_i48574_2_) {
        super(type, p_i48574_2_);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0, PigEntity.class));
        this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)this, 1.2, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151146_bM}), false));
        this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)this, 1.2, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(4, (Goal)new GoToMudGoal(this, 1.0){

            @Override
            public boolean func_75250_a() {
                return MuddyPigEntity.this.isDry() && super.func_75250_a();
            }
        });
        this.field_70714_bg.func_75776_a(5, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(1.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DRY, (Object)false);
        this.field_70180_af.func_187214_a(HAS_FLOWER, (Object)true);
        this.field_70180_af.func_187214_a(RUNNING, (Object)false);
        this.field_70180_af.func_187214_a(FLOWER_COLOR, (Object)DyeColor.RED.func_196059_a());
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new Navigator((MobEntity)this, worldIn);
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187703_dN;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187700_dM;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187697_dL;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187709_dP, 0.15f, 1.0f);
    }

    protected ResourceLocation func_184647_J() {
        return EntityType.field_200784_X.func_220348_g();
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Dry", this.isDry());
        compound.func_74757_a("HasFlower", this.getHasFlower());
        compound.func_74774_a("FlowerColor", (byte)this.getFlowerColor().func_196059_a());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setDry(compound.func_74767_n("Dry"));
        this.setHasFlower(compound.func_74767_n("HasFlower"));
        this.setFlowerColor(DyeColor.func_196056_a((int)compound.func_74762_e("FlowerColor")));
    }

    public DyeColor getFlowerColor() {
        return DyeColor.func_196056_a((int)((Integer)this.field_70180_af.func_187225_a(FLOWER_COLOR)));
    }

    public void setFlowerColor(DyeColor color) {
        this.field_70180_af.func_187227_b(FLOWER_COLOR, (Object)color.func_196059_a());
    }

    public boolean getHasFlower() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_FLOWER);
    }

    public void setHasFlower(boolean hasFlower) {
        this.field_70180_af.func_187227_b(HAS_FLOWER, (Object)hasFlower);
    }

    public boolean isDry() {
        return (Boolean)this.field_70180_af.func_187225_a(DRY);
    }

    public void setDry(boolean hasFlower) {
        this.field_70180_af.func_187227_b(DRY, (Object)hasFlower);
    }

    public boolean isRunning() {
        return (Boolean)this.field_70180_af.func_187225_a(RUNNING);
    }

    public void setRunning(boolean isRunnning) {
        this.field_70180_af.func_187227_b(RUNNING, (Object)isRunnning);
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        if (!itemstack.func_190926_b() && item instanceof DyeItem) {
            DyeColor dyecolor = ((DyeItem)item).func_195962_g();
            if (this.getHasFlower() && dyecolor != this.getFlowerColor()) {
                this.setFlowerColor(dyecolor);
                if (!player.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
                return true;
            }
        }
        return super.func_184645_a(player, hand);
    }

    public boolean isShearable(ItemStack item, IWorldReader world, BlockPos pos) {
        return this.getHasFlower() && !this.isDry();
    }

    public List<ItemStack> onSheared(ItemStack item, IWorld world, BlockPos pos, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (!this.field_70170_p.field_72995_K) {
            this.setHasFlower(false);
            ret.add(new ItemStack(DYE_BY_COLOR.get(this.getFlowerColor())));
        }
        this.func_184185_a(SoundEvents.field_187763_eJ, 1.0f, 1.0f);
        return ret;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.isWet && !this.isShaking && !this.isDry()) {
            this.isShaking = true;
            this.timeIsShaking = 0.0f;
            this.prevTimeIsShaking = 0.0f;
            this.field_70170_p.func_72960_a((Entity)this, (byte)8);
        }
    }

    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.setHasFlower(true);
        this.setFlowerColor(DyeColor.func_196056_a((int)worldIn.func_201674_k().nextInt(DyeColor.values().length)));
        return spawnDataIn;
    }

    public static boolean spawnHandler(EntityType<? extends AnimalEntity> p_223316_0_, IWorld p_223316_1_, SpawnReason p_223316_2_, BlockPos p_223316_3_, Random p_223316_4_) {
        return p_223316_1_.func_201672_e().func_201675_m().func_186058_p() == DimensionType.field_223227_a_ && p_223316_1_.func_180495_p(p_223316_3_.func_177977_b()).func_177230_c() == Blocks.field_196658_i && p_223316_1_.func_201669_a(p_223316_3_, 0) > 8;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_70089_S()) {
            if (this.field_70703_bu && (!(this.field_211517_W > 0.0) || this.field_70122_E && !(this.field_211517_W > 0.4))) {
                this.func_180466_bG(EarthTags.Fluids.MUD_WATER);
            }
            if (this.isDry()) {
                int n;
                if (this.isInMud() && !this.isShaking) {
                    this.dryTime = 0;
                    this.isShaking = true;
                    this.timeIsShaking = 0.0f;
                    this.prevTimeIsShaking = 0.0f;
                }
                ++this.dryTime;
                if ((double)n >= 2400.0) {
                    this.makeMuddyPig();
                }
            } else if (this.isInMud()) {
                this.dryTime = 0;
            } else {
                int n;
                ++this.dryTime;
                if ((double)n >= 2400.0 && !this.isShaking) {
                    this.dryTime = 0;
                    this.isShaking = true;
                    this.timeIsShaking = 0.0f;
                    this.prevTimeIsShaking = 0.0f;
                }
            }
            if (!this.isDry() && this.func_203008_ap() && !this.isShaking) {
                this.isWet = true;
                this.isShaking = true;
                this.timeIsShaking = 0.0f;
                this.prevTimeIsShaking = 0.0f;
            }
            if (this.isWet || this.isShaking) {
                if (this.timeIsShaking == 0.0f) {
                    this.func_184185_a(SoundEvents.field_187867_gJ, this.func_70599_aP(), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                }
                this.prevTimeIsShaking = this.timeIsShaking;
                this.timeIsShaking += 0.05f;
                if (this.prevTimeIsShaking >= 2.0f) {
                    if (!this.field_70170_p.field_72995_K) {
                        if (this.isWet && !this.isDry()) {
                            this.setDry(true);
                            this.setHasFlower(false);
                        } else if (this.isWet && this.isDry()) {
                            this.makeMuddyPig();
                        } else if (!this.isWet && this.isDry()) {
                            this.setDry(false);
                            this.setHasFlower(true);
                        } else if (!this.isWet && !this.isDry()) {
                            this.setDry(true);
                            this.setHasFlower(false);
                        }
                    }
                    this.isWet = false;
                    this.isShaking = false;
                    this.prevTimeIsShaking = 0.0f;
                    this.timeIsShaking = 0.0f;
                }
                if (this.timeIsShaking > 0.4f) {
                    float f = (float)this.func_174813_aQ().field_72338_b;
                    int i = (int)(MathHelper.func_76126_a((float)((this.timeIsShaking - 0.4f) * (float)Math.PI)) * 7.0f);
                    Vec3d vec3d = this.func_213322_ci();
                    for (int j = 0; j < i; ++j) {
                        float f1 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.func_213311_cf() * 0.6f;
                        float f2 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.func_213311_cf() * 0.6f;
                        if (!this.isWet) continue;
                        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218422_X, this.field_70165_t + (double)f1, (double)(f + 0.85f), this.field_70161_v + (double)f2, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
                    }
                }
            }
        }
    }

    private void makeMuddyPig() {
        if (!this.field_70170_p.field_72995_K) {
            PigEntity pigEntity = (PigEntity)EntityType.field_200784_X.func_200721_a(this.field_70170_p);
            pigEntity.func_94061_f(this.func_175446_cd());
            pigEntity.func_180432_n((Entity)this);
            if (this.func_145818_k_()) {
                pigEntity.func_200203_b(this.func_200201_e());
                pigEntity.func_174805_g(this.func_174833_aM());
            }
            if (this.func_70901_n()) {
                pigEntity.func_70900_e(true);
            }
            if (this.func_70631_g_()) {
                pigEntity.func_70873_a(this.func_70874_b());
            }
            this.field_70170_p.func_73046_m().func_71218_a(this.field_71093_bK).removeEntityComplete((Entity)this, false);
            this.field_70170_p.func_73046_m().func_71218_a(this.field_71093_bK).func_217460_e((Entity)pigEntity);
        }
    }

    public void func_213352_e(Vec3d vec) {
        if (this.func_70089_S()) {
            Entity entity;
            Entity entity2 = entity = this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
            if (this.func_184207_aI() && this.func_82171_bF()) {
                this.field_70126_B = this.field_70177_z = entity.field_70177_z;
                this.field_70125_A = entity.field_70125_A * 0.5f;
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
                this.field_70761_aq = this.field_70177_z;
                this.field_70759_as = this.field_70177_z;
                this.field_70138_W = 1.0f;
                this.field_70747_aH = this.func_70689_ay() * 0.1f;
                if (this.func_184186_bw()) {
                    Vec3d vec3d6 = this.func_213322_ci();
                    float d0 = 0.0f;
                    if (this.func_70090_H() || this.isInMud()) {
                        d0 = d0 < 0.35f ? (d0 += 0.01f) : 0.3f;
                    } else if (d0 > 0.0f) {
                        d0 -= 0.01f;
                    }
                    this.func_213293_j(vec3d6.field_72450_a, (double)d0 + vec3d6.field_72448_b, vec3d6.field_72449_c);
                    super.func_213352_e(vec);
                } else {
                    this.func_213317_d(Vec3d.field_186680_a);
                }
                this.field_184618_aE = this.field_70721_aZ;
                double d1 = this.field_70165_t - this.field_70169_q;
                double d0 = this.field_70161_v - this.field_70166_s;
                float f1 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
                if (f1 > 1.0f) {
                    f1 = 1.0f;
                }
                this.field_70721_aZ += (f1 - this.field_70721_aZ) * 0.4f;
                this.field_184619_aG += this.field_70721_aZ;
            } else {
                this.field_70138_W = 0.5f;
                this.field_70747_aH = 0.02f;
                super.func_213352_e(vec);
            }
        }
    }

    protected float func_189749_co() {
        return this.isInMud() ? 0.9f : super.func_189749_co();
    }

    public boolean func_70072_I() {
        if (this.func_210500_b(EarthTags.Fluids.MUD_WATER)) {
            if (!this.inMud && !this.field_70148_d) {
                this.func_71061_d_();
            }
            this.field_70143_R = 0.0f;
            this.inMud = true;
            this.func_70066_B();
            return false;
        }
        this.inMud = false;
        return super.func_70072_I();
    }

    public boolean func_203008_ap() {
        return !this.isInMud() && super.func_203008_ap();
    }

    public boolean isInMud() {
        return this.inMud;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 8) {
            this.isShaking = true;
            this.timeIsShaking = 0.0f;
            this.prevTimeIsShaking = 0.0f;
        } else {
            super.func_70103_a(id);
        }
    }

    public void func_70645_a(DamageSource cause) {
        this.isWet = false;
        this.isShaking = false;
        this.prevTimeIsShaking = 0.0f;
        this.timeIsShaking = 0.0f;
        super.func_70645_a(cause);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70026_G() {
        return this.isWet;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShadingWhileWet(float p_70915_1_) {
        return 0.75f + MathHelper.func_219799_g((float)p_70915_1_, (float)this.prevTimeIsShaking, (float)this.timeIsShaking) / 2.0f * 0.25f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShakeAngle(float p_70923_1_, float p_70923_2_) {
        float f = (MathHelper.func_219799_g((float)p_70923_1_, (float)this.prevTimeIsShaking, (float)this.timeIsShaking) + p_70923_2_) / 1.8f;
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        return MathHelper.func_76126_a((float)(f * (float)Math.PI)) * MathHelper.func_76126_a((float)(f * (float)Math.PI * 11.0f)) * 0.15f * (float)Math.PI;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223222_a_;
    }

    public MuddyPigEntity createChild(AgeableEntity ageable) {
        return (MuddyPigEntity)EarthEntitys.MUDDYPIG.func_200721_a(this.field_70170_p);
    }

    public boolean func_70877_b(ItemStack stack) {
        return TEMPTATION_ITEMS.test(stack);
    }

    public boolean func_70878_b(AnimalEntity otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (otherAnimal instanceof PigEntity) {
            return this.func_70880_s() && otherAnimal.func_70880_s();
        }
        return false;
    }

    static class Processor
    extends WalkNodeProcessor {
        private Processor() {
        }

        public PathPoint func_186318_b() {
            int i;
            if (this.func_186322_e() && this.field_186326_b.func_70090_H()) {
                i = MathHelper.func_76128_c((double)this.field_186326_b.func_174813_aQ().field_72338_b);
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(this.field_186326_b.field_70165_t, (double)i, this.field_186326_b.field_70161_v);
                BlockState blockstate = this.field_176169_a.func_180495_p((BlockPos)blockpos$mutableblockpos);
                while (blockstate.func_177230_c() == Blocks.field_150355_j || blockstate.func_204520_s() == Fluids.field_204546_a.func_207204_a(false)) {
                    blockpos$mutableblockpos.func_189532_c(this.field_186326_b.field_70165_t, (double)(++i), this.field_186326_b.field_70161_v);
                    blockstate = this.field_176169_a.func_180495_p((BlockPos)blockpos$mutableblockpos);
                }
                blockstate = this.field_176169_a.func_180495_p((BlockPos)blockpos$mutableblockpos);
                while (blockstate.func_177230_c() == EarthBlocks.MUDWATER || blockstate.func_204520_s() == EarthFluids.MUD_WATER.func_207204_a(false)) {
                    blockpos$mutableblockpos.func_189532_c(this.field_186326_b.field_70165_t, (double)(++i), this.field_186326_b.field_70161_v);
                    blockstate = this.field_176169_a.func_180495_p((BlockPos)blockpos$mutableblockpos);
                }
                --i;
            } else if (this.field_186326_b.field_70122_E) {
                i = MathHelper.func_76128_c((double)(this.field_186326_b.func_174813_aQ().field_72338_b + 0.5));
            } else {
                BlockPos blockpos = new BlockPos((Entity)this.field_186326_b);
                while ((this.field_176169_a.func_180495_p(blockpos).func_196958_f() || this.field_176169_a.func_180495_p(blockpos).func_196957_g((IBlockReader)this.field_176169_a, blockpos, PathType.LAND)) && blockpos.func_177956_o() > 0) {
                    blockpos = blockpos.func_177977_b();
                }
                i = blockpos.func_177984_a().func_177956_o();
            }
            BlockPos blockpos2 = new BlockPos((Entity)this.field_186326_b);
            PathNodeType pathnodetype1 = this.getPathNodeType(this.field_186326_b, blockpos2.func_177958_n(), i, blockpos2.func_177952_p());
            if (this.field_186326_b.func_184643_a(pathnodetype1) < 0.0f) {
                HashSet set = Sets.newHashSet();
                set.add(new BlockPos(this.field_186326_b.func_174813_aQ().field_72340_a, (double)i, this.field_186326_b.func_174813_aQ().field_72339_c));
                set.add(new BlockPos(this.field_186326_b.func_174813_aQ().field_72340_a, (double)i, this.field_186326_b.func_174813_aQ().field_72334_f));
                set.add(new BlockPos(this.field_186326_b.func_174813_aQ().field_72336_d, (double)i, this.field_186326_b.func_174813_aQ().field_72339_c));
                set.add(new BlockPos(this.field_186326_b.func_174813_aQ().field_72336_d, (double)i, this.field_186326_b.func_174813_aQ().field_72334_f));
                for (BlockPos blockpos1 : set) {
                    PathNodeType pathnodetype = this.getPathNodeType(this.field_186326_b, blockpos1);
                    if (!(this.field_186326_b.func_184643_a(pathnodetype) >= 0.0f)) continue;
                    return this.func_176159_a(blockpos1.func_177958_n(), blockpos1.func_177956_o(), blockpos1.func_177952_p());
                }
            }
            return this.func_176159_a(blockpos2.func_177958_n(), i, blockpos2.func_177952_p());
        }

        private PathNodeType getPathNodeType(MobEntity entitylivingIn, BlockPos pos) {
            return this.getPathNodeType(entitylivingIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }

        private PathNodeType getPathNodeType(MobEntity entitylivingIn, int x, int y, int z) {
            return this.func_186319_a((IBlockReader)this.field_176169_a, x, y, z, entitylivingIn, this.field_176168_c, this.field_176165_d, this.field_176166_e, this.func_186324_d(), this.func_186323_c());
        }
    }

    static class Navigator
    extends GroundPathNavigator {
        public Navigator(MobEntity p_i50754_1_, World p_i50754_2_) {
            super(p_i50754_1_, p_i50754_2_);
        }

        protected PathFinder func_179679_a(int p_179679_1_) {
            this.field_179695_a = new Processor();
            return new PathFinder(this.field_179695_a, p_179679_1_);
        }

        protected Vec3d func_75502_i() {
            return new Vec3d(this.field_75515_a.field_70165_t, (double)this.getPathablePosY(), this.field_75515_a.field_70161_v);
        }

        private int getPathablePosY() {
            if (this.field_75515_a.func_70090_H() && this.func_212238_t()) {
                int i = MathHelper.func_76128_c((double)this.field_75515_a.func_174813_aQ().field_72338_b);
                Block block = this.field_75513_b.func_180495_p(new BlockPos(this.field_75515_a.field_70165_t, (double)i, this.field_75515_a.field_70161_v)).func_177230_c();
                int j = 0;
                while (block == Blocks.field_150355_j || block == EarthBlocks.MUDWATER) {
                    block = this.field_75513_b.func_180495_p(new BlockPos(this.field_75515_a.field_70165_t, (double)(++i), this.field_75515_a.field_70161_v)).func_177230_c();
                    if (++j <= 16) continue;
                    return MathHelper.func_76128_c((double)this.field_75515_a.func_174813_aQ().field_72338_b);
                }
                return i;
            }
            return MathHelper.func_76128_c((double)(this.field_75515_a.func_174813_aQ().field_72338_b + 0.5));
        }
    }
}

