/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod;

import baguchan.earthmobsmod.client.ClientRegistrar;
import baguchan.earthmobsmod.entity.MooBloomEntity;
import baguchan.earthmobsmod.entity.MuddyPigEntity;
import baguchan.earthmobsmod.entity.ai.GoToMudGoal;
import baguchan.earthmobsmod.handler.EarthBlocks;
import baguchan.earthmobsmod.handler.EarthEntitys;
import baguchan.earthmobsmod.handler.EarthFeatures;
import baguchan.earthmobsmod.handler.EarthFluids;
import baguchan.earthmobsmod.handler.EarthItems;
import baguchan.earthmobsmod.handler.EarthTags;
import net.minecraft.block.Block;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="earthmobsmod")
public class EarthMobsMod {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "earthmobsmod";
    public static EarthMobsMod instance;

    public EarthMobsMod() {
        instance = this;
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Block.class, this::onBlockRegistry);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Item.class, this::onItemRegistry);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(EntityType.class, this::onEntityRegistry);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Fluid.class, this::onFluidRegistry);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Feature.class, this::onFeatureRegistry);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(ClientRegistrar::setup));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
        EarthFeatures.addFeature();
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
    }

    private void processIMC(InterModProcessEvent event) {
    }

    private void doClientStuff(FMLClientSetupEvent event) {
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        World world = event.getEntityLiving().field_70170_p;
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity.func_210500_b(EarthTags.Fluids.MUD_WATER, 0.014)) {
            if (livingEntity.func_213322_ci().func_82617_b() < 0.0) {
                livingEntity.func_213317_d(livingEntity.func_213322_ci().func_216372_d((double)0.8f, 0.5, (double)0.8f));
            } else {
                livingEntity.func_213317_d(livingEntity.func_213322_ci().func_186678_a((double)0.9f));
            }
            if (livingEntity.field_70703_bu) {
                livingEntity.func_213317_d(livingEntity.func_213322_ci().func_72441_c(0.0, (double)0.08f * livingEntity.func_110148_a((Attribute)ForgeMod.SWIM_SPEED.get()).func_111126_e(), 0.0));
            }
            livingEntity.field_70143_R = 0.0f;
        }
        if (event.getEntityLiving().func_200600_R() == EntityType.field_200784_X && event.getEntityLiving().field_70173_aa % 5 == 0 && livingEntity.func_210500_b(EarthTags.Fluids.MUD_WATER, 0.014) && !world.func_201670_d()) {
            MuddyPigEntity pigEntity = (MuddyPigEntity)EarthEntitys.MUDDYPIG.func_200721_a(world);
            pigEntity.func_180432_n((Entity)event.getEntityLiving());
            pigEntity.func_94061_f(((PigEntity)livingEntity).func_175446_cd());
            if (livingEntity.func_145818_k_()) {
                pigEntity.func_200203_b(livingEntity.func_200201_e());
                pigEntity.func_174805_g(livingEntity.func_174833_aM());
            }
            if (((PigEntity)livingEntity).func_110257_ck()) {
                pigEntity.func_230264_L__();
            }
            if (livingEntity.func_70631_g_()) {
                pigEntity.func_70873_a(((PigEntity)livingEntity).func_70874_b());
            }
            pigEntity.setFlowerColor(DyeColor.func_196056_a((int)world.func_201674_k().nextInt(DyeColor.values().length)));
            pigEntity.setHasFlower(false);
            pigEntity.setDry(true);
            livingEntity.field_70170_p.func_73046_m().func_71218_a(livingEntity.func_130014_f_().func_234923_W_()).removeEntityComplete((Entity)livingEntity, false);
            livingEntity.field_70170_p.func_73046_m().func_71218_a(livingEntity.func_130014_f_().func_234923_W_()).func_217376_c((Entity)pigEntity);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onEntityRightClick(PlayerInteractEvent.EntityInteract event) {
        ItemStack stack = event.getItemStack();
        World world = event.getWorld();
        if (event.getTarget().func_200600_R() == EntityType.field_200796_j && !(event.getTarget() instanceof MooBloomEntity) && stack.func_77973_b() == Items.field_196100_at) {
            MooBloomEntity cowBloomEntity = (MooBloomEntity)EarthEntitys.MOOBLOOM.func_200721_a(world);
            cowBloomEntity.func_70012_b(event.getTarget().func_226277_ct_(), event.getTarget().func_226278_cu_(), event.getTarget().func_226281_cx_(), event.getTarget().field_70177_z, event.getTarget().field_70125_A);
            cowBloomEntity.func_94061_f(((AnimalEntity)event.getTarget()).func_175446_cd());
            if (event.getTarget().func_145818_k_()) {
                cowBloomEntity.func_200203_b(event.getTarget().func_200201_e());
                cowBloomEntity.func_174805_g(event.getTarget().func_174833_aM());
            }
            if (((AnimalEntity)event.getTarget()).func_70631_g_()) {
                cowBloomEntity.func_70873_a(((AnimalEntity)event.getTarget()).func_70874_b());
            }
            if (!event.getPlayer().func_184812_l_()) {
                stack.func_190918_g(1);
            }
            event.getWorld().func_217376_c((Entity)cowBloomEntity);
            event.getWorld().func_184133_a(null, cowBloomEntity.func_233580_cy_(), SoundEvents.field_187941_ho, SoundCategory.NEUTRAL, 1.5f, 1.0f);
            event.getTarget().func_70106_y();
        }
    }

    @SubscribeEvent
    public void onEntityJoin(EntityJoinWorldEvent event) {
        MobEntity livingEntity;
        World world = event.getWorld();
        if (!(event.getEntity() instanceof MobEntity) || (livingEntity = (MobEntity)event.getEntity()).func_70668_bt() != CreatureAttribute.field_223223_b_) {
            // empty if block
        }
        if (event.getEntity().func_200600_R() == EntityType.field_200784_X) {
            PigEntity pig = (PigEntity)event.getEntity();
            pig.field_70714_bg.func_75776_a(0, (Goal)new GoToMudGoal(pig, 1.0));
        }
    }

    public void onBlockRegistry(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        EarthBlocks.registerBlocks((IForgeRegistry<Block>)registry);
    }

    public void onItemRegistry(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        EarthBlocks.registerItemBlocks((IForgeRegistry<Item>)registry);
        EarthItems.registerItems((IForgeRegistry<Item>)registry);
    }

    public void onEntityRegistry(RegistryEvent.Register<EntityType<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        EarthEntitys.registerEntity(registry);
    }

    public void onFeatureRegistry(RegistryEvent.Register<Feature<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        EarthFeatures.register(registry);
    }

    public void onFluidRegistry(RegistryEvent.Register<Fluid> event) {
        IForgeRegistry registry = event.getRegistry();
        EarthFluids.register((IForgeRegistry<Fluid>)registry);
    }
}

