/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.entity;

import baguchan.earthmobsmod.entity.ai.EatGrassOrBloomGoal;
import baguchan.earthmobsmod.handler.EarthBlocks;
import baguchan.earthmobsmod.handler.EarthEntitys;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowerBlock;
import net.minecraft.block.GrassBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IShearable;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IForgeShearable;

public class MooBloomEntity
extends CowEntity
implements IShearable,
IForgeShearable {
    private static final Ingredient BREEDING_ITEMS = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151153_ao});
    private static final DataParameter<Boolean> SLEEP = EntityDataManager.func_187226_a(MooBloomEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private int grassEatTimer;
    private int eatDelayTimer;
    private EatGrassOrBloomGoal eatGrassGoal;

    public MooBloomEntity(EntityType<? extends MooBloomEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_184651_r() {
        this.eatGrassGoal = new EatGrassOrBloomGoal(this);
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new DoNothingGoal());
        this.field_70714_bg.func_75776_a(2, (Goal)new PanicGoal((CreatureEntity)this, 2.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new TemptGoal((CreatureEntity)this, 1.25, BREEDING_ITEMS, false));
        this.field_70714_bg.func_75776_a(5, (Goal)this.eatGrassGoal);
        this.field_70714_bg.func_75776_a(6, (Goal)new FollowParentGoal((AnimalEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, BeeEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    public static AttributeModifierMap.MutableAttribute createMutableAttribute() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 12.0).func_233815_a_(Attributes.field_233821_d_, 0.2);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SLEEP, (Object)false);
    }

    protected void func_70619_bc() {
        this.grassEatTimer = this.eatGrassGoal.getEatingGrassTimer();
        super.func_70619_bc();
        if (this.field_70122_E && this.field_70170_p.field_73012_v.nextInt(300) == 0 && !this.isSleep()) {
            FlowerBlock flowerBlock = EarthBlocks.BUTTERCUP;
            BlockPos blockpos = this.func_233580_cy_().func_177977_b();
            this.setEatDelayTimer(120);
            if (flowerBlock.func_196260_a(flowerBlock.func_176223_P(), (IWorldReader)this.field_70170_p, blockpos) && this.field_70170_p.func_175623_d(this.func_233580_cy_())) {
                this.field_70170_p.func_175656_a(this.func_233580_cy_(), flowerBlock.func_176223_P());
            }
        }
        if (this.eatDelayTimer > 0) {
            --this.eatDelayTimer;
        }
        if (this.field_70122_E && this.field_70170_p.field_73012_v.nextInt(160) == 0 && this.isSleep()) {
            BlockPos blockPos = this.func_233580_cy_();
            for (int i = 0; i < 2 + this.field_70146_Z.nextInt(6); ++i) {
                BlockPos pos = new BlockPos(blockPos.func_177958_n() + this.field_70146_Z.nextInt(12) - 6, blockPos.func_177956_o() + this.field_70146_Z.nextInt(6) - 3, blockPos.func_177952_p() + this.field_70146_Z.nextInt(12) - 6);
                BlockState blockstate = this.field_70170_p.func_180495_p(pos);
                if (!(blockstate.func_177230_c() instanceof IGrowable) || blockstate.func_177230_c() instanceof GrassBlock) continue;
                IGrowable igrowable = (IGrowable)blockstate.func_177230_c();
                if (this.field_70170_p.field_72995_K) continue;
                this.field_70170_p.func_217379_c(2005, pos, 0);
                if (this.field_70170_p.func_73046_m() == null || !igrowable.func_180670_a(this.field_70170_p, this.field_70170_p.field_73012_v, pos, blockstate)) continue;
                igrowable.func_225535_a_(this.field_70170_p.func_73046_m().func_71218_a(this.field_70170_p.func_234923_W_()), this.field_70170_p.field_73012_v, pos, blockstate);
            }
        }
        if (this.isSleep() && this.field_70170_p.func_72935_r() || this.isSleep() && this.func_70638_az() != null) {
            this.setSleep(false);
        }
        if (!this.isSleep() && !this.field_70170_p.func_72935_r() && this.func_70638_az() == null && this.field_70146_Z.nextInt(240) == 0) {
            this.setSleep(true);
        }
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            this.grassEatTimer = Math.max(0, this.grassEatTimer - 1);
        }
        this.func_82168_bl();
        super.func_70636_d();
    }

    public int getEatDelayTimer() {
        return this.eatDelayTimer;
    }

    public void setEatDelayTimer(int eatDelayTimer) {
        this.eatDelayTimer = eatDelayTimer;
    }

    protected SoundEvent func_184639_G() {
        if (!this.isSleep()) {
            return SoundEvents.field_187558_ak;
        }
        return null;
    }

    public static boolean spawnHandler(EntityType<? extends AnimalEntity> p_223316_0_, IWorld p_223316_1_, SpawnReason p_223316_2_, BlockPos p_223316_3_, Random p_223316_4_) {
        return p_223316_1_.func_180495_p(p_223316_3_.func_177977_b()).func_177230_c() == Blocks.field_196658_i && p_223316_1_.func_226659_b_(p_223316_3_, 0) > 8;
    }

    public ActionResultType func_184199_a(PlayerEntity player, Vector3d vec, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        if (item == Items.field_151054_z) {
            return ActionResultType.FAIL;
        }
        return super.func_184199_a(player, vec, hand);
    }

    public boolean func_230262_K__() {
        return true;
    }

    public boolean isShearable(ItemStack item, World world, BlockPos pos) {
        return true;
    }

    public void func_230263_a_(SoundCategory category) {
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.func_226277_ct_(), this.func_226278_cu_() + (double)(this.func_213302_cg() / 2.0f), this.func_226281_cx_(), 0.0, 0.0, 0.0);
        if (!this.field_70170_p.field_72995_K) {
            this.func_199701_a_(new ItemStack((IItemProvider)Item.func_150898_a((Block)EarthBlocks.BUTTERCUP), 3));
            CowEntity cowEntity = (CowEntity)EntityType.field_200796_j.func_200721_a(this.field_70170_p);
            cowEntity.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
            cowEntity.func_94061_f(this.func_175446_cd());
            if (this.func_145818_k_()) {
                cowEntity.func_200203_b(this.func_200201_e());
                cowEntity.func_174805_g(this.func_174833_aM());
            }
            if (this.func_70631_g_()) {
                cowEntity.func_70873_a(this.func_70874_b());
            }
            this.field_70170_p.func_217376_c((Entity)cowEntity);
            this.func_70106_y();
        }
        this.func_184185_a(SoundEvents.field_187763_eJ, 1.0f, 1.0f);
    }

    public List<ItemStack> onSheared(PlayerEntity player, ItemStack item, World world, BlockPos pos, int fortune) {
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.func_226277_ct_(), this.func_226278_cu_() + (double)(this.func_213302_cg() / 2.0f), this.func_226281_cx_(), 0.0, 0.0, 0.0);
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (!this.field_70170_p.field_72995_K) {
            ret.add(new ItemStack((IItemProvider)Item.func_150898_a((Block)EarthBlocks.BUTTERCUP), 3));
            CowEntity cowEntity = (CowEntity)EntityType.field_200796_j.func_200721_a(this.field_70170_p);
            cowEntity.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
            cowEntity.func_94061_f(this.func_175446_cd());
            if (this.func_145818_k_()) {
                cowEntity.func_200203_b(this.func_200201_e());
                cowEntity.func_174805_g(this.func_174833_aM());
            }
            if (this.func_70631_g_()) {
                cowEntity.func_70873_a(this.func_70874_b());
            }
            this.field_70170_p.func_217376_c((Entity)cowEntity);
            this.func_70106_y();
        }
        this.func_184185_a(SoundEvents.field_187763_eJ, 1.0f, 1.0f);
        return ret;
    }

    public boolean isSleep() {
        return (Boolean)this.field_70180_af.func_187225_a(SLEEP);
    }

    public void setSleep(boolean sleep) {
        this.field_70180_af.func_187227_b(SLEEP, (Object)sleep);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Sleep", this.isSleep());
        compound.func_74768_a("EatDelay", this.getEatDelayTimer());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setSleep(compound.func_74767_n("Sleep"));
        this.setEatDelayTimer(compound.func_74762_e("EatDelay"));
        this.func_70873_a(Math.max(0, this.func_70874_b()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.grassEatTimer = 40;
        } else {
            super.func_70103_a(id);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getHeadRotationPointY(float p_70894_1_) {
        if (this.grassEatTimer <= 0) {
            return 0.0f;
        }
        if (this.grassEatTimer >= 4 && this.grassEatTimer <= 36) {
            return 1.0f;
        }
        return this.grassEatTimer < 4 ? ((float)this.grassEatTimer - p_70894_1_) / 4.0f : -((float)(this.grassEatTimer - 40) - p_70894_1_) / 4.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getHeadRotationAngleX(float p_70890_1_) {
        if (this.grassEatTimer > 4 && this.grassEatTimer <= 36) {
            float f = ((float)(this.grassEatTimer - 4) - p_70890_1_) / 32.0f;
            return 0.62831855f + 0.21991149f * MathHelper.func_76126_a((float)(f * 28.7f));
        }
        return this.grassEatTimer > 0 ? 0.62831855f : this.field_70125_A * ((float)Math.PI / 180);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        this.setSleep(false);
        return super.func_70097_a(source, amount);
    }

    public boolean func_70877_b(ItemStack stack) {
        return BREEDING_ITEMS.test(stack);
    }

    protected ResourceLocation func_184647_J() {
        return EntityType.field_200796_j.func_220348_g();
    }

    public MooBloomEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity ageable) {
        return (MooBloomEntity)EarthEntitys.MOOBLOOM.func_200721_a(this.field_70170_p);
    }

    class DoNothingGoal
    extends Goal {
        public DoNothingGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public boolean func_75253_b() {
            return MooBloomEntity.this.isSleep();
        }

        public boolean func_75250_a() {
            return MooBloomEntity.this.isSleep();
        }

        public void func_75249_e() {
            MooBloomEntity.this.func_70637_d(false);
            MooBloomEntity.this.setSleep(true);
            MooBloomEntity.this.func_70605_aq().func_75642_a(MooBloomEntity.this.func_226277_ct_(), MooBloomEntity.this.func_226278_cu_(), MooBloomEntity.this.func_226281_cx_(), 0.0);
        }

        public void func_75246_d() {
            super.func_75246_d();
            MooBloomEntity.this.func_70661_as().func_75499_g();
        }
    }
}

