/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.event;

import baguchan.earthmobsmod.handler.EarthBlocks;
import baguchan.earthmobsmod.handler.EarthEntitys;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.BlockStateFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="earthmobsmod")
public class BiomeLoadHandler {
    public static final ConfiguredFeature<?, ?> LAKE_MUD = BiomeLoadHandler.register("earthmobsmod:mud_lake", Feature.field_202289_ai.func_225566_b_((IFeatureConfig)new BlockStateFeatureConfig(EarthBlocks.MUDWATER.func_176223_P())).func_227228_a_(Placement.field_215006_E.func_227446_a_((IPlacementConfig)new ChanceConfig(4))));

    private static <FC extends IFeatureConfig> ConfiguredFeature<FC, ?> register(String key, ConfiguredFeature<FC, ?> configuredFeature) {
        return (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)key, configuredFeature);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void loadingBiome(BiomeLoadingEvent event) {
        BiomeGenerationSettingsBuilder generation = event.getGeneration();
        if (event.getName().toString().contains("minecraft:flower_forest")) {
            event.getSpawns().getSpawner(EntityClassification.CREATURE).add(new MobSpawnInfo.Spawners(EarthEntitys.MOOBLOOM, 10, 2, 3));
        }
        if (event.getName().toString().contains("minecraft:mushroom_fields")) {
            event.getSpawns().getSpawner(EntityClassification.CREATURE).add(new MobSpawnInfo.Spawners(EarthEntitys.CLUCKSHROOM, 8, 2, 3));
        }
        if (event.getName().func_110624_b().toString().contains("minecraft") || event.getName().func_110624_b().toString().contains("biomesoplenty")) {
            if (event.getCategory() == Biome.Category.SWAMP) {
                event.getGeneration().func_242513_a(GenerationStage.Decoration.LAKES, LAKE_MUD);
            }
            if (event.getCategory() == Biome.Category.EXTREME_HILLS) {
                event.getSpawns().getSpawner(EntityClassification.CREATURE).add(new MobSpawnInfo.Spawners(EarthEntitys.HORNED_SHEEP, 6, 2, 3));
            }
        }
    }
}

