/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.fluid;

import baguchan.earthmobsmod.handler.EarthBlocks;
import baguchan.earthmobsmod.handler.EarthFluids;
import baguchan.earthmobsmod.handler.EarthItems;
import baguchan.earthmobsmod.handler.EarthTags;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.Item;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.Tag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidAttributes;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class FluidMudWater
extends FlowingFluid {
    public Fluid func_210197_e() {
        return EarthFluids.MUD_WATER_FLOW;
    }

    public Fluid func_210198_f() {
        return EarthFluids.MUD_WATER;
    }

    public Item func_204524_b() {
        return EarthItems.MUD_BUCKET;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_204522_a(World worldIn, BlockPos pos, FluidState state, Random random) {
    }

    protected void func_205580_a(IWorld worldIn, BlockPos pos, BlockState state) {
        TileEntity tileentity = state.func_177230_c().hasTileEntity(state) ? worldIn.func_175625_s(pos) : null;
        Block.func_220059_a((BlockState)state, (IWorld)worldIn, (BlockPos)pos, (TileEntity)tileentity);
    }

    public int func_185698_b(IWorldReader worldIn) {
        return 4;
    }

    public BlockState func_204527_a(FluidState state) {
        return (BlockState)EarthBlocks.MUDWATER.func_176223_P().func_206870_a((Property)FlowingFluidBlock.field_176367_b, (Comparable)Integer.valueOf(FluidMudWater.func_207205_e((FluidState)state)));
    }

    public boolean func_207187_a(Fluid fluidIn) {
        return fluidIn.func_207185_a(EarthTags.Fluids.MUD_WATER);
    }

    public int func_204528_b(IWorldReader worldIn) {
        return 2;
    }

    public int func_205569_a(IWorldReader p_205569_1_) {
        return 10;
    }

    protected float func_210195_d() {
        return 100.0f;
    }

    protected boolean func_205579_d() {
        return false;
    }

    protected void func_205574_a(IWorld worldIn, BlockPos pos, BlockState blockStateIn, Direction direction, FluidState fluidStateIn) {
        FluidState ifluidstate;
        if (direction == Direction.DOWN && (ifluidstate = worldIn.func_204610_c(pos)).func_206884_a((ITag)FluidTags.field_206960_b)) {
            worldIn.func_180501_a(pos, Blocks.field_150346_d.func_176223_P(), 3);
            worldIn.func_217379_c(1501, pos, 0);
            this.triggerEffects(worldIn, pos);
            return;
        }
        super.func_205574_a(worldIn, pos, blockStateIn, direction, fluidStateIn);
    }

    private void triggerEffects(IWorld p_205581_1_, BlockPos p_205581_2_) {
        p_205581_1_.func_217379_c(1501, p_205581_2_, 0);
    }

    protected boolean func_215665_a(FluidState p_215665_1_, IBlockReader p_215665_2_, BlockPos p_215665_3_, Fluid p_215665_4_, Direction p_215665_5_) {
        return p_215665_5_ == Direction.DOWN && !p_215665_4_.func_207185_a(EarthTags.Fluids.MUD_WATER);
    }

    public boolean isEntityInside(FluidState state, IWorldReader world, BlockPos pos, Entity entity, double yToTest, Tag<Fluid> tag, boolean testingHead) {
        if (testingHead && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.func_70050_g(this.decreaseAirSupply(livingEntity.func_70086_ai(), livingEntity));
            if (livingEntity.func_70086_ai() == -20) {
                livingEntity.func_70050_g(0);
                Vector3d vec3d = livingEntity.func_213322_ci();
                for (int i = 0; i < 8; ++i) {
                    float f = livingEntity.field_70170_p.field_73012_v.nextFloat() - livingEntity.field_70170_p.field_73012_v.nextFloat();
                    float f1 = livingEntity.field_70170_p.field_73012_v.nextFloat() - livingEntity.field_70170_p.field_73012_v.nextFloat();
                    float f2 = livingEntity.field_70170_p.field_73012_v.nextFloat() - livingEntity.field_70170_p.field_73012_v.nextFloat();
                    livingEntity.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, livingEntity.func_226277_ct_() + (double)f, livingEntity.func_226278_cu_() + (double)f1, livingEntity.func_226281_cx_() + (double)f2, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
                }
                livingEntity.func_70097_a(DamageSource.field_76369_e, 2.0f);
            }
        }
        return super.isEntityInside(state, world, pos, entity, yToTest, tag, testingHead);
    }

    protected int decreaseAirSupply(int air, LivingEntity livingEntity) {
        int i = EnchantmentHelper.func_185292_c((LivingEntity)livingEntity);
        return i > 0 && livingEntity.field_70170_p.field_73012_v.nextInt(i + 1) > 0 ? air : air - 1;
    }

    protected FluidAttributes createAttributes() {
        return FluidAttributes.builder((ResourceLocation)new ResourceLocation("earthmobsmod", "blocks/mud"), (ResourceLocation)new ResourceLocation("earthmobsmod", "blocks/flow_mud")).overlay(new ResourceLocation("earthmobsmod", "blocks/mud_overlay")).density(1100).viscosity(2000).build((Fluid)this);
    }

    public static class Source
    extends FluidMudWater {
        public int func_207192_d(FluidState p_207192_1_) {
            return 8;
        }

        public boolean func_207193_c(FluidState state) {
            return true;
        }
    }

    public static class Flowing
    extends FluidMudWater {
        protected void func_207184_a(StateContainer.Builder<Fluid, FluidState> builder) {
            super.func_207184_a(builder);
            builder.func_206894_a(new Property[]{field_207210_b});
        }

        public int func_207192_d(FluidState p_207192_1_) {
            return (Integer)p_207192_1_.func_177229_b((Property)field_207210_b);
        }

        public boolean func_207193_c(FluidState state) {
            return false;
        }
    }
}

