/*
 * Decompiled with CFR 0.152.
 */
package com.eractnod.ediblebugs.module.fryer;

import com.eractnod.ediblebugs.module.fryer.Fryer;
import com.eractnod.ediblebugs.module.fryer.FryerContainer;
import com.eractnod.ediblebugs.recipe.AllRecipes;
import com.eractnod.ediblebugs.recipe.FryerRecipe;
import com.eractnod.ediblebugs.setup.EdiblebugsSetup;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class FryerTile
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider,
ISidedInventory {
    private final Map<ResourceLocation, Integer> field_214022_n = Maps.newHashMap();
    private static final int[] slots_top = new int[]{0};
    private static final int[] slots_bottom = new int[]{2, 1};
    private static final int[] slots_sides = new int[]{1};
    private NonNullList<ItemStack> fryerItemStacks = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    public int cookTimeTotal;
    public int burnTime;
    public int cookTime;
    private String displayName;
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((ISidedInventory)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    public FryerTile() {
        super((TileEntityType)EdiblebugsSetup.FRYER_TILE.get());
    }

    public void func_73660_a() {
        boolean flag = this.isBurning();
        boolean flag1 = false;
        if (this.isBurning()) {
            --this.burnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            ItemStack itemstack = (ItemStack)this.fryerItemStacks.get(1);
            if (this.isBurning() || !itemstack.func_190926_b() && !((ItemStack)this.fryerItemStacks.get(0)).func_190926_b()) {
                IRecipe irecipe = this.field_145850_b.func_199532_z().func_215371_a(AllRecipes.Types.FRYING, (IInventory)this, this.field_145850_b).orElse(null);
                if (!this.isBurning() && this.canSmelt(irecipe)) {
                    this.burnTime = this.getBurnTime(itemstack);
                    this.cookTimeTotal = this.getCookedTime();
                    if (this.isBurning()) {
                        flag1 = true;
                        if (itemstack.hasContainerItem()) {
                            this.fryerItemStacks.set(1, (Object)itemstack.getContainerItem());
                        } else if (!itemstack.func_190926_b()) {
                            Item item = itemstack.func_77973_b();
                            itemstack.func_190918_g(1);
                            if (itemstack.func_190926_b()) {
                                this.fryerItemStacks.set(1, (Object)itemstack.getContainerItem());
                            }
                        }
                    }
                }
                if (this.isBurning() && this.canSmelt(irecipe)) {
                    ++this.cookTime;
                    if (this.cookTime == this.cookTimeTotal) {
                        this.cookTime = 0;
                        this.cookTimeTotal = this.getCookedTime();
                        this.smeltItem(irecipe);
                        flag1 = true;
                    }
                } else {
                    this.cookTime = 0;
                }
            } else if (!this.isBurning() && this.cookTime > 0) {
                this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.cookTimeTotal);
            }
            if (flag != this.isBurning()) {
                flag1 = true;
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)Fryer.LIT, (Comparable)Boolean.valueOf(this.isBurning())), 3);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    protected int getCookedTime() {
        return this.field_145850_b.func_199532_z().func_215371_a(AllRecipes.Types.FRYING, (IInventory)this, this.field_145850_b).map(FryerRecipe::getCookTime).orElse(200);
    }

    public boolean isBurning() {
        return this.burnTime > 0;
    }

    private boolean canSmelt(@Nullable IRecipe<?> recipeIn) {
        if (!((ItemStack)this.fryerItemStacks.get(0)).func_190926_b() && recipeIn != null) {
            ItemStack itemstack = recipeIn.func_77571_b();
            if (itemstack.func_190926_b()) {
                return false;
            }
            ItemStack itemstack1 = (ItemStack)this.fryerItemStacks.get(2);
            if (itemstack1.func_190926_b()) {
                return true;
            }
            if (!itemstack1.func_77969_a(itemstack)) {
                return false;
            }
            if (itemstack1.func_190916_E() + itemstack.func_190916_E() <= this.func_70297_j_() && itemstack1.func_190916_E() + itemstack.func_190916_E() <= itemstack1.func_77976_d()) {
                return true;
            }
            return itemstack1.func_190916_E() + itemstack.func_190916_E() <= itemstack.func_77976_d();
        }
        return false;
    }

    private void smeltItem(@Nullable IRecipe<?> recipe) {
        if (recipe != null && this.canSmelt(recipe)) {
            ItemStack itemstack = (ItemStack)this.fryerItemStacks.get(0);
            ItemStack itemstack1 = recipe.func_77571_b();
            ItemStack itemstack2 = (ItemStack)this.fryerItemStacks.get(2);
            if (itemstack2.func_190926_b()) {
                this.fryerItemStacks.set(2, (Object)itemstack1.func_77946_l());
            } else if (itemstack2.func_77973_b() == itemstack1.func_77973_b()) {
                itemstack2.func_190917_f(itemstack1.func_190916_E());
            }
            if (!this.field_145850_b.field_72995_K) {
                this.setRecipeUsed(recipe);
            }
            if (itemstack.func_77973_b() == Blocks.field_196577_ad.func_199767_j() && !((ItemStack)this.fryerItemStacks.get(1)).func_190926_b() && ((ItemStack)this.fryerItemStacks.get(1)).func_77973_b() == Items.field_151133_ar) {
                this.fryerItemStacks.set(1, (Object)new ItemStack((IItemProvider)Items.field_151131_as));
            }
            itemstack.func_190918_g(1);
        }
    }

    public void setRecipeUsed(@Nullable IRecipe<?> recipe) {
        if (recipe != null) {
            this.field_214022_n.compute(recipe.func_199560_c(), (p_214004_0_, p_214004_1_) -> 1 + (p_214004_1_ == null ? 0 : p_214004_1_));
        }
    }

    protected int getBurnTime(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        Item item = stack.func_77973_b();
        return ForgeHooks.getBurnTime((ItemStack)stack);
    }

    public static boolean isFuel(ItemStack stack) {
        return ForgeHooks.getBurnTime((ItemStack)stack) > 0;
    }

    public void setFurnaceCookTime(int value) {
        this.cookTime = value;
    }

    public void setFurnaceCookTimeTotal(int value) {
        this.cookTimeTotal = value;
    }

    public void setFurnaceBurnTime(int value) {
        this.burnTime = value;
    }

    public void func_230337_a_(BlockState p_230337_1_, CompoundNBT tag) {
        super.func_230337_a_(p_230337_1_, tag);
        this.fryerItemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)tag, this.fryerItemStacks);
        this.burnTime = tag.func_74762_e("BurnTime");
        this.cookTime = tag.func_74762_e("CookTime");
        this.cookTimeTotal = tag.func_74762_e("CookTimeTotal");
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_74768_a("BurnTime", this.burnTime);
        tag.func_74768_a("CookTime", this.cookTime);
        tag.func_74768_a("CookTimeTotal", this.cookTimeTotal);
        ItemStackHelper.func_191282_a((CompoundNBT)tag, this.fryerItemStacks);
        return super.func_189515_b(tag);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.field_145846_f && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new FryerContainer(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    public int func_70302_i_() {
        return this.fryerItemStacks.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.fryerItemStacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.fryerItemStacks.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.fryerItemStacks, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.fryerItemStacks, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.fryerItemStacks.get(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.fryerItemStacks.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !flag) {
            this.cookTimeTotal = this.getCookedTime();
            this.cookTime = 0;
            this.func_70296_d();
        }
    }

    public boolean func_70300_a(PlayerEntity player) {
        return this.field_145850_b.func_175625_s(new BlockPos((Vector3i)this.field_174879_c)) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174888_l() {
    }

    public int[] func_180463_a(Direction side) {
        return side == Direction.DOWN ? slots_bottom : (side == Direction.UP ? slots_top : slots_sides);
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index == 2 ? false : (index == 1 ? FryerTile.isFuel(stack) : true);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return direction != Direction.DOWN || index != 1 || stack.func_77973_b() == Items.field_151133_ar;
    }
}

