/*
 * Decompiled with CFR 0.152.
 */
package com.eractnod.ediblebugs.recipe;

import com.eractnod.ediblebugs.recipe.AllRecipes;
import com.eractnod.ediblebugs.recipe.StochasticOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public abstract class ProcessingRecipe<T extends IInventory>
implements IRecipe<T> {
    protected final List<Ingredient> ingredients;
    private final List<StochasticOutput> results;
    private final IRecipeType<?> type;
    private final IRecipeSerializer<?> serializer;
    protected final ResourceLocation id;
    protected final String group;
    protected final int processingDuration;

    public ProcessingRecipe(AllRecipes recipeType, ResourceLocation id, String group, List<Ingredient> ingredients, List<StochasticOutput> results, int processingDuration) {
        this.type = recipeType.type;
        this.serializer = recipeType.serializer;
        this.id = id;
        this.group = group;
        this.ingredients = ingredients;
        this.results = results;
        this.processingDuration = processingDuration;
    }

    public NonNullList<Ingredient> func_192400_c() {
        NonNullList nonnulllist = NonNullList.func_191196_a();
        nonnulllist.addAll(this.ingredients);
        return nonnulllist;
    }

    public int getProcessingDuration() {
        return this.processingDuration;
    }

    public List<ItemStack> rollResults() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (StochasticOutput output : this.getRollableResults()) {
            ItemStack stack = output.rollOutput();
            if (stack.func_190926_b()) continue;
            stacks.add(stack);
        }
        return stacks;
    }

    public ItemStack func_77572_b(T inv) {
        return this.func_77571_b();
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return this.getRollableResults().isEmpty() ? ItemStack.field_190927_a : this.getRollableResults().get(0).getStack();
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return this.serializer;
    }

    public String func_193358_e() {
        return this.group;
    }

    public IRecipeType<?> func_222127_g() {
        return this.type;
    }

    public List<StochasticOutput> getRollableResults() {
        return this.results;
    }

    public List<ItemStack> getPossibleOutputs() {
        return this.getRollableResults().stream().map(output -> output.getStack()).collect(Collectors.toList());
    }
}

