/*
 * Decompiled with CFR 0.152.
 */
package com.eractnod.ediblebugs.recipe;

import com.eractnod.ediblebugs.recipe.ProcessingRecipe;
import com.eractnod.ediblebugs.recipe.StochasticOutput;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ProcessingRecipeSerializer<T extends ProcessingRecipe<?>>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<T> {
    protected final IRecipeFactory<T> factory;

    public ProcessingRecipeSerializer(IRecipeFactory<T> factory) {
        this.factory = factory;
    }

    public T read(ResourceLocation recipeId, JsonObject json) {
        String s = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
        ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
        for (Object e : JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients")) {
            ingredients.add(Ingredient.func_199802_a((JsonElement)e));
        }
        ArrayList<StochasticOutput> results = new ArrayList<StochasticOutput>();
        for (JsonElement e : JSONUtils.func_151214_t((JsonObject)json, (String)"results")) {
            String s1 = JSONUtils.func_151206_a((JsonElement)e.getAsJsonObject().get("item"), (String)"item");
            int i = JSONUtils.func_151215_f((JsonElement)e.getAsJsonObject().get("count"), (String)"count");
            float chance = 1.0f;
            if (JSONUtils.func_151204_g((JsonObject)((JsonObject)e), (String)"chance")) {
                chance = JSONUtils.func_151220_d((JsonElement)e.getAsJsonObject().get("chance"), (String)"chance");
            }
            ItemStack itemstack = new ItemStack((IItemProvider)Registry.field_212630_s.func_82594_a(new ResourceLocation(s1)), i);
            results.add(new StochasticOutput(itemstack, chance));
        }
        int duration = JSONUtils.func_151203_m((JsonObject)json, (String)"processingTime");
        return this.factory.create(recipeId, s, ingredients, results, duration);
    }

    public T read(ResourceLocation recipeId, PacketBuffer buffer) {
        String s = buffer.func_150789_c(Short.MAX_VALUE);
        ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
        int ingredientCount = buffer.readInt();
        for (int i = 0; i < ingredientCount; ++i) {
            ingredients.add(Ingredient.func_199566_b((PacketBuffer)buffer));
        }
        ArrayList<StochasticOutput> results = new ArrayList<StochasticOutput>();
        int outputCount = buffer.readInt();
        for (int i = 0; i < outputCount; ++i) {
            results.add(StochasticOutput.read(buffer));
        }
        int duration = buffer.readInt();
        return this.factory.create(recipeId, s, ingredients, results, duration);
    }

    public void write(PacketBuffer buffer, T recipe) {
        buffer.func_180714_a(((ProcessingRecipe)recipe).group);
        buffer.writeInt(((ProcessingRecipe)recipe).ingredients.size());
        ((ProcessingRecipe)recipe).ingredients.forEach(i -> i.func_199564_a(buffer));
        buffer.writeInt(((ProcessingRecipe)recipe).getRollableResults().size());
        ((ProcessingRecipe)recipe).getRollableResults().forEach(i -> i.write(buffer));
        buffer.writeInt(((ProcessingRecipe)recipe).processingDuration);
    }

    public static interface IRecipeFactory<T extends ProcessingRecipe<?>> {
        public T create(ResourceLocation var1, String var2, List<Ingredient> var3, List<StochasticOutput> var4, int var5);
    }
}

