/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.packet.PacketSyncSettings;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.MagicDamage;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.tuple.Pair;

public final class Settings {
    public static final String GAMEPLAY_CATEGORY = "gameplay";
    public static final String DIFFICULTY_CATEGORY = "difficulty";
    public static final String TWEAKS_CATEGORY = "tweaks";
    public static final String SPELLS_CATEGORY = "spells";
    public static final String ARTEFACTS_CATEGORY = "artefacts";
    public static final String RESISTANCES_CATEGORY = "resistances";
    public static final String CLIENT_CATEGORY = "client";
    public static final String COMMANDS_CATEGORY = "commands";
    public static final String WORLDGEN_CATEGORY = "worldgen";
    public static final String COMPATIBILITY_CATEGORY = "compatibility";
    private static final String[] DEFAULT_TREE_BLOCKS = new String[]{"dynamictrees:oakbranch", "dynamictrees:sprucebranch", "dynamictrees:birchbranch", "dynamictrees:junglebranch", "dynamictrees:darkoakbranch", "dynamictrees:acaciabranch", "dynamictrees:cactusbranch", "dynamictrees:leaves0", "dynamictrees:leaves1"};
    private static final String[] DEFAULT_LOOT_INJECTION_LOCATIONS = new String[]{"minecraft:chests/simple_dungeon", "minecraft:chests/abandoned_mineshaft", "minecraft:chests/desert_pyramid", "minecraft:chests/jungle_temple", "minecraft:chests/stronghold_corridor", "minecraft:chests/stronghold_crossing", "minecraft:chests/stronghold_library", "minecraft:chests/igloo_chest", "minecraft:chests/woodland_mansion", "minecraft:chests/end_city_treasure"};
    private Configuration config;
    public boolean fastWorldgen = false;
    public int[] towerDimensions = new int[]{0};
    public int towerRarity = 700;
    public ResourceLocation[] towerFiles = new ResourceLocation[]{new ResourceLocation("ebwizardry", "wizard_tower_0"), new ResourceLocation("ebwizardry", "wizard_tower_1"), new ResourceLocation("ebwizardry", "wizard_tower_2"), new ResourceLocation("ebwizardry", "wizard_tower_3")};
    public ResourceLocation[] towerWithChestFiles = new ResourceLocation[]{new ResourceLocation("ebwizardry", "wizard_tower_chest_0"), new ResourceLocation("ebwizardry", "wizard_tower_chest_1"), new ResourceLocation("ebwizardry", "wizard_tower_chest_2"), new ResourceLocation("ebwizardry", "wizard_tower_chest_3")};
    public int[] obeliskDimensions = new int[]{0, -1};
    public int obeliskRarity = 600;
    public ResourceLocation[] obeliskFiles = new ResourceLocation[]{new ResourceLocation("ebwizardry", "obelisk_0"), new ResourceLocation("ebwizardry", "obelisk_1"), new ResourceLocation("ebwizardry", "obelisk_2"), new ResourceLocation("ebwizardry", "obelisk_3"), new ResourceLocation("ebwizardry", "obelisk_4")};
    public int[] shrineDimensions = new int[]{0, -1};
    public int shrineRarity = 1100;
    public ResourceLocation[] shrineFiles = new ResourceLocation[]{new ResourceLocation("ebwizardry", "shrine_0"), new ResourceLocation("ebwizardry", "shrine_1"), new ResourceLocation("ebwizardry", "shrine_2"), new ResourceLocation("ebwizardry", "shrine_3"), new ResourceLocation("ebwizardry", "shrine_4"), new ResourceLocation("ebwizardry", "shrine_5"), new ResourceLocation("ebwizardry", "shrine_6"), new ResourceLocation("ebwizardry", "shrine_7")};
    public int[] libraryDimensions = new int[]{0};
    public int libraryRarity = 900;
    public ResourceLocation[] libraryFiles = new ResourceLocation[]{new ResourceLocation("ebwizardry", "library_ruins_0"), new ResourceLocation("ebwizardry", "library_ruins_1"), new ResourceLocation("ebwizardry", "library_ruins_2"), new ResourceLocation("ebwizardry", "library_ruins_3")};
    public ResourceLocation[] undergroundLibraryFiles = new ResourceLocation[]{new ResourceLocation("ebwizardry", "underground_library_ruins_0"), new ResourceLocation("ebwizardry", "underground_library_ruins_1"), new ResourceLocation("ebwizardry", "underground_library_ruins_2"), new ResourceLocation("ebwizardry", "underground_library_ruins_3")};
    public Pair<ResourceLocation, Short>[] treeBlocks = Settings.parseItemMetaStrings(DEFAULT_TREE_BLOCKS);
    public double evilWizardChance = 0.2;
    public int[] oreDimensions = new int[]{0};
    public int[] flowerDimensions = new int[]{0};
    public ResourceLocation[] lootInjectionLocations = Settings.toResourceLocations(DEFAULT_LOOT_INJECTION_LOCATIONS);
    public ResourceLocation[] mobLootTableWhitelist = new ResourceLocation[0];
    public ResourceLocation[] mobLootTableBlacklist = Settings.toResourceLocations("entities/vex", "entities/ender_dragon", "entities/wither", "entities/silverfish", "entities/endermite", "ebwizardryentities/evil_wizard");
    public boolean teleportThroughUnbreakableBlocks = false;
    public AllyDesignationSystem.FriendlyFire friendlyFire = AllyDesignationSystem.FriendlyFire.ALL;
    public boolean telekineticDisarmament = true;
    public boolean minionRevengeTargeting = true;
    public boolean worldTimeManipulation = true;
    public boolean playersMoveEachOther = true;
    public boolean playerBlockDamage = true;
    public boolean dispenserBlockDamage = true;
    public boolean legacyWandLevelling = false;
    public boolean blindnessTweak = true;
    public boolean bonemealGrowsCrystalFlowers = true;
    public ResourceLocation[] summonedCreatureTargetsWhitelist = new ResourceLocation[0];
    public ResourceLocation[] summonedCreatureTargetsBlacklist = Settings.toResourceLocations("creeper");
    public ResourceLocation[] mindControlTargetsBlacklist = new ResourceLocation[0];
    public Pair<ResourceLocation, Short>[] pocketFurnaceItemBlacklist = Settings.parseItemMetaStrings("cobblestone", "netherrack");
    public Pair<ResourceLocation, Short>[] divinationOreWhitelist = Settings.parseItemMetaStrings(new String[0]);
    public Pair<ResourceLocation, Short>[] swordItemWhitelist = Settings.parseItemMetaStrings(new String[0]);
    public Pair<ResourceLocation, Short>[] bowItemWhitelist = Settings.parseItemMetaStrings(new String[0]);
    public Map<Pair<ResourceLocation, Short>, Integer> currencyItems = new HashMap<Pair<ResourceLocation, Short>, Integer>();
    public double playerDamageScale = 1.0;
    public double npcDamageScale = 1.0;
    public int[] mobSpawnDimensions = new int[]{0};
    public int evilWizardSpawnRate = 3;
    public int iceWraithSpawnRate = 3;
    public int lightningWraithSpawnRate = 1;
    public ResourceLocation[] mobSpawnBiomeBlacklist = Settings.toResourceLocations("mushroom_island", "mushroom_island_shore");
    public double maxSpellCommandMultiplier = 20.0;
    public String castCommandName = "cast";
    public String discoverspellCommandName = "discoverspell";
    public String allyCommandName = "ally";
    public String alliesCommandName = "allies";
    public String[] damageSourceBlacklist = new String[0];
    public boolean compatibilityWarnings = true;
    public boolean baublesIntegration = true;
    public boolean jeiIntegration = true;
    public boolean antiqueAtlasIntegration = true;
    public boolean autoTowerMarkers = true;
    public boolean autoObeliskMarkers = true;
    public boolean autoShrineMarkers = true;
    public boolean autoLibraryMarkers = true;
    public boolean autoUndergroundLibraryMarkers = false;
    public boolean discoveryMode = true;
    public boolean creativeBypassesArcaneLock = true;
    public boolean slowTimeAffectsPlayers = true;
    public boolean passiveMobsAreAllies = false;
    public boolean replaceVanillaFireballs = true;
    public boolean replaceVanillaFallDamage = true;
    public double forfeitChance = 0.2;
    public int[] progressionRequirements = new int[]{1500, 3500, 6000};
    public int bookshelfSearchRadius = 4;
    public Pair<ResourceLocation, Short>[] bookshelfBlocks = Settings.parseItemMetaStrings("ebwizardry:oak_bookshelf", "ebwizardry:spruce_bookshelf", "ebwizardry:birch_bookshelf", "ebwizardry:jungle_bookshelf", "ebwizardry:acacia_bookshelf", "ebwizardry:dark_oak_bookshelf");
    public Pair<ResourceLocation, Short>[] bookItems = Settings.parseItemMetaStrings(new String[0]);
    public Element donationPerkElement = Element.MAGIC;
    public boolean shiftScrolling = true;
    public boolean reverseScrollDirection = false;
    public boolean summonedCreatureNames = true;
    public boolean handbookProgression = true;
    public boolean booksPauseGame = true;
    public boolean useShaders = true;
    public boolean screenShake = true;
    public boolean blinkEffect = true;
    public boolean spellcastingAnimations = true;
    public boolean showSpellHUD = true;
    public boolean showChargeMeter = true;
    public GuiPosition spellHUDPosition = GuiPosition.BOTTOM_LEFT;
    public static final String DEFAULT_HUD_SKIN_KEY = "default";
    public String spellHUDSkin = "default";

    void initConfig(FMLPreInitializationEvent event) {
        this.config = new Configuration(new File(Wizardry.configDirectory, "ebwizardry.cfg"));
        this.config.load();
        Wizardry.logger.info("Setting up main config");
        this.setupGameplayConfig();
        this.setupDifficultyConfig();
        this.setupWorldgenConfig();
        this.setupTweaksConfig();
        if (event.getSide() == Side.CLIENT) {
            this.setupClientConfig();
        }
        this.setupCommandsConfig();
        this.setupCompatibilityConfig();
        this.config.save();
    }

    void initConfigExtras() {
        Wizardry.logger.info("Setting up spells config for " + Spell.getTotalSpellCount() + " spells");
        this.setupSpellsConfig();
        Wizardry.logger.info("Setting up artefacts config");
        this.setupArtefactsConfig();
        Wizardry.logger.info("Setting up resistances config");
        this.setupResistancesConfig();
        this.config.save();
    }

    void saveConfigChanges() {
        Wizardry.logger.info("Saving in-game config changes");
        this.setupGameplayConfig();
        this.setupDifficultyConfig();
        this.setupWorldgenConfig();
        this.setupTweaksConfig();
        this.setupClientConfig();
        this.setupCommandsConfig();
        this.setupCompatibilityConfig();
        this.setupSpellsConfig();
        this.setupArtefactsConfig();
        this.setupResistancesConfig();
        this.config.save();
    }

    public void sync(EntityPlayerMP player) {
        Wizardry.logger.info("Synchronising config settings for " + player.func_70005_c_());
        PacketSyncSettings.Message message = new PacketSyncSettings.Message(this);
        WizardryPacketHandler.net.sendTo((IMessage)message, player);
    }

    public ConfigCategory getConfigCategory(String name) {
        return this.config.getCategory(name);
    }

    private void setupSpellsConfig() {
        this.config.addCustomCategoryComment(SPELLS_CATEGORY, "Set a spell to false to disable it. Disabled spells will still have their associated spell book (mainly so the spell books don't all change) and can still be bound to wands, but cannot be cast in game, will not appear in any subsequently generated chests or wizard trades and will not drop from mobs. Disable a spell if it is causing problems, conflicts with another mod or creates an unintended exploit.");
        for (Spell spell : Spell.getAllSpells()) {
            Property property = this.config.get(SPELLS_CATEGORY, spell.getRegistryName().toString(), true, "Set to false to disable this spell");
            property.setLanguageKey("spell." + spell.getUnlocalisedName());
            Wizardry.proxy.setToNamedBooleanEntry(property);
            spell.setEnabled(property.getBoolean(true));
        }
    }

    private void setupArtefactsConfig() {
        this.config.addCustomCategoryComment(ARTEFACTS_CATEGORY, "Set an item to false to disable it. Disabled items will still appear in-game but will have no effect when worn. It is also advisable to remove disabled items from wizardry's (and addons') loot tables. Disable an item if it is causing problems, conflicts with another mod or creates an unintended exploit.");
        for (Item item : Item.field_150901_e) {
            if (!(item instanceof ItemArtefact)) continue;
            Property property = this.config.get(ARTEFACTS_CATEGORY, item.getRegistryName().toString(), true, "Set to false to disable this item");
            property.setLanguageKey(item.func_77658_a() + ".name");
            Wizardry.proxy.setToNamedBooleanEntry(property);
            ((ItemArtefact)item).setEnabled(property.getBoolean());
        }
    }

    private void setupGameplayConfig() {
        ArrayList<String> propOrder = new ArrayList<String>();
        this.config.addCustomCategoryComment(GAMEPLAY_CATEGORY, "Global settings that affect game mechanics. In multiplayer, the server/LAN host settings will apply. Please note that changing some of these settings may make the mod very difficult to play.");
        Property property = this.config.get(GAMEPLAY_CATEGORY, "playerBlockDamage", true, "Whether spells cast by players can destroy blocks in the world. Wizardry makes every attempt to respect protection mods and plugins, but cannot guarantee it will work in all cases for every mod. If you need absolutely watertight anti-grief, disable this setting. (N.B. This setting only affects players. To prevent mobs from destroying blocks with magic, use the mobGriefing gamerule.)");
        property.setLanguageKey("config.ebwizardry.player_block_damage");
        Wizardry.proxy.setToNamedBooleanEntry(property);
        this.playerBlockDamage = property.getBoolean();
        propOrder.add(property.getName());
        property = this.config.get(GAMEPLAY_CATEGORY, "dispenserBlockDamage", true, "Whether spells cast by dispensers can destroy blocks in the world. Wizardry makes every attempt to respect protection mods and plugins, but cannot guarantee it will work in all cases for every mod. If you need absolutely watertight anti-grief, disable this setting.");
        property.setLanguageKey("config.ebwizardry.dispenser_block_damage");
        Wizardry.proxy.setToNamedBooleanEntry(property);
        this.dispenserBlockDamage = property.getBoolean();
        propOrder.add(property.getName());
        property = this.config.get(GAMEPLAY_CATEGORY, "playersMoveEachOther", true, "Whether to allow players to move other players around using magic.");
        property.setLanguageKey("config.ebwizardry.players_move_each_other");
        Wizardry.proxy.setToNamedBooleanEntry(property);
        this.playersMoveEachOther = property.getBoolean();
        propOrder.add(property.getName());
        property = this.config.get(GAMEPLAY_CATEGORY, "telekineticDisarmament", true, "Whether to allow players to disarm other players using the telekinesis spell. Set to false to prevent stealing of items.");
        property.setLanguageKey("config.ebwizardry.telekinetic_disarmament");
        Wizardry.proxy.setToNamedBooleanEntry(property);
        this.telekineticDisarmament = property.getBoolean();
        propOrder.add(property.getName());
        property = this.config.get(GAMEPLAY_CATEGORY, "teleportThroughUnbreakableBlocks", false, "Whether players are allowed to teleport through unbreakable blocks (e.g. bedrock) using the phase step spell.");
        property.setLanguageKey("config.ebwizardry.teleport_through_unbreakable_blocks");
        Wizardry.proxy.setToNamedBooleanEntry(property);
        this.teleportThroughUnbreakableBlocks = property.getBoolean();
        propOrder.add(property.getName());
        property = this.config.get(GAMEPLAY_CATEGORY, "worldTimeManipulation", true, "Whether players are allowed to change the world time with the speed time spell. If this is false, the speed time spell will not change the world time but will still speed up nearby block, entity and tile entity ticks.");
        property.setLanguageKey("config.ebwizardry.world_time_manipulation");
        Wizardry.proxy.setToNamedBooleanEntry(property);
        this.worldTimeManipulation = property.getBoolean();
        propOrder.add(property.getName());
        property = this.config.get(GAMEPLAY_CATEGORY, "slowTimeAffectsPlayers", true, "Whether players are slowed when another nearby player uses the slow time spell. If this is false, mobs and projectiles will still be affected but players will move at normal speed.");
        property.setLanguageKey("config.ebwizardry.slow_time_affects_players");
        Wizardry.proxy.setToNamedBooleanEntry(property);
        property.setRequiresWorldRestart(true);
        this.slowTimeAffectsPlayers = property.getBoolean();
        propOrder.add(property.getName());
        property = this.config.get(GAMEPLAY_CATEGORY, "creativeBypassesArcaneLock", true, "Whether any player in creative mode can bypass arcane-locked blocks. If this is false, players must also be op in order to do so.");
        property.setLanguageKey("config.ebwizardry.creative_bypasses_arcane_lock");
        Wizardry.proxy.setToNamedBooleanEntry(property);
        property.setRequiresWorldRestart(true);
        this.creativeBypassesArcaneLock = property.getBoolean();
        propOrder.add(property.getName());
        property = this.config.get(GAMEPLAY_CATEGORY, "bonemealGrowsCrystalFlowers", true, "Whether using bonemeal on grass blocks has a chance to grow crystal flowers.");
        property.setLanguageKey("config.ebwizardry.bonemeal_grows_crystal_flowers");
        Wizardry.proxy.setToNamedBooleanEntry(property);
        this.bonemealGrowsCrystalFlowers = property.getBoolean();
        propOrder.add(property.getName());
        this.config.setCategoryPropertyOrder(GAMEPLAY_CATEGORY, propOrder);
    }

    private void setupDifficultyConfig() {
        ArrayList<String> propOrder = new ArrayList<String>();
        this.config.addCustomCategoryComment(DIFFICULTY_CATEGORY, "Settings that affect the mod's difficulty. In multiplayer, the server/LAN host settings will apply.");
        Property property = this.config.get(DIFFICULTY_CATEGORY, "discoveryMode", true, "For those who like a sense of mystery! When set to true, spells you haven't cast yet will be unreadable until you cast them (on a per-world basis). Has no effect when in creative mode. Spells of identification will be unobtainable in survival mode if this is false.");
        property.setLanguageKey("config.ebwizardry.discovery_mode");
        Wizardry.proxy.setToNamedBooleanEntry(property);
        property.setRequiresWorldRestart(true);
        this.discoveryMode = property.getBoolean();
        propOrder.add(property.getName());
        property = this.config.get(DIFFICULTY_CATEGORY, "legacyWandLevelling", false, "Controls whether wands are required to gain progression before they can be upgraded to the next tier. Enable this option to revert to the pre-4.2 system, which only requires tomes of arcana. Wands will still gain progression even when this is enabled, so if you go back to the new system you won't lose any progress.");
        property.setLanguageKey("config.ebwizardry.legacy_wand_levelling");
        Wizardry.proxy.setToNamedBooleanEntry(property);
        this.legacyWandLevelling = property.getBoolean();
        propOrder.add(property.getName());
        property = this.config.get(DIFFICULTY_CATEGORY, "friendlyFire", AllyDesignationSystem.FriendlyFire.ALL.name, "Controls which creatures may be damaged by your magic when allied to you. Your spells will not target your allies or creatures summoned/owned by them regardless of this setting, but this setting prevents all magic damage to allies.", AllyDesignationSystem.FriendlyFire.names);
        property.setLanguageKey("config.ebwizardry.friendly_fire");
        this.friendlyFire = AllyDesignationSystem.FriendlyFire.fromName(property.getString());
        propOrder.add(property.getName());
        property = this.config.get(DIFFICULTY_CATEGORY, "passiveMobsAreAllies", false, "Whether passive mobs should count as allies, i.e. they should not be damaged indirectly by spells.");
        property.setLanguageKey("config.ebwizardry.passive_mobs_are_allies");
        Wizardry.proxy.setToNamedBooleanEntry(property);
        property.setRequiresWorldRestart(true);
        this.passiveMobsAreAllies = property.getBoolean();
        propOrder.add(property.getName());
        property = this.config.get(DIFFICULTY_CATEGORY, "minionRevengeTargeting", true, "Whether summoned creatures can revenge attack their owner if their owner attacks them.");
        property.setLanguageKey("config.ebwizardry.minion_revenge_targeting");
        Wizardry.proxy.setToNamedBooleanEntry(property);
        property.setRequiresWorldRestart(false);
        this.minionRevengeTargeting = property.getBoolean();
        propOrder.add(property.getName());
        property = this.config.get(DIFFICULTY_CATEGORY, "forfeitChance", 0.2, "The chance to 'misread' an undiscovered spell and trigger a forfeit instead. Setting this to 0 effectively disables the forfeit mechanic. Has no effect if discovery mode is disabled.", 0.0, 1.0);
        property.setLanguageKey("config.ebwizardry.forfeit_chance");
        Wizardry.proxy.setToNumberSliderEntry(property);
        property.setRequiresWorldRestart(true);
        this.forfeitChance = property.getDouble();
        propOrder.add(property.getName());
        property = this.config.get(DIFFICULTY_CATEGORY, "progressionRequirements", new int[]{1500, 3500, 6000}, "The amount of progression required to upgrade a wand to each tier (apprentice, advanced and master respectively).");
        property.setLanguageKey("config.ebwizardry.progression_requirements");
        property.setRequiresWorldRestart(true);
        this.progressionRequirements = property.getIntList();
        propOrder.add(property.getName());
        property = this.config.get(DIFFICULTY_CATEGORY, "playerDamageScaling", 1.0, "Global damage scaling factor for the damage dealt by players casting spells, relative to 1.", 0.0, 255.0);
        property.setLanguageKey("config.ebwizardry.player_damage_scaling");
        this.playerDamageScale = property.getDouble();
        propOrder.add(property.getName());
        property = this.config.get(DIFFICULTY_CATEGORY, "npcDamageScaling", 1.0, "Global damage scaling factor for the damage dealt by NPCs casting spells, relative to 1.", 0.0, 255.0);
        property.setLanguageKey("config.ebwizardry.npc_damage_scaling");
        this.npcDamageScale = property.getDouble();
        propOrder.add(property.getName());
        property = this.config.get(DIFFICULTY_CATEGORY, "evilWizardSpawnRate", 3, "Spawn rate for naturally-spawned evil wizards; higher numbers mean more evil wizards will spawn. 5 is equivalent to witches, 100 is equivalent to zombies, skeletons and creepers. Set to 0 to disable evil wizard spawning entirely.", 0, 100);
        property.setLanguageKey("config.ebwizardry.evil_wizard_spawn_rate");
        Wizardry.proxy.setToNumberSliderEntry(property);
        property.setRequiresMcRestart(true);
        this.evilWizardSpawnRate = property.getInt();
        propOrder.add(property.getName());
        property = this.config.get(DIFFICULTY_CATEGORY, "iceWraithSpawnRate", 3, "Spawn rate for naturally-spawned ice wraiths; higher numbers mean more ice wraiths will spawn. 5 is equivalent to witches, 100 is equivalent to zombies, skeletons and creepers. Set to 0 to disable ice wraith spawning entirely.", 0, 100);
        property.setLanguageKey("config.ebwizardry.ice_wraith_spawn_rate");
        Wizardry.proxy.setToNumberSliderEntry(property);
        property.setRequiresMcRestart(true);
        this.iceWraithSpawnRate = property.getInt();
        propOrder.add(property.getName());
        property = this.config.get(DIFFICULTY_CATEGORY, "lightningWraithSpawnRate", 1, "Spawn rate for naturally-spawned lightning wraiths; higher numbers mean more lightning wraiths will spawn. 5 is equivalent to witches, 100 is equivalent to zombies, skeletons and creepers. Set to 0 to disable lightning wraith spawning entirely.", 0, 100);
        property.setLanguageKey("config.ebwizardry.lightning_wraith_spawn_rate");
        Wizardry.proxy.setToNumberSliderEntry(property);
        property.setRequiresMcRestart(true);
        this.lightningWraithSpawnRate = property.getInt();
        propOrder.add(property.getName());
        this.config.setCategoryPropertyOrder(DIFFICULTY_CATEGORY, propOrder);
    }

    private void setupTweaksConfig() {
        ArrayList<String> propOrder = new ArrayList<String>();
        this.config.addCustomCategoryComment(TWEAKS_CATEGORY, "Assorted settings for tweaking the mod's behaviour. In multiplayer, the server/LAN host settings will apply.");
        Property property = this.config.get(TWEAKS_CATEGORY, "replaceVanillaFireballs", true, "Whether to replace Minecraft's own fireballs with wizardry fireballs. If this is disabled, only wizardry spells will use the custom fireballs.");
        property.setLanguageKey("config.ebwizardry.replace_vanilla_fireballs");
        Wizardry.proxy.setToNamedBooleanEntry(property);
        property.setRequiresWorldRestart(true);
        this.replaceVanillaFireballs = property.getBoolean();
        propOrder.add(property.getName());
        property = this.config.get(TWEAKS_CATEGORY, "replaceVanillaFallDamage", true, "Whether to replace Minecraft's distance-based fall damage calculation with an equivalent, velocity-based one. This is done such that mobs in freefall will take exactly the same damage as normal, so it will not break falling-based mob farms. Disable this if you experience falling-related weirdness! If this is disabled, some spells will use a more simplistic method of resetting the player's fall damage in certain cases.");
        property.setLanguageKey("config.ebwizardry.replace_vanilla_fall_damage");
        Wizardry.proxy.setToNamedBooleanEntry(property);
        property.setRequiresWorldRestart(true);
        this.replaceVanillaFallDamage = property.getBoolean();
        propOrder.add(property.getName());
        property = this.config.get(TWEAKS_CATEGORY, "blindnessTweak", true, "Whether to tweak the blindness effect to reduce follow distance when used on non-players. This automatically disables itself in favour of Potion Core's implementation if installed.");
        property.setLanguageKey("config.ebwizardry.blindness_tweak");
        Wizardry.proxy.setToNamedBooleanEntry(property);
        this.blindnessTweak = property.getBoolean();
        propOrder.add(property.getName());
        property = this.config.get(TWEAKS_CATEGORY, "mobLootTableWhitelist", new String[0], "Whitelist for loot tables to inject additional mob drops (as specified in loot_tables/entities/mob_additions.json) into. Wizardry makes a best guess as to which loot tables belong to hostile mobs, but this may not always be correct or appropriate; add loot table locations (not entity IDs) to this list to manually include them.");
        property.setLanguageKey("config.ebwizardry.mob_loot_table_whitelist");
        property.setRequiresMcRestart(true);
        this.mobLootTableWhitelist = Settings.getResourceLocationList(property);
        propOrder.add(property.getName());
        property = this.config.get(TWEAKS_CATEGORY, "mobLootTableBlacklist", new String[]{"entities/vex", "entities/ender_dragon", "entities/wither", "ebwizardry:entities/evil_wizard"}, "Blacklist for loot tables to inject additional mob drops (as specified in loot_tables/entities/mob_additions.json) into. Wizardry makes a best guess as to which loot tables belong to hostile mobs, but this may not always be correct or appropriate; add loot table locations (not entity IDs) to this list to manually exclude them.");
        property.setLanguageKey("config.ebwizardry.mob_loot_table_blacklist");
        property.setRequiresMcRestart(true);
        this.mobLootTableBlacklist = Settings.getResourceLocationList(property);
        propOrder.add(property.getName());
        property = this.config.get(TWEAKS_CATEGORY, "mobSpawnDimensions", new int[]{0}, "List of dimension ids in which wizardry's hostile mobs can spawn.");
        property.setLanguageKey("config.ebwizardry.mob_spawn_dimensions");
        property.setRequiresMcRestart(true);
        this.mobSpawnDimensions = property.getIntList();
        propOrder.add(property.getName());
        property = this.config.get(TWEAKS_CATEGORY, "mobSpawnBiomeBlacklist", new String[]{"mushroom_island", "mushroom_island_shore"}, "List of names of biomes in which wizardry's hostile mobs cannot spawn. Biome names are not case-sensitive. For mod biomes, prefix with the mod ID (e.g. biomesoplenty:mystic_grove).");
        property.setLanguageKey("config.ebwizardry.mob_spawn_biome_blacklist");
        property.setRequiresMcRestart(true);
        this.mobSpawnBiomeBlacklist = Settings.getResourceLocationList(property);
        propOrder.add(property.getName());
        property = this.config.get(TWEAKS_CATEGORY, "summonedCreatureTargetsWhitelist", new String[0], "List of names of entities which summoned creatures and wizards are allowed to attack, in addition to the defaults. Add mod creatures to this list if you want summoned creatures to attack them and they aren't already doing so. SoundLoopSpellEntity names are not case sensitive. For mod entities, prefix with the mod ID (e.g. ebwizardry:wizard).");
        property.setLanguageKey("config.ebwizardry.summoned_creature_targets_whitelist");
        property.setRequiresWorldRestart(true);
        this.summonedCreatureTargetsWhitelist = Settings.getResourceLocationList(property);
        propOrder.add(property.getName());
        property = this.config.get(TWEAKS_CATEGORY, "summonedCreatureTargetsBlacklist", new String[]{"creeper"}, "List of names of entities which summoned creatures and wizards are specifically not allowed to attack, overriding the defaults and the whitelist. Add creatures to this list if allowing them to be attacked causes problems or is too destructive (removing creepers from this list is done at your own risk!). SoundLoopSpellEntity names are not case sensitive. For mod entities, prefix with the mod ID (e.g. ebwizardry:wizard).");
        property.setLanguageKey("config.ebwizardry.summoned_creature_targets_blacklist");
        property.setRequiresWorldRestart(true);
        this.summonedCreatureTargetsBlacklist = Settings.getResourceLocationList(property);
        propOrder.add(property.getName());
        property = this.config.get(TWEAKS_CATEGORY, "mindControlTargetsBlacklist", new String[0], "List of names of entities which cannot be mind controlled, in addition to the defaults. Add creatures to this list if allowing them to be mind-controlled causes problems or could be exploited. SoundLoopSpellEntity names are not case sensitive. For mod entities, prefix with the mod ID (e.g. ebwizardry:wizard).");
        property.setLanguageKey("config.ebwizardry.mind_control_targets_blacklist");
        this.mindControlTargetsBlacklist = Settings.getResourceLocationList(property);
        propOrder.add(property.getName());
        property = this.config.get(TWEAKS_CATEGORY, "pocketFurnaceItemBlacklist", new String[]{"cobblestone", "netherrack"}, "List of registry names of blocks or items which cannot be smelted by the pocket furnace spell, in addition to armour, tools and weapons. Block/item names are not case sensitive. For mod items, prefix with the mod ID (e.g. ebwizardry:crystal_ore).");
        property.setLanguageKey("config.ebwizardry.pocket_furnace_item_blacklist");
        this.pocketFurnaceItemBlacklist = Settings.parseItemMetaStrings(property.getStringList());
        propOrder.add(property.getName());
        property = this.config.get(TWEAKS_CATEGORY, "divinationOreWhitelist", new String[0], "List of registry names of ore blocks which can be detected by the divination spell. Block names are not case sensitive. For mod blocks, prefix with the mod ID (e.g. ebwizardry:crystal_ore).");
        property.setLanguageKey("config.ebwizardry.divination_ore_whitelist");
        this.divinationOreWhitelist = Settings.parseItemMetaStrings(property.getStringList());
        propOrder.add(property.getName());
        property = this.config.get(TWEAKS_CATEGORY, "swordItemWhitelist", new String[0], "List of registry names of items which should count as swords for imbuement spells. Most swords should work automatically, but those that don't can be added manually here. Item names are not case sensitive. For mod items, prefix with the mod ID (e.g. tconstruct:broadsword).");
        property.setLanguageKey("config.ebwizardry.sword_item_whitelist");
        this.swordItemWhitelist = Settings.parseItemMetaStrings(property.getStringList());
        propOrder.add(property.getName());
        property = this.config.get(TWEAKS_CATEGORY, "bowItemWhitelist", new String[0], "List of registry names of items which should count as bows for imbuement spells. Most bows should work automatically, but those that don't can be added manually here. Item names are not case sensitive. For mod items, prefix with the mod ID (e.g. tconstruct:shortbow).");
        property.setLanguageKey("config.ebwizardry.bow_item_whitelist");
        this.bowItemWhitelist = Settings.parseItemMetaStrings(property.getStringList());
        propOrder.add(property.getName());
        property = this.config.get(TWEAKS_CATEGORY, "bookshelfBlocks", new String[]{"ebwizardry:oak_bookshelf", "ebwizardry:spruce_bookshelf", "ebwizardry:birch_bookshelf", "ebwizardry:jungle_bookshelf", "ebwizardry:acacia_bookshelf", "ebwizardry:dark_oak_bookshelf"}, "List of registry names of blocks that count as bookshelves for the arcane workbench and lectern. Block names are not case sensitive. For mod blocks, prefix with the mod ID (e.g. ebwizardry:oak_bookshelf).");
        property.setLanguageKey("config.ebwizardry.bookshelf_blocks");
        property.setRequiresWorldRestart(true);
        this.bookshelfBlocks = Settings.parseItemMetaStrings(property.getStringList());
        propOrder.add(property.getName());
        property = this.config.get(TWEAKS_CATEGORY, "bookItems", new String[0], "List of registry names of items which can be placed in a bookshelf, in addition to the defaults. Item names are not case sensitive. For mod items, prefix with the mod ID (e.g. thaumcraft:thaumonomicon).");
        property.setLanguageKey("config.ebwizardry.book_items");
        property.setRequiresWorldRestart(true);
        this.bookItems = Settings.parseItemMetaStrings(property.getStringList());
        propOrder.add(property.getName());
        property = this.config.get(TWEAKS_CATEGORY, "bookshelfSearchRadius", 4, "The maximum number of blocks a bookshelf can be from an arcane workbench or lectern to be able to link to it.", 1, 10);
        property.setLanguageKey("config.ebwizardry.bookshelf_search_radius");
        Wizardry.proxy.setToNumberSliderEntry(property);
        property.setRequiresWorldRestart(true);
        this.bookshelfSearchRadius = property.getInt();
        propOrder.add(property.getName());
        property = this.config.get(TWEAKS_CATEGORY, "currencyItems", new String[]{"gold_ingot 3", "emerald 6"}, "List of registry names of items which wizard trades can use as currency (in the first slot; the second slot is unaffected). Each entry in this list should consist of an item registry name, followed by a single space, then an integer which defines the 'value' of the item. Higher values mean fewer of that currency item are required for a given trade.", Pattern.compile("[A-Za-z0-9:_]+ [0-9]+"));
        property.setLanguageKey("config.ebwizardry.currency_items");
        propOrder.add(property.getName());
        this.currencyItems = new HashMap<Pair<ResourceLocation, Short>, Integer>();
        for (String string : property.getStringList()) {
            String[] args = (string = string.toLowerCase(Locale.ROOT).trim()).split(" ");
            if (args.length != 2) {
                Wizardry.logger.warn("Invalid entry in currency items: {}", (Object)string);
                continue;
            }
            try {
                this.currencyItems.put(Settings.parseItemMetaString(args[0]), Integer.parseInt(args[1]));
            }
            catch (NumberFormatException e) {
                Wizardry.logger.warn("Invalid integer in currency items: {}", (Object)args[1]);
            }
        }
        this.config.setCategoryPropertyOrder(TWEAKS_CATEGORY, propOrder);
    }

    private void setupWorldgenConfig() {
        ArrayList<String> propOrder = new ArrayList<String>();
        this.config.addCustomCategoryComment(WORLDGEN_CATEGORY, "Settings that affect world generation. In multiplayer, the server/LAN host settings will apply.");
        Property property = this.config.get(WORLDGEN_CATEGORY, "fastWorldgen", false, "Whether to use faster worldgen at the cost of 'seamlessness'. Enabling this option removes the checks for steep slopes and cleanup of floating trees that improve the look of worldgen. Performance improvement will vary depending on your setup. This option will affect randomisation; for any given seed, structures will not be the same as when it is turned off.");
        property.setLanguageKey("config.ebwizardry.fast_worldgen");
        Wizardry.proxy.setToNamedBooleanEntry(property);
        this.fastWorldgen = property.getBoolean();
        propOrder.add(property.getName());
        property = this.config.get(WORLDGEN_CATEGORY, "towerDimensions", new int[]{0}, "List of dimension ids in which wizard towers will generate. Remove all dimensions to disable wizard towers completely.");
        property.setLanguageKey("config.ebwizardry.tower_dimensions");
        property.setRequiresWorldRestart(true);
        this.towerDimensions = property.getIntList();
        propOrder.add(property.getName());
        property = this.config.get(WORLDGEN_CATEGORY, "towerRarity", 900, "Rarity of wizard towers. 1 in this many chunks will contain a wizard tower, meaning higher numbers are rarer.", 20, 5000);
        property.setLanguageKey("config.ebwizardry.tower_rarity");
        property.setRequiresWorldRestart(true);
        Wizardry.proxy.setToNumberSliderEntry(property);
        this.towerRarity = property.getInt();
        propOrder.add(property.getName());
        if (this.towerRarity < 20) {
            this.towerRarity = 600;
        }
        property = this.config.get(WORLDGEN_CATEGORY, "evilWizardChance", 0.2, "The chance for wizard towers to generate with an evil wizard and chest inside, instead of a friendly wizard.", 0.0, 1.0);
        property.setLanguageKey("config.ebwizardry.evil_wizard_chance");
        property.setRequiresWorldRestart(true);
        Wizardry.proxy.setToNumberSliderEntry(property);
        this.evilWizardChance = property.getDouble();
        propOrder.add(property.getName());
        property = this.config.get(WORLDGEN_CATEGORY, "towerFiles", new String[]{"ebwizardry:wizard_tower_0", "ebwizardry:wizard_tower_1", "ebwizardry:wizard_tower_2", "ebwizardry:wizard_tower_3"}, "List of structure file locations for wizard towers without loot chests. One of these files will be randomly selected each time a wizard tower is generated. File locations are of the format [mod id]:[filename], which refers to the file assets/[mod id]/structures/[filename].nbt. Duplicate entries are permitted, allowing for simple weighting without duplicating the structure files themselves. This list should not be empty; to disable wizard towers, use the tower dimensions setting.");
        property.setLanguageKey("config.ebwizardry.tower_files");
        property.setRequiresWorldRestart(true);
        this.towerFiles = Settings.getResourceLocationList(property);
        propOrder.add(property.getName());
        property = this.config.get(WORLDGEN_CATEGORY, "towerWithChestFiles", new String[]{"ebwizardry:wizard_tower_chest_0", "ebwizardry:wizard_tower_chest_1", "ebwizardry:wizard_tower_chest_2", "ebwizardry:wizard_tower_chest_3"}, "List of structure file locations for wizard towers with loot chests. One of these files will be randomly selected each time a wizard tower is generated. File locations are of the format [mod id]:[filename], which refers to the file assets/[mod id]/structures/[filename].nbt. Duplicate entries are permitted, allowing for simple weighting without duplicating the structure files themselves. This list should not be empty; to disable wizard towers, use the tower dimensions setting.");
        property.setLanguageKey("config.ebwizardry.tower_with_chest_files");
        property.setRequiresWorldRestart(true);
        this.towerWithChestFiles = Settings.getResourceLocationList(property);
        propOrder.add(property.getName());
        property = this.config.get(WORLDGEN_CATEGORY, "obeliskDimensions", new int[]{0, -1}, "List of dimension ids in which obelisks will generate. Remove all dimensions to disable obelisks completely.");
        property.setLanguageKey("config.ebwizardry.obelisk_dimensions");
        property.setRequiresWorldRestart(true);
        this.obeliskDimensions = property.getIntList();
        propOrder.add(property.getName());
        property = this.config.get(WORLDGEN_CATEGORY, "obeliskRarity", 800, "Rarity of obelisks. 1 in this many chunks will contain an obelisk, meaning higher numbers are rarer.", 20, 5000);
        property.setLanguageKey("config.ebwizardry.obelisk_rarity");
        property.setRequiresWorldRestart(true);
        Wizardry.proxy.setToNumberSliderEntry(property);
        this.obeliskRarity = property.getInt();
        propOrder.add(property.getName());
        property = this.config.get(WORLDGEN_CATEGORY, "obeliskFiles", new String[]{"ebwizardry:obelisk_0", "ebwizardry:obelisk_1", "ebwizardry:obelisk_2", "ebwizardry:obelisk_3", "ebwizardry:obelisk_4"}, "List of structure file locations for obelisks. One of these files will be randomly selected each time an obelisk is generated. File locations are of the format [mod id]:[filename], which refers to the file assets/[mod id]/structures/[filename].nbt. Duplicate entries are permitted, allowing for simple weighting without duplicating the structure files themselves. This list should not be empty; to disable obelisks, use the obelisk dimensions setting.");
        property.setLanguageKey("config.ebwizardry.obelisk_files");
        property.setRequiresWorldRestart(true);
        this.obeliskFiles = Settings.getResourceLocationList(property);
        propOrder.add(property.getName());
        property = this.config.get(WORLDGEN_CATEGORY, "shrineDimensions", new int[]{0, -1}, "List of dimension ids in which shrines will generate. Remove all dimensions to disable shrines completely.");
        property.setLanguageKey("config.ebwizardry.shrine_dimensions");
        property.setRequiresWorldRestart(true);
        this.shrineDimensions = property.getIntList();
        propOrder.add(property.getName());
        property = this.config.get(WORLDGEN_CATEGORY, "shrineRarity", 1500, "Rarity of shrines. 1 in this many chunks will contain a shrine, meaning higher numbers are rarer.", 20, 5000);
        property.setLanguageKey("config.ebwizardry.shrine_rarity");
        property.setRequiresWorldRestart(true);
        Wizardry.proxy.setToNumberSliderEntry(property);
        this.shrineRarity = property.getInt();
        propOrder.add(property.getName());
        property = this.config.get(WORLDGEN_CATEGORY, "shrineFiles", new String[]{"ebwizardry:shrine_0", "ebwizardry:shrine_1", "ebwizardry:shrine_2", "ebwizardry:shrine_3", "ebwizardry:shrine_4", "ebwizardry:shrine_5", "ebwizardry:shrine_6", "ebwizardry:shrine_7"}, "List of structure file locations for shrines. One of these files will be randomly selected each time a shrine is generated. File locations are of the format [mod id]:[filename], which refers to the file assets/[mod id]/structures/[filename].nbt. Duplicate entries are permitted, allowing for simple weighting without duplicating the structure files themselves. This list should not be empty; to disable shrines, use the shrine dimensions setting.");
        property.setLanguageKey("config.ebwizardry.shrine_files");
        property.setRequiresWorldRestart(true);
        this.shrineFiles = Settings.getResourceLocationList(property);
        propOrder.add(property.getName());
        property = this.config.get(WORLDGEN_CATEGORY, "libraryDimensions", new int[]{0}, "List of dimension ids in which library ruins will generate. Remove all dimensions to disable library ruins completely.");
        property.setLanguageKey("config.ebwizardry.library_dimensions");
        property.setRequiresWorldRestart(true);
        this.libraryDimensions = property.getIntList();
        propOrder.add(property.getName());
        property = this.config.get(WORLDGEN_CATEGORY, "libraryRarity", 900, "Rarity of library ruins. 1 in this many chunks will contain a library ruin, meaning higher numbers are rarer.", 20, 5000);
        property.setLanguageKey("config.ebwizardry.library_rarity");
        property.setRequiresWorldRestart(true);
        Wizardry.proxy.setToNumberSliderEntry(property);
        this.libraryRarity = property.getInt();
        propOrder.add(property.getName());
        property = this.config.get(WORLDGEN_CATEGORY, "libraryFiles", new String[]{"ebwizardry:library_ruins_0", "ebwizardry:library_ruins_1", "ebwizardry:library_ruins_2", "ebwizardry:library_ruins_3"}, "List of structure file locations for surface library ruins. One of these files will be randomly selected each time a surface library ruin is generated. File locations are of the format [mod id]:[filename], which refers to the file assets/[mod id]/structures/[filename].nbt. Duplicate entries are permitted, allowing for simple weighting without duplicating the structure files themselves. This list should not be empty; to disable library ruins, use the library dimensions setting.");
        property.setLanguageKey("config.ebwizardry.library_files");
        property.setRequiresWorldRestart(true);
        this.libraryFiles = Settings.getResourceLocationList(property);
        propOrder.add(property.getName());
        property = this.config.get(WORLDGEN_CATEGORY, "undergroundLibraryFiles", new String[]{"ebwizardry:underground_library_ruins_0", "ebwizardry:underground_library_ruins_1", "ebwizardry:underground_library_ruins_2", "ebwizardry:underground_library_ruins_3"}, "List of structure file locations for underground library ruins. One of these files will be randomly selected each time an underground library ruin is generated. File locations are of the format [mod id]:[filename], which refers to the file assets/[mod id]/structures/[filename].nbt. Duplicate entries are permitted, allowing for simple weighting without duplicating the structure files themselves. This list should not be empty; to disable library ruins, use the library dimensions setting.");
        property.setLanguageKey("config.ebwizardry.underground_library_files");
        property.setRequiresWorldRestart(true);
        this.undergroundLibraryFiles = Settings.getResourceLocationList(property);
        propOrder.add(property.getName());
        property = this.config.get(WORLDGEN_CATEGORY, "treeBlocks", DEFAULT_TREE_BLOCKS, "List of registry names of blocks which can be overwritten by wizardry's structure generators, affecting both fast and fancy structure generation. Most tree blocks and other foliage should work automatically, but those that don't can be added manually here. Block names are not case sensitive. For mod blocks, prefix with the mod ID (e.g. dynamictrees:oakbranch).");
        property.setLanguageKey("config.ebwizardry.tree_blocks");
        property.setRequiresWorldRestart(true);
        this.treeBlocks = Settings.parseItemMetaStrings(property.getStringList());
        propOrder.add(property.getName());
        property = this.config.get(WORLDGEN_CATEGORY, "oreDimensions", new int[]{0}, "List of dimension ids in which crystal ore will generate. Note that removing the overworld (id 0) from this list will make the mod VERY difficult to play!");
        property.setLanguageKey("config.ebwizardry.ore_dimensions");
        property.setRequiresWorldRestart(true);
        this.oreDimensions = property.getIntList();
        propOrder.add(property.getName());
        property = this.config.get(WORLDGEN_CATEGORY, "flowerDimensions", new int[]{0}, "List of dimension ids in which crystal flowers will generate.");
        property.setLanguageKey("config.ebwizardry.flower_dimensions");
        property.setRequiresWorldRestart(true);
        this.flowerDimensions = property.getIntList();
        propOrder.add(property.getName());
        property = this.config.get(WORLDGEN_CATEGORY, "lootInjectionLocations", DEFAULT_LOOT_INJECTION_LOCATIONS, "List of loot tables to inject wizardry loot (as specified in loot_tables/chests/dungeon_additions.json) into.");
        property.setLanguageKey("config.ebwizardry.loot_injection_locations");
        property.setRequiresMcRestart(true);
        this.lootInjectionLocations = Settings.getResourceLocationList(property);
        propOrder.add(property.getName());
        this.config.setCategoryPropertyOrder(WORLDGEN_CATEGORY, propOrder);
    }

    private void setupClientConfig() {
        ArrayList<String> propOrder = new ArrayList<String>();
        this.config.addCustomCategoryComment(CLIENT_CATEGORY, "Client-side settings that only affect the local minecraft game. If this file is on a dedicated server, these settings will have no effect; in multiplayer, each player obeys their own settings.");
        Property property = this.config.get(CLIENT_CATEGORY, "shiftScrolling", true, "Whether you can switch between spells on a wand by scrolling with the mouse wheel while sneaking. Note that this will only affect you; other players connected to the same server obey their own settings.");
        property.setLanguageKey("config.ebwizardry.shift_scrolling");
        property.setRequiresWorldRestart(false);
        Wizardry.proxy.setToNamedBooleanEntry(property);
        this.shiftScrolling = property.getBoolean();
        propOrder.add(property.getName());
        property = this.config.get(CLIENT_CATEGORY, "reverseScrollDirection", false, "The scroll direction used to switch between spells on a wand while sneaking.");
        property.setLanguageKey("config.ebwizardry.reverse_scroll_direction");
        property.setRequiresWorldRestart(false);
        Wizardry.proxy.setToNamedBooleanEntry(property);
        this.reverseScrollDirection = property.getBoolean();
        propOrder.add(property.getName());
        property = this.config.get(CLIENT_CATEGORY, "showSpellHUD", true, "Whether to show the spell HUD in the corner of the screen when holding a wand.");
        property.setLanguageKey("config.ebwizardry.show_spell_hud");
        property.setRequiresWorldRestart(false);
        Wizardry.proxy.setToNamedBooleanEntry(property);
        this.showSpellHUD = property.getBoolean();
        propOrder.add(property.getName());
        property = this.config.get(CLIENT_CATEGORY, "showChargeMeter", true, "Whether to show the spell charge-up meter around the crosshairs when charging up a spell.");
        property.setLanguageKey("config.ebwizardry.show_charge_meter");
        property.setRequiresWorldRestart(false);
        Wizardry.proxy.setToNamedBooleanEntry(property);
        this.showChargeMeter = property.getBoolean();
        propOrder.add(property.getName());
        property = this.config.get(CLIENT_CATEGORY, "spellHUDPosition", GuiPosition.BOTTOM_LEFT.name, "The position of the spell HUD.", GuiPosition.names);
        property.setLanguageKey("config.ebwizardry.spell_hud_position");
        this.spellHUDPosition = GuiPosition.fromName(property.getString());
        propOrder.add(property.getName());
        property = this.config.get(CLIENT_CATEGORY, "spellHUDSkin", DEFAULT_HUD_SKIN_KEY, "The skin used for the spell HUD.", Wizardry.proxy.getSpellHUDSkins().toArray(new String[0]));
        property.setLanguageKey("config.ebwizardry.spell_hud_skin");
        Wizardry.proxy.setToHUDChooserEntry(property);
        this.spellHUDSkin = property.getString();
        propOrder.add(property.getName());
        property = this.config.get(CLIENT_CATEGORY, "handbookProgression", true, "When set to true, sections of The Wizard's Handbook are unlocked when a player gains the advancement that triggers them, and are hidden otherwise. When set to false, the entire handbook is readable regardless of advancement progress.");
        property.setLanguageKey("config.ebwizardry.handbook_progression");
        Wizardry.proxy.setToNamedBooleanEntry(property);
        this.handbookProgression = property.getBoolean();
        propOrder.add(property.getName());
        property = this.config.get(CLIENT_CATEGORY, "booksPauseGame", true, "Whether opening any of wizardry's books pauses the game in singleplayer. Has no effect on servers or LAN worlds.");
        property.setLanguageKey("config.ebwizardry.books_pause_game");
        Wizardry.proxy.setToNamedBooleanEntry(property);
        this.booksPauseGame = property.getBoolean();
        propOrder.add(property.getName());
        property = this.config.get(CLIENT_CATEGORY, "summonedCreatureNames", true, "Whether to show summoned creatures' names and owners above their heads.");
        property.setLanguageKey("config.ebwizardry.summoned_creature_names");
        Wizardry.proxy.setToNamedBooleanEntry(property);
        this.summonedCreatureNames = property.getBoolean();
        propOrder.add(property.getName());
        property = this.config.get(CLIENT_CATEGORY, "useShaders", true, "Whether to use custom shaders for certain spells. These use the vanilla shader system (like mob spectating shaders) and shouldn't have much of an effect on performance in most cases, but they may conflict with other shaders.");
        property.setLanguageKey("config.ebwizardry.use_shaders");
        Wizardry.proxy.setToNamedBooleanEntry(property);
        this.useShaders = property.getBoolean();
        propOrder.add(property.getName());
        property = this.config.get(CLIENT_CATEGORY, "screenShake", true, "Whether to use the screen shake effect for certain spells.");
        property.setLanguageKey("config.ebwizardry.screen_shake");
        Wizardry.proxy.setToNamedBooleanEntry(property);
        this.screenShake = property.getBoolean();
        propOrder.add(property.getName());
        property = this.config.get(CLIENT_CATEGORY, "blinkEffect", true, "Whether to use the screen blink effect for teleportation spells.");
        property.setLanguageKey("config.ebwizardry.blink_effect");
        Wizardry.proxy.setToNamedBooleanEntry(property);
        this.blinkEffect = property.getBoolean();
        propOrder.add(property.getName());
        property = this.config.get(CLIENT_CATEGORY, "spellcastingAnimations", true, "Whether to use custom animations for players casting spells. Disable this option if it conflicts with other mods that add player animations.");
        property.setLanguageKey("config.ebwizardry.spellcasting_animations");
        property.setRequiresMcRestart(true);
        Wizardry.proxy.setToNamedBooleanEntry(property);
        this.spellcastingAnimations = property.getBoolean();
        propOrder.add(property.getName());
        List<String> elementNames = Arrays.stream(Element.values()).map(Element::func_176610_l).collect(Collectors.toList());
        elementNames.add("");
        property = this.config.get(CLIENT_CATEGORY, "donationPerkElement", Element.MAGIC.func_176610_l(), "The element of the flying companion orb rendered on donor and contributor players, leave empty to disable the effect. If you're one of them, this setting will change how all players see you (if not, it won't do anything).", elementNames.toArray(new String[0]));
        property.setLanguageKey("config.ebwizardry.donation_perk_element");
        this.donationPerkElement = Element.fromName(property.getString(), null);
        propOrder.add(property.getName());
        this.config.setCategoryPropertyOrder(CLIENT_CATEGORY, propOrder);
    }

    private void setupCommandsConfig() {
        ArrayList<String> propOrder = new ArrayList<String>();
        this.config.addCustomCategoryComment(COMMANDS_CATEGORY, "Settings for the commands added by Wizardry. In multiplayer, the server/LAN host settings will apply.");
        Property property = this.config.get(COMMANDS_CATEGORY, "castCommandMultiplierLimit", 20.0, "Upper limit for the multipliers passed into the /cast command. This is here to stop players from accidentally breaking a world/server. Large blast mutipliers can cause extreme lag - you have been warned!", 1.0, 2.147483647E9);
        property.setLanguageKey("config.ebwizardry.cast_command_multiplier_limit");
        this.maxSpellCommandMultiplier = property.getDouble();
        propOrder.add(property.getName());
        property = this.config.get(COMMANDS_CATEGORY, "castCommandName", "cast", "The name of the /cast command. This is what you type directly after the /; for example if this was set to 'magic' then instead of typing /cast you would type /magic instead.");
        property.setLanguageKey("config.ebwizardry.cast_command_name");
        property.setRequiresWorldRestart(true);
        this.castCommandName = property.getString();
        propOrder.add(property.getName());
        property = this.config.get(COMMANDS_CATEGORY, "discoverspellCommandName", "discoverspell", "The name of the /discoverspell command. This is what you type directly after the /; for example if this was set to 'magic' then instead of typing /discoverspell you would type /magic instead.");
        property.setLanguageKey("config.ebwizardry.discoverspell_command_name");
        property.setRequiresWorldRestart(true);
        this.discoverspellCommandName = property.getString();
        propOrder.add(property.getName());
        property = this.config.get(COMMANDS_CATEGORY, "allyCommandName", "ally", "The name of the /ally command. This is what you type directly after the /; for example if this was set to 'magic' then instead of typing /ally you would type /magic instead.");
        property.setLanguageKey("config.ebwizardry.ally_command_name");
        property.setRequiresWorldRestart(true);
        this.allyCommandName = property.getString();
        propOrder.add(property.getName());
        property = this.config.get(COMMANDS_CATEGORY, "alliesCommandName", "allies", "The name of the /allies command. This is what you type directly after the /; for example if this was set to 'magic' then instead of typing /allies you would type /magic instead.");
        property.setLanguageKey("config.ebwizardry.allies_command_name");
        property.setRequiresWorldRestart(true);
        this.alliesCommandName = property.getString();
        propOrder.add(property.getName());
        this.config.setCategoryPropertyOrder(COMMANDS_CATEGORY, propOrder);
    }

    private void setupResistancesConfig() {
        int i;
        ArrayList<String> propOrder = new ArrayList<String>();
        this.config.addCustomCategoryComment(RESISTANCES_CATEGORY, "Settings which allow entities to be made immune to certain types of magic. In multiplayer, the server/LAN host settings will apply.");
        Property property = this.config.get(RESISTANCES_CATEGORY, "mobsImmuneToFire", new String[0], "List of names of entities that are immune to fire, in addition to the defaults. Add mod creatures to this list if you want them to be immune to fire magic and they aren't already. SoundLoopSpellEntity names are not case sensitive. For mod entities, prefix with the mod ID (e.g. ebwizardry:wizard).");
        property.setLanguageKey("config.ebwizardry.mobs_immune_to_fire");
        property.setRequiresMcRestart(true);
        for (i = 0; i < property.getStringList().length; ++i) {
            property.getStringList()[i] = property.getStringList()[i].toLowerCase(Locale.ROOT).trim();
            MagicDamage.addEntityImmunity(EntityList.getClass((ResourceLocation)new ResourceLocation(property.getStringList()[i])), MagicDamage.DamageType.FIRE);
        }
        propOrder.add(property.getName());
        property = this.config.get(RESISTANCES_CATEGORY, "mobsImmuneToIce", new String[0], "List of names of entities that are immune to ice, in addition to the defaults. Add mod creatures to this list if you want them to be immune to ice magic and they aren't already. SoundLoopSpellEntity names are not case sensitive. For mod entities, prefix with the mod ID (e.g. ebwizardry:wizard).");
        property.setLanguageKey("config.ebwizardry.mobs_immune_to_ice");
        property.setRequiresMcRestart(true);
        for (i = 0; i < property.getStringList().length; ++i) {
            property.getStringList()[i] = property.getStringList()[i].toLowerCase(Locale.ROOT).trim();
            MagicDamage.addEntityImmunity(EntityList.getClass((ResourceLocation)new ResourceLocation(property.getStringList()[i])), MagicDamage.DamageType.FROST);
        }
        propOrder.add(property.getName());
        property = this.config.get(RESISTANCES_CATEGORY, "mobsImmuneToLightning", new String[0], "List of names of entities that are immune to lightning, in addition to the defaults. Add mod creatures to this list if you want them to be immune to lightning magic and they aren't already. SoundLoopSpellEntity names are not case sensitive. For mod entities, prefix with the mod ID (e.g. ebwizardry:wizard).");
        property.setLanguageKey("config.ebwizardry.mobs_immune_to_lightning");
        property.setRequiresMcRestart(true);
        for (i = 0; i < property.getStringList().length; ++i) {
            property.getStringList()[i] = property.getStringList()[i].toLowerCase(Locale.ROOT).trim();
            MagicDamage.addEntityImmunity(EntityList.getClass((ResourceLocation)new ResourceLocation(property.getStringList()[i])), MagicDamage.DamageType.SHOCK);
        }
        propOrder.add(property.getName());
        property = this.config.get(RESISTANCES_CATEGORY, "mobsImmuneToWither", new String[0], "List of names of entities that are immune to wither effects, in addition to the defaults. Add mod creatures to this list if you want them to be immune to withering magic and they aren't already. SoundLoopSpellEntity names are not case sensitive. For mod entities, prefix with the mod ID (e.g. ebwizardry:wizard).");
        property.setLanguageKey("config.ebwizardry.mobs_immune_to_wither");
        property.setRequiresMcRestart(true);
        for (i = 0; i < property.getStringList().length; ++i) {
            property.getStringList()[i] = property.getStringList()[i].toLowerCase(Locale.ROOT).trim();
            MagicDamage.addEntityImmunity(EntityList.getClass((ResourceLocation)new ResourceLocation(property.getStringList()[i])), MagicDamage.DamageType.WITHER);
        }
        propOrder.add(property.getName());
        property = this.config.get(RESISTANCES_CATEGORY, "mobsImmuneToPoison", new String[0], "List of names of entities that are immune to poison, in addition to the defaults. Add mod creatures to this list if you want them to be immune to poison magic and they aren't already. SoundLoopSpellEntity names are not case sensitive. For mod entities, prefix with the mod ID (e.g. ebwizardry:wizard).");
        property.setLanguageKey("config.ebwizardry.mobs_immune_to_poison");
        property.setRequiresMcRestart(true);
        for (i = 0; i < property.getStringList().length; ++i) {
            property.getStringList()[i] = property.getStringList()[i].toLowerCase(Locale.ROOT).trim();
            MagicDamage.addEntityImmunity(EntityList.getClass((ResourceLocation)new ResourceLocation(property.getStringList()[i])), MagicDamage.DamageType.POISON);
        }
        propOrder.add(property.getName());
        this.config.setCategoryPropertyOrder(RESISTANCES_CATEGORY, propOrder);
    }

    private void setupCompatibilityConfig() {
        ArrayList<String> propOrder = new ArrayList<String>();
        this.config.addCustomCategoryComment(COMPATIBILITY_CATEGORY, "Settings that affect how wizardry interacts with other mods. In multiplayer, the server/LAN host settings will apply.");
        Property property = this.config.get(COMPATIBILITY_CATEGORY, "damageSourceBlacklist", new String[0], "List of damage source string identifiers to be ignored when re-applying damage. Case-sensitive. A message will be logged if wizardry detects a damage source that should be added to this list. Otherwise, don't change unless instructed to do so.");
        property.setLanguageKey("config.ebwizardry.damage_source_blacklist");
        property.setRequiresWorldRestart(true);
        this.damageSourceBlacklist = property.getStringList();
        propOrder.add(property.getName());
        property = this.config.get(COMPATIBILITY_CATEGORY, "compatibilityWarnings", true, "Whether to print compatibility warnings to the console. Set to false if excessive messages are being printed.");
        property.setLanguageKey("config.ebwizardry.compatibility_warnings");
        Wizardry.proxy.setToNamedBooleanEntry(property);
        this.compatibilityWarnings = property.getBoolean();
        propOrder.add(property.getName());
        property = this.config.get(COMPATIBILITY_CATEGORY, "baublesIntegration", true, "If Baubles is installed, controls whether Baubles integration features are enabled. If this is disabled, wizardry will always behave as if Baubles is not installed.");
        property.setLanguageKey("config.ebwizardry.baubles_integration");
        property.setRequiresMcRestart(true);
        Wizardry.proxy.setToNamedBooleanEntry(property);
        this.baublesIntegration = property.getBoolean();
        propOrder.add(property.getName());
        property = this.config.get(COMPATIBILITY_CATEGORY, "jeiIntegration", true, "If JEI (Just Enough Items) is installed, controls whether JEI integration features are enabled. If this is disabled, wizardry will always behave as if JEI is not installed.");
        property.setLanguageKey("config.ebwizardry.jei_integration");
        property.setRequiresMcRestart(true);
        Wizardry.proxy.setToNamedBooleanEntry(property);
        this.jeiIntegration = property.getBoolean();
        propOrder.add(property.getName());
        property = this.config.get(COMPATIBILITY_CATEGORY, "antiqueAtlasIntegration", true, "If Antique Atlas is installed, controls whether Antique Atlas integration features are enabled. If this is disabled, wizardry will always behave as if Antique Atlas is not installed.");
        property.setLanguageKey("config.ebwizardry.antique_atlas_integration");
        property.setRequiresMcRestart(true);
        Wizardry.proxy.setToNamedBooleanEntry(property);
        this.antiqueAtlasIntegration = property.getBoolean();
        propOrder.add(property.getName());
        property = this.config.get(COMPATIBILITY_CATEGORY, "autoPlaceTowerMarkers", true, "Controls whether wizardry automatically places antique atlas markers at the locations of wizard towers.");
        property.setLanguageKey("config.ebwizardry.auto_place_tower_markers");
        property.setRequiresMcRestart(true);
        Wizardry.proxy.setToNamedBooleanEntry(property);
        this.autoTowerMarkers = property.getBoolean();
        propOrder.add(property.getName());
        property = this.config.get(COMPATIBILITY_CATEGORY, "autoPlaceObeliskMarkers", true, "Controls whether wizardry automatically places antique atlas markers at the locations of obelisks.");
        property.setLanguageKey("config.ebwizardry.auto_place_obelisk_markers");
        property.setRequiresMcRestart(true);
        Wizardry.proxy.setToNamedBooleanEntry(property);
        this.autoObeliskMarkers = property.getBoolean();
        propOrder.add(property.getName());
        property = this.config.get(COMPATIBILITY_CATEGORY, "autoPlaceShrineMarkers", true, "Controls whether wizardry automatically places antique atlas markers at the locations of shrines.");
        property.setLanguageKey("config.ebwizardry.auto_place_shrine_markers");
        property.setRequiresMcRestart(true);
        Wizardry.proxy.setToNamedBooleanEntry(property);
        this.autoShrineMarkers = property.getBoolean();
        propOrder.add(property.getName());
        property = this.config.get(COMPATIBILITY_CATEGORY, "autoPlaceLibraryMarkers", true, "Controls whether wizardry automatically places antique atlas markers at the locations of library ruins.");
        property.setLanguageKey("config.ebwizardry.auto_place_library_markers");
        property.setRequiresMcRestart(true);
        Wizardry.proxy.setToNamedBooleanEntry(property);
        this.autoLibraryMarkers = property.getBoolean();
        propOrder.add(property.getName());
        property = this.config.get(COMPATIBILITY_CATEGORY, "autoPlaceUndergroundLibraryMarkers", false, "Controls whether wizardry automatically places antique atlas markers at the locations of underground library ruins.");
        property.setLanguageKey("config.ebwizardry.auto_place_underground_library_markers");
        property.setRequiresMcRestart(true);
        Wizardry.proxy.setToNamedBooleanEntry(property);
        this.autoUndergroundLibraryMarkers = property.getBoolean();
        propOrder.add(property.getName());
        this.config.setCategoryPropertyOrder(COMPATIBILITY_CATEGORY, propOrder);
    }

    public static ResourceLocation[] getResourceLocationList(Property property) {
        return Settings.toResourceLocations(property.getStringList());
    }

    public static ResourceLocation[] toResourceLocations(String ... strings) {
        return (ResourceLocation[])Arrays.stream(strings).map(s -> new ResourceLocation(s.toLowerCase(Locale.ROOT).trim())).toArray(ResourceLocation[]::new);
    }

    public static Pair<ResourceLocation, Short>[] parseItemMetaStrings(String ... strings) {
        return (Pair[])Arrays.stream(strings).map(Settings::parseItemMetaString).toArray(Pair[]::new);
    }

    public static Pair<ResourceLocation, Short> parseItemMetaString(String string) {
        String item;
        short meta;
        string = string.toLowerCase(Locale.ROOT).trim();
        String[] itemArgs = string.split(":");
        try {
            meta = Short.parseShort(itemArgs[itemArgs.length - 1]);
            item = String.join((CharSequence)":", Arrays.copyOfRange(itemArgs, 0, itemArgs.length - 1));
        }
        catch (NumberFormatException e) {
            meta = Short.MAX_VALUE;
            item = string;
        }
        return Pair.of((Object)new ResourceLocation(item), (Object)meta);
    }

    public static boolean containsMetaBlock(Pair<ResourceLocation, Short>[] array, IBlockState block) {
        return Settings.containsMetaThing(array, block.func_177230_c().getRegistryName(), (short)block.func_177230_c().func_176201_c(block));
    }

    public static boolean containsMetaItem(Pair<ResourceLocation, Short>[] array, ItemStack stack) {
        return Settings.containsMetaThing(array, stack.func_77973_b().getRegistryName(), (short)stack.func_77960_j());
    }

    public static boolean containsMetaThing(Pair<ResourceLocation, Short>[] array, ResourceLocation id, short metadata) {
        return Arrays.asList(array).contains(Pair.of((Object)id, (Object)metadata)) || Arrays.asList(array).contains(Pair.of((Object)id, (Object)Short.MAX_VALUE));
    }

    public static enum GuiPosition {
        BOTTOM_LEFT("Bottom left", false, false, false),
        TOP_LEFT("Top left", false, true, false),
        TOP_RIGHT("Top right", true, true, false),
        BOTTOM_RIGHT("Bottom right", true, false, false),
        FOLLOW_BOTTOM("Follow wand, bottom", false, false, true),
        FOLLOW_TOP("Follow wand, top", false, true, true),
        OPPOSITE_BOTTOM("Opposite wand, bottom", true, false, true),
        OPPOSITE_TOP("Opposite wand, top", true, true, true);

        public static final String[] names;
        public final String name;
        public final boolean flipX;
        public final boolean flipY;
        public final boolean dynamic;

        private GuiPosition(String name, boolean flipX, boolean flipY, boolean dynamic) {
            this.name = name;
            this.flipX = flipX;
            this.flipY = flipY;
            this.dynamic = dynamic;
        }

        public static GuiPosition fromName(String name) {
            for (GuiPosition position : GuiPosition.values()) {
                if (!position.name.equalsIgnoreCase(name)) continue;
                return position;
            }
            Wizardry.logger.info("Invalid string for the spell HUD position. Using default (bottom left) instead.");
            return BOTTOM_LEFT;
        }

        static {
            names = new String[GuiPosition.values().length];
            for (GuiPosition position : GuiPosition.values()) {
                GuiPosition.names[position.ordinal()] = position.name;
            }
        }
    }
}

