/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.client;

import electroblob.wizardry.CommonProxy;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.client.MixedFontRenderer;
import electroblob.wizardry.client.ScreenShakeHandler;
import electroblob.wizardry.client.animation.ActionAnimation;
import electroblob.wizardry.client.animation.PlayerAnimator;
import electroblob.wizardry.client.audio.MovingSoundEntity;
import electroblob.wizardry.client.audio.MovingSoundSpellCharge;
import electroblob.wizardry.client.audio.SoundLoop;
import electroblob.wizardry.client.audio.SoundLoopSpell;
import electroblob.wizardry.client.gui.GuiLectern;
import electroblob.wizardry.client.gui.GuiSpellDisplay;
import electroblob.wizardry.client.gui.config.NamedBooleanEntry;
import electroblob.wizardry.client.gui.config.SpellHUDSkinChooserEntry;
import electroblob.wizardry.client.gui.handbook.GuiWizardHandbook;
import electroblob.wizardry.client.model.ModelWizardArmour;
import electroblob.wizardry.client.particle.ParticleBeam;
import electroblob.wizardry.client.particle.ParticleBlockHighlight;
import electroblob.wizardry.client.particle.ParticleBuff;
import electroblob.wizardry.client.particle.ParticleCloud;
import electroblob.wizardry.client.particle.ParticleDarkMagic;
import electroblob.wizardry.client.particle.ParticleDust;
import electroblob.wizardry.client.particle.ParticleFlash;
import electroblob.wizardry.client.particle.ParticleGuardianBeam;
import electroblob.wizardry.client.particle.ParticleIce;
import electroblob.wizardry.client.particle.ParticleLeaf;
import electroblob.wizardry.client.particle.ParticleLightning;
import electroblob.wizardry.client.particle.ParticleLightningPulse;
import electroblob.wizardry.client.particle.ParticleMagicBubble;
import electroblob.wizardry.client.particle.ParticleMagicFlame;
import electroblob.wizardry.client.particle.ParticlePath;
import electroblob.wizardry.client.particle.ParticleScorch;
import electroblob.wizardry.client.particle.ParticleSnow;
import electroblob.wizardry.client.particle.ParticleSpark;
import electroblob.wizardry.client.particle.ParticleSparkle;
import electroblob.wizardry.client.particle.ParticleSphere;
import electroblob.wizardry.client.particle.ParticleTornado;
import electroblob.wizardry.client.particle.ParticleVine;
import electroblob.wizardry.client.particle.ParticleWizardry;
import electroblob.wizardry.client.renderer.entity.RenderBlackHole;
import electroblob.wizardry.client.renderer.entity.RenderBlank;
import electroblob.wizardry.client.renderer.entity.RenderBoulder;
import electroblob.wizardry.client.renderer.entity.RenderBubble;
import electroblob.wizardry.client.renderer.entity.RenderDecay;
import electroblob.wizardry.client.renderer.entity.RenderDecoy;
import electroblob.wizardry.client.renderer.entity.RenderEvilWizard;
import electroblob.wizardry.client.renderer.entity.RenderFireRing;
import electroblob.wizardry.client.renderer.entity.RenderForceArrow;
import electroblob.wizardry.client.renderer.entity.RenderForcefield;
import electroblob.wizardry.client.renderer.entity.RenderHammer;
import electroblob.wizardry.client.renderer.entity.RenderIceBarrier;
import electroblob.wizardry.client.renderer.entity.RenderIceGiant;
import electroblob.wizardry.client.renderer.entity.RenderIceSpike;
import electroblob.wizardry.client.renderer.entity.RenderLightningDisc;
import electroblob.wizardry.client.renderer.entity.RenderMagicArrow;
import electroblob.wizardry.client.renderer.entity.RenderPhoenix;
import electroblob.wizardry.client.renderer.entity.RenderProjectile;
import electroblob.wizardry.client.renderer.entity.RenderRadiantTotem;
import electroblob.wizardry.client.renderer.entity.RenderRemnant;
import electroblob.wizardry.client.renderer.entity.RenderSigil;
import electroblob.wizardry.client.renderer.entity.RenderSpiritHorse;
import electroblob.wizardry.client.renderer.entity.RenderSpiritWolf;
import electroblob.wizardry.client.renderer.entity.RenderStrayMinion;
import electroblob.wizardry.client.renderer.entity.RenderWitheringTotem;
import electroblob.wizardry.client.renderer.entity.RenderWizard;
import electroblob.wizardry.client.renderer.entity.RenderZombieSpawner;
import electroblob.wizardry.client.renderer.entity.layers.LayerDisintegrateAnimation;
import electroblob.wizardry.client.renderer.entity.layers.LayerFrost;
import electroblob.wizardry.client.renderer.entity.layers.LayerMindControl;
import electroblob.wizardry.client.renderer.entity.layers.LayerStone;
import electroblob.wizardry.client.renderer.entity.layers.LayerSummonAnimation;
import electroblob.wizardry.client.renderer.entity.layers.LayerTiledOverlay;
import electroblob.wizardry.client.renderer.overlay.RenderBlinkEffect;
import electroblob.wizardry.client.renderer.tileentity.RenderArcaneWorkbench;
import electroblob.wizardry.client.renderer.tileentity.RenderImbuementAltar;
import electroblob.wizardry.client.renderer.tileentity.RenderLectern;
import electroblob.wizardry.client.renderer.tileentity.RenderMagicLight;
import electroblob.wizardry.client.renderer.tileentity.RenderStatue;
import electroblob.wizardry.command.SpellEmitter;
import electroblob.wizardry.data.DispenserCastingData;
import electroblob.wizardry.data.SpellEmitterData;
import electroblob.wizardry.data.SpellGlyphData;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.entity.EntityShield;
import electroblob.wizardry.entity.construct.EntityArrowRain;
import electroblob.wizardry.entity.construct.EntityBlackHole;
import electroblob.wizardry.entity.construct.EntityBlizzard;
import electroblob.wizardry.entity.construct.EntityBoulder;
import electroblob.wizardry.entity.construct.EntityBubble;
import electroblob.wizardry.entity.construct.EntityCombustionRune;
import electroblob.wizardry.entity.construct.EntityDecay;
import electroblob.wizardry.entity.construct.EntityEarthquake;
import electroblob.wizardry.entity.construct.EntityFireRing;
import electroblob.wizardry.entity.construct.EntityFireSigil;
import electroblob.wizardry.entity.construct.EntityForcefield;
import electroblob.wizardry.entity.construct.EntityFrostSigil;
import electroblob.wizardry.entity.construct.EntityHailstorm;
import electroblob.wizardry.entity.construct.EntityHammer;
import electroblob.wizardry.entity.construct.EntityHealAura;
import electroblob.wizardry.entity.construct.EntityIceBarrier;
import electroblob.wizardry.entity.construct.EntityIceSpike;
import electroblob.wizardry.entity.construct.EntityLightningSigil;
import electroblob.wizardry.entity.construct.EntityRadiantTotem;
import electroblob.wizardry.entity.construct.EntityStormcloud;
import electroblob.wizardry.entity.construct.EntityTornado;
import electroblob.wizardry.entity.construct.EntityWitheringTotem;
import electroblob.wizardry.entity.construct.EntityZombieSpawner;
import electroblob.wizardry.entity.living.EntityDecoy;
import electroblob.wizardry.entity.living.EntityEvilWizard;
import electroblob.wizardry.entity.living.EntityHuskMinion;
import electroblob.wizardry.entity.living.EntityIceGiant;
import electroblob.wizardry.entity.living.EntityIceWraith;
import electroblob.wizardry.entity.living.EntityLightningWraith;
import electroblob.wizardry.entity.living.EntityPhoenix;
import electroblob.wizardry.entity.living.EntityRemnant;
import electroblob.wizardry.entity.living.EntityShadowWraith;
import electroblob.wizardry.entity.living.EntitySkeletonMinion;
import electroblob.wizardry.entity.living.EntitySpiritHorse;
import electroblob.wizardry.entity.living.EntitySpiritWolf;
import electroblob.wizardry.entity.living.EntityStormElemental;
import electroblob.wizardry.entity.living.EntityStrayMinion;
import electroblob.wizardry.entity.living.EntityWizard;
import electroblob.wizardry.entity.living.ISpellCaster;
import electroblob.wizardry.entity.living.ISummonedCreature;
import electroblob.wizardry.entity.projectile.EntityDarknessOrb;
import electroblob.wizardry.entity.projectile.EntityDart;
import electroblob.wizardry.entity.projectile.EntityEmber;
import electroblob.wizardry.entity.projectile.EntityFirebolt;
import electroblob.wizardry.entity.projectile.EntityFirebomb;
import electroblob.wizardry.entity.projectile.EntityFlamecatcherArrow;
import electroblob.wizardry.entity.projectile.EntityForceArrow;
import electroblob.wizardry.entity.projectile.EntityForceOrb;
import electroblob.wizardry.entity.projectile.EntityIceCharge;
import electroblob.wizardry.entity.projectile.EntityIceLance;
import electroblob.wizardry.entity.projectile.EntityIceShard;
import electroblob.wizardry.entity.projectile.EntityIceball;
import electroblob.wizardry.entity.projectile.EntityLargeMagicFireball;
import electroblob.wizardry.entity.projectile.EntityLightningArrow;
import electroblob.wizardry.entity.projectile.EntityLightningDisc;
import electroblob.wizardry.entity.projectile.EntityMagicFireball;
import electroblob.wizardry.entity.projectile.EntityMagicMissile;
import electroblob.wizardry.entity.projectile.EntityPoisonBomb;
import electroblob.wizardry.entity.projectile.EntitySmokeBomb;
import electroblob.wizardry.entity.projectile.EntitySpark;
import electroblob.wizardry.entity.projectile.EntitySparkBomb;
import electroblob.wizardry.entity.projectile.EntityThunderbolt;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.integration.antiqueatlas.WizardryAntiqueAtlasIntegration;
import electroblob.wizardry.item.ItemScroll;
import electroblob.wizardry.item.ItemSpellBook;
import electroblob.wizardry.item.ItemWand;
import electroblob.wizardry.packet.PacketCastContinuousSpell;
import electroblob.wizardry.packet.PacketCastSpell;
import electroblob.wizardry.packet.PacketCastSpellAtPos;
import electroblob.wizardry.packet.PacketClairvoyance;
import electroblob.wizardry.packet.PacketConquerShrine;
import electroblob.wizardry.packet.PacketDispenserCastSpell;
import electroblob.wizardry.packet.PacketEmitterData;
import electroblob.wizardry.packet.PacketGlyphData;
import electroblob.wizardry.packet.PacketNPCCastSpell;
import electroblob.wizardry.packet.PacketPlayerSync;
import electroblob.wizardry.packet.PacketPossession;
import electroblob.wizardry.packet.PacketResurrection;
import electroblob.wizardry.packet.PacketSyncAdvancements;
import electroblob.wizardry.packet.PacketTransportation;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Clairvoyance;
import electroblob.wizardry.spell.None;
import electroblob.wizardry.spell.Possession;
import electroblob.wizardry.spell.Resurrection;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.tileentity.TileEntityArcaneWorkbench;
import electroblob.wizardry.tileentity.TileEntityImbuementAltar;
import electroblob.wizardry.tileentity.TileEntityLectern;
import electroblob.wizardry.tileentity.TileEntityMagicLight;
import electroblob.wizardry.tileentity.TileEntityShrineCore;
import electroblob.wizardry.tileentity.TileEntityStatue;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.WandHelper;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiMerchant;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.entity.RenderBlaze;
import net.minecraft.client.renderer.entity.RenderHusk;
import net.minecraft.client.renderer.entity.RenderSkeleton;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ContainerMerchant;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ClientProxy
extends CommonProxy {
    public static MixedFontRenderer mixedFontRenderer;
    private static final Map<ResourceLocation, ParticleWizardry.IWizardryParticleFactory> factories;
    public static final KeyBinding NEXT_SPELL;
    public static final KeyBinding PREVIOUS_SPELL;
    public static final KeyBinding[] SPELL_QUICK_ACCESS;
    public static final ModelBiped WIZARD_ARMOUR_MODEL;
    private static final int TOOLTIP_WRAP_WIDTH = 140;
    private static final ResourceLocation ICE_WRAITH_TEXTURE;
    private static final ResourceLocation LIGHTNING_WRAITH_TEXTURE;
    public static RenderStatue renderStatue;

    @Override
    public ModelBiped getWizardArmourModel() {
        return WIZARD_ARMOUR_MODEL;
    }

    @Override
    public void registerKeyBindings() {
        ClientRegistry.registerKeyBinding((KeyBinding)NEXT_SPELL);
        ClientRegistry.registerKeyBinding((KeyBinding)PREVIOUS_SPELL);
        for (KeyBinding key : SPELL_QUICK_ACCESS) {
            ClientRegistry.registerKeyBinding((KeyBinding)key);
        }
    }

    @Override
    public void initGuiBits() {
        mixedFontRenderer = new MixedFontRenderer(Minecraft.func_71410_x().field_71474_y, new ResourceLocation("textures/font/ascii.png"), Minecraft.func_71410_x().field_71446_o, false);
    }

    @Override
    public void registerResourceReloadListeners() {
        IResourceManager manager = Minecraft.func_71410_x().func_110442_L();
        if (manager instanceof IReloadableResourceManager) {
            ((IReloadableResourceManager)manager).func_110542_a(GuiSpellDisplay::loadSkins);
            ((IReloadableResourceManager)manager).func_110542_a(GuiWizardHandbook::loadHandbookFile);
        }
    }

    @Override
    public void registerAtlasMarkers() {
        WizardryAntiqueAtlasIntegration.registerMarkers();
    }

    @Override
    public void setToNumberSliderEntry(Property property) {
        property.setConfigEntryClass(GuiConfigEntries.NumberSliderEntry.class);
    }

    @Override
    public void setToHUDChooserEntry(Property property) {
        property.setConfigEntryClass(SpellHUDSkinChooserEntry.class);
    }

    @Override
    public void setToNamedBooleanEntry(Property property) {
        property.setConfigEntryClass(NamedBooleanEntry.class);
    }

    @Override
    public World getTheWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    @Override
    public EntityPlayer getThePlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public boolean isFirstPerson(Entity entity) {
        return entity == Minecraft.func_71410_x().func_175606_aa() && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0;
    }

    @Override
    public void playBlinkEffect(EntityPlayer player) {
        if (Minecraft.func_71410_x().field_71439_g == player) {
            RenderBlinkEffect.playBlinkEffect();
        }
    }

    @Override
    public void shakeScreen(EntityPlayer player, float intensity) {
        if (Minecraft.func_71410_x().field_71439_g == player) {
            ScreenShakeHandler.shakeScreen(intensity);
        }
    }

    @Override
    public void loadShader(EntityPlayer player, ResourceLocation shader) {
        if (Minecraft.func_71410_x().field_71439_g == player && Wizardry.settings.useShaders && !Minecraft.func_71410_x().field_71460_t.func_147702_a()) {
            Minecraft.func_71410_x().field_71460_t.func_175069_a(shader);
        }
    }

    @Override
    public Set<String> getSpellHUDSkins() {
        return GuiSpellDisplay.getSkinKeys();
    }

    @Override
    public void notifyBookshelfChange(World world, BlockPos pos) {
        super.notifyBookshelfChange(world, pos);
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player.func_174818_b(pos) < 1024.0 && Minecraft.func_71410_x().field_71462_r instanceof GuiLectern) {
            ((GuiLectern)Minecraft.func_71410_x().field_71462_r).refreshAvailableSpells();
        }
    }

    @Override
    public void playMovingSound(Entity entity, SoundEvent sound, SoundCategory category, float volume, float pitch, boolean repeat) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a(new MovingSoundEntity<Entity>(entity, sound, category, volume, pitch, repeat));
    }

    @Override
    public void playChargeupSound(EntityLivingBase entity) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new MovingSoundSpellCharge(entity, WizardrySounds.ITEM_WAND_CHARGEUP, WizardrySounds.SPELLS, 2.5f, 1.4f, false));
    }

    @Override
    public void playSpellSoundLoop(EntityLivingBase entity, Spell spell, SoundEvent start, SoundEvent loop, SoundEvent end, SoundCategory category, float volume, float pitch) {
        SoundLoop.addLoop(new SoundLoopSpell.SoundLoopSpellEntity(start, loop, end, spell, entity, volume, pitch));
    }

    @Override
    public void playSpellSoundLoop(World world, double x, double y, double z, Spell spell, SoundEvent start, SoundEvent loop, SoundEvent end, SoundCategory category, float volume, float pitch, int duration) {
        if (duration == -1) {
            SoundLoop.addLoop(new SoundLoopSpell.SoundLoopSpellDispenser(start, loop, end, spell, world, x, y, z, volume, pitch));
        } else {
            SoundLoop.addLoop(new SoundLoopSpell.SoundLoopSpellPosTimed(start, loop, end, spell, duration, x, y, z, volume, pitch));
        }
    }

    @Override
    public boolean shouldDisplayDiscovered(Spell spell, @Nullable ItemStack stack) {
        MerchantRecipeList recipes;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return false;
        }
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiMerchant && (recipes = ((GuiMerchant)Minecraft.func_71410_x().field_71462_r).func_147035_g().func_70934_b((EntityPlayer)player)) != null && recipes.stream().anyMatch(r -> r.func_77397_d() == stack)) {
            return true;
        }
        if (player.field_71070_bA instanceof ContainerMerchant && ((ContainerMerchant)player.field_71070_bA).func_75174_d().func_70301_a(2) == stack) {
            return true;
        }
        if (!Wizardry.settings.discoveryMode) {
            return true;
        }
        if (player.func_184812_l_()) {
            return true;
        }
        return WizardData.get((EntityPlayer)player) != null && WizardData.get((EntityPlayer)player).hasSpellBeenDiscovered(spell);
    }

    @Override
    public FontRenderer getFontRenderer(ItemStack stack) {
        Spell spell = Spells.none;
        if (stack.func_77973_b() instanceof ItemWand) {
            spell = WandHelper.getCurrentSpell(stack);
        } else if (stack.func_77973_b() instanceof ItemSpellBook || stack.func_77973_b() instanceof ItemScroll) {
            spell = Spell.byMetadata(stack.func_77952_i());
        }
        if (!this.shouldDisplayDiscovered(spell, stack)) {
            return mixedFontRenderer;
        }
        return null;
    }

    @Override
    public String getScrollDisplayName(ItemStack scroll) {
        Spell spell = Spell.byMetadata(scroll.func_77952_i());
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        boolean discovered = true;
        if (player != null && Wizardry.settings.discoveryMode && !player.func_184812_l_() && WizardData.get((EntityPlayer)player) != null && !WizardData.get((EntityPlayer)player).hasSpellBeenDiscovered(spell)) {
            discovered = false;
        }
        if (discovered) {
            return I18n.func_135052_a((String)"item.ebwizardry:scroll.name", (Object[])new Object[]{spell.getDisplayName()}).trim();
        }
        return I18n.func_135052_a((String)"item.ebwizardry:scroll.undiscovered.name", (Object[])new Object[]{"#" + SpellGlyphData.getGlyphName(spell, player.field_70170_p) + "#"}).trim();
    }

    @Override
    public double getConjuredBowDurability(ItemStack stack) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player.func_184607_cu() == stack) {
            return (double)(stack.func_77952_i() + player.func_184612_cw()) / (double)stack.func_77958_k();
        }
        return super.getConjuredBowDurability(stack);
    }

    @Override
    public String translate(String key, Style style, Object ... args) {
        return style.func_150218_j() + I18n.func_135052_a((String)key, (Object[])args);
    }

    @Override
    public void addMultiLineDescription(List<String> tooltip, String key, Style style, Object ... args) {
        tooltip.addAll(Minecraft.func_71410_x().field_71466_p.func_78271_c(this.translate(key, style, args), 140));
    }

    public static void addParticleFactory(ResourceLocation name, ParticleWizardry.IWizardryParticleFactory factory) {
        factories.put(name, factory);
    }

    @Override
    public void registerParticles() {
        ParticleWizardry.registerParticle(ParticleBuilder.Type.BEAM, ParticleBeam::new);
        ParticleWizardry.registerParticle(ParticleBuilder.Type.BLOCK_HIGHLIGHT, ParticleBlockHighlight::new);
        ParticleWizardry.registerParticle(ParticleBuilder.Type.BUFF, ParticleBuff::new);
        ParticleWizardry.registerParticle(ParticleBuilder.Type.CLOUD, ParticleCloud::new);
        ParticleWizardry.registerParticle(ParticleBuilder.Type.DARK_MAGIC, ParticleDarkMagic::new);
        ParticleWizardry.registerParticle(ParticleBuilder.Type.DUST, ParticleDust::new);
        ParticleWizardry.registerParticle(ParticleBuilder.Type.FLASH, ParticleFlash::new);
        ParticleWizardry.registerParticle(ParticleBuilder.Type.GUARDIAN_BEAM, ParticleGuardianBeam::new);
        ParticleWizardry.registerParticle(ParticleBuilder.Type.ICE, ParticleIce::new);
        ParticleWizardry.registerParticle(ParticleBuilder.Type.LEAF, ParticleLeaf::new);
        ParticleWizardry.registerParticle(ParticleBuilder.Type.LIGHTNING, ParticleLightning::new);
        ParticleWizardry.registerParticle(ParticleBuilder.Type.LIGHTNING_PULSE, ParticleLightningPulse::new);
        ParticleWizardry.registerParticle(ParticleBuilder.Type.MAGIC_BUBBLE, ParticleMagicBubble::new);
        ParticleWizardry.registerParticle(ParticleBuilder.Type.MAGIC_FIRE, ParticleMagicFlame::new);
        ParticleWizardry.registerParticle(ParticleBuilder.Type.PATH, ParticlePath::new);
        ParticleWizardry.registerParticle(ParticleBuilder.Type.SCORCH, ParticleScorch::new);
        ParticleWizardry.registerParticle(ParticleBuilder.Type.SNOW, ParticleSnow::new);
        ParticleWizardry.registerParticle(ParticleBuilder.Type.SPARK, ParticleSpark::new);
        ParticleWizardry.registerParticle(ParticleBuilder.Type.SPARKLE, ParticleSparkle::new);
        ParticleWizardry.registerParticle(ParticleBuilder.Type.SPHERE, ParticleSphere::new);
        ParticleWizardry.registerParticle(ParticleBuilder.Type.VINE, ParticleVine::new);
    }

    @Override
    public ParticleWizardry createParticle(ResourceLocation type, World world, double x, double y, double z) {
        ParticleWizardry.IWizardryParticleFactory factory = factories.get(type);
        if (factory == null) {
            Wizardry.logger.warn("Unrecognised particle type {} ! Ensure the particle is properly registered.", (Object)type);
            return null;
        }
        return factory.createParticle(world, x, y, z);
    }

    @Override
    public void spawnTornadoParticle(World world, double x, double y, double z, double velX, double velZ, double radius, int maxAge, IBlockState block, BlockPos pos) {
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleTornado(world, maxAge, x, z, radius, y, velX, velZ, block).func_174846_a(pos));
    }

    @Override
    public void handleCastSpellPacket(PacketCastSpell.Message message) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        Entity caster = world.func_73045_a(message.casterID);
        Spell spell = Spell.byNetworkID(message.spellID);
        if (caster instanceof EntityPlayer) {
            ((EntityPlayer)caster).func_184598_c(message.hand);
            spell.cast((World)world, (EntityPlayer)caster, message.hand, 0, message.modifiers);
            SpellCastEvent.Source source = SpellCastEvent.Source.OTHER;
            Item item = ((EntityPlayer)caster).func_184586_b(message.hand).func_77973_b();
            if (item instanceof ItemWand) {
                source = SpellCastEvent.Source.WAND;
            } else if (item instanceof ItemScroll) {
                source = SpellCastEvent.Source.SCROLL;
            }
            MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Post(source, spell, (EntityLivingBase)((EntityPlayer)caster), message.modifiers));
        } else {
            Wizardry.logger.warn("Recieved a PacketCastSpell, but the caster ID was not the ID of a player");
        }
    }

    @Override
    public void handleCastSpellAtPosPacket(PacketCastSpellAtPos.Message message) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        Spell spell = Spell.byNetworkID(message.spellID);
        spell.cast((World)world, message.position.field_72450_a, message.position.field_72448_b, message.position.field_72449_c, message.direction, 0, message.duration, message.modifiers);
        MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Post(SpellCastEvent.Source.COMMAND, spell, (World)world, message.position.field_72450_a, message.position.field_72448_b, message.position.field_72449_c, message.direction, message.modifiers));
        if (spell.isContinuous) {
            SpellEmitter.add(spell, (World)world, message.position.field_72450_a, message.position.field_72448_b, message.position.field_72449_c, message.direction, message.duration, message.modifiers);
        }
    }

    @Override
    public void handleCastContinuousSpellPacket(PacketCastContinuousSpell.Message message) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        Entity caster = world.func_73045_a(message.casterID);
        Spell spell = Spell.byNetworkID(message.spellID);
        if (caster instanceof EntityPlayer) {
            WizardData data = WizardData.get((EntityPlayer)caster);
            if (data != null) {
                if (data.isCasting()) {
                    WizardData.get((EntityPlayer)caster).stopCastingContinuousSpell();
                } else {
                    WizardData.get((EntityPlayer)caster).startCastingContinuousSpell(spell, message.modifiers, message.duration);
                }
            }
        } else {
            Wizardry.logger.warn("Recieved a PacketCastContinuousSpell, but the caster ID was not the ID of a player");
        }
    }

    @Override
    public void handleNPCCastSpellPacket(PacketNPCCastSpell.Message message) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        Entity caster = world.func_73045_a(message.casterID);
        Entity target = message.targetID == -1 ? null : world.func_73045_a(message.targetID);
        Spell spell = Spell.byNetworkID(message.spellID);
        if (caster instanceof EntityLiving) {
            if (target instanceof EntityLivingBase) {
                spell.cast((World)world, (EntityLiving)caster, message.hand, 0, (EntityLivingBase)target, message.modifiers);
                MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Post(SpellCastEvent.Source.NPC, spell, (EntityLivingBase)((EntityLiving)caster), message.modifiers));
                if (caster instanceof ISpellCaster && (spell.isContinuous || spell instanceof None)) {
                    ((ISpellCaster)caster).setContinuousSpell(spell);
                    ((ISpellCaster)caster).setSpellCounter(spell instanceof None ? 0 : 1);
                    ((EntityLiving)caster).func_70624_b((EntityLivingBase)target);
                }
            }
        } else if (caster != null) {
            Wizardry.logger.warn("Recieved a PacketNPCCastSpell, but the caster ID was not the ID of an EntityLiving");
        }
    }

    @Override
    public void handleDispenserCastSpellPacket(PacketDispenserCastSpell.Message message) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world.func_175625_s(message.pos) instanceof TileEntityDispenser) {
            Spell spell = Spell.byNetworkID(message.spellID);
            spell.cast((World)world, message.x, message.y, message.z, message.direction, 0, -1, message.modifiers);
            MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Post(SpellCastEvent.Source.DISPENSER, spell, (World)world, message.x, message.y, message.z, message.direction, message.modifiers));
            if (spell.isContinuous || spell instanceof None) {
                DispenserCastingData data = DispenserCastingData.get((TileEntityDispenser)world.func_175625_s(message.pos));
                if (spell.isContinuous) {
                    data.startCasting(spell, message.x, message.y, message.z, message.duration, message.modifiers);
                } else {
                    data.stopCasting();
                }
            }
        } else {
            Wizardry.logger.warn("Recieved a PacketDispenserCastSpell, but no tileEntity was found at the supplied location.");
        }
    }

    @Override
    public void handleTransportationPacket(PacketTransportation.Message message) {
        double z;
        double y;
        double x;
        float angle;
        double radius;
        int i;
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        BlockPos pos = message.destination;
        Entity entity = world.func_73045_a(message.dismountEntityID);
        if (message.dismountEntityID != -1 && entity != null) {
            entity.func_184210_p();
        }
        world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), WizardrySounds.SPELL_TRANSPORTATION_TRAVEL, WizardrySounds.SPELLS, 1.0f, 1.0f, false);
        for (i = 0; i < 20; ++i) {
            radius = 1.0;
            angle = world.field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
            x = (double)pos.func_177958_n() + 0.5 + radius * (double)MathHelper.func_76134_b((float)angle);
            y = (double)pos.func_177956_o() + world.field_73012_v.nextDouble() * 2.0;
            z = (double)pos.func_177952_p() + 0.5 + radius * (double)MathHelper.func_76126_a((float)angle);
            ParticleBuilder.create(ParticleBuilder.Type.SPARKLE).pos(x, y, z).vel(0.0, 0.02, 0.0).clr(0.6f, 1.0f, 0.6f).time(80 + world.field_73012_v.nextInt(10)).spawn((World)world);
        }
        for (i = 0; i < 20; ++i) {
            radius = 1.0;
            angle = world.field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
            x = (double)pos.func_177958_n() + 0.5 + radius * (double)MathHelper.func_76134_b((float)angle);
            y = (double)pos.func_177956_o() + world.field_73012_v.nextDouble() * 2.0;
            z = (double)pos.func_177952_p() + 0.5 + radius * (double)MathHelper.func_76126_a((float)angle);
            world.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, x, y, z, 0.0, 0.02, 0.0, new int[0]);
        }
        for (i = 0; i < 20; ++i) {
            radius = 1.0;
            angle = world.field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
            x = (double)pos.func_177958_n() + 0.5 + radius * (double)MathHelper.func_76134_b((float)angle);
            y = (double)pos.func_177956_o() + world.field_73012_v.nextDouble() * 2.0;
            z = (double)pos.func_177952_p() + 0.5 + radius * (double)MathHelper.func_76126_a((float)angle);
            world.func_175688_a(EnumParticleTypes.ENCHANTMENT_TABLE, x, y, z, 0.0, 0.02, 0.0, new int[0]);
        }
    }

    @Override
    public void handlePlayerSyncPacket(PacketPlayerSync.Message message) {
        WizardData data = WizardData.get((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        if (data != null) {
            Entity entity;
            data.synchronisedRandom.setSeed(message.seed);
            data.spellsDiscovered = message.spellsDiscovered;
            message.spellData.forEach(data::setVariable);
            data.selectedMinion = message.selectedMinionID == -1 ? null : ((entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.selectedMinionID)) instanceof ISummonedCreature ? new WeakReference<ISummonedCreature>((ISummonedCreature)entity) : null);
        }
    }

    @Override
    public void handleGlyphDataPacket(PacketGlyphData.Message message) {
        SpellGlyphData data = SpellGlyphData.get((World)Minecraft.func_71410_x().field_71441_e);
        data.randomNames = new HashMap<Spell, String>();
        data.randomDescriptions = new HashMap<Spell, String>();
        for (Spell spell : Spell.getAllSpells()) {
            if (spell.networkID() > message.names.size()) {
                Wizardry.logger.warn("Received no glyph data for spell {}, skipping", (Object)spell.getRegistryName());
                continue;
            }
            data.randomNames.put(spell, message.names.get(spell.networkID() - 1));
            data.randomDescriptions.put(spell, message.descriptions.get(spell.networkID() - 1));
        }
    }

    @Override
    public void handleEmitterDataPacket(PacketEmitterData.Message message) {
        message.emitters.forEach(e -> e.setWorld((World)Minecraft.func_71410_x().field_71441_e));
        SpellEmitterData data = SpellEmitterData.get((World)Minecraft.func_71410_x().field_71441_e);
        message.emitters.forEach(data::add);
    }

    @Override
    public void handleClairvoyancePacket(PacketClairvoyance.Message message) {
        Clairvoyance.spawnPathPaticles((World)Minecraft.func_71410_x().field_71441_e, message.path, message.durationMultiplier);
    }

    @Override
    public void handleAdvancementSyncPacket(PacketSyncAdvancements.Message message) {
        GuiWizardHandbook.updateUnlockStatus(message.showToasts, message.completedAdvancements);
    }

    @Override
    public void handleResurrectionPacket(PacketResurrection.Message message) {
        Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.playerID);
        if (entity instanceof EntityPlayer) {
            ((Resurrection)Spells.resurrection).resurrect((EntityPlayer)entity);
            if (entity == Minecraft.func_71410_x().field_71439_g) {
                Minecraft.func_71410_x().field_71441_e.func_72838_d(entity);
                Minecraft.func_71410_x().func_147108_a(null);
            }
        } else {
            Wizardry.logger.warn("Received a PacketResurrection, but the entity ID did not match any player");
        }
    }

    @Override
    public void handlePossessionPacket(PacketPossession.Message message) {
        Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.playerID);
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (message.targetID == -1) {
                ((Possession)Spells.possession).endPossession(player);
            } else {
                Entity target = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.targetID);
                if (target instanceof EntityLiving) {
                    ((Possession)Spells.possession).possess(player, (EntityLiving)target, message.duration);
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("spell." + Spells.possession.getRegistryName() + ".success", new Object[]{Minecraft.func_71410_x().field_71474_y.field_74311_E.getDisplayName()}), true);
                } else {
                    Wizardry.logger.warn("Received a PacketPossession, but the target ID did not match any living entity");
                }
            }
        } else {
            Wizardry.logger.warn("Received a PacketPossession, but the player ID did not match any player");
        }
    }

    @Override
    public void handleConquerShrinePacket(PacketConquerShrine.Message message) {
        TileEntity tileEntity = Minecraft.func_71410_x().field_71441_e.func_175625_s(new BlockPos(message.x, message.y, message.z));
        if (tileEntity instanceof TileEntityShrineCore) {
            ((TileEntityShrineCore)tileEntity).conquer();
        } else {
            Wizardry.logger.warn("Received a PacketConquerShrine, but there was no shrine core at the position sent");
        }
    }

    @Override
    public void initialiseLayers() {
        LayerTiledOverlay.initialiseLayers(LayerStone::new);
        LayerTiledOverlay.initialiseLayers(LayerFrost::new);
        LayerTiledOverlay.initialiseLayers(LayerMindControl::new);
        LayerTiledOverlay.initialiseLayers(LayerSummonAnimation::new);
        LayerTiledOverlay.initialiseLayers(LayerDisintegrateAnimation::new);
    }

    @Override
    public void initialiseAnimations() {
        PlayerAnimator.init();
        ActionAnimation.register();
    }

    @Override
    public void registerRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(EntityHuskMinion.class, RenderHusk::new);
        RenderingRegistry.registerEntityRenderingHandler(EntitySkeletonMinion.class, RenderSkeleton::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityStrayMinion.class, RenderStrayMinion::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityLightningWraith.class, manager -> new RenderBlaze(manager){

            protected ResourceLocation func_110775_a(EntityBlaze entity) {
                return LIGHTNING_WRAITH_TEXTURE;
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityIceWraith.class, manager -> new RenderBlaze(manager){

            protected ResourceLocation func_110775_a(EntityBlaze entity) {
                return ICE_WRAITH_TEXTURE;
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityIceGiant.class, RenderIceGiant::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityPhoenix.class, RenderPhoenix::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityMagicMissile.class, manager -> new RenderMagicArrow(manager, new ResourceLocation("ebwizardry", "textures/entity/magic_missile.png"), false, 8.0, 4.0, 16, 9, false));
        RenderingRegistry.registerEntityRenderingHandler(EntityIceShard.class, manager -> new RenderMagicArrow(manager, new ResourceLocation("ebwizardry", "textures/entity/ice_shard.png"), false, 8.0, 2.0, 16, 5, false));
        RenderingRegistry.registerEntityRenderingHandler(EntityLightningArrow.class, manager -> new RenderMagicArrow(manager, new ResourceLocation("ebwizardry", "textures/entity/lightning_arrow.png"), true, 8.0, 2.0, 16, 5, false));
        RenderingRegistry.registerEntityRenderingHandler(EntityDart.class, manager -> new RenderMagicArrow(manager, new ResourceLocation("ebwizardry", "textures/entity/dart.png"), false, 8.0, 2.0, 16, 5, true));
        RenderingRegistry.registerEntityRenderingHandler(EntityIceLance.class, manager -> new RenderMagicArrow(manager, new ResourceLocation("ebwizardry", "textures/entity/ice_lance.png"), false, 16.0, 3.0, 22, 5, false));
        RenderingRegistry.registerEntityRenderingHandler(EntityFlamecatcherArrow.class, manager -> new RenderMagicArrow(manager, new ResourceLocation("ebwizardry", "textures/entity/flamecatcher_arrow.png"), false, 8.0, 2.0, 16, 5, true));
        RenderingRegistry.registerEntityRenderingHandler(EntityForceArrow.class, RenderForceArrow::new);
        RenderingRegistry.registerEntityRenderingHandler(EntitySpiritWolf.class, RenderSpiritWolf::new);
        RenderingRegistry.registerEntityRenderingHandler(EntitySpiritHorse.class, RenderSpiritHorse::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityWizard.class, RenderWizard::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityEvilWizard.class, RenderEvilWizard::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityDecoy.class, RenderDecoy::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityRemnant.class, RenderRemnant::new);
        RenderingRegistry.registerEntityRenderingHandler(EntitySparkBomb.class, manager -> new RenderProjectile(manager, 0.6f, new ResourceLocation("ebwizardry", "textures/items/spark_bomb.png"), false));
        RenderingRegistry.registerEntityRenderingHandler(EntityFirebomb.class, manager -> new RenderProjectile(manager, 0.6f, new ResourceLocation("ebwizardry", "textures/items/firebomb.png"), false));
        RenderingRegistry.registerEntityRenderingHandler(EntityPoisonBomb.class, manager -> new RenderProjectile(manager, 0.6f, new ResourceLocation("ebwizardry", "textures/items/poison_bomb.png"), false));
        RenderingRegistry.registerEntityRenderingHandler(EntityIceCharge.class, manager -> new RenderProjectile(manager, 0.6f, new ResourceLocation("ebwizardry", "textures/entity/ice_charge.png"), false));
        RenderingRegistry.registerEntityRenderingHandler(EntityForceOrb.class, manager -> new RenderProjectile(manager, 0.7f, new ResourceLocation("ebwizardry", "textures/entity/force_orb.png"), true));
        RenderingRegistry.registerEntityRenderingHandler(EntitySpark.class, manager -> new RenderProjectile(manager, 0.4f, new ResourceLocation("ebwizardry", "textures/entity/spark.png"), true));
        RenderingRegistry.registerEntityRenderingHandler(EntityDarknessOrb.class, manager -> new RenderProjectile(manager, 0.6f, new ResourceLocation("ebwizardry", "textures/entity/darkness_orb.png"), true));
        RenderingRegistry.registerEntityRenderingHandler(EntityFirebolt.class, manager -> new RenderProjectile(manager, 0.2f, new ResourceLocation("ebwizardry", "textures/entity/firebolt.png"), false));
        RenderingRegistry.registerEntityRenderingHandler(EntityLightningDisc.class, manager -> new RenderLightningDisc(manager, new ResourceLocation("ebwizardry", "textures/entity/lightning_sigil.png"), 2.0f));
        RenderingRegistry.registerEntityRenderingHandler(EntitySmokeBomb.class, manager -> new RenderProjectile(manager, 0.6f, new ResourceLocation("ebwizardry", "textures/items/smoke_bomb.png"), false));
        RenderingRegistry.registerEntityRenderingHandler(EntityEmber.class, manager -> new RenderProjectile(manager, 0.15f, new ResourceLocation("ebwizardry", "textures/entity/ember.png"), false));
        RenderingRegistry.registerEntityRenderingHandler(EntityMagicFireball.class, manager -> new RenderProjectile(manager, 0.7f, new ResourceLocation("ebwizardry", "textures/entity/fireball.png"), false));
        RenderingRegistry.registerEntityRenderingHandler(EntityLargeMagicFireball.class, manager -> new RenderProjectile(manager, 1.5f, new ResourceLocation("ebwizardry", "textures/entity/fireball.png"), false));
        RenderingRegistry.registerEntityRenderingHandler(EntityIceball.class, manager -> new RenderProjectile(manager, 0.7f, new ResourceLocation("ebwizardry", "textures/entity/iceball.png"), false));
        RenderingRegistry.registerEntityRenderingHandler(EntityBlackHole.class, RenderBlackHole::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityShield.class, RenderBlank::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityBubble.class, RenderBubble::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityHammer.class, RenderHammer::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityIceSpike.class, RenderIceSpike::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityForcefield.class, RenderForcefield::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityZombieSpawner.class, RenderZombieSpawner::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityRadiantTotem.class, RenderRadiantTotem::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityBoulder.class, RenderBoulder::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityWitheringTotem.class, RenderWitheringTotem::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityIceBarrier.class, RenderIceBarrier::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityBlizzard.class, RenderBlank::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityTornado.class, RenderBlank::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityArrowRain.class, RenderBlank::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityShadowWraith.class, RenderBlank::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityThunderbolt.class, RenderBlank::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityStormElemental.class, RenderBlank::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityEarthquake.class, RenderBlank::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityHailstorm.class, RenderBlank::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityStormcloud.class, RenderBlank::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityHealAura.class, manager -> new RenderSigil(manager, new ResourceLocation("ebwizardry", "textures/entity/healing_aura.png"), 0.3f, false));
        RenderingRegistry.registerEntityRenderingHandler(EntityFireSigil.class, manager -> new RenderSigil(manager, new ResourceLocation("ebwizardry", "textures/entity/fire_sigil.png"), 0.0f, true));
        RenderingRegistry.registerEntityRenderingHandler(EntityFrostSigil.class, manager -> new RenderSigil(manager, new ResourceLocation("ebwizardry", "textures/entity/frost_sigil.png"), 0.0f, true));
        RenderingRegistry.registerEntityRenderingHandler(EntityLightningSigil.class, manager -> new RenderSigil(manager, new ResourceLocation("ebwizardry", "textures/entity/lightning_sigil.png"), 0.0f, true));
        RenderingRegistry.registerEntityRenderingHandler(EntityFireRing.class, manager -> new RenderFireRing(manager, new ResourceLocation("ebwizardry", "textures/entity/ring_of_fire.png")));
        RenderingRegistry.registerEntityRenderingHandler(EntityDecay.class, RenderDecay::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityCombustionRune.class, manager -> new RenderSigil(manager, new ResourceLocation("ebwizardry", "textures/entity/combustion_rune.png"), 0.0f, true));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityArcaneWorkbench.class, (TileEntitySpecialRenderer)new RenderArcaneWorkbench());
        renderStatue = new RenderStatue();
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityStatue.class, (TileEntitySpecialRenderer)renderStatue);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityMagicLight.class, (TileEntitySpecialRenderer)new RenderMagicLight());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityLectern.class, (TileEntitySpecialRenderer)new RenderLectern());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityImbuementAltar.class, (TileEntitySpecialRenderer)new RenderImbuementAltar());
    }

    static {
        factories = new HashMap<ResourceLocation, ParticleWizardry.IWizardryParticleFactory>();
        NEXT_SPELL = new KeyBinding("key.ebwizardry.next_spell", (IKeyConflictContext)KeyConflictContext.IN_GAME, 49, "key.categories.ebwizardry");
        PREVIOUS_SPELL = new KeyBinding("key.ebwizardry.previous_spell", (IKeyConflictContext)KeyConflictContext.IN_GAME, 48, "key.categories.ebwizardry");
        SPELL_QUICK_ACCESS = new KeyBinding[8];
        for (int i = 0; i < SPELL_QUICK_ACCESS.length; ++i) {
            ClientProxy.SPELL_QUICK_ACCESS[i] = new KeyBinding("key.ebwizardry.spell_" + (i + 1), (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.ALT, 2 + i, "key.categories.ebwizardry");
        }
        WIZARD_ARMOUR_MODEL = new ModelWizardArmour(0.75f);
        ICE_WRAITH_TEXTURE = new ResourceLocation("ebwizardry", "textures/entity/ice_wraith.png");
        LIGHTNING_WRAITH_TEXTURE = new ResourceLocation("ebwizardry", "textures/entity/lightning_wraith.png");
    }
}

