/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.client.gui.handbook;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.client.ClientProxy;
import electroblob.wizardry.client.DrawingUtils;
import electroblob.wizardry.client.gui.GuiButtonInvisible;
import electroblob.wizardry.client.gui.GuiButtonTurnPage;
import electroblob.wizardry.client.gui.handbook.Contents;
import electroblob.wizardry.client.gui.handbook.CraftingRecipe;
import electroblob.wizardry.client.gui.handbook.GuiButtonHyperlink;
import electroblob.wizardry.client.gui.handbook.Image;
import electroblob.wizardry.client.gui.handbook.Section;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.packet.PacketRequestAdvancementSync;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.registry.WizardrySounds;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;

public class GuiWizardHandbook
extends GuiScreen {
    private static final ResourceLocation DEFAULT = new ResourceLocation("ebwizardry", "texts/handbook_en_us.json");
    static final ResourceLocation texture = new ResourceLocation("ebwizardry", "textures/gui/handbook/handbook.png");
    private static final Gson gson = new Gson();
    static final char FORMAT_MARKER = '#';
    static final char HYPERLINK_MARKER = '@';
    static final String IMAGE_TAG = "image";
    static final String RECIPE_TAG = "recipe";
    static final String RULER_TAG = "ruler";
    static final Map<String, String> FORMAT_TAGS = new HashMap<String, String>();
    static final int GUI_WIDTH = 288;
    static final int GUI_HEIGHT = 180;
    static final int TEXTURE_WIDTH = 512;
    static final int TEXTURE_HEIGHT = 256;
    static final int PAGE_WIDTH = 120;
    static final int PAGE_HEIGHT = 140;
    static final int TEXT_INSET_X = 17;
    static final int TEXT_INSET_Y = 16;
    private static final int BUTTON_INSET_X = 22;
    private static final int BUTTON_INSET_Y = 13;
    private static final int BUTTON_SPACING = 20;
    private static final int PAGE_NUMBER_INSET = 22;
    private int currentPage = 0;
    private int pageCount = 1;
    private static int bookmarkPage = 0;
    private static String bookmarkSection;
    private GuiButton bookmark;
    private GuiButton next;
    private GuiButton previous;
    private GuiButton nextSection;
    private GuiButton previousSection;
    private GuiButton menu;
    static final Map<String, Section> sections;
    private static List<Section> sectionList;
    static final Map<String, Contents> contentsList;
    static final Map<String, Integer> colours;
    static final Map<String, Image> images;
    static final Map<String, CraftingRecipe> recipes;

    public static void addFormatTag(String tag, String value) {
        FORMAT_TAGS.put(tag, value);
    }

    private static void initFormatTags() {
        GuiWizardHandbook.addFormatTag("next_spell_key", ClientProxy.NEXT_SPELL.getDisplayName());
        GuiWizardHandbook.addFormatTag("previous_spell_key", ClientProxy.PREVIOUS_SPELL.getDisplayName());
        GuiWizardHandbook.addFormatTag("example_charging_loss", "70");
        GuiWizardHandbook.addFormatTag("mana_per_crystal", "100");
        GuiWizardHandbook.addFormatTag("novice_max_charge", "" + Tier.NOVICE.maxCharge);
        GuiWizardHandbook.addFormatTag("apprentice_max_charge", "" + Tier.APPRENTICE.maxCharge);
        GuiWizardHandbook.addFormatTag("advanced_max_charge", "" + Tier.ADVANCED.maxCharge);
        GuiWizardHandbook.addFormatTag("master_max_charge", "" + Tier.MASTER.maxCharge);
        GuiWizardHandbook.addFormatTag("version", "4.3.2");
        GuiWizardHandbook.addFormatTag("mcversion", "1.12.2");
        GuiWizardHandbook.addFormatTag("colour_novice", "\u00a77");
        GuiWizardHandbook.addFormatTag("colour_apprentice", Tier.APPRENTICE.getFormattingCode());
        GuiWizardHandbook.addFormatTag("colour_advanced", Tier.ADVANCED.getFormattingCode());
        GuiWizardHandbook.addFormatTag("colour_master", Tier.MASTER.getFormattingCode());
        GuiWizardHandbook.addFormatTag("colour_fire", Element.FIRE.getFormattingCode());
        GuiWizardHandbook.addFormatTag("colour_ice", Element.ICE.getFormattingCode());
        GuiWizardHandbook.addFormatTag("colour_lightning", Element.LIGHTNING.getFormattingCode());
        GuiWizardHandbook.addFormatTag("colour_necromancy", Element.NECROMANCY.getFormattingCode());
        GuiWizardHandbook.addFormatTag("colour_earth", Element.EARTH.getFormattingCode());
        GuiWizardHandbook.addFormatTag("colour_sorcery", Element.SORCERY.getFormattingCode());
        GuiWizardHandbook.addFormatTag("colour_healing", Element.HEALING.getFormattingCode());
        GuiWizardHandbook.addFormatTag("colour_reset", "\u00a70");
    }

    static int singleToDoublePage(int singlePageIndex) {
        return singlePageIndex / 2;
    }

    static int doubleToSinglePage(int doublePageIndex, boolean rightHandPage) {
        return rightHandPage ? doublePageIndex * 2 + 1 : doublePageIndex * 2;
    }

    static boolean isRightPage(int page) {
        return page % 2 == 1;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        String pageNumber;
        this.func_146276_q_();
        int left = this.field_146294_l / 2 - 144;
        int top = this.field_146295_m / 2 - 90;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        DrawingUtils.drawTexturedRect(left, top, 0, 0, 288, 180, 512, 256);
        if (this.currentPage == 0) {
            DrawingUtils.drawTexturedRect(left, top, 368, 0, 144, 180, 512, 256);
            this.previous.field_146125_m = false;
            this.previousSection.field_146125_m = false;
            this.menu.field_146125_m = false;
        } else {
            this.previous.field_146125_m = true;
            this.previousSection.field_146125_m = true;
            this.menu.field_146125_m = true;
        }
        if (this.currentPage == GuiWizardHandbook.singleToDoublePage(this.pageCount)) {
            DrawingUtils.drawTexturedFlippedRect(left + 144, top, 368, 0, 144, 180, 512, 256, true, false);
            this.next.field_146125_m = false;
            this.nextSection.field_146125_m = false;
        } else {
            this.next.field_146125_m = true;
            this.nextSection.field_146125_m = true;
        }
        if (this.currentPage > 0) {
            pageNumber = "" + GuiWizardHandbook.doubleToSinglePage(this.currentPage, false);
            this.field_146289_q.func_78276_b(pageNumber, left + 17 + 60 - this.field_146289_q.func_78256_a(pageNumber) / 2, top + 180 - 22, 1);
        }
        if (this.currentPage < GuiWizardHandbook.singleToDoublePage(this.pageCount)) {
            pageNumber = "" + GuiWizardHandbook.doubleToSinglePage(this.currentPage, true);
            this.field_146289_q.func_78276_b(pageNumber, left + 288 - 17 - 60 - this.field_146289_q.func_78256_a(pageNumber) / 2, top + 180 - 22, 1);
        }
        contentsList.values().forEach(c -> {
            if (c.section.isUnlocked()) {
                c.draw(this.field_146289_q, this.currentPage, left, top);
            }
        });
        sections.values().forEach(s -> {
            if (s.isUnlocked()) {
                s.draw(this.field_146289_q, this.currentPage, left, top);
            }
        });
        images.values().forEach(i -> i.draw(this.field_146289_q, this.currentPage, left, top));
        recipes.values().forEach(r -> r.draw(this.field_146289_q, this.field_146296_j, this.currentPage, left, top));
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
        if (this.currentPage == GuiWizardHandbook.singleToDoublePage(GuiWizardHandbook.sections.get((Object)GuiWizardHandbook.bookmarkSection).startPage) + bookmarkPage) {
            this.bookmark.field_146125_m = false;
            DrawingUtils.drawTexturedRect(left + 138, top, 299, 0, 11, 191, 512, 256);
        } else {
            this.bookmark.field_146125_m = true;
            this.bookmark.field_146128_h = left + (this.currentPage > GuiWizardHandbook.singleToDoublePage(GuiWizardHandbook.sections.get((Object)GuiWizardHandbook.bookmarkSection).startPage) + bookmarkPage ? 130 : 147);
            DrawingUtils.drawTexturedRect(this.bookmark.field_146128_h, top, this.bookmark.func_146115_a() ? 310 : 288, 0, 11, 191, 512, 256);
        }
        recipes.values().forEach(r -> r.drawTooltips(this, this.field_146289_q, this.field_146296_j, this.currentPage, left, top, mouseX, mouseY));
    }

    public void func_175273_b(Minecraft minecraft, int width, int height) {
        this.func_73866_w_();
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        GuiWizardHandbook.initFormatTags();
        int left = this.field_146294_l / 2 - 144;
        int top = this.field_146295_m / 2 - 90;
        recipes.values().forEach(CraftingRecipe::load);
        int nextButtonId = 0;
        this.field_146292_n.clear();
        this.next = new GuiButtonTurnPage(nextButtonId++, left + 288 - 22 - 20, top + 180 - 13 - 12, GuiButtonTurnPage.Type.NEXT_PAGE, texture, 512, 256);
        this.field_146292_n.add(this.next);
        this.previous = new GuiButtonTurnPage(nextButtonId++, left + 22, top + 180 - 13 - 12, GuiButtonTurnPage.Type.PREVIOUS_PAGE, texture, 512, 256);
        this.field_146292_n.add(this.previous);
        this.nextSection = new GuiButtonTurnPage(nextButtonId++, left + 288 - 22 - 20 - 20, top + 180 - 13 - 12, GuiButtonTurnPage.Type.NEXT_SECTION, texture, 512, 256);
        this.field_146292_n.add(this.nextSection);
        this.previousSection = new GuiButtonTurnPage(nextButtonId++, left + 22 + 20, top + 180 - 13 - 12, GuiButtonTurnPage.Type.PREVIOUS_SECTION, texture, 512, 256);
        this.field_146292_n.add(this.previousSection);
        this.menu = new GuiButtonTurnPage(nextButtonId++, left + 144 - 28, top + 180 - 13 - 12, GuiButtonTurnPage.Type.CONTENTS, texture, 512, 256);
        this.field_146292_n.add(this.menu);
        this.bookmark = new GuiButtonInvisible(nextButtonId++, left + 130, top + 172, 11, 19){

            public void func_146113_a(SoundHandler soundHandler) {
                soundHandler.func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)WizardrySounds.MISC_PAGE_TURN, (float)1.0f));
            }
        };
        this.field_146292_n.add(this.bookmark);
        this.pageCount = 1;
        images.values().forEach(Image::clearInstances);
        recipes.values().forEach(CraftingRecipe::clearInstances);
        for (Section section : sections.values()) {
            if (!section.isUnlocked()) continue;
            this.pageCount = section.format(this.field_146289_q, this.pageCount, left, top);
            this.field_146292_n.addAll(section.getButtons());
        }
        contentsList.values().forEach(c -> this.field_146292_n.addAll(c.getButtons()));
        this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)WizardrySounds.MISC_BOOK_OPEN, (float)1.0f));
    }

    public static void loadHandbookFile(IResourceManager manager) {
        if (manager == null) {
            Wizardry.logger.error("Tried to reload the handbook file, but received a null resource manager. Aborting!");
            return;
        }
        IResource handbookFile = GuiWizardHandbook.getHandbookResource(manager);
        if (handbookFile != null) {
            images.clear();
            sections.clear();
            contentsList.clear();
            colours.clear();
            bookmarkSection = null;
            BufferedReader reader = new BufferedReader(new InputStreamReader(handbookFile.func_110527_b(), StandardCharsets.UTF_8));
            JsonElement je = (JsonElement)gson.fromJson((Reader)reader, JsonElement.class);
            JsonObject json = je.getAsJsonObject();
            JsonUtils.func_152754_s((JsonObject)json, (String)"colours").entrySet().forEach(e -> colours.put((String)e.getKey(), Color.decode(((JsonElement)e.getValue()).getAsString()).getRGB()));
            Image.populate(images, json);
            CraftingRecipe.populate(recipes, json);
            Section.populate(sections, json);
            sectionList = Collections.unmodifiableList(new ArrayList<Section>(sections.values()));
            if (sections.isEmpty()) {
                Wizardry.logger.warn("Handbook has no sections! Aborting loading...");
                return;
            }
            bookmarkSection = JsonUtils.func_151200_h((JsonObject)json, (String)"bookmark_start_section");
            if (!sections.containsKey(bookmarkSection)) {
                throw new JsonSyntaxException("Section with id " + bookmarkSection + " is undefined");
            }
        }
        if (WizardryPacketHandler.net != null) {
            WizardryPacketHandler.net.sendToServer((IMessage)new PacketRequestAdvancementSync.Message());
        }
    }

    private static IResource getHandbookResource(IResourceManager manager) {
        IResource handbookFile = null;
        try {
            handbookFile = manager.func_110536_a(new ResourceLocation("ebwizardry", "texts/handbook_" + Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a() + ".json"));
        }
        catch (IOException e) {
            Wizardry.logger.info("Wizard handbook JSON file missing for the current language (" + Minecraft.func_71410_x().func_135016_M().func_135041_c() + "). Using default (English-US) instead.");
            try {
                handbookFile = manager.func_110536_a(DEFAULT);
            }
            catch (IOException x) {
                Wizardry.logger.error("Couldn't find file: " + DEFAULT + ". The file may be missing; please try re-downloading and reinstalling Wizardry.", (Throwable)x);
            }
        }
        return handbookFile;
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            if (button == this.next) {
                if (this.currentPage < GuiWizardHandbook.singleToDoublePage(this.pageCount)) {
                    ++this.currentPage;
                }
            } else if (button == this.previous) {
                if (this.currentPage > 0) {
                    --this.currentPage;
                }
            } else if (button == this.nextSection || button == this.previousSection) {
                Section currentSection = null;
                for (Section section : sections.values()) {
                    if (!section.containsPage(GuiWizardHandbook.doubleToSinglePage(this.currentPage, true))) continue;
                    currentSection = section;
                    break;
                }
                if (currentSection != null) {
                    ArrayList<Section> visibleSections = new ArrayList<Section>(sectionList);
                    visibleSections.removeIf(s -> !s.isUnlocked());
                    int index = visibleSections.indexOf(currentSection);
                    if (button == this.nextSection && index + 1 < visibleSections.size()) {
                        this.currentPage = GuiWizardHandbook.singleToDoublePage(((Section)visibleSections.get((int)(index + 1))).startPage);
                    } else if (index > 0) {
                        this.currentPage = GuiWizardHandbook.singleToDoublePage(((Section)visibleSections.get((int)(index - 1))).startPage);
                    }
                }
            } else if (button == this.menu) {
                this.currentPage = GuiWizardHandbook.singleToDoublePage(GuiWizardHandbook.sections.get((Object)"main_contents").startPage);
            } else if (button == this.bookmark && bookmarkSection != null) {
                this.currentPage = GuiWizardHandbook.singleToDoublePage(GuiWizardHandbook.sections.get((Object)GuiWizardHandbook.bookmarkSection).startPage) + bookmarkPage;
            } else if (button instanceof GuiButtonHyperlink.Internal) {
                this.currentPage = GuiWizardHandbook.singleToDoublePage(((GuiButtonHyperlink.Internal)button).target.startPage);
            } else if (button instanceof GuiButtonHyperlink.External) {
                this.func_175276_a(((GuiButtonHyperlink.External)button).link);
            }
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (mouseButton == 1) {
            if (this.bookmark.func_146116_c(this.field_146297_k, mouseX, mouseY)) {
                this.field_146290_a = this.bookmark;
                for (String key : sections.keySet()) {
                    if (!sections.get(key).containsPage(GuiWizardHandbook.doubleToSinglePage(this.currentPage, false))) continue;
                    bookmarkSection = key;
                }
                bookmarkPage = this.currentPage - GuiWizardHandbook.singleToDoublePage(GuiWizardHandbook.sections.get((Object)GuiWizardHandbook.bookmarkSection).startPage);
            }
        } else {
            super.func_73864_a(mouseX, mouseY, mouseButton);
        }
    }

    public void func_146285_a(ItemStack stack, int x, int y) {
        super.func_146285_a(stack, x, y);
    }

    public boolean func_73868_f() {
        return Wizardry.settings.booksPauseGame;
    }

    public static void updateUnlockStatus(boolean showToasts, ResourceLocation ... completedAdvancements) {
        sections.values().forEach(s -> s.updateUnlockStatus(showToasts, completedAdvancements));
    }

    static {
        sections = new LinkedHashMap<String, Section>();
        contentsList = new HashMap<String, Contents>();
        colours = new HashMap<String, Integer>();
        images = new HashMap<String, Image>();
        recipes = new HashMap<String, CraftingRecipe>();
    }
}

