/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.client.gui.handbook;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import electroblob.wizardry.client.DrawingUtils;
import electroblob.wizardry.client.gui.handbook.GuiWizardHandbook;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

class Image {
    private final ResourceLocation location;
    private final int width;
    private final int height;
    private int textureWidth;
    private int textureHeight;
    private int u = 0;
    private int v = 0;
    private String caption = "";
    private boolean border = true;
    private final Set<int[]> instances = new HashSet<int[]>();
    private static final int CAPTION_OFFSET = 4;
    private static final int TEXTURE_INSET_X = 180;
    private static final int BORDER = 1;

    private Image(ResourceLocation location, int width, int height) {
        this.location = location;
        this.width = width;
        this.height = height;
    }

    int getWidth() {
        return this.width;
    }

    int getHeight(FontRenderer font) {
        return this.caption.isEmpty() ? this.height : this.height + 4 + font.field_78288_b;
    }

    void addInstance(int page, int x, int y) {
        this.instances.add(new int[]{page, x, y});
    }

    void clearInstances() {
        this.instances.clear();
    }

    void draw(FontRenderer font, int doublePage, int left, int top) {
        for (int[] instance : this.instances) {
            if (GuiWizardHandbook.singleToDoublePage(instance[0]) != doublePage) continue;
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.location);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            DrawingUtils.drawTexturedRect(left + instance[1], top + instance[2], this.u, this.v, this.width, this.height, this.textureWidth, this.textureHeight);
            font.func_78276_b("\u00a7o" + this.caption, left + instance[1] + this.width / 2 - font.func_78256_a(this.caption) / 2, top + instance[2] + this.height + 4, GuiWizardHandbook.colours.get("caption").intValue());
        }
        if (this.border) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(GuiWizardHandbook.texture);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            for (int[] instance : this.instances) {
                if (GuiWizardHandbook.singleToDoublePage(instance[0]) != doublePage) continue;
                DrawingUtils.drawTexturedFlippedRect(left + instance[1] - 1, top + instance[2] - 1, 180, 180, this.width / 2 + 1, this.height / 2 + 1, 512, 256, false, false);
                DrawingUtils.drawTexturedFlippedRect(left + instance[1] + this.width / 2, top + instance[2] - 1, 180, 180, MathHelper.func_76123_f((float)((float)this.width / 2.0f)) + 1, this.height / 2 + 1, 512, 256, true, false);
                DrawingUtils.drawTexturedFlippedRect(left + instance[1] - 1, top + instance[2] + this.height / 2, 180, 180, this.width / 2 + 1, MathHelper.func_76123_f((float)((float)this.height / 2.0f)) + 1, 512, 256, false, true);
                DrawingUtils.drawTexturedFlippedRect(left + instance[1] + this.width / 2, top + instance[2] + this.height / 2, 180, 180, MathHelper.func_76123_f((float)((float)this.width / 2.0f)) + 1, MathHelper.func_76123_f((float)((float)this.height / 2.0f)) + 1, 512, 256, true, true);
            }
        }
    }

    static Image fromJson(JsonObject json) {
        Image image = new Image(new ResourceLocation(JsonUtils.func_151200_h((JsonObject)json, (String)"location")), JsonUtils.func_151203_m((JsonObject)json, (String)"width"), JsonUtils.func_151203_m((JsonObject)json, (String)"height"));
        image.u = JsonUtils.func_151208_a((JsonObject)json, (String)"u", (int)0);
        image.v = JsonUtils.func_151208_a((JsonObject)json, (String)"v", (int)0);
        image.textureWidth = JsonUtils.func_151208_a((JsonObject)json, (String)"texture_width", (int)image.width);
        image.textureHeight = JsonUtils.func_151208_a((JsonObject)json, (String)"texture_height", (int)image.height);
        image.caption = JsonUtils.func_151219_a((JsonObject)json, (String)"caption", (String)"");
        image.border = JsonUtils.func_151209_a((JsonObject)json, (String)"border", (boolean)true);
        return image;
    }

    static void populate(Map<String, Image> map, JsonObject json) {
        JsonObject sectionsObject = JsonUtils.func_152754_s((JsonObject)json, (String)"images");
        for (Map.Entry entry : sectionsObject.entrySet()) {
            String key = (String)entry.getKey();
            Image image = Image.fromJson(((JsonElement)entry.getValue()).getAsJsonObject());
            map.put(key, image);
        }
    }
}

