/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.entity.construct;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.entity.construct.EntityScaledConstruct;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityRadiantTotem
extends EntityScaledConstruct {
    private static final int PERIMETER_PARTICLE_DENSITY = 6;

    public EntityRadiantTotem(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
    }

    @Override
    protected boolean shouldScaleWidth() {
        return false;
    }

    @Override
    protected boolean shouldScaleHeight() {
        return false;
    }

    @Override
    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K && this.field_70173_aa == 1) {
            Wizardry.proxy.playMovingSound(this, WizardrySounds.ENTITY_RADIANT_TOTEM_AMBIENT, WizardrySounds.SPELLS, 1.0f, 1.0f, true);
        }
        super.func_70071_h_();
        double radius = Spells.radiant_totem.getProperty("effect_radius").floatValue() * this.sizeMultiplier;
        if (this.field_70170_p.field_72995_K) {
            ParticleBuilder.create(ParticleBuilder.Type.DUST, this.field_70146_Z, this.field_70165_t, this.field_70163_u + 0.2, this.field_70161_v, 0.3, false).vel(0.0, -0.02 - (double)this.field_70170_p.field_73012_v.nextFloat() * 0.01, 0.0).clr(0xFFFFFF).fade(16772240).spawn(this.field_70170_p);
            for (int i = 0; i < 6; ++i) {
                double z;
                float angle = 1.0471976f * ((float)i + this.field_70146_Z.nextFloat());
                double x = this.field_70165_t + radius * (double)MathHelper.func_76126_a((float)angle);
                Integer y = BlockUtils.getNearestSurface(this.field_70170_p, new BlockPos(x, this.field_70163_u, z = this.field_70161_v + radius * (double)MathHelper.func_76134_b((float)angle)), EnumFacing.UP, 5, true, BlockUtils.SurfaceCriteria.COLLIDABLE);
                if (y == null) continue;
                ParticleBuilder.create(ParticleBuilder.Type.DUST).pos(x, y.intValue(), z).vel(0.0, 0.01, 0.0).clr(0xFFFFFF).fade(16772240).spawn(this.field_70170_p);
            }
        }
        List<EntityLivingBase> nearby = EntityUtils.getLivingWithinRadius(radius, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70170_p);
        nearby.sort(Comparator.comparingDouble(e -> e.func_70068_e((Entity)this)));
        List nearbyAllies = nearby.stream().filter(e -> e == this.getCaster() || AllyDesignationSystem.isAllied(this.getCaster(), e)).collect(Collectors.toList());
        nearby.removeAll(nearbyAllies);
        int targetsRemaining = Spells.radiant_totem.getProperty("max_targets").intValue() + (int)((this.damageMultiplier - 1.0f) / 0.15f);
        while (!nearbyAllies.isEmpty() && targetsRemaining > 0) {
            EntityLivingBase ally = (EntityLivingBase)nearbyAllies.remove(0);
            if (!(ally.func_110143_aJ() < ally.func_110138_aP())) continue;
            if (ally.field_70173_aa % 8 == 0) {
                ally.func_70691_i(Spells.radiant_totem.getProperty("health").floatValue());
            }
            --targetsRemaining;
            if (!this.field_70170_p.field_72995_K) continue;
            ParticleBuilder.create(ParticleBuilder.Type.BEAM).pos(this.func_174791_d().func_72441_c(0.0, (double)(this.field_70131_O / 2.0f), 0.0)).target((Entity)ally).clr(1.0f, 0.6f + 0.3f * this.field_70170_p.field_73012_v.nextFloat(), 0.2f).spawn(this.field_70170_p);
        }
        while (!nearby.isEmpty() && targetsRemaining > 0) {
            EntityLivingBase target = nearby.remove(0);
            if (!EntityUtils.isLiving((Entity)target) || !this.isValidTarget((Entity)target)) continue;
            if (target.field_70173_aa % target.field_70771_an == 1) {
                float damage = Spells.radiant_totem.getProperty("damage").floatValue();
                EntityUtils.attackEntityWithoutKnockback((Entity)target, MagicDamage.causeIndirectMagicDamage(this, (Entity)this.getCaster(), MagicDamage.DamageType.RADIANT), damage);
            }
            --targetsRemaining;
            if (!this.field_70170_p.field_72995_K) continue;
            ParticleBuilder.create(ParticleBuilder.Type.BEAM).pos(this.func_174791_d().func_72441_c(0.0, (double)(this.field_70131_O / 2.0f), 0.0)).target((Entity)target).clr(1.0f, 0.6f + 0.3f * this.field_70170_p.field_73012_v.nextFloat(), 0.2f).spawn(this.field_70170_p);
        }
    }

    @Override
    public void despawn() {
        this.func_184185_a(WizardrySounds.ENTITY_RADIANT_TOTEM_VANISH, 1.0f, 1.0f);
        super.despawn();
    }

    @Override
    public void writeSpawnData(ByteBuf data) {
        super.writeSpawnData(data);
        data.writeFloat(this.damageMultiplier);
    }

    @Override
    public void readSpawnData(ByteBuf data) {
        super.readSpawnData(data);
        this.damageMultiplier = data.readFloat();
    }
}

